/*
 * Decompiled with CFR 0.152.
 */
package ash.util;

import java.io.PrintStream;

public class Log {
    static final PrintStream STDERR = System.err;
    static PrintStream err = System.err;
    private static int debugLevel = 0;

    private static void printTrace(int n, String string) {
        (n < 0 ? STDERR : err).println(string);
    }

    public static boolean check(int n) {
        if (n < 0) {
            n = -n;
        }
        if (debugLevel < 10) {
            return n <= debugLevel;
        }
        if (debugLevel / 10 == n / 10) {
            int n2 = debugLevel % 10;
            int n3 = n % 10;
            return n2 == 0 || n3 == 0 || n2 == n3;
        }
        return false;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int n) {
        if (n >= 0) {
            err = System.err;
        } else if (n < 0) {
            n = -n;
            err = STDERR;
        }
        debugLevel = n;
        assert (Log.debug(9, "\u30c7\u30d0\u30c3\u30b0\u30ec\u30d9\u30eb 9"));
        assert (Log.debug(100, "\u30c7\u30d0\u30c3\u30b0\u30ec\u30d9\u30eb 100"));
        assert (Log.debug(101, "\u30c7\u30d0\u30c3\u30b0\u30ec\u30d9\u30eb 101"));
        assert (Log.debug(109, "\u30c7\u30d0\u30c3\u30b0\u30ec\u30d9\u30eb 109"));
        assert (Log.debug(-101, "\u30c7\u30d0\u30c3\u30b0\u30ec\u30d9\u30eb -101"));
    }

    public static boolean debug(int n, String string) {
        if (Log.check(n)) {
            Log.printTrace(n, string);
        }
        return true;
    }

    public static boolean debug(Throwable throwable) {
        if (debugLevel == 0) {
            Log.printTrace(0, throwable.toString());
        } else {
            throwable.printStackTrace(err);
        }
        return true;
    }

    public static boolean debug(Throwable throwable, int n, String string) {
        Log.debug(n, string);
        Log.debug(throwable);
        return true;
    }

    public static boolean trace(int n, String string) {
        if (Log.check(n)) {
            Log.printTrace(n, "" + Log.thread() + " " + string);
        }
        return true;
    }

    public static boolean trace(int n, String string, Thread thread) {
        return Log.trace(n, string + Log.thread(thread));
    }

    public static String thread() {
        return Log.thread(Thread.currentThread());
    }

    public static String thread(Thread thread) {
        return String.format("[%-6s]", thread.getName());
    }
}

