#!/usr/bin/env bash

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

OUTDIR=`pwd`

if test "x$DIRMARKDIR" = "x"; then
  echo  "E: please set your DirectoryMark directory in DIRMARKDIR"
  exit 1
fi

if test "x$1" = "x"; then
  echo "Usage: $0 <num>"
  exit 1
fi

TOP="o=dirmark-$1,$SUFFIX"

(cd $DIRMARKDIR/Tools; perl dbgen.pl -o ultrapossum-dirmark-$1 -x $TOP $1)

ldapdelete -v -r -x -D $ROOTDN -w $ROOTPW $TOP -h $UPDATE_MASTER || true
ldapadd -x -D $ROOTDN -w $ROOTPW -h $UPDATE_MASTER -f $DIRMARKDIR/Tools/ultrapossum-dirmark-$1_noaci.ldif
ldapadd -x -D $ROOTDN -w $ROOTPW -h $UPDATE_MASTER -f $DIRMARKDIR/Tools/ultrapossum-dirmark-$1.ldif

