#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

# System level default
key="sha1 $CREDENTIALS"

if test -f $SYSCONFDIR/default.cf; then
  . $SYSCONFDIR/default.cf
fi

if test -f default.cf; then
  . default.cf
fi

AUTHKEYSIN=$TEMPLATEDIR/authkeys.in
if test -f "authkeys.in"; then
  AUTHKEYSIN=authkeys.in
fi

cat $AUTHKEYSIN
echo "auth 1"
echo "1 $key"
