/**********************************************************************
 * sched_lc.c                                               August 2005
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include "vanessa_logger.h"
#include "l7vs.h"

static void fini(void);
static struct l7vs_dest *l7vs_sched_lc_schedule(struct l7vs_service *srv,
                                                struct l7vs_conn *conn);

static struct l7vs_scheduler sched_lc_scheduler = {
        NULL,
        "lc",
        0,
        l7vs_sched_lc_schedule,         /* schedule function */
        NULL,                           /* bind function */
        NULL,                           /* unbind function */
        fini                            /* fini function */
};

struct l7vs_scheduler *
init(void *handle)
{
        sched_lc_scheduler.handle = handle;
        return &sched_lc_scheduler;
}

static void
fini(void)
{
}

static struct l7vs_dest *
l7vs_sched_lc_schedule(struct l7vs_service *srv,
                       struct l7vs_conn *conn)
{
        struct l7vs_dest *d, *dleast;
        GList *l;

        dleast = NULL;
        for (l = g_list_first(srv->dest_list); l != NULL; l = g_list_next(l)) {
                d = (struct l7vs_dest *)l->data;
                if (dleast == NULL || d->nactive < dleast->nactive) {
                        dleast = d;
                }
        }

        return dleast;
}
