/**********************************************************************
 * tcpstest.c                                               August 2005
 *
 * TCPS: TCP Splicing Module
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include "tcps.h"

#define VIRT_SERVICE_PORT	8000
#define HTTP_SERVICE_PORT	80 /* XXX Should use getservbyname() instead */
const char reqstr[] = "GET / HTTP/1.0\r\n\r\n";

static int
serversock(struct sockaddr_in *claddr)
{
	int s, as;
	int ret;
	struct sockaddr_in sin;
	socklen_t len;

	s = socket(PF_INET, SOCK_STREAM, 0);
	if (s < 0) {
		perror("socket");
		exit(1);
	}

	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	sin.sin_port = htons(VIRT_SERVICE_PORT);

	ret = bind(s, (struct sockaddr *)&sin, sizeof(sin));
	if (ret < 0) {
		perror("bind");
		exit(1);
	}

	ret = listen(s, 5);
	if (ret < 0) {
		perror("listen");
		exit(1);
	}

	memset(&sin, 0, sizeof(sin));
	len = sizeof(sin);
	as = accept(s, (struct sockaddr *)&sin, &len);
	if (as < 0) {
		perror("accept");
		exit(1);
	}

	*claddr = sin;
	return as;
}

int
main(int argc, char *argv[])
{
	int s, as;
	int ret;
	struct sockaddr_in sin, claddr;
	char buf[16];

	if (argc < 2) {
		fprintf(stderr, 
			"Usage: tcpstest <IP-address>\n"
			"   <IP-address>: HTTP server's IP address\n");
		exit(1);
	}
	as = serversock(&claddr);
	s = socket(PF_INET, SOCK_STREAM, 0);
	if (s < 0) {
		perror("socket");
		exit(1);
	}
	ret = setsockopt(s, IPPROTO_IP, TCPS_SO_SET_SOURCE_FAKE,
			 &claddr, sizeof(claddr));
	if (ret < 0) {
		perror("setsockopt TCPS_SO_SET_SOURCE_FAKE");
		exit(1);
	}

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = inet_addr(argv[1]);
	sin.sin_port = htons(HTTP_SERVICE_PORT);
	ret = connect(s, (struct sockaddr *)&sin, sizeof(sin));
	if (ret < 0) {
		perror("connect");
		exit(1);
	}

	ret = setsockopt(as, IPPROTO_IP, TCPS_SO_SPLICE, &s, sizeof(s));
	if (ret < 0) {
		perror("setsockopt(TCPS_SO_SPLICE)");
		exit(1);
	}
	fprintf(stderr, "splicing ok.\n");
	send(s, reqstr, sizeof(reqstr) - 1, 0);
	recv(as, buf, sizeof(buf), 0);
	close(as);
	close(s);
	return 0;
}
