/**********************************************************************
 * socket.h                                                 August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _KSSL_SOCKET_H
#define _KSSL_SOCKET_H


#include <linux/kernel.h>
#include <linux/net.h>
#include <net/sock.h>

int kssl_socket_inet_open_listen(const u32 addr, const u16 port, 
	                struct socket **sock);

int kssl_socket_inet_open_connect(const u32 addr, const u16 port, 
	                struct socket **sock);

int kssl_socket_unix_open_connect(const char *peername,
	                struct socket **sock);

void kssl_socket_close(struct socket *sock);

int kssl_socket_accept(struct socket *sock, struct socket **new);

#endif /* _KSSL_SOCKET_H */
