/**********************************************************************
 * record_list.c                                            August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#include <linux/list.h>

#include "conn.h"
#include "record.h"
#include "record_list.h"
#include "log.h"

struct list_head kssl_message_in_list;
struct list_head kssl_record_in_list;
struct list_head kssl_record_out_list;


void 
kssl_record_list_clear(struct list_head *list)
{
	kssl_record_t *cr;
	struct list_head *t_list;
	struct list_head *c_list;

	list_for_each_safe(c_list, t_list, list) {
		cr = list_entry(list->next, kssl_record_t, list);
		kssl_record_destroy(cr);
	}

	if (!list_empty(list)) 
		KSSL_DEBUG(1, "BUG! kssl_record_list_clear: "
				"could not clear list\n");
}


void 
kssl_record_list_clear_conn(struct list_head *list, kssl_conn_t *conn)
{
	kssl_record_t *cr;
	struct list_head *t_list;
	struct list_head *c_list;

	list_for_each_safe(c_list, t_list, list) {
		cr = list_entry(c_list, kssl_record_t, list);
		/* printk(KERN_DEBUG "kssl_record_list_clear_conn: "
				"cr->conn=%p conn=%p\n", cr->conn, conn); */
		if (cr->conn == conn)
			kssl_record_destroy(cr);
	}
}
