/**********************************************************************
 * handshake.h                                              August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSL_CONN_HANDSHAKE_H
#define KSSL_CONN_HANDSHAKE_H

#include <linux/kernel.h>
#include <linux/net.h>
#include <linux/version.h>

#include "record.h"

#include "types/handshake_t.h"
#include "types/alert_t.h"

#define CERTIFICATE_LIST_HEAD_NLEN 3
#define CERTIFICATE_CERT_HEAD_NLEN 3
#define CERTIFICATE_HEAD_NLEN                                                 \
        (CERTIFICATE_LIST_HEAD_NLEN + CERTIFICATE_LIST_HEAD_NLEN)

int kssl_handshake_body_tls(kssl_record_t *cr);

int kssl_handshake_body_ssl2(kssl_record_t *cr);

void kssl_handshake_destroy_data(handshake_t *hs);

int kssl_handshake_process(kssl_record_t *cr, alert_t *alert);

#endif /* KSSL_CONN_HANDSHAKE_H */

