/**********************************************************************
 * ssl2_record_t.h                                          August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _SSL2_RECORD_T_H
#define _SSL2_RECORD_T_H

#include "types/base_t.h"


/* SSL2 has a different record structure to SSL3 and TLS1. Hooray!!! */

typedef struct {
	u16 len;
	u8 pad;
	u8 is_escape;
} ssl2_head_t;

/* buf must be at least 2 bytes long if the most significant
 * bit of the first byte is 1. 3 otherwise */
static inline void ssl2_head_from_buf(ssl2_head_t *head, const u8 *buf)
{
	if(*buf & 0x80) {
		head->len = ((*buf & 0x7f) << 8) | *(buf+1);
		head->pad = 0;
		head->is_escape = 0;
	}
	else {
		head->len = ((*buf & 0x3f) << 8) | *(buf+1);
		head->pad = *(buf + 2);
		head->is_escape = ((*buf & 0x40) != 0);
	}
}


/* buf must be at least 2 bytes long if head->pad is 0,
 * at least 3 bytes long otherwise */
static inline void ssl2_head_to_buf(const ssl2_head_t *head, u8 *buf)
{
	if(!head->pad) {
		*buf = ((head->len >> 8) & 0x7f) | 0x80;
		*(buf+1) = head->len & 0xff;
	}
	else {
		*buf = ((head->len >> 8) & 0x3f) | 0x80;
		*(buf+1) = head->len & 0xff;
		*(buf+2) = head->pad;
		if(head->is_escape) {
			*buf |= 0x40;
		}
	}
}

/* buf must be at least 1 byte long */
#define SSL2_HEAD_NLEN_BUF(buf) (*(buf) & 0x80 ? 2 : 3)

#define SSL2_HEAD_NLEN(head) ((head)->pad ? 3 : 2)
#define SSL2_RECORD_NLEN(head) ((head)->len + SSL2_HEAD_NLEN(head))

#endif /* _SSL2_RECORD_T_H */

