/**********************************************************************
 * base_t.h                                                 August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _GENERAL_T_H
#define _GENERAL_T_H

#ifdef __KERNEL__
#include <linux/types.h>
#else
#include <stdint.h>
typedef uint8_t  u8;
typedef uint16_t u16;
typedef uint32_t u32;
#endif

/**********************************************************************
 * Generic Types 
 * In addition to u8, u16 and u32
 **********************************************************************/

typedef u8  opaque_t;
typedef u32 pos24_t;       /* Some bright spark at Netscape decided it
			    * would be a great idea to use 24 bit entities.
			    * Of course most (all?) architectures that run
			    * SSL code are 32 or 64 bit and don't have
			    * native 24bit types.  So we use a 32 bit type,
			    * but typedef it to pos24_t to remind us that
			    * only 24 bits are used. */

#endif /* _GENERAL_T_H */
