/**********************************************************************
 * alert_t.c                                                August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _ALERT_T_H
#define _ALERT_T_H


/**********************************************************************
 * Alert
 **********************************************************************/

typedef enum {
	al_warning=1,
	al_fatal=2,
	al_last=255
} alert_level_t;

typedef enum {
	ad_close=0,
	ad_unexpected_message=10,
	ad_bad_record_mac=20,
	ad_decompression_failire=30,
	ad_handshake_failure=40,
	ad_no_certificate=41,
	ad_bad_certificate=42,
	ad_unsupported_certificate=43,
	ad_certificate_revoked=44,
	ad_certificate_expired=45,
	ad_certificate_unknown=46,
	ad_illegal_parameter=47,
	ad_last=255
} alert_description_t;

typedef struct {
	alert_level_t level;
	alert_description_t description;
} alert_t;

/* buf must be at least 2 bytes long */
static inline void alert_to_buf(const alert_t *alert, u8 *buf)
{
	*buf = alert->level;
	*(buf+1) = alert->description;
}

/* buf must be at least 2 bytes long */
static inline void alert_from_buf(alert_t *alert, const u8 *buf)
{
	alert->level = *buf;
	alert->description = *(buf+1);
}

#define ALERT_NLEN 2

#endif /* _ALERT_T_H */

