/**********************************************************************
 * base64_test.c                                            August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifdef __KERNEL__
#include <linux/slab.h>
#else
#include "compat.h"
#endif

#include "base64_test.h"
#include "base64.h"
#include "test_util.h"

int base64_test(char *input, size_t inputLen)
{
	int ret = 0;
	char *enc = NULL;
	size_t encLen;
	char *dec = NULL;
	size_t decLen;

	encLen = inputLen/3 * 4 + (inputLen%3 ? 4 : 0);

	enc = (char *)kmalloc(encLen, GFP_KERNEL);
	if(!enc)
		goto leave;
	base64_encode(enc, input, inputLen);

	decLen = encLen/4*3;

	dec = (char *)kmalloc(decLen, GFP_KERNEL);
	if(!dec)
		goto leave;
	base64_decode(dec, &decLen, enc, encLen);

	asym_print_char(KERN_DEBUG "input", input, inputLen);
	asym_print_char(KERN_DEBUG "enc", enc, encLen);
	asym_print_char(KERN_DEBUG "dec", dec, decLen);

	ret = 0;
leave:
	if(enc)
		kfree(enc);
	if(dec)
		kfree(dec);
	return (ret);
}
