<?php
/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *              that is available at http://www.php.net/license/3_01.txt
 *              If you did not receive a copy of the PHP license and are unable 
 *              to obtain it through the world-wide-web, please send a note to 
 *              license@php.net so we can mail you a copy immediately.  
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @author     Kazuki from UsagiProject
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.1.0 Nighty
 * ======================================================================== 
 */
 
/*
This script was inspired and updated by:
saido menu By TORANEKO from OpenPNE Community
Thanks
*/


function custom_new_diary_list($limit)
{
    //PREFIX対応
    $sql = "SELECT d.c_diary_id,d.subject,m.nickname,d.comment_count FROM ".MYNETS_PREFIX_NAME."c_diary as d, ".MYNETS_PREFIX_NAME."c_member as m WHERE m.c_member_id =d.c_member_id AND d.public_flag = 'public' ORDER BY d.r_datetime DESC";
    $new_diary_list = db_get_all_limit($sql, 0 , $limit);
    //コメントカウント方法をUsagiに合わせるため以下不要
    //foreach($new_diary_list as $key => $value) {
    //    $new_diary_list[$key]['count_comments'] = db_diary_count_c_diary_comment4c_diary_id($value['c_diary_id']);
    //}
    return $new_diary_list;
}

function custom_new_topic_list($limit)
{
    $sql = 'SELECT b.*, a.name AS c_commu_name, MAX( c.r_datetime ) AS mtime FROM '.MYNETS_PREFIX_NAME.'c_commu as a '.
            'LEFT JOIN '.MYNETS_PREFIX_NAME.'c_commu_topic as b USING ( c_commu_id ) LEFT JOIN '.MYNETS_PREFIX_NAME.'c_commu_topic_comment as c USING ( c_commu_topic_id ) '.
            'WHERE b.name != \'NULL\' AND a.public_flag IN (\'public\', \'auth_sns\' ) '.
            'GROUP BY b.c_commu_topic_id ORDER BY mtime DESC';
    $new_topic_list = db_get_all_limit($sql, 0 , $limit);
    foreach($new_topic_list as $key => $value) {
        $new_topic_list[$key]['number'] = db_commu_get_max_number4topic($value['c_commu_topic_id']);
    }
    return $new_topic_list;
}

function custom_new_user_list($limit)
{
    $sql = "SELECT c_member_id,nickname,r_date FROM ".MYNETS_PREFIX_NAME."c_member ORDER BY c_member_id DESC";
    $arr = db_get_all_limit($sql, 0 , $limit);
    foreach($arr as $key => $value) {
        $arr[$key]['diary']=db_diary_get_c_diary_list4c_member_id($value['c_member_id'],5);
    }
    return $arr;
}

function custom_random_user()
{
    $sql = 'SELECT nickname,c_member.c_member_id,count(c_member_id_to) FROM '.
            '('.MYNETS_PREFIX_NAME.'c_member INNER JOIN '.MYNETS_PREFIX_NAME.'c_member_profile ON '.MYNETS_PREFIX_NAME.'c_member.c_member_id = '.MYNETS_PREFIX_NAME.'c_member_profile.c_member_id ) '.
            'LEFT JOIN '.MYNETS_PREFIX_NAME.'c_friend ON '.MYNETS_PREFIX_NAME.'c_member.c_member_id = '.MYNETS_PREFIX_NAME.'c_friend.c_member_id_from WHERE c_profile_option_id = 103 '.
            'GROUP BY c_member_id_from HAVING count(c_member_id_to) <=20 order by rand()';
    $arr = db_get_all_limit($sql, 0 , 1);
    return $arr;
}

//必須項目のチェック
function custom_profile($c_member_id)
// return 1:必須項目登録してない return 0;登録済
{
    $sql = 'SELECT c_profile_id from '.MYNETS_PREFIX_NAME.'c_member_profile WHERE c_member_id = ?';
    $params = array(intval($c_member_id));
    $list = db_get_all($sql, $params);
    foreach($list as $key => $value) {
        if($value['c_profile_id']==5){
            $hissu=1;
        }
        if($value['c_profile_id']==9){
            $hissu=1;
        }
    }
    if(!$hissu){
        return 1;
    }
}

//コミュ管理してる場合に警告を出す
function custom_info_follow_commu_alert($c_member)
{
    $c_member_id = $c_member['c_member_id'];

    //管理コミュのリスト
    $sql = "select c_commu_id,image_filename from ".MYNETS_PREFIX_NAME."c_commu WHERE c_member_id_admin=?";
    $params=array(intval($c_member_id));
    $admin_commu_list = db_get_all($sql, $params);

    //画像の無いコミュと書き込みの古いコミュをカウント
    $no_image_commu=0;
    $commu_admin=0;
    foreach($admin_commu_list as $key => $value) {
        $commu_admin++;
        $image_filename = $value['image_filename'];
        if($value['image_filename'] === ""){
            $no_image_commu++;
            $commu_id=$value['c_commu_id'];
        }
    }

    if($commu_admin>0){
        if($no_image_commu==0){
            $notactive_commu=0;
            foreach($admin_commu_list as $key => $value) {
                $sql = "select count(*) from ".MYNETS_PREFIX_NAME."c_commu_topic_comment where c_commu_id= ?";
                $sql .= " and to_days(now())-to_days(r_datetime) < 30";
                $params = array(intval($value['c_commu_id']));
                if(db_get_one($sql, $params)==0){
                    $notactive_commu++;
                    $commu_id=$value['c_commu_id'];
                }
            }
        }
    }
    $follow_commu_admin['no_image_commu']=$no_image_commu;
    $follow_commu_admin['notactive_commu']=$notactive_commu;
    $follow_commu_admin['commu_id']=$commu_id;
    return $follow_commu_admin;
}

function custom_onlinelist($limit)
{

    $sql = "SELECT c_member_id, nickname FROM ".MYNETS_PREFIX_NAME."c_member"
          . " WHERE access_date > date_add( now( ) , INTERVAL -3 MINUTE ) "
          . " ORDER BY access_date DESC ";
    $arr = db_get_all_limit($sql, 0 , $limit);
    return $arr;
}

function custom_newdoccilist($limit)
{

    $sql = "SELECT docci_topic_id,topic FROM docci_topic ORDER BY docci_topic_id DESC";
    $arr = db_get_all_limit($sql, 0 , $limit);
    return $arr;
}

?>
