<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Detail_success.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach ($template['student']->subjects as $subject) {
?>
			<li class="sub_s">
				<a id="sub_<?= $subject->sid ?>" href="#" class="sub_b_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a>
			</li>
<?php
}
?>
		</ul>
		<div class="div_clear">&#160;</div>
	</div>
	
	
	<div id="main">
		<div id="compose1">
			<div id="navi">
				<h1>学生詳細</h1>
				<a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>" class="operation">戻る</a>
			</div>
			
			<div id="user_detail" class="user_detail">
				<table>
					<tr>
						<th>ユーザID:</th>
						<td><?= htmlspecialchars($template['student']->uid) ?></td>
					</tr>
					<tr>
						<th>氏名:</th>
						<td><?= htmlspecialchars($template['student']->name) ?></td>
					</tr>
					<tr>
						<th>メールアドレス:</th>
						<td><?= htmlspecialchars($template['student']->mail) ?></td>
					</tr>
					<tr>
						<th>学年:</th>
						<td><?= htmlspecialchars($template['student']->year) ?></td>
					</tr>
					<tr>
						<th>学生番号:</th>
						<td><?= htmlspecialchars($template['student']->number) ?></td>
					</tr>
					<tr>
						<th>受講している科目:</th>
						<td>
							<ul>
<?php
foreach($template['student']->subjects as $subject) {
?>
								<li><?= htmlspecialchars($subject->name) ?></li>
<?php
}
?>
							</ul>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	
	
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
</body>
</html>