<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Search_success.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
<script type="text/javascript">
var url = '<?= TemplateUtils::createURL('Results', 'Search') ?>';

var examdb = new Object();
var stddb = new Object();
<?php
foreach($template['subjects'] as $subject) {
?>
examdb[<?= $subject->sid ?>] = [
<?php
	for($i = 0; $i < count($subject->pub_exams); $i++) {
		if($i > 0) echo ',';
?>
	{value:<?= $subject->pub_exams[$i]->eid ?>, text:"<?= $subject->pub_exams[$i]->name ?>"}
<?php
	}
?>
];
stddb[<?= $subject->sid ?>] = [
<?php
	for($i = 0; $i < count($subject->users); $i++) {
		if($i > 0) echo ',';
?>
	{value:<?= $subject->users[$i]->uid ?>, text:"<?= $subject->users[$i]->name ?>"}
<?php
	}
?>
];
<?php
}
?>
</script>
<script src="files/js/results.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" href="javascript:;" class="<?= ($subject->sid == $template['sid']) ? '' : 'disable ' ?>sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
}
?> 
		</ul>
		<div class="div_clear">&#160;</div>
	</div>
	
	<div id="main">
		<div id="compose1">
			<div id="navi">
				<h1>成績</h1>
			</div>
			
			<div>
				<table>
					<tr>
						<th>科目:</th>
						<td>
							<select id="subject_select" name="subject" class="select_mid">
								<option></option>
<?php
foreach($template['subjects'] as $subject) {
?>
								<option value="<?= $subject->sid ?>" <?= ($template['sid'] == $subject->sid) ? 'selected="selected"' : '' ?>><?= htmlspecialchars($subject->name)?></option>
<?php
}
?>
							</select>
						</td>
					</tr>
				</table>
			</div>
			
			<div>
				<a href="javascript:listUp('exam');" class="operation">テスト一覧</a>
				|
				<a href="javascript:listUp('user');" class="operation">学生一覧</a>
			</div>
			
<?php
if(is_array($template['results'])) {
?>			
			<div id="results" class="results">
				<div  class="navi">
					<h1>
						<?= htmlspecialchars($template['subject']->name) ?>
						<?= ($template['group'] == 'exam') ? 'テスト一覧' : '' ?>
						<?= ($template['group'] == 'user') ? '学生一覧' : '' ?>
					</h1>
				</div>
				<table>
					<tr>
<?php
	if($template['group'] == 'exam') {
?>
						<th>テスト名</th>
						<th>配信</th>
						<th>締切</th>
						<th>問題数</th>
						<th>満点</th>
<?php
	} elseif($template['group'] == 'user') {
?>
						<th>氏名</th>
						<th>学年</th>
						<th>学生番号</th>
						<th>メールアドレス</th>
<?php
	}
?>
					</tr>
<?php
	for($i = 0; $i < count($template['results']); $i++) {
?>
					<tr class="result">
<?php
		if($template['group'] == 'exam') {
?>
						<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','List', array('sid'=>$template['results'][$i]->sid, 'eid'=>$template['results'][$i]->eid))) ?>"><?= htmlspecialchars($template['results'][$i]->name) ?></a></td>
						<td class="text_center"><?= htmlspecialchars(TemplateUtils::formatDateTime($template['results'][$i]->publish_time)) ?></td>
						<td class="text_center"><?= ($template['results'][$i]->deadline_time) ? htmlspecialchars(TemplateUtils::formatDateTime($template['results'][$i]->deadline_time)) : 'なし' ?></td>
						<td class="text_right"><?= $template['results'][$i]->getQuestionsCount() ?></td>
						<td class="text_right"><?= $template['results'][$i]->getTotalPoint() ?></td>
<?php
		} elseif($template['group'] == 'user') {
?>
						<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','List', array('sid'=>$template['sid'], 'uid'=>$template['results'][$i]->uid))) ?>"><?= htmlspecialchars($template['results'][$i]->name) ?></a></td>
						<td class="text_center"><?= htmlspecialchars($template['results'][$i]->year) ?></td>
						<td class="text_center"><?= htmlspecialchars($template['results'][$i]->number) ?></td>
						<td class="text_center"><?= htmlspecialchars($template['results'][$i]->mail) ?></td>
<?php
		}
?>
					</tr>
<?php
	}
?>
				</table>
			</div>
<?php
}
?>
		</div>
		
	</div>
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
<script type="text/javascript">
</script>
</body>
</html>