<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: RegistAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/06/03
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/DBAction.class.php');
require_once (OPT_DIR.'u-learning/lib/TemplateUtils.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');

/**
 * RegistAction
 * 
 * 教員登録
 */
class RegistAction extends DBAction {

    function execute(& $controller, & $request, & $user) {
        // DBオブジェクト取得
        $DB = $request->getAttribute('DB');

        $aid = $request->getParameter('aid');
        $pass = $request->getParameter('pass');
        $pass2 = $request->getParameter('pass2');
        $name = $request->getParameter('name');

        // バリデーション
        $error = '';
        if (!mb_ereg("^[0-9a-zA-Z]+$", $aid)) {
            $error .= "ユーザ名を半角英数字で入力してください。\n";
        }
        if (!mb_ereg("^[[0-9a-zA-Z]+$", $pass)) {
            $error .= "パスワードを半角英数字で入力してください。\n";
        }
        if (strlen($pass) < 4) {
            $error .= "パスワードは4文字以上で入力してください。\n";
        }
        if ($pass != $pass2) {
            $error .= "確認用パスワードが違います。\n";
        }

        // 重複確認
        $admin = new Admin();
        $admin->setDB($DB);
        $admin->aid = $aid;
        $admin->pass = $pass;
        $admin->name = $name;
        if ($admin->keyExists()) {
            $error .= "すでに同じユーザ名が登録されています。\n";
        }

        if (strlen($error)) {
            $request->setError('error', $error);
            $request->setAttribute('aid', $aid);
            $request->setAttribute('pass', $pass);
            $request->setAttribute('pass2', $pass2);
            $request->setAttribute('name', $name);
            return VIEW_ERROR;
        }

        // ユーザ登録処理
        $admin->insert();

        return VIEW_SUCCESS;
    }

    function getRequestMethods() {
        return REQ_POST;
    }

    function getDefaultView(& $controller, & $request, & $user) {
        return VIEW_INPUT;
    }

    /**
     * このページにログインは必要か
     */
    function isSecure() {
        return false;
    }
}
?>