<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Questions_published.php,v 1.1 2005/06/20 09:31:25 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
<script type="text/javascript">

var updateChoices = new Array();
<?php
foreach($template['questions'] as $question) {
?>
updateChoices[<?= $question->number ?>] = new Array();
<?php
    for($i = 0; $i < count($question->choices); $i++) {
?>
updateChoices[<?= $question->number ?>][<?= $i ?>] = '<?= htmlspecialchars($question->choices[$i]->value) ?>';
<?php
    }
}
?>

</script>
<script src="files/js/exam_questions.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach ($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" class="<?= ($subject->sid == $template['exam']->sid) ? "" : "disable " ?>sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
}
?>
		</ul>
		
		<div class="div_clear">&#160;</div>
	</div>
	
	
	<div id="main">
		<div id="compose2">
			<div id="navi">
				<h1>
					<?= htmlspecialchars($template['exam']->name) ?> 
                    <span class="exam_info">
                        &nbsp;全<?= $template['questions_count'] ?>問&nbsp;合計点数<?= $template['total_point'] ?>
                    </span>
				</h1>
                <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>" class="operation">キャンセル</a>
			</div>


<?php
if(count($template['questions'])) {
?>
			<div>
				<a href="javascript:expandAllQuestions();">すべて展開</a>
				<a href="javascript:collapseAllQuestions();">すべて閉じる</a>
			</div>
			
			<div id="exams">
<?php
	foreach($template['questions'] as $question) {
?>
				<div id="exam_<?= $question->number ?>_collapse" class="exam exam_collapse">
					<h1>
						<a href="javascript:expandQuestion(<?= $question->number?>);">第<?= $question->number ?>問 &nbsp; <?= (mb_strlen($question->question) < 20) ? htmlspecialchars($question->question) : htmlspecialchars(mb_substr($question->question, 0, 20)."....") ?></a>
					</h1>
				</div>
				<div id="exam_<?= $question->number ?>_expand" class="exam exam_expand" style="display: none;">
					<h1>
						<a name="a_expand_<?= $question->number ?>" href="javascript:collapseQuestion(<?= $question->number ?>);">第<?= $question->number ?>問</a>
					</h1>
					<div id="exam_<?= $question->number ?>_body" class="exam_body">
						<a href="javascript:;"
							onclick="updateQuestion(<?= $question->number ?>);" class="operation">再編集</a>
						<table>
						<tr>
							<th>設問:</th>
							<td><?= nl2br(htmlspecialchars($question->question)) ?></td>
						</tr>
						<tr>
							<th>回答:</th>
							<td>
							<ol type="1">
<?php
		foreach($question->choices as $choice) {
?>
								<li><?= ($choice->correct == '1') ? '<span class="answer_right_saved">'.htmlspecialchars($choice->value).'</span>' : htmlspecialchars($choice->value) ?></li>
<?php
		}
?>
							</ol>
							</td>
						</tr>
						<tr>
							<th>配点:</th>
							<td><?= $question->point ?></td>
						</tr>
						<tr>
							<th>解説:</th>
							<td><?= nl2br(htmlspecialchars($question->explanation)) ?></td>
						</tr>
						
						</table>
						<div class="div_clear">&#160;</div>
					</div>
				</div>
				<div id="exam_<?= $question->number ?>_update" class="exam exam_update" style="display: none;">
<form id="update_form_<?= $question->number ?>" name="update_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'Questions')) ?>" method="post">
	<input type="hidden" name="eid" value="<?= $template['exam']->eid ?>" />
	<input type="hidden" name="update_published_submit" value="true" />
	<input type="hidden" name="qid" value="<?= $question->qid ?>" />
	<input type="hidden" id="update_correct_choice_<?= $question->number ?>" name="correct_choice" value="<?= htmlspecialchars($question->getCorrectValue()) ?>" />
	<input type="hidden" name="expand_num" value="<?= $question->number ?>" />
	
	<h1>
		<a name="a_update_<?= $question->number ?>" href="javascript:collapseQuestion(<?= $question->number ?>);">第<?= $question->number ?>問</a>
	</h1>
	<div class="exam_body exam_update_body">
		<table>
			<tr>
				<th>設問:</th>
				<td>
					<textarea id="update_question_<?= $question->number ?>" name="update_question" cols="" rows="4" style="width:95%;"><?= htmlspecialchars($question->question) ?></textarea>
				</td>
			</tr>
			<tr>
				<th>回答:</th>
				<td>
					<ol type="1">
<?php
		foreach($question->choices as $choice) {
?>
						<li><?= ($choice->correct == '1') ? '<span class="answer_right_saved">'.htmlspecialchars($choice->value).'</span>' : htmlspecialchars($choice->value) ?></li>
<?php
		}
?>
					</ol>
				</td>
			</tr>
			<tr>
				<th>配点:</th>
				<td>
                    <?= $question->point ?>
                    <!--
					<input id="update_point_<?= $question->number ?>" name="update_point" type="text" size="4" maxsize="4" value="<?= htmlspecialchars($question->point) ?>">点
                    -->
				</td>
			</tr>
			<tr>
				<th>解説:</th>
				<td>
					<textarea id="update_explanation_<?= $question->number ?>" name="update_explanation" cols="" rows="4" style="width:95%;"><?= htmlspecialchars($question->explanation) ?></textarea>
				</td>
			</tr>
			<tr>
				<th></th>
				<td>
					
				</td>
			</tr>
		</table>
		<div class="text_center">
			<input type="button" onclick="updateSubmit(<?= $question->number ?>);" value="この問題を更新" />
			&nbsp;
			<a href="javascript:expandQuestion(<?= $question->number ?>);" class="operation">取りやめ</a>
		</div>
	</div>
</form>
				</div>
<?php
	}
?>
			</div>
<?php
}
?>


<div class="console">
	<a href="javascript:checkPrint('<?= htmlspecialchars(TemplateUtils::createLink('Exam','Print', array('eid'=>$template['exam']->eid))) ?>');" class="operation">テストを印刷</a>
	| <a href="javascript:checkPrint('<?= htmlspecialchars(TemplateUtils::createLink('Exam','Print', array('eid'=>$template['exam']->eid,'correct'=>'true'))) ?>');" class="operation">正解を印刷</a>
</div>
		</div>
		
	</div>

	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
<?php
if(!is_null($template['expand_num'])) {
?>
<script language="javascript" type="text/javascript">
expandQuestion(<?= $template['expand_num'] ?>);
</script>
<?php
} elseif(!is_null($template['update_num'])) {
?>
<script language="javascript" type="text/javascript">
updateQuestion(<?= $template['update_num'] ?>);
getById('input_update_choice_<?= $template['update_num'] ?>').focus();
</script>
<?php
}
?>
</body>
</html>