<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Compose_success.php,v 1.1 2005/06/20 09:31:25 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
<script type="text/javascript">

function composeSubmit() {
	var form = getById('compose_form');
	var name = getById('compose_name');
	if(name.value.length < 1) {
		alert('テスト名を入力してください。');
	} else {
		form.submit();
	}
}

</script>
</head>
<body>
<div id="container">

<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach ($template['subjects'] as $subject) {
?>
			<li class="sub_s">
				<a id="sub_<?= $subject->sid ?>" href="javascript:changeSubject(<?= $subject->sid ?>);" class="disable sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a>
			</li> 
<?php
}
?>
		</ul>
		<div class="div_clear">&#160;</div>
	</div>
	
	<div id="main">
		<div id="compose1">
			<div id="navi">
				<h1>科目とテスト名</h1>
			</div>
			<form id="compose_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Exam', 'Compose')) ?>" method="post">
				<input type="hidden" name="compose_submit" value="true" />
				<table>
					<tr>
						<th>科目:</th>
						<td>
							<select id="subject_select" name="subject" class="select_mid" onchange="selectSubject(this);">
<?php
foreach ($template['subjects'] as $subject) {
?>
								<option value="<?= $subject->sid ?>"><?= htmlspecialchars($subject->name) ?></option>
<?php
}
?>
							</select>
						</td>
					</tr>
					<tr>
						<th>テスト名:</th>
						<td>
							<input id="compose_name" name="name" class="input_mid" type="text" value="" size="40" maxlength="256"/>
						</td>
					</tr>
					<tr>
						<th>再受験:</th>
						<td class="input_mid">
							<input class="input_mid" name="retry" type="radio" value="1" checked="checked" />可
							<input class="input_mid" name="retry" type="radio" value="0" />不可
						</td>
					</tr>
					<tr>
						<th>解答と解説:</th>
						<td class="input_mid">
							<input class="input_mid" name="correct" type="radio" value="1" checked="checked" />１問ずつ
							<input class="input_mid" name="correct" type="radio" value="0" />最後にまとめて
						</td>
					</tr>
					<tr>
						<th></th>
						<td>
							<input type="button" value="作成" onclick="composeSubmit();"/>
						</td>
					</tr>
				</table>
			</form>
		</div>
		
	</div>
	<div id="side">
		<div class="side_menu">
			<h2>3ステップ</h2>
			<div class="progress">
			<span class="focus point">①</span><br/>
			<span>科目とテスト名</span><br/>
			<span class="arrow">↓</span><br/>
			<span class="point">②</span><br/>
			<span>テスト内容</span><br/>
			<span class="arrow">↓</span><br/>
			<span class="point">③</span><br/>
			<span>配信</span><br/>
			</div>
			
		</div>
	</div>
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>

<script type="text/javascript">
getById('subject_select').onchange();
</script>
</div>
</body>
</html>