<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: QuestionsAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once (OPT_DIR.'u-learning/data/AdminQuestion.class.php');
require_once (OPT_DIR.'u-learning/data/AdminChoice.class.php');

/**
 * テスト質問編集
 */
class QuestionsAction extends AdminAction {

    /**
     * POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db = $request->getAttribute('DB');
        $admin = new Admin($user->getAttribute('aid'), $db);

        // 科目取得
        $subjects = $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);

        // テスト取得
        $eid = $request->getParameter('eid');
        $exam = new AdminExam($eid, $db);
        $request->setAttribute('exam', $exam);

        // 科目取得
        $subject = $exam->getSubject($db);
        $request->setAttribute('subject', $subject);

        if ($request->hasParameter('add_submit')) {
        // 追加
            $question = new AdminQuestion();
            $question->eid = $eid;
            $question->number = $request->getParameter('nextnum');
            $question->question = $request->getParameter('question');
            $question->point = $request->getParameter('point');
            $question->explanation = $request->getParameter('explanation');

            $question->insert($db);
            $qid = $db->lastInsertID();

            $choices = $request->getParameter('add_choices_list');
            foreach ($choices as $value) {
                $choice = new AdminChoice();
                $choice->eid = $eid;
                $choice->qid = $qid;
                $choice->value = $value;
                ($value == $request->getParameter('correct_choice')) ? $choice->correct = '1' : $choice->correct = '0';

                $choice->insert($db);
            }

            // 初期表示に遷移
            $this->location('Exam', 'Questions', array ('eid' => $eid));
            return VIEW_NONE;

        }
        elseif ($request->hasParameter('update_submit_choice')) {
            // 設問選択肢更新
            $qid = $request->getParameter('qid');
            $question = new AdminQuestion($qid, $db);
            $question->rebuildChoices($request->getParameter('update_choices_list'), $request->getParameter('correct_choice'), $db);
            $request->setAttribute('update_qid', $qid);

            // 編集途中の位置に遷移
            $update_num = $request->getParameter('update_num');
            $this->location('Exam', 'Questions', array ('eid' => $eid, 'update_num' => $update_num), "a_update_".$update_num);
            return VIEW_NONE;

        }
        elseif ($request->hasParameter('update_submit')) {
            // 設問更新
            $qid = $request->getParameter('qid');
            $question = new AdminQuestion($qid, $db);
            $question->question = $request->getParameter('update_question');
            $question->point = $request->getParameter('update_point');
            $question->explanation = $request->getParameter('update_explanation');
            $question->update($db);
            
            $question->setCorrectChoice($request->getParameter('correct_choice'), $db);

            // 編集途中の位置に遷移
            $expand_num = $request->getParameter('expand_num');
            $this->location('Exam', 'Questions', array ('eid' => $eid, 'expand_num' => $expand_num), "a_expand_".$expand_num);
            return VIEW_NONE;

        }
        elseif ($request->hasParameter('delete_submit')) {
            // 削除
            $qid = $request->getParameter('qid');
            $question = new AdminQuestion($qid, $db);
            $question->delete($db);

        }
        elseif ($request->hasParameter('update_published_submit')) {
            // 配信後更新
            $qid = $request->getParameter('qid');
            $question = new AdminQuestion($qid, $db);
            $question->question = $request->getParameter('update_question');
            $question->point = $request->getParameter('update_point');
            $question->explanation = $request->getParameter('update_explanation');
            $question->update($db);

            // 編集途中の位置に遷移
            $expand_num = $request->getParameter('expand_num');
            $this->location('Exam', 'Questions', array ('eid' => $eid, 'expand_num' => $expand_num), "a_expand_".$expand_num);
            return VIEW_NONE;
        }

        $this->location('Exam', 'Questions', array ('eid' => $eid));
        return VIEW_NONE;
    }

    function getRequestMethods() {
        return REQ_POST;
    }

    /**
     * GET
     */
    function getDefaultView(& $controller, & $request, & $user) {
        // DBコネクション
        $db = $request->getAttribute('DB');
        $admin = new Admin($user->getAttribute('aid'), $db);

        // 科目取得
        $subjects = $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);

        // テスト取得
        $eid = $request->getParameter('eid');
        $exam = new AdminExam($eid, $db);
        $request->setAttribute('exam', $exam);

        // 科目取得
        $subject = $exam->getSubject($db);
        $request->setAttribute('subject', $subject);

        // テストの設問取得
        $questions = $exam->getQuestions($db);
        foreach ($questions as $key => $question) {
            // 各設問の選択肢をセットする
            $questions[$key]->setChoices($db);
        }
        $request->setAttribute('questions', $questions);

        // 設問の次の番号
        $nextnum = $exam->getNextQuestionNumber($db);
        $request->setAttribute('nextnum', $nextnum);

        if ($request->hasParameter('expand_num')) {
            $request->setAttribute('expand_num', $request->getParameter('expand_num'));
        } else {
            $request->setAttribute('expand_num', null);
        }

        if ($request->hasParameter('update_num')) {
            $request->setAttribute('update_num', $request->getParameter('update_num'));
        } else {
            $request->setAttribute('update_num', null);
        }

        // テストの設問数
        $request->setAttribute('questions_count', count($questions));

        // テストの合計点
        $request->setAttribute('total_point', $exam->getTotalPoint($db));

        return VIEW_SUCCESS;
    }

}
?>