<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: StudentQuestion.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/20
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');
require_once (OPT_DIR.'u-learning/data/StudentChoice.class.php');

/**
 * StudentQuestion
 * 
 * 学生テスト設問クラス
 */
class StudentQuestion extends DataObject {

    // 回答ID
    var $rid;
    // 設問ID
    var $qid;

    // 教員ID
    var $aid;
    // 学生ID
    var $uid;
    // テストID
    var $eid;

    // 得点
    var $point;

    // 選択肢リスト
    var $choices;

    /**
     * コンストラクタ
     */
    function StudentQuestion($rid= null, $qid= null, $db= null) {
        if (!is_null($rid) && !is_null($qid) && !is_null($db)) {
            $this->setDB($db);
            $this->rid= $rid;
            $this->qid= $qid;

            $sql= "SELECT * FROM user_question WHERE qid = $qid and rid = $rid";
            $row= $this->DB->GetRow($sql);
            if (count($row) > 0) {
                $this->setValues($row);
            }
        }

    }

    /**
     * 配列から値をセットする
     */
    function setValues($array) {
        $this->rid= $array['rid'];
        $this->qid= $array['qid'];
        $this->aid= $array['aid'];
        $this->uid= $array['uid'];
        $this->eid= $array['eid'];
        $this->point= $array['point'];
    }

    /**
     * 問題の回答情報登録
     */
    function insert($db= null) {
        $this->setDB($db);
        $sql= "insert into user_question (rid,qid,aid,uid,eid,point) values (".$this->rid.", ".$this->qid.", ".$this->DB->qstr($this->aid).", ".$this->DB->qstr($this->uid).", ".$this->eid.", ".$this->point.")";
        return $this->DB->Execute($sql);
    }

    /**
     * 問題の回答情報更新
     */
    function update($db= null) {
        $this->setDB($db);
        $sql= "update user_question set "."aid = ".$this->DB->qstr($this->aid).", "."uid = ".$this->DB->qstr($this->uid).", "."eid = ".$this->eid.", "."point = ".$this->point." where rid = ".$this->rid." and qid = ".$this->qid;
        return $this->DB->Execute($sql);
    }

    /**
     * 問題の回答情報更新
     */
    function save($db= null) {
        $this->setDB($db);
        $sql= "select * from user_question where "." rid = ".$this->rid." and qid = ".$this->qid;
        $row= $this->DB->GetRow($sql);
        if (count($row) > 0) {
            return $this->update($db);
        } else {
            return $this->insert($db);
        }

    }

    /**
     * 現在の設問の回答IDを取得
     */
    function getChoice($db= null) {
        $this->setDB($db);
        $sql= "select cid from user_choice where "." qid = ".$this->qid." and rid = ".$this->rid;
        return $this->DB->GetOne($sql);
    }

    /**
     * 現在の設問の回答リストを取得
     */
    function setChoice($db= null) {
        $this->setDB($db);
        $sql= "select * from user_choice where "." qid = ".$this->qid." and rid = ".$this->rid."order by cid";
        $all= $this->DB->GetAll($sql);
        $this->choices= array ();
        foreach ($all as $row) {
            $choice= new StudentChoice();
            $choice->setValues($row);
            array_push($this->choices, $choice);
        }
        return $this->choices;
    }

}
?>