<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: AdminQuestion.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/19
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');
require_once (OPT_DIR.'u-learning/data/AdminChoice.class.php');

/**
 * AdminQuestion
 * 
 * 設問クラス
 */
class AdminQuestion extends DataObject {

    // 設問ID
    var $qid;

    // テストID
    var $eid;
    // 設問番号
    var $number;
    // 設問
    var $question;
    // 配点　
    var $point;
    // 解説
    var $explanation;
    // 画像ファイルパス
    var $image_path;
    // 共有フラグ
    var $share;

    // 選択肢
    var $choices;

    /**
     * コンストラクタ
     */
    function AdminQuestion($qid = null, $db = null) {
        if (!is_null($qid) && !is_null($db)) {
            $this->setDB($db);
            $sql = "SELECT * FROM admin_question WHERE qid = ".$qid;
            $row = $this->DB->GetRow($sql);
            $this->setValues($row);
        }
    }

    /**
     * 配列から値をセットする
     */
    function setValues($array) {
        $this->qid = $array['qid'];
        $this->eid = $array['eid'];
        $this->number = $array['number'];
        $this->question = $array['question'];
        $this->point = $array['point'];
        $this->explanation = $array['explanation'];
        $this->image_path = $array['image_path'];
        $this->share = $array['share'];
    }

    /**
     * 自分自身をDBへ追加
     */
    function insert($db = null) {
        $this->setDB($db);
        $sql = "SELECT count(*) FROM admin_question WHERE eid = ".$this->eid." AND number = ".$this->number;
        $one = $this->DB->GetOne($sql);
        if ($one > 0) {
            error_log("number is duplicated.");
            return false;
        }
        $sql = "INSERT INTO admin_question (eid, number, question, point, explanation)"." VALUES (".$this->eid.", ".$this->number.", ".$this->DB->qstr($this->question).", ".$this->point.", ".$this->DB->qstr($this->explanation).")";
        return $this->DB->Execute($sql);
    }

    /**
     * DBを更新する
     */
    function update($db = null) {
        $this->setDB($db);
        $sql = "UPDATE admin_question SET "."number = ".$this->number.", "."eid = ".$this->eid.", "."question = ".$this->DB->qstr($this->question).", "."point = ".$this->point.", "."explanation = ".$this->DB->qstr($this->explanation)." WHERE eid = ".$this->eid." AND qid = ".$this->qid;
        return $this->DB->Execute($sql);
    }

    /**
     * DBから削除
     */
    function delete($db = null) {
        $this->setDB($db);
        // 選択肢の削除
        $sql = "DELETE FROM admin_choice WHERE eid = ".$this->eid." AND qid = ".$this->qid;
        $this->DB->Execute($sql);
        // 設問の削除
        $sql = "DELETE FROM admin_question WHERE qid = ".$this->qid." AND eid = ".$this->eid;
        $this->DB->Execute($sql);
        // 設問番号の繰上げ
        $sql = "UPDATE admin_question SET "."number = number-1"." WHERE eid = ".$this->eid." AND number > ".$this->number;
        $this->DB->Execute($sql);
    }

    /**
     * 教員ID,テストID,設問番号から問題を取得し、値をセットする
     */
    function setValuesByIDNumber($aid, $eid, $num, $db = null) {
        $this->setDB($db);
        $sql = "SELECT * FROM "." (admin_subject s INNER JOIN admin_exam e USING (sid))"." INNER JOIN admin_question q USING(eid) "." WHERE s.aid = ".$this->DB->qstr($aid)." AND e.eid = ".$eid." AND q.number = ".$num;
        $row = $this->DB->GetRow($sql);
        setValues($row);
    }

    /**
     * 質問に属する選択肢を取得する 
     */
    function getChoices($db = null) {
        $this->setDB($db);
        if (is_array($this->choices)) {
            return $this->choices;
        }
        return $this->setChoices($db);
    }

    /**
     * 選択肢を取得して保持する
     * 取得した選択肢を返す
     */
    function setChoices($db = null) {
        $this->setDB($db);
        $sql = "SELECT * FROM admin_choice WHERE qid = ".$this->qid." ORDER BY cid";
        $all = $this->DB->GetAll($sql);
        $this->choices = array ();
        foreach ($all as $row) {
            $choice = new AdminChoice();
            $choice->setValues($row);
            $choice->setDB($this->DB);
            array_push($this->choices, $choice);
        }
        return $this->choices;
    }

    /**
     * 保持している選択肢から正解の値を取得する
     */
    function getCorrectValue() {
        foreach ($this->choices as $choice) {
            if ($choice->correct == '1') {
                return $choice->value;
            }
        }
        return false;
    }

    /**
     * 保持している選択肢から正解の番号を取得する
     */
    function getCorrectNumber() {
        for ($i = 0; $i < count($this->choices); $i ++) {
            if ($this->choices[$i]->correct == '1') {
                return $i +1;
            }
        }
        return false;
    }

    /**
     * 選択肢を配列と正解から組み立てて保存する
     */
    function rebuildChoices($array, $correct, $db = null) {
        $this->setDB($db);
        $sql = "DELETE FROM admin_choice"." WHERE eid = ".$this->eid." AND qid = ".$this->qid;
        $result = $this->DB->Execute($sql);
        if (!is_array($array) || !count($array))
            return;
        foreach ($array as $value) {
            $choice = new AdminChoice();
            $choice->eid = $this->eid;
            $choice->qid = $this->qid;
            $choice->value = $value;
            if ($value == $correct) {
                $choice->correct = '1';
            } else {
                $choice->correct = '0';
            }
            $choice->insert($db);
        }
        return $result;
    }

    /**
     * 所持する選択肢の中から正答をセットする
     */
    function setCorrectChoice($correct, $db = null) {
        $this->setDB($db);
        $choices = $this->getChoices($db);
        foreach ($choices as $choice) {
            if ($choice->value == $correct) {
                $choice->correct = '1';
            } else {
                $choice->correct = '0';
            }
            $choice->update($db);
        }
    }

}
?>