<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: QuestionAction.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/18
//

/** 
*	QuestionAction.class.php
*	Mai Kawasaki
*	2005/05/18
*/
require_once(OPT_DIR.'u-learning/config.php');
require_once(OPT_DIR.'u-learning/action/SecureStudentAction.class.php');
require_once(OPT_DIR.'u-learning/data/Admin.class.php');
require_once(OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once(OPT_DIR.'u-learning/data/AdminQuestion.class.php');
require_once(OPT_DIR.'u-learning/data/AdminChoice.class.php');
require_once(OPT_DIR.'u-learning/data/StudentExam.class.php');
require_once(OPT_DIR.'u-learning/data/StudentQuestion.class.php');
require_once(OPT_DIR.'u-learning/data/StudentChoice.class.php');

/** 
*	QuestionAction
*/
class QuestionAction extends SecureStudentAction {
    function execute (&$controller, &$request, &$user) {
	
		// uEU̔
		$type = $this->getUserAgentType();
		$request->setAttribute('type', $type);
		
		$DB = $request->getAttribute('DB');
		$aid = $user->getAttribute('aid');
		$uid = $user->getAttribute('uid');
		$eid = $request->getParameter('eid');
		$rid = $request->getParameter('rid');	
		$number = $request->getParameter('number') ;	// ݂̖ԍ
		$back_flug = false;
		// 擾
		$request->setAttribute('admin', new Admin($aid, $DB));


		// ߂Ẵy[Wɂ
		if($number == '' || is_null($number)){
			// 1
			$number = 1;
			// 񓚃f[^o^
			$exam_student_first = new StudentExam();
			$exam_student_first->aid = $aid;
			$exam_student_first->uid = $uid;
			$exam_student_first->eid = $eid;		
			$rid = $exam_student_first->getUnansweredID($DB);
			if ( $rid == '' || is_null($rid) ){
				$exam_student_first->insert($DB);				
				$rid = $DB->lastInsertID('user_exam', 'rid');
			}
			$exam_student_first->rid = $rid;
			// eXg擾
			$exam_admin_first = new AdminExam($eid, $DB);
			$exam_admin_first->getSubjectName($DB);
			// eXg̖萔擾
	    	$sql_count = 'select count(eid) as count from admin_question where eid = '.$eid;
			 //ZbVɊi[
			session_unregister('exam_admin');
			session_unregister('exam_student');
			session_unregister('count');
			$_SESSION['exam_admin'] = serialize($exam_admin_first);
			$_SESSION['exam_student'] = serialize($exam_student_first);
			$_SESSION['count'] = serialize( $exam_admin_first->getQuestionsCount());
		}
		// eXg擾
		$exam_admin =  unserialize($_SESSION['exam_admin']);
		$exam_student =  unserialize($_SESSION['exam_student']);
		
		// ߐ؂莞Ԕ
		$now_time = time();
		if( !is_null($exam_admin->deadline_time) && $exam_admin->deadline_time != ''){
			$deadline_time = strtotime($exam_admin->deadline_time);
			if ($deadline_time - $now_time < 0){
				$this->location('Exam', 'Result', array('rid'=>$rid, 'now_time'=>$now_time));
				return VIEW_NONE;
			}
		}
		
		// uցv{^ꂽ
		if($request->getParameter('next')){
			$qid = $request->getParameter('qid');
			$cid = $request->getParameter('choice');
			// 񓚂DBɕۑ 
			if (!is_null($cid) && $cid != ''){
				$choice_admin = new AdminChoice($cid,$DB);
				// user_choice
				$choice_student = new StudentChoice($cid, $DB);
				$choice_student->rid = $rid;
				$choice_student->qid = $qid;
				$choice_student->cid = $cid;
				$choice_student->aid = $aid;
				$choice_student->uid = $uid;
				$choice_student->eid = $eid;
				$choice_student->choice = $choice_admin->value;
				$choice_student->save($DB);
				// user_question
				$question_admin = new AdminQuestion($qid, $DB);
				$question_student = new StudentQuestion();
				$question_student->rid = $rid;
				$question_student->qid = $qid;
				$question_student->aid = $aid;
				$question_student->uid = $uid;
				$question_student->eid = $eid;
				if($choice_admin->correct){
					$question_student->point = $question_admin->point;
				} else {
					$question_student->point = 0;
				}
				$question_student->save($DB);	
			} else {
				// user_question
				$question_student = new StudentQuestion();
				$question_student->rid = $rid;
				$question_student->qid = $qid;
				$question_student->aid = $aid;
				$question_student->uid = $uid;
				$question_student->eid = $eid;
				$question_student->point = 0;
				$question_student->save($DB);				
			}
			// user_exam
			$exam_student->setPoints($DB);
			$exam_student->updateWithoutReplyDate($DB);
			// ZbVɓo^
			session_unregister('exam_student');
			$_SESSION['exam_student'] = serialize($exam_student);

			// 1₲Ƃɉ\鎞
			if($exam_admin->correct == '1'){
				session_unregister('question_admin');
				$_SESSION['question_admin'] = serialize($exam_admin->getQuestionByNumber($number, $DB));
				$this->location('Exam', 'ExplanationEvery', array('rid'=>$rid, 'cid'=>$cid, 'number'=>$number));
				return VIEW_NONE;
			}

			// ̖
			$number += 1;
			$next = $exam_admin->getQuestionByNumber($number, $DB);
			if( $next->qid == '' || is_null($next->qid) ){
				$this->location('Exam', 'Confirm', array('rid'=>$rid));
				return VIEW_NONE;
			}
			$back_flug = true;			
			
		// u߂v{^ꂽ
		} else if($request->getParameter('back')){
			$number = $number - 1;
		// ueXgIv{^ꂽ
		} else if($request->getParameter('end')){
			$this->location('Exam', 'Confirm', array('rid'=>$rid));
			return VIEW_NONE;
		}

		// Ɖ񓚂擾
		$question_admin_new = $exam_admin->getQuestionByNumber($number, $DB);
		$choices_admin = $question_admin_new->getChoices($DB);
		// ݂̉񓚂擾
		$question_student_now = new StudentQuestion($rid, $question_admin_new->qid, $DB);
		$choice_student = $question_student_now->getChoice($DB);
		// ߂{^\tO
		if( $number - 1 >= 1){
			$back_flug = true;			
		} 
		
		$request->setAttribute('exam_admin', $exam_admin);
		$request->setAttribute('count', unserialize($_SESSION['count']));
		$request->setAttribute('rid', $rid);
		$request->setAttribute('question_admin', $question_admin_new);
		$request->setAttribute('back_flug', $back_flug);
		$request->setAttribute('choices_admin', $choices_admin);
		$request->setAttribute('choice_student', $choice_student);
		
		return VIEW_SUCCESS;
    }
	
}

?>