<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: ListAction.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');

/**
 * ListAction
 * 
 * 学生一覧
 */
class ListAction extends AdminAction {

    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db = $request->getAttribute('DB');
        $admin = new Admin($user->getAttribute('aid'), $db);

        // 学生削除
        if ($request->hasParameter('del_id')) {
            $admin->deleteUser($request->getParameter('del_id'));
        }

        // 科目取得
        $subjects = $admin->getSubjects();
        // 科目に学生をセット
        foreach ($subjects as $key => $subject) {
            $subjects[$key]->setUsers();
        }
        $request->setAttribute('subjects', $subjects);

        // すべての学生を取得
        $users = $admin->setAllUsers();
        $request->setAttribute('all_users', $users);

        return VIEW_SUCCESS;
    }

}
?>