<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: ListAction.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');

/**
 * ListAction
 * 
 * 科目一覧
 */
class ListAction extends AdminAction {

    /**
     * POST
     */
    function execute(& $controller, & $request, & $user) {
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        if ($request->hasParameter('add_submit')) {
            // 追加処理
            $subject= new Subject();
            $subject->aid= $admin->aid;
            $subject->name= $request->getParameter('add_name');
            $subject->usable= $request->getParameter('add_usable');
            // DB追加
            $subject->insert($db);

        }
        elseif ($request->hasParameter('edit_submit')) {
            // 更新処理
            $subject= new Subject($request->getParameter('edit_sid'), $db);
            $subject->name= $request->getParameter('edit_name');
            $subject->usable= $request->getParameter('edit_usable');
            // DB更新
            $subject->update($db);

        }
        elseif ($request->hasParameter('del_submit')) {
            // 削除処理
            $subject= new Subject($request->getParameter('del_sid'), $db);
            $subject->del= '1';
            // DB更新
            $subject->update($db);

        }

        $this->location('Subject', 'List');
        return VIEW_NONE;
    }

    function getRequestMethods() {
        return REQ_POST;
    }

    /**
     * GET
     */
    function getDefaultView(& $controller, & $request, & $user) {
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);
        return VIEW_SUCCESS;
    }

}
?>