<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: AdminExam.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/19
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');
require_once (OPT_DIR.'u-learning/data/Subject.class.php');
require_once (OPT_DIR.'u-learning/data/AdminQuestion.class.php');

/**
 * AdminExam
 * 
 * テストクラス
 */
class AdminExam extends DataObject {

    // テストID
    var $eid;

    // 科目ID;
    var $sid;
    // テスト名
    var $name;
    // 再受験フラグ
    var $retry;
    // 解答表示フラグ
    var $correct;
    // 共有フラグ
    var $share;
    // 公開フラグ
    var $pub;
    // 更新日
    var $update_time;
    // 配信日
    var $publish_time;
    // テスト概要
    var $summary;
    // 回答締切日
    var $deadline_time;

    // 設問
    var $questions;
    // 科目名
    var $sname;
    // 締切タイプ
    var $deadline_type;

    /**
     * コンストラクタ
     */
    function AdminExam($eid = null, $db = null) {
        if (!is_null($eid) && !is_null($db)) {
            $this->setDB($db);
            $sql = "SELECT * FROM admin_exam WHERE eid = $eid";
            $row = $this->DB->GetRow($sql);

            $this->setValues($row);
        }
    }

    /**
     * 配列に含まれているプロパティをセットする
     */
    function setExamValues($array) {
        $this->setValues($array);
    }

    /**
     * 配列に含まれているプロパティをセットする
     */
    function setValues($array) {
        $this->eid = $array['eid'];
        $this->sid = $array['sid'];
        $this->name = $array['name'];
        $this->retry = $array['retry'];
        $this->correct = $array['correct'];
        $this->share = $array['share'];
        $this->pub = $array['pub'];
        $this->update_time = $array['update_time'];
        $this->publish_time = $array['publish_time'];
        $this->summary = $array['summary'];
        $this->deadline_time = $array['deadline_time'];
        if (array_key_exists('sname', $array))
            $this->sname = $array['sname'];
    }

    /**
     * 自分自身をDBに追加
     */
    function insert($db = null) {
        $this->setDB($db);
        $sql = "INSERT INTO admin_exam (sid, name, retry, correct, update_time)"." VALUES (".$this->sid.", ".$this->DB->qstr($this->name).", ".$this->DB->qstr($this->retry).", ".$this->DB->qstr($this->correct).", "."NOW() )";
        return $this->DB->Execute($sql);
    }

    /**
     * DBを更新
     */
    function update($db = null) {
        $this->setDB($db);
        $sql = "UPDATE admin_exam SET "."sid = ".$this->sid.", "."name = ".$this->DB->qstr($this->name).", "."retry = ".$this->DB->qstr($this->retry).", "."correct = ".$this->DB->qstr($this->correct).", "."update_time = NOW()"." WHERE eid = ".$this->eid;
        return $this->DB->Execute($sql);
    }

    /**
     * テストに属する質問を取得する 
     */
    function getQuestions($db = null) {
        $this->setDB($db);
        if (is_array($this->questions)) {
            return $this->questions;
        }
        return $this->setQuestions($db);
    }

    /**
     * テストに属する設問をDBから取得する
     * 取得した設問を返す
     */
    function setQuestions($db = null) {
        $this->setDB($db);
        $sql = "SELECT * FROM admin_question "." WHERE eid = ".$this->eid." ORDER BY number";
        $all = $this->DB->GetAll($sql);
        $this->questions = array ();
        foreach ($all as $row) {
            $question = new AdminQuestion();
            $question->setValues($row);
            $question->setDB($this->DB);
            $question->setChoices();
            array_push($this->questions, $question);
        }
        return $this->questions;
    }

    /**
     * 設問の次の番号を取得
     */
    function getNextQuestionNumber($db = null) {
        $this->setDB($db);
        $sql = "SELECT max(number) FROM admin_question "." WHERE eid = ".$this->eid;
        $one = $this->DB->GetOne($sql);
        return $one +1;
    }

    /**
     * 設問番号から設問を取得する
     */
    function getQuestionByNumber($num, $db = null) {
        $this->setDB($db);
        $sql = "SELECT q.* FROM "."admin_exam e INNER JOIN admin_question q USING(eid)"." WHERE e.eid = ".$this->eid." AND q.number = ".$num;
        $row = $this->DB->GetRow($sql);
        if (count($row) < 1)
            return null;
        $question = new AdminQuestion();
        $question->setValues($row);
        return $question;
    }

    /**
     * テストの合計点を取得する
     */
    function getTotalPoint($db = null) {
        $this->setDB($db);
        $questions = $this->getQuestions($db);
        $total = 0;
        foreach ($questions as $question) {
            $total += $question->point;
        }
        return $total;
    }

    /**
     * テストの設問数を取得する
     */
    function getQuestionsCount() {
        $select = "SELECT count(*)";
        $from = "FROM admin_question";
        $where = "WHERE eid = ".$this->eid;
        return $this->DB->GetOne("$select $from $where");
    }

    /**
     * 科目名を取得する
     */
    function getSubjectName($db = null) {
        $this->setDB($db);
        if ($this->sname)
            return sname;
        $this->getSubject($db);
        return $this->sname;
    }

    /**
     * 科目を取得する
     */
    function getSubject($db = null) {
        $this->setDB($db);
        $subject = new Subject($this->sid, $db);
        $this->sname = $subject->name;
        return $subject;
    }

    /**
     * 配信する
     */
    function publish() {
        // すでに配信済でないか確認
        if ($this->isPublished())
            return null;

        // DB更新
        $deadline = ($this->deadline_time) ? $this->DB->DBTimeStamp(date("YmdHis", strtotime($this->deadline_time))) : 'NULL';
        $sql = "UPDATE admin_exam SET "."publish_time = NOW(), "."summary = ".$this->DB->qstr($this->summary).", "."deadline_time = ".$deadline." "." WHERE eid = ".$this->eid;
        return $this->DB->Execute($sql);
    }

    /**
     * すでに配信済かどうか確認する
     */
    function isPublished() {
        $select = "SELECT publish_time";
        $from = "FROM admin_exam";
        $where = "WHERE eid = ".$this->eid;
        if ($this->DB->GetOne("$select $from $where"))
            return true;
        return false;
    }

    /**
     * 締切の値からラベルを取得する
     */
    function getDeadlineLabel() {
        if ($this->deadline_type == 'today') {
            return '今日中';
        }
        elseif ($this->deadline_type == 'tommorow') {
            return '明日中';
        }
        elseif ($this->deadline_type == 'date') {
            return '日付指定(当日可)';
        }
        elseif ($this->deadline_type == 'time') {
            return '日時指定';
        } else {
            return '締切なし';
        }
    }

    /**
     * 締切タイプの値から日時を取得する
     */
    function getDeadlineTime() {
        if (!$this->deadline_time)
            return null;
        $time = strtotime($this->deadline_time);
        if ($this->deadline_type == 'today' || $this->deadline_type == 'tommorow' || $this->deadline_type == 'date') {
            return date("Y/m/d", $time);
        }
        elseif ($this->deadline_type == 'time') {
            return date("Y/m/d G:i:s", $time);
        }
        return null;
    }

    /**
     * 締切日をセットする
     */
    function setDeadline($type, $year = null, $month = null, $day = null, $hour = null, $min = null, $sec = null) {
        $this->deadline_type = $type;
        if ($type == 'today') {
            $this->deadline_time = date("Y/m/d")." 23:59:59";
        }
        elseif ($type == 'tommorow') {
            $this->deadline_time = date("Y/m/d", time() + 86400)." 23:59:59";
        }
        elseif ($type == 'date') {
            $this->deadline_time = $year."/".$month."/".$day." 23:59:59";
        }
        elseif ($type == 'time') {
            $this->deadline_time = $year."/".$month."/".$day." ".$hour.":".$min.":00";
        }
        return $this->deadline_time;
    }

}
?>