<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: AdminAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/23
//

require_once (OPT_DIR.'u-learning/action/SecureDBAction.class.php');
require_once (OPT_DIR.'u-learning/lib/TemplateUtils.class.php');

/**
 * AdminAction
 * 
 * 管理者ログイン後のページ
 */
class AdminAction extends SecureDBAction {

    /**
     * 初期化メソッド
     * 
     * Action の execute の前に呼ばれる
     */
    function initialize(& $controller, & $request, & $user) {
        parent :: initialize($controller, $request, $user);

        $DB = $request->getAttribute('DB');
        $admin = new Admin($user->getAttribute('aid'), $DB);
        $request->setAttribute('admin', $admin);
        return TRUE;
    }

    /**
     * Locationヘッダで別のページへリダイレクトする
     */
    function location($module, $action, $params = null, $place = null) {
        $url = TemplateUtils :: createLink($module, $action, $params, $place);
        header("Location: ".$url);
        return VIEW_NONE;
    }
}
?>