//
//  PPrefIntegration.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------

#import "PPrefIntegration.h"


@implementation PPrefIntegration

- (void)awakeFromNib
{
    userDefaults = [NSUserDefaults standardUserDefaults];
    
    if(![userDefaults objectForKey:@"PMoveImages"])
       [userDefaults setBool:0 forKey:@"PMoveImages"];
       
    if(![userDefaults objectForKey:@"PMoveVideos"])
       [userDefaults setBool:0 forKey:@"PMoveVideos"];
       
    [self readConfFiles];
  
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

- (void)readConfFiles;
{
    tempBool = [userDefaults boolForKey: @"PMoveImages"];
    [moveImages setState: (tempBool) ? NSOnState : NSOffState];
    
    tempBool = [userDefaults boolForKey: @"PMoveVideos"];
    [moveVideos setState: (tempBool) ? NSOnState : NSOffState];
    
}

/* IB Actions */
- (IBAction)moveImages: (id)sender;
{
    [userDefaults setBool: [sender intValue] forKey: @"PMoveImages"];
}

- (IBAction)moveVideos: (id)sender;
{
    [userDefaults setBool: [sender intValue] forKey: @"PMoveVideos"];
}
@end
