//
// PPrefDownloads.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------

#import "PPrefDownloads.h"

@implementation PPrefDownloads

- (void)awakeFromNib
{
    userDefaults = [NSUserDefaults standardUserDefaults];
    
    gift_conf = [PGiFTConf singleton];    
    
    [self readConfFiles];

    if ([userDefaults boolForKey:@"PRemoveCompletedDownloads"]) [removeCompleted setState:NSOnState];
    else [removeCompleted setState:NSOffState];
    
    if ([userDefaults boolForKey:@"PRemoveCancelledDownloads"]) [removeCancelled setState:NSOnState];
    else [removeCancelled setState:NSOffState];    
    
    if ([userDefaults boolForKey:@"PSwitchToDownloads"]) [switchToDownload setState:NSOnState];
    else [switchToDownload setState:NSOffState];
    
    if ([userDefaults boolForKey:@"PConfirmDownloadCancels"]) [confirmCancel setState:NSOnState];
    else [confirmCancel setState:NSOffState];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(readConfFiles) name:@"PUpdateFromConfFiles" object:nil];

}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

- (void)enable
{
    [incoming setEnabled:YES];
    [completed setEnabled:YES];
}

- (void)disable
{
    [incoming setEnabled:NO];
    [completed setEnabled:NO];
}

- (void)readConfFiles
{
    if (gift_conf = [PGiFTConf singleton]) [self enable];
    else {
        [self disable];
        return;
    }

    [gift_conf read];
    NSString  *_in = [gift_conf optionForKey:@"incoming"];
    NSString *_comp = [gift_conf optionForKey:@"completed"];
    if (_in) [completed setStringValue:_comp];
    if (_comp) [incoming setStringValue:_in];
}

- (IBAction)cancelledPrefsChanged:(id)sender
{
    if ([removeCancelled state]==NSOnState) [userDefaults setBool:YES forKey:@"PRemoveCancelledDownloads"];
    else [userDefaults setBool:NO forKey:@"PRemoveCancelledDownloads"];
}

- (IBAction)completedPrefsChanged:(id)sender
{
    if ([removeCompleted state]==NSOnState) [userDefaults setBool:YES forKey:@"PRemoveCompletedDownloads"];
    else [userDefaults setBool:NO forKey:@"PRemoveCompletedDownloads"];
}

- (IBAction)switchToDownloadPrefsChanged:(id)sender
{
    if ([switchToDownload state]==NSOnState) [userDefaults setBool:YES forKey:@"PSwitchToDownloads"];
    else [userDefaults setBool:NO forKey:@"PSwitchToDownloads"];
}

- (IBAction)completedChanged:(id)sender
{
	//NSDictionary *fattrs=[[NSFileManager defaultManager] fileAttributesAtPath:[sender stringValue]];

    [gift_conf setValue:[[sender stringValue] stringByAbbreviatingWithTildeInPath] forKey:@"completed"];
	[gift_conf setValue:[[[sender stringValue] stringByAbbreviatingWithTildeInPath] stringByAppendingPathComponent:@".incoming"] forKey:@"incoming"];
    [self readConfFiles];
    [[NSNotificationCenter defaultCenter] postNotificationName:@"PCompletedDirectoryChanged" object:self userInfo:nil];
}

- (IBAction)confimCancelChanged:(id)sender
{
    if ([confirmCancel state]==NSOnState) [userDefaults setBool:YES forKey:@"PConfirmDownloadCancels"];
    else [userDefaults setBool:NO forKey:@"PConfirmDownloadCancels"];
}

- (IBAction)incomingChanged:(id)sender
{
	// removed this and incoming is now always going to be derived from the completed folder.
	// this was because some users were setting the incoming folder to their desktop. this is dangerous
	// because when the incoming folder becomes corrupted the solution is to delete that folder.
	// in any reguard a user should never need to change this. Its just too destructive.
	
    //[gift_conf setValue:[[sender stringValue] stringByAbbreviatingWithTildeInPath] forKey:@"incoming"];
    //[self readConfFiles];
}

- (IBAction)browseIncoming:(id)sender
{

    NSOpenPanel *open = [NSOpenPanel openPanel];
    [open setCanChooseFiles:NO];
    [open setCanChooseDirectories:YES];
    int ret = [open 
        runModalForDirectory:NSHomeDirectory()
        file:nil
        types:nil
    ];
    if (ret==NSOKButton) {
        [gift_conf setValue:[[[open filenames] objectAtIndex:0] stringByAbbreviatingWithTildeInPath] forKey:@"incoming"];
        [self readConfFiles];
    }
}

- (IBAction)browseCompleted:(id)sender
{
    NSOpenPanel *open = [NSOpenPanel openPanel];
    [open setCanChooseFiles:NO];
    [open setCanChooseDirectories:YES];
    int ret = [open 
        runModalForDirectory:NSHomeDirectory()
        file:nil
        types:nil
    ];
    if (ret==NSOKButton) {
        [gift_conf setValue:[[[open filenames] objectAtIndex:0] stringByAbbreviatingWithTildeInPath] forKey:@"completed"];
		[gift_conf setValue:[[gift_conf optionForKey:@"completed"] stringByAppendingPathComponent:@".incoming"] forKey:@"incoming"];
        [self readConfFiles];
        [[NSNotificationCenter defaultCenter] postNotificationName:@"PCompletedDirectoryChanged" object:self userInfo:nil];
    }
}

@end
