// PMediaType.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------

#import "PMediaType.h"


PMediaType PMediaTypeForExtension(id theExtension)
{
    static NSSet* music = nil;
    static NSSet* video = nil;
    static NSSet* image = nil;
    static NSSet* document = nil;

    if (!music) {
        music = [[NSSet alloc] initWithObjects: @"mp3", @"ogg", @"wma", @"aiff", @"aif", @"au", @"mod", @"wav", @"mid", @"m4a", nil];
        video = [[NSSet alloc] initWithObjects: @"mp4", @"avi", @"mov", @"mpg", @"mpeg", @"asf", @"rm", @"ram", @"divx", @"wmv", nil];
        image = [[NSSet alloc] initWithObjects: @"gif", @"jpg", @"jpe", @"jpeg", @"png", @"tif", @"tiff", @"bmp", nil];
        document = [[NSSet alloc] initWithObjects: @"doc", @"pdf", @"rtf", @"rtfd", @"txt", @"htm", @"html", nil];
    }
    
    if ([music member: theExtension]) return PMusic;
    if ([video member: theExtension]) return PVideo;
    if ([image member: theExtension]) return PImage;
    if ([document member: theExtension]) return PDocument;
    return PFile;
}

BOOL isMusic(id theExtension) {
    return PMediaTypeForExtension(theExtension) == PMusic;
}

BOOL isImage(id theExtension) {
    return PMediaTypeForExtension(theExtension) == PImage;
}

BOOL isVideo(id theExtension) {
    return PMediaTypeForExtension(theExtension) == PVideo;
}

BOOL isDocument(id theExtension) {
    return PMediaTypeForExtension(theExtension) == PDocument;
}