// PLogViewerController.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------

#import "PLogViewerController.h"

@implementation PLogViewerController

- (void)awakeFromNib
{
    [log setRichText:NO];
    [self getLog];
}

- (void) getLog
{       
        NSString *thePath;
        
        thePath = @"~/Library/Application Support/Poisoned/giftd.log";
        thePath = [thePath stringByExpandingTildeInPath];
        
        if ([[NSFileManager defaultManager] fileExistsAtPath: thePath])
            [log readRTFDFromFile:thePath];
}

- (IBAction)logViewer:(id)sender
{
    [logWindow makeKeyAndOrderFront:self];
	[logWindow center];
}

- (IBAction)refreshLog:(id)sender
{
    [self getLog];
    
    [log pageDown:self];
}

@end
