//
//  PDataFormatter.m
//  PoisonGiFT
//
//  Created by Silvio Rizzi on Thu Jan 29 2004.
//  Copyright (c) 2004 gottsilla.net. All rights reserved.
//

#import "PDataFormatter.h"


@implementation PDataFormatter

+ (NSString *)formatSize:(NSString *)size
{
    if (!size) return @"";
    long long s;
    [[NSScanner scannerWithString:size] scanLongLong:&s];
    if (s<1024) return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%d B",@"Misc",nil),(int)s];
    else if (s<1048576) return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%d kB",@"Misc",nil),(int)(s/1024)];
    else if (s<1073741824) return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%.2f MB",@"Misc",nil),(s/1048576.0)];
    else return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%.2f GB",@"Misc",nil),(s/1073741824.0)];
}

+ (NSString *)formatBitrate:(NSString *)bitrate {
    if (!bitrate) return @"";
    int br = [bitrate intValue];
    if (br<10000)
        return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%d kbps",@"Misc",nil),br];
    else if (br<999999)
        return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%d kbps",@"Misc",nil),br/1000];
    else
        return @"";
}

+ (NSString *)formatDuration:(NSString *)data {
    if (!data) return @"";
    // is it ok to just parse for an integer??? -rizzi
    int s = [data intValue];
    if (s<60) return [NSString stringWithFormat:NSLocalizedStringFromTable(@"0:%02d",@"Misc",nil),s];
    else if (s<3600) return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%d:%02d",@"Misc",nil),s/60,s%60];
    else {
        int hrs = s/3600;
        s -= hrs*3600;
        return [NSString stringWithFormat:NSLocalizedStringFromTable(@"%d:%02d:%02d",@"Misc",nil),hrs,s/60,s%60];
    }
}

@end
