//
// FileHandle.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------

#import "FileHandle.h"

@implementation FileHandle

+ (BOOL) moveFileToUserTrash : (id) filePath
{
	// this function was ripped right out of the cocoa documentation from apple and altered.
	
	CFURLRef        trashURL;
    FSRef           trashFolderRef;
    CFStringRef     trashPath;
    OSErr           err;
	int				ok=0;
	
    NSFileManager   *mgr = [NSFileManager defaultManager];

    err = FSFindFolder(kUserDomain, kTrashFolderType, kDontCreateFolder, &trashFolderRef);
    if (err == noErr) 
	{
		trashURL = CFURLCreateFromFSRef(kCFAllocatorSystemDefault, &trashFolderRef);
		if (trashURL) 
		{
			trashPath = CFURLCopyFileSystemPath (trashURL, kCFURLPOSIXPathStyle);
			NSString *filePathDest = filePath;
			while (!ok) 
			{
				if ([mgr fileExistsAtPath :[(NSString *)trashPath stringByAppendingPathComponent:[filePathDest lastPathComponent]]])
					filePathDest = [filePathDest stringByAppendingString:@" copy"];
				else
					ok=1;
			}
			if (![mgr movePath:filePath toPath:[(NSString *)trashPath stringByAppendingPathComponent:[filePathDest lastPathComponent]] handler:nil])
			{
				NSLog(@"Move from %@ to User Trash did not succeed!", filePath);
				return NO;
			} else
				[[NSWorkspace sharedWorkspace] noteFileSystemChanged: (NSString*)trashPath];
		}
		else 
			return NO;
    }
	else
		return NO;
		
	return YES;
}

+ (BOOL) isAppRunning:(NSString *)theApp
{
	NSTask *task = [[NSTask alloc] init];
	[task setLaunchPath:@"/bin/ps"];
	[task setArguments:[NSArray arrayWithObjects:@"-x",@"-w",nil]];

	NSPipe *pipe = [NSPipe pipe];
	[task setStandardOutput:pipe];

	[task launch];

	NSFileHandle *handle= [pipe fileHandleForReading];
	NSData *data= [handle readDataToEndOfFile];
	NSString *psx= [NSString stringWithCString:[data bytes]];

	[task release];

	if ([psx rangeOfString:theApp].location==NSNotFound)
		return NO;
	else
		return YES;
}

+ (void) forceShutdown: (id)theApp
{
	NSTask *task = [[NSTask alloc] init];
	[task setLaunchPath:@"/usr/bin/killall"];
	[task setArguments:[NSArray arrayWithObjects:theApp,nil,nil]];

	[task launch];

	[task release];
}

+ (BOOL) fileExists: (id) filePath
{
	NSFileManager   *mgr = [NSFileManager defaultManager];
	
	if ([mgr fileExistsAtPath : (NSString *)filePath])
		return YES;
	else
		return NO;
}

@end
