/*
 * Decompiled with CFR 0.152.
 */
package org.nihonsoft.turbosql.modules.pg.app.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.nihonsoft.turbosql.modules.pg.app.PostgreSQLDataObject;
import org.nihonsoft.turbosql.modules.pg.app.dialogs.RelationalTableColumnModel;
import org.nihonsoft.turbosql.modules.pg.app.dialogs.RelationalTableColumnRowDataObject;

public class TableAddFrame
extends JFrame
implements ActionListener,
TableModelListener {
    String serverIP;
    String serverPort;
    String username;
    String password;
    String dbName;
    JTable table;
    RelationalTableColumnModel model;
    JScrollPane resultsPane;
    int singleSelectedRow = -1;
    boolean hasSingleSelectedRow = false;
    JLabel columnDefaultValueLabel;
    JTextField columnDefaultValueField;
    JLabel columnCommentLabel;
    JTextField columnCommentField;
    JLabel columnNumericPrecisionLabel;
    JTextField columnNumericPrecisionField;
    JButton okButton;
    JButton cancelButton;
    ActionListener refreshListener;

    public TableAddFrame(String serverIP, String serverPort, String username, String password, String dbName, ActionListener refreshListener) {
        super("Add Table - " + dbName);
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.refreshListener = refreshListener;
        this.setBounds(0, 0, 400, 300);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowHandler());
        this.getContentPane().setLayout(new BorderLayout());
        this.model = new RelationalTableColumnModel();
        this.model.addTableModelListener(this);
        this.table = new JTable(this.model);
        this.resultsPane = new JScrollPane(this.table);
        this.table.setAutoResizeMode(0);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.setUpColumnTypeColumn(this.table.getColumnModel().getColumn(2));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.getContentPane().add((Component)this.resultsPane, "Center");
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel contentPanel = new JPanel(new GridLayout(3, 2));
        tabbedPane.setBounds(0, 0, 100, 40);
        contentPanel.setPreferredSize(new Dimension(100, 60));
        this.columnDefaultValueLabel = new JLabel("Default value: ");
        this.columnDefaultValueField = new JTextField();
        this.columnCommentLabel = new JLabel("Description: ");
        this.columnCommentField = new JTextField();
        this.columnNumericPrecisionLabel = new JLabel("Numeric Precision");
        this.columnNumericPrecisionField = new JTextField();
        contentPanel.add((Component)this.columnDefaultValueLabel, 0);
        contentPanel.add((Component)this.columnDefaultValueField, 1);
        contentPanel.add((Component)this.columnCommentLabel, 2);
        contentPanel.add((Component)this.columnCommentField, 3);
        contentPanel.add((Component)this.columnNumericPrecisionLabel, 4);
        contentPanel.add((Component)this.columnNumericPrecisionField, 5);
        tabbedPane.addTab("Column Properties", null, contentPanel, "Properties");
        tabbedPane.setSelectedIndex(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    TableAddFrame.this.processPreviousRowSelection();
                    TableAddFrame.this.hasSingleSelectedRow = false;
                    TableAddFrame.this.singleSelectedRow = -1;
                    TableAddFrame.this.columnDefaultValueField.setText("");
                    TableAddFrame.this.columnCommentField.setText("");
                    TableAddFrame.this.columnNumericPrecisionField.setText("");
                } else {
                    int maxSelectedRow;
                    int minSelectedRow = lsm.getMinSelectionIndex();
                    if (minSelectedRow == (maxSelectedRow = lsm.getMaxSelectionIndex())) {
                        TableAddFrame.this.processPreviousRowSelection();
                        TableAddFrame.this.hasSingleSelectedRow = true;
                        TableAddFrame.this.singleSelectedRow = minSelectedRow;
                        TableAddFrame.this.columnDefaultValueField.setText((String)TableAddFrame.this.model.getPropertyValueAt(TableAddFrame.this.singleSelectedRow, 0));
                        TableAddFrame.this.columnCommentField.setText((String)TableAddFrame.this.model.getPropertyValueAt(TableAddFrame.this.singleSelectedRow, 1));
                        TableAddFrame.this.columnNumericPrecisionField.setText((String)TableAddFrame.this.model.getPropertyValueAt(TableAddFrame.this.singleSelectedRow, 2));
                    } else {
                        TableAddFrame.this.processPreviousRowSelection();
                        TableAddFrame.this.hasSingleSelectedRow = false;
                        TableAddFrame.this.singleSelectedRow = -1;
                        TableAddFrame.this.columnDefaultValueField.setText("");
                        TableAddFrame.this.columnCommentField.setText("");
                        TableAddFrame.this.columnNumericPrecisionField.setText("");
                    }
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)tabbedPane, "North");
        southPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)southPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    public void setUpColumnTypeColumn(TableColumn columnTypeColumn) {
        JComboBox<String> comboBox = new JComboBox<String>();
        String[] supportedDataTypes = RelationalTableColumnRowDataObject.getSupportedDataTypes();
        String[] unsupportedDataTypes = RelationalTableColumnRowDataObject.getUnsupportedDataTypes();
        int i = 0;
        while (i < supportedDataTypes.length) {
            comboBox.addItem(supportedDataTypes[i]);
            ++i;
        }
        comboBox.addItem("");
        comboBox.addItem("----------");
        comboBox.addItem("unsupported*");
        comboBox.addItem("----------");
        int i2 = 0;
        while (i2 < unsupportedDataTypes.length) {
            comboBox.addItem(unsupportedDataTypes[i2]);
            ++i2;
        }
        columnTypeColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for combo box");
        columnTypeColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = columnTypeColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Click the sport to see a list of choices");
        }
    }

    private void processPreviousRowSelection() {
        if (!this.hasSingleSelectedRow) {
            return;
        }
        this.model.setPropertyValueAt(this.columnDefaultValueField.getText(), this.singleSelectedRow, 0);
        this.model.setPropertyValueAt(this.columnCommentField.getText(), this.singleSelectedRow, 1);
        this.model.setPropertyValueAt(this.columnNumericPrecisionField.getText(), this.singleSelectedRow, 2);
    }

    private String createTable() {
        Vector modifiedDataRows = this.model.getModifiedDataRows();
        int modSize = modifiedDataRows.size();
        if (modSize == 0) {
            return "No columns to create table";
        }
        String tableName = JOptionPane.showInputDialog(this, "Enter a name for the table:", "Add Table", -1);
        if (tableName == null) {
            return "Name not entered";
        }
        if (tableName.equals("")) {
            return "Name not entered";
        }
        boolean[] relationalColumnPrimaryKeys = new boolean[modSize];
        String[] relationalColumnNames = new String[modSize];
        String[] relationalColumnTypes = new String[modSize];
        Integer[] relationalColumnLengths = new Integer[modSize];
        boolean[] relationalColumnAllowNullsArray = new boolean[modSize];
        String[] relationalColumnDefaultValues = new String[modSize];
        String[] relationalColumnComments = new String[modSize];
        Integer[] relationalColumnNumericPrecisions = new Integer[modSize];
        int i = 0;
        while (i < modSize) {
            RelationalTableColumnRowDataObject dataObject = (RelationalTableColumnRowDataObject)modifiedDataRows.get(i);
            relationalColumnPrimaryKeys[i] = (Boolean)dataObject.getValueAt(0);
            relationalColumnNames[i] = (String)dataObject.getValueAt(1);
            relationalColumnTypes[i] = (String)dataObject.getValueAt(2);
            relationalColumnLengths[i] = dataObject.isLengthEditable() ? (Integer)dataObject.getValueAt(3) : null;
            relationalColumnAllowNullsArray[i] = (Boolean)dataObject.getValueAt(4);
            relationalColumnDefaultValues[i] = (String)dataObject.getPropertyValueAt(0);
            relationalColumnComments[i] = (String)dataObject.getPropertyValueAt(1);
            try {
                relationalColumnNumericPrecisions[i] = Integer.getInteger((String)dataObject.getPropertyValueAt(2));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            ++i;
        }
        return PostgreSQLDataObject.createTable(this.serverIP, this.serverPort, this.username, this.password, this.dbName, tableName, relationalColumnPrimaryKeys, relationalColumnNames, relationalColumnTypes, relationalColumnLengths, relationalColumnAllowNullsArray, relationalColumnDefaultValues, relationalColumnComments, relationalColumnNumericPrecisions);
    }

    public static void main(String[] args) {
        TableAddFrame tableAddFrame = new TableAddFrame("192.168.168.235", "5432", "postgres", "pg.test", "testdb3", null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.processPreviousRowSelection();
            String errorMSG = this.createTable();
            if (errorMSG == null) {
                return;
            }
            if (!errorMSG.equals("")) {
                JOptionPane.showConfirmDialog(this, errorMSG, "msg", 2);
            } else {
                if (this.refreshListener != null) {
                    this.refreshListener.actionPerformed(null);
                }
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.setUpColumnTypeColumn(this.table.getColumnModel().getColumn(2));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        if (this.hasSingleSelectedRow) {
            this.columnDefaultValueField.setText((String)this.model.getPropertyValueAt(this.singleSelectedRow, 0));
            this.columnCommentField.setText((String)this.model.getPropertyValueAt(this.singleSelectedRow, 1));
            this.columnNumericPrecisionField.setText((String)this.model.getPropertyValueAt(this.singleSelectedRow, 2));
            this.columnNumericPrecisionField.setEditable(this.model.isPropertyCellEditable(this.singleSelectedRow, 2));
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            TableAddFrame.this.dispose();
        }
    }
}

