/*
 * Decompiled with CFR 0.152.
 */
package org.nihonsoft.turbosql.modules.pg.app;

import java.awt.Color;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.nihonsoft.turbosql.modules.pg.app.DBTreeCellRenderer;
import org.nihonsoft.turbosql.modules.pg.app.PostgreSQLDataObject;
import org.nihonsoft.turbosql.modules.pg.app.ServerNodeObject;

public class TestTree
extends JFrame {
    private String username = "postgres";
    private String password = "pg.test";
    private String serverIP = "192.168.168.235";
    private String serverPort = "5432";
    private Connection conn;
    private String url = "";

    public TestTree(String name) {
        super(name);
        this.setDefaultCloseOperation(2);
        this.setBounds(10, 10, 300, 300);
        this.setVisible(true);
        DefaultMutableTreeNode serverNode = new DefaultMutableTreeNode("No database");
        DefaultTreeModel dbTreeModel = new DefaultTreeModel(serverNode);
        JTree dbTree = new JTree(dbTreeModel);
        JScrollPane treePane = new JScrollPane(dbTree);
        treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.getContentPane().add(treePane);
        DefaultMutableTreeNode dbNode = new DefaultMutableTreeNode("Database 1");
        serverNode.setUserObject("Server 1");
        serverNode.add(dbNode);
        dbTreeModel.setRoot(dbNode);
        serverNode = new DefaultMutableTreeNode(new ServerNodeObject(this.serverIP, this.username, this.password, this.serverIP, this.serverPort));
        dbTree.setCellRenderer(new DBTreeCellRenderer());
        this.url = PostgreSQLDataObject.getDefaultDBURL(this.serverIP, this.serverPort);
        this.conn = PostgreSQLDataObject.getConnection(this.url, this.username, this.password);
        PostgreSQLDataObject.buildServerNode(serverNode, this.conn);
        dbTreeModel.setRoot(serverNode);
        this.show();
    }

    public static void main(String[] args) {
        TestTree testTree = new TestTree("Test Tree");
    }
}

