/*
 * Decompiled with CFR 0.152.
 */
package org.nihonsoft.turbosql.modules.pg.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.nihonsoft.turbosql.modules.pg.app.BrowserLauncher;
import org.nihonsoft.turbosql.modules.pg.app.DBTreeCellRenderer;
import org.nihonsoft.turbosql.modules.pg.app.NodeObject;
import org.nihonsoft.turbosql.modules.pg.app.PopupMenuContainer;
import org.nihonsoft.turbosql.modules.pg.app.PostgreSQLDataObject;
import org.nihonsoft.turbosql.modules.pg.app.ServerNodeObject;

public class DatabasePanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private ClassLoader urlClassLoader;
    private String username = "postgres";
    private String password = "";
    private String serverIP = "127.0.0.1";
    private String serverPort = "5432";
    private String url = "";
    private boolean isDBTreeLoaded = false;
    private JTextField serverIPInput = new JTextField(this.serverIP);
    private JTextField serverPortInput = new JTextField(this.serverPort);
    private JTextField usernameInput = new JTextField(this.username);
    private JPasswordField passwordInput = new JPasswordField(this.password);
    private JTextArea status = new JTextArea(3, 30);
    private DefaultMutableTreeNode serverNode;
    private DefaultTreeModel dbTreeModel;
    private JTree dbTree;
    private JScrollPane treePane;
    JScrollPane infoPane;
    JEditorPane editorPane;
    private JScrollPane statusPane;
    private String[] drivers = new String[]{"org.postgresql.Driver"};
    Connection conn;
    Statement statement;
    private PopupMenuContainer popupMenuContainer;
    private JPopupMenu defaultPanelPopup = new JPopupMenu("General");
    JButton connectButton = new JButton("Connect");
    JButton refreshButton = new JButton("Refresh");
    ActionListener refreshListener = new RefreshAction();

    public DatabasePanel() {
        this.urlClassLoader = this.getClass().getClassLoader();
        this.setLayout(new BorderLayout());
        JLabel serverIPLabel = new JLabel("Server IP: ");
        JLabel serverPortLabel = new JLabel("Port: ");
        JLabel usernameLabel = new JLabel("User ID: ", 4);
        JLabel passwordLabel = new JLabel("Password: ");
        this.connectButton.addActionListener(this);
        this.refreshButton.addActionListener(this);
        Box dbPane = Box.createHorizontalBox();
        dbPane.add(serverIPLabel);
        dbPane.add(this.serverIPInput);
        dbPane.add(serverPortLabel);
        dbPane.add(this.serverPortInput);
        Box loginPane = Box.createHorizontalBox();
        loginPane.add(usernameLabel);
        loginPane.add(this.usernameInput);
        loginPane.add(passwordLabel);
        loginPane.add(this.passwordInput);
        Box buttonPane = Box.createVerticalBox();
        buttonPane.add(this.connectButton);
        buttonPane.add(this.refreshButton);
        Box inputPane2 = Box.createVerticalBox();
        inputPane2.add(dbPane);
        inputPane2.add(loginPane);
        Box inputPane = Box.createHorizontalBox();
        inputPane.add(inputPane2);
        inputPane.add(buttonPane);
        this.add((Component)inputPane, "North");
        this.status.setText("Enter a database URL and/or press Enter");
        this.status.setEditable(false);
        this.status.setLineWrap(true);
        this.status.setWrapStyleWord(true);
        this.status.setBorder(BorderFactory.createBevelBorder(1));
        this.statusPane = new JScrollPane(this.status);
        this.statusPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.add((Component)this.statusPane, "South");
        this.serverNode = new DefaultMutableTreeNode("No database");
        this.dbTreeModel = new DefaultTreeModel(this.serverNode);
        this.dbTree = new JTree(this.dbTreeModel);
        this.treePane = new JScrollPane(this.dbTree);
        this.treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.treePane.setPreferredSize(new Dimension(400, 100));
        String tempFileName = Locale.getDefault().getLanguage().equals("ja") ? "dbwelcome_ja.html" : "dbwelcome.html";
        String fileContentsStr = this.getContentsStringFromFile("org/nihonsoft/turbosql/modules/pg/app/html/" + tempFileName, Locale.getDefault().getLanguage());
        this.editorPane = new JEditorPane();
        this.editorPane.addHyperlinkListener(new HyperlinkHandler());
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.editorPane.setEditable(false);
        this.editorPane.setText(fileContentsStr);
        this.infoPane = new JScrollPane(this.editorPane);
        this.infoPane.setPreferredSize(new Dimension(500, 100));
        this.infoPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        JSplitPane splitPane = new JSplitPane(1, true, this.treePane, this.infoPane);
        this.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(200);
        this.serverIPInput.addActionListener(this);
        this.serverPortInput.addActionListener(this);
        this.usernameInput.addActionListener(this);
        this.passwordInput.addActionListener(this);
        this.dbTree.addTreeSelectionListener(this);
        this.dbTree.addMouseListener(new TreeMouseHandler());
        this.dbTree.addTreeSelectionListener(new TreeSelectionHandler());
        GenericMouseHandler mouseHandler = new GenericMouseHandler();
        this.editorPane.addMouseListener(mouseHandler);
        this.status.addMouseListener(mouseHandler);
        this.setVisible(true);
        this.passwordInput.requestFocus();
        this.defaultPanelPopup.add(new GenericAction("No action"));
        this.popupMenuContainer = new PopupMenuContainer();
        int i = 0;
        while (i < this.drivers.length) {
            try {
                Class.forName(this.drivers[i]);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe);
                this.status.setText("Driver load failed: " + cnfe.getMessage());
            }
            ++i;
        }
    }

    public void openConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.infoPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                this.serverNode = new DefaultMutableTreeNode("No database");
                this.dbTreeModel.setRoot(this.serverNode);
                this.dbTree.setRootVisible(true);
                this.treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                this.dbTreeModel.reload();
            }
            this.conn = PostgreSQLDataObject.getConnection(this.url, this.username, this.password);
            if (this.conn == null) {
                this.status.setText("Connection failed. Check that the hostname, port, user ID and password are correct, and that the postmaster is running with the -i flag, which enables TCP/IP networking.");
                return;
            }
            this.status.setText("Database connection established");
            this.serverNode = new DefaultMutableTreeNode(new ServerNodeObject(this.serverIP, this.username, this.password, this.serverIP, this.serverPort));
            this.dbTreeModel.setRoot(this.serverNode);
            this.dbTree.setCellRenderer(new DBTreeCellRenderer());
            PostgreSQLDataObject.buildServerNode(this.serverNode, this.conn);
            this.treePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), this.url, 2, 0));
            this.isDBTreeLoaded = true;
            this.dbTreeModel.reload();
            this.editorPane.setText("");
            this.conn.close();
        }
        catch (SQLException sqle) {
            this.status.setText(sqle.getMessage());
            do {
                System.err.println("Exception occured:\nMessage: " + sqle.getMessage());
                System.err.println("SQL state: " + sqle.getSQLState());
                System.err.println("Vendor code: " + sqle.getErrorCode() + "\n----------------------------");
            } while ((sqle = sqle.getNextException()) != null);
        }
    }

    public void refreshConnection() {
        TreePath[] visibleTreePaths = new TreePath[this.dbTree.getRowCount()];
        int i = 0;
        while (i < visibleTreePaths.length) {
            visibleTreePaths[i] = this.dbTree.getPathForRow(i);
            ++i;
        }
        this.url = PostgreSQLDataObject.getDefaultDBURL(this.serverIPInput.getText(), this.serverPortInput.getText());
        this.username = this.usernameInput.getText();
        char[] pw = this.passwordInput.getPassword();
        if (pw != null) {
            this.password = new String(pw);
        }
        if (this.url == null || this.url.length() == 0) {
            this.status.setText("Please specify a database URL ");
            return;
        }
        this.openConnection();
        this.password = null;
        int i2 = 0;
        while (i2 < visibleTreePaths.length) {
            int row = this.getParentRowToExpand(visibleTreePaths[i2]);
            if (row != -1 && !this.dbTree.isExpanded(row)) {
                this.dbTree.expandRow(row);
            }
            ++i2;
        }
    }

    public int getParentRowToExpand(TreePath treePath) {
        TreePath parentPath = treePath.getParentPath();
        if (parentPath == null) {
            return -1;
        }
        int parentRow = -1;
        int i = 0;
        while (i < this.dbTree.getRowCount()) {
            if (parentPath.toString().equals(this.dbTree.getPathForRow(i).toString())) {
                parentRow = i;
                break;
            }
            ++i;
        }
        return parentRow;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.serverIPInput || source == this.serverPortInput || source == this.usernameInput || source == this.passwordInput || source == this.connectButton) {
            this.serverIP = this.serverIPInput.getText();
            this.serverPort = this.serverPortInput.getText();
            this.url = PostgreSQLDataObject.getDefaultDBURL(this.serverIP, this.serverPort);
            this.username = this.usernameInput.getText();
            char[] pw = this.passwordInput.getPassword();
            if (pw != null) {
                this.password = new String(pw);
            }
            if (this.url == null || this.url.length() == 0) {
                this.status.setText("Please specify a database URL ");
                return;
            }
            this.openConnection();
            this.password = null;
        } else if (source == this.refreshButton) {
            this.refreshConnection();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = this.dbTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        boolean tableSelected = false;
        Object columnsParam = null;
        Object tableParam = null;
        String message = null;
        if (message != null) {
            this.status.setText(message);
        }
    }

    public boolean isHomogeneousNodeSelection(TreePath[] treePaths) {
        boolean isHomogeneous = true;
        Class<?> firstObject = ((DefaultMutableTreeNode)treePaths[0].getLastPathComponent()).getUserObject().getClass();
        int i = 1;
        while (i < treePaths.length) {
            if (!firstObject.equals(((DefaultMutableTreeNode)treePaths[i].getLastPathComponent()).getUserObject().getClass())) {
                isHomogeneous = false;
            }
            ++i;
        }
        return isHomogeneous;
    }

    public void treeSingleClick(int row, TreePath path) {
    }

    public void treeDoubleClick(int row, TreePath path) {
    }

    public void treeSingleSelect(int row, TreePath path) {
        String htmlStr = PostgreSQLDataObject.getNodePropertyInHTML(this, this.dbTree);
        if (htmlStr != null) {
            this.editorPane.setText(htmlStr);
        }
    }

    public void treePopupTrigger(int row, Component comp, int x, int y) {
        int[] selectedRows = this.dbTree.getSelectionRows();
        boolean rowSelected = false;
        JPopupMenu popup = new JPopupMenu();
        if (row != -1) {
            if (selectedRows != null) {
                int i = 0;
                while (i < selectedRows.length) {
                    if (selectedRows[i] == row) {
                        rowSelected = true;
                    }
                    ++i;
                }
                if (!rowSelected) {
                    this.dbTree.setSelectionRow(row);
                }
            } else {
                this.dbTree.setSelectionRow(row);
            }
            int[] newSelectedRows = this.dbTree.getSelectionRows();
            if (newSelectedRows.length == 1) {
                TreePath treePath = this.dbTree.getPathForRow(row);
                Object userObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (userObject instanceof String) {
                    this.defaultPanelPopup.show(comp, x, y);
                } else {
                    NodeObject nodeObject = (NodeObject)userObject;
                    String[] actionList = PostgreSQLDataObject.getPopupMenuNodeActionList(nodeObject);
                    int i = 0;
                    while (i < actionList.length) {
                        if (actionList[i].equals("JSeparator")) {
                            popup.add(new JSeparator());
                        } else {
                            popup.add(new GenericAction(actionList[i]));
                        }
                        ++i;
                    }
                    popup.show(comp, x, y);
                }
            } else if (this.isHomogeneousNodeSelection(this.dbTree.getSelectionPaths())) {
                TreePath treePath = this.dbTree.getPathForRow(row);
                Object userObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (userObject instanceof String) {
                    this.defaultPanelPopup.show(comp, x, y);
                } else {
                    NodeObject nodeObject = (NodeObject)userObject;
                    String[] actionList = PostgreSQLDataObject.getPopupMenuMultipleNodeActionList(nodeObject);
                    int i = 0;
                    while (i < actionList.length) {
                        if (actionList[i].equals("JSeparator")) {
                            popup.add(new JSeparator());
                        } else {
                            popup.add(new GenericAction(actionList[i]));
                        }
                        ++i;
                    }
                    popup.show(comp, x, y);
                }
            } else {
                this.defaultPanelPopup.show(comp, x, y);
            }
        } else {
            this.defaultPanelPopup.show(comp, x, y);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getContentsStringFromFile(String url, String language) {
        String fileContentsStr;
        block3: {
            fileContentsStr = "";
            try {
                String thisLine;
                BufferedReader buffReader = language.equals("ja") ? new BufferedReader(new InputStreamReader(this.urlClassLoader.getResource(url).openStream(), "JISAutoDetect")) : new BufferedReader(new InputStreamReader(this.urlClassLoader.getResource(url).openStream()));
                if (!buffReader.ready()) break block3;
                while ((thisLine = buffReader.readLine()) != null) {
                    void var5_5;
                    fileContentsStr = fileContentsStr + (String)var5_5 + "\n";
                }
            }
            catch (IOException ioe) {}
        }
        return fileContentsStr;
    }

    class GenericMouseHandler
    extends MouseAdapter {
        GenericMouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupTrigger((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupTrigger((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void popupTrigger(Component comp, int x, int y) {
            DatabasePanel.this.defaultPanelPopup.show(comp, x, y);
        }
    }

    class HyperlinkHandler
    implements HyperlinkListener {
        HyperlinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            block4: {
                if (!e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) break block4;
                if (e.getURL() == null) {
                    return;
                }
                if (e.getURL().getProtocol().equals("http")) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (IOException ioe) {
                        System.out.println("Cannot Launch Browser: " + ioe.getMessage());
                    }
                }
            }
        }
    }

    class TreeSelectionHandler
    implements TreeSelectionListener {
        TreeSelectionHandler() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            int[] selRows = DatabasePanel.this.dbTree.getSelectionRows();
            if (DatabasePanel.this.isDBTreeLoaded && selRows != null) {
                if (selRows.length == 1) {
                    DatabasePanel.this.treeSingleSelect(selRows[0], DatabasePanel.this.dbTree.getSelectionPath());
                } else {
                    DatabasePanel.this.editorPane.setText("");
                }
            }
        }
    }

    class RefreshAction
    extends AbstractAction {
        RefreshAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatabasePanel.this.refreshConnection();
        }
    }

    class GenericAction
    extends AbstractAction {
        String name;
        String actionType;

        public GenericAction(String name, String actionType) {
            super(name);
            this.name = name;
            this.actionType = actionType;
        }

        public GenericAction(String name) {
            this(name, null);
        }

        public String getName() {
            return this.name;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PostgreSQLDataObject.performAction((Component)actionEvent.getSource(), this.name, DatabasePanel.this.dbTree, DatabasePanel.this.refreshListener);
        }
    }

    class TreeMouseHandler
    extends MouseAdapter {
        private Point start;

        TreeMouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = DatabasePanel.this.dbTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = DatabasePanel.this.dbTree.getPathForLocation(e.getX(), e.getY());
            if (e.isPopupTrigger()) {
                this.start = e.getPoint();
                DatabasePanel.this.treePopupTrigger(selRow, (Component)e.getSource(), this.start.x, this.start.y);
                this.start = null;
            } else if (selRow != -1) {
                if (e.getClickCount() == 1) {
                    DatabasePanel.this.treeSingleClick(selRow, selPath);
                } else if (e.getClickCount() == 2) {
                    DatabasePanel.this.treeDoubleClick(selRow, selPath);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            int modifier = e.getModifiers();
            if (e.isPopupTrigger()) {
                this.start = e.getPoint();
                int selRow = DatabasePanel.this.dbTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = DatabasePanel.this.dbTree.getPathForLocation(e.getX(), e.getY());
                DatabasePanel.this.treePopupTrigger(selRow, (Component)e.getSource(), this.start.x, this.start.y);
                this.start = null;
            }
        }
    }
}

