#include "apilib.h"
#include "mml.h"
#include "mml_freq.h"

struct MMLDATA {
	int ch;
	MML_OPTION *mmlopt;
};

char mmldata[] = "t150l16o4g2^8<b8>e8f+8g8.a8.b8b8.a8.b8g2..bga4.>c4.<a4b1&b8b8a8g4f+4ef+g2..f+gf+4.e4.d4e1r1r1r1g8^32r32f+8r2^8^16r1<gab>degab>degab>degr1edc<a>c8<a>c8<ag8e8d8cdecegegagaga>c<a>cedc<a>c8<a>c8<ag8e8d8cdecegegagaga>c<a>cedc<a>c8<a>c8<ag8e8d8cdecegegagaga>c<a>cedc<a>c8<a>c8<ag8e8d8r1g.r32g32r32g.r32g32r32g8..r32g8f+8e8d8..r32d8e<b2^16r8a.r32a.r32g.r32a4g.r32a.r32b4b.r32>d<b4..r8>g.r32g32r32g.r32g32r32g8..r32g8a8b8f+8.rf+8gd4^16r8d8e8..r32g8..r32f+8d8..r32d8&d8e.r32e2.r2^8e.r32e.r32f+.r32g8..r32f+8..r32e8f+8g8a8&a8a8g8..r32f+8d8..r32d8&d8<<b>dega";
int tempo = 120;

void mml_callback(MML_INFO *p, void *extobj);

void HariMain(void)
{
	struct MMLDATA mmls;
	MML mml;
	MML_OPTION mmlopt;

	mmls.mmlopt = &mmlopt;
	mml_init(&mml, mml_callback, &mmls);
	MML_OPTION_INITIALIZER_DEFAULT(&mmlopt);
	mml_setup(&mml,&mmlopt,mmldata);
	
	while(1) {
		mml_fetch(&mml);
	}
	
	api_end();
}

void mml_callback(MML_INFO *p, void *extobj)
{
	struct MMLDATA *mml = (struct MMLDATA *) extobj;
	switch (p->type) {
	case MML_TYPE_NOTE:
		{
			MML_ARGS_NOTE *args = &(p->args.note);
			float t = ((float)args->ticks / mml->mmlopt->bticks * (60000.0 / (float)tempo));
			api_beepEx(mml_freq[args->number] * 1000,t / 10.0f);
		}
		break;
	case MML_TYPE_REST:
		{
			MML_ARGS_REST *args = &(p->args.rest);
			float t = ((float)args->ticks / mml->mmlopt->bticks * (60000.0 / (float)tempo));
			api_beepEx(0,t / 10.0f);
		}
		break;
	case MML_TYPE_TEMPO:
		{
			MML_ARGS_TEMPO *args = &(p->args.tempo);
			tempo = args->value;
		}
		break;
	}
}
