#include "version.h"

#define CUR_UP 0xa0
#define CUR_DOWN 0xff
#define CUR_LEFT 0xfd
#define CUR_RIGHT 0xfe

struct ENV {
	int offset[1024];
};

#define COL8_000000		0x00000000
#define COL8_FF0000		0x00ff0000
#define COL8_00FF00		0x0000ff00
#define COL8_FFFF00		0x00ffff00
#define COL8_0000FF		0x000000ff
#define COL8_FF00FF		0x00ff00ff
#define COL8_00FFFF		0x0000ffff
#define COL8_FFFFFF		0x00ffffff
#define COL8_C6C6C6		0x00c6c6c6
#define COL8_840000		0x00840000
#define COL8_008400		0x00008400
#define COL8_848400		0x00848400
#define COL8_000084		0x00000084
#define COL8_840084		0x00840084
#define COL8_008484		0x00008484
#define COL8_848484		0x00848484
#define COL8_333333		0x00333333
#define COL8_FF7F27		0x00ff7f27
#define COL8_ffffff		0x00fefefe

void api_putchar(int c);
void api_putstr0(char *s);
void api_putstr1(char *s, int l);
void api_end(void);
int api_openwin(char *buf, int xsiz, int ysiz, int col_inv, char *title);
void api_putstrwin(int win, int x, int y, int col, int len, char *str);
void api_boxfilwin(int win, int x0, int y0, int x1, int y1, int col);
void api_initmalloc(void);
char *api_malloc(int size);
void api_free(char *addr, int size);
void api_point(int win, int x, int y, int col);
void api_refreshwin(int win, int x0, int y0, int x1, int y1);
void api_linewin(int win, int x0, int y0, int x1, int y1, int col);
void api_closewin(int win);
int api_getkey(int mode);
int api_alloctimer(void);
void api_inittimer(int timer, int data);
void api_settimer(int timer, int time);
void api_freetimer(int timer);
void api_beep(int tone);
int api_fopen(char *fname);
void api_fclose(int fhandle);
void api_fseek(int fhandle, int offset, int mode);
int api_fsize(int fhandle, int mode);
int api_fread(char *buf, int maxsize, int fhandle);
int api_cmdline(char *buf, int maxsize);
int api_getlang(void);
int api_newfile(char *name, int size);
int api_fwrite(char *buf, int maxsize, int fhandle);
int api_getmousex(int win);
int api_getmousey(int win);
int api_getint(unsigned char c);
int api_makebutton(int win, int x0, int y0, int x1, int y1, char *text);
int api_getbtc(int bt, int win);
int api_getmousec(void);
void api_sendkey(char *cmdline);
void api_getdir(char *buf, int num);
void api_beepEx(int tone, int time);
void api_getsys(int *scrnx, int *scrny, int *colbit);
void api_drawgraph(int win, char *graph, int x, int y, int gxsize, int gysize);
void api_convgrp(char *filename, int *graphbuf);
int api_getsize(char *fname);
void api_beep8(struct ENV env, int tone, int time);
void api_getwsize(int win, int *xsize, int *ysize);
char *api_getargs(int index);
