#!/usr/bin/env python
# -*- coding: utf-8 -*-

from lxml import etree

player = "http://www\.tube8\.com/[^/]+/[^/]+/(\d+)/?"
doc = None


def fetch(url):
  global doc
  parser = etree.HTMLParser(encoding="utf-8")
  doc = etree.parse(url, parser)


def get_html():
  global doc
  r = doc.xpath('//div[@id="flvplayer"]')
  player_script = etree.tostring(r[0], method="html")
  content = """
<html><body>
<style type="text/css">* {padding: 0; margin: 0;}</style>
<script src="http://www.google.com/jsapi"></script>
<script>
google.load("jquery", "1.4.2");
google.load("swfobject", "2.2");
</script>
%(player_script)s
</body></html>
"""
  return content % {"player_script": player_script
                    .replace('autoplay = "false"', 'autoplay = "true"')
                    .replace("608", "100%").replace("481", "100%")}


def get_title():
  global doc
  r = doc.xpath('//title')
  title = r[0].text
  return title
