#!/usr/bin/env python
# -*- coding: utf-8 -*-

from lxml import etree
import re


class HTMLParser:

  def __init__(self, url):
    self.url = url
    self.method = None
    self.video_id = None
    self.title = None
    self.supported_sites = (
      # url pattern, method key
      ["(http://www\.youtube\.com/watch\?v=([^&]+))", "youtube"],
      ["(http://www\.tube8\.com/[^/]+/[^/]+/(\d+)/)", "tube8"],
      ["(http://video\.fc2\.com/(?:a/)?content/[^/]+/(\w+)/)", "fc2"],
      ["(http://www\.yourfilehost\.com/media\.php\?cat=video&file=([^&]+))",
       "yourfilehost"])

  def is_supported(self):
    for site in self.supported_sites:
      match = re.compile(site[0]).search(self.url)
      if (match):
        self.method = site[1]
        self.url = match.group(1)
        self.video_id = match.group(2)
        return True

    return False

  def get_content(self):
    if (self.method):
      content = getattr(self, "get_content_" + self.method)()
      return content
    else:
      return ""

  def get_title(self):
    return self.title

  def get_content_youtube(self):
    parser = etree.HTMLParser(encoding="utf-8")
    doc = etree.parse(self.url, parser)
    r = doc.xpath('//meta[@name="title"]/@content')
    self.title = r[0]
    r = doc.xpath('//div[@id="watch-video-container"]')
    content_script = etree.tostring(r[0], method="html")
    content = """
<html><body>
<style type="text/css">* {padding: 0; margin: 0;}</style>
%(content_script)s
</body></html>
"""
    return content % {"content_script": content_script
                      .replace("38\" + \"5", "100%")
                      .replace("64\" + \"0", "100%")}

  def get_content_tube8(self):
    parser = etree.HTMLParser()
    doc = etree.parse(self.url, parser)
    r = doc.xpath('//title')
    self.title = r[0].text
    r = doc.xpath('//div[@id="flvplayer"]')
    content_script = etree.tostring(r[0], method="html")
    content = """
<html><body>
<style type="text/css">* {padding: 0; margin: 0;}</style>
<script src="http://www.google.com/jsapi"
  language="javascript" type="text/javascript"></script>
<script language="javascript" type="text/javascript" >
google.load("jquery", "1.4.2");
google.load("swfobject", "2.2");
</script>
%(content_script)s
</body></html>
"""
    return content % {"content_script": content_script
                      .replace('autoplay = "false"', 'autoplay = "true"')
                      .replace("608", "100%").replace("481", "100%")}

  def get_content_fc2(self):
    parser = etree.HTMLParser()
    doc = etree.parse(self.url, parser)
    r = doc.xpath('//title')
    self.title = r[0].text
    r = doc.xpath('//div[@class="content_block"]')
    content_script = etree.tostring(r[0], method="html")
    content = """
<html><body>
<style type="text/css">* {padding: 0; margin: 0;}</style>
%(content_script)s
</body></html>
"""
    return content % {"content_script": content_script
                      .replace("no_progressive=1", "no_progressive=0")
                      .replace("640", "100%").replace("392", "100%")}

  def get_content_yourfilehost(self):
    parser = etree.HTMLParser()
    doc = etree.parse(self.url, parser)
    self.title = self.video_id
    r = doc.xpath('//div[@id="mediadiv"]')
    content_script = etree.tostring(r[0], method="html")
    content = """
<html><head>
<script src="/flashplayer/flowplayer-3.2.2.min.js"></script>
<script src="http://code.jquery.com/jquery-1.4.2.min.js"></script>
<script src="/scripts/main.js"></script>
</head><body>
<style type="text/css">* {padding: 0; margin: 0;}</style>
%(content_script)s
</body></html>
"""
    return content % {"content_script": content_script
                      .replace("width:500px; height:324px;",
                               "width:100%; height:100%")}
