/*
 * Copyright 2008-2009 the Project Tsukuyomi and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.tsukuyomi.japanese;

/**
 * 母音を表す列挙型です。
 * 
 * @author itoasuka
 * @since 0.2.0
 */
public enum Vowel {
    /** 母音が「a」、すなわち 50 音表のあ段にある仮名であることを表します。 */
    A, 
    /** 母音が「i」、すなわち 50 音表のい段にある仮名であることを表します。 */
    I, 
    /** 母音が「u」、すなわち 50 音表のう段にある仮名であることを表します。 */
    U, 
    /** 母音が「e」、すなわち 50 音表のえ段にある仮名であることを表します。 */
    E, 
    /** 母音が「o」、すなわち 50 音表のお段にある仮名であることを表します。 */
    O
}
