package jp.sourceforge.tsukuyomi.openid.impl;

import jp.sourceforge.tsukuyomi.openid.Consts;
import jp.sourceforge.tsukuyomi.openid.OpenIDManager;
import jp.sourceforge.tsukuyomi.openid.OpenIDRuntimeException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;

/**
 * OpenID4Java に関するリソースの管理を行うクラスの実装です。DI コンテナによってシングルトンとして管理されることを期待しています。
 * 
 * @author asuka
 */
public class OpenIDManagerImpl implements OpenIDManager {
	private static final Log LOG = LogFactory.getLog(OpenIDManagerImpl.class);

	private ConsumerManager consumerManager;

	/**
	 * 新たにインスタンスを生成します。
	 */
	public OpenIDManagerImpl() {
		try {
			consumerManager = new ConsumerManager();
		} catch (ConsumerException e) {
			String s = Consts.BUNDLE
					.getString(Consts.KEY_PREFIX + "ConsumerException");
			LOG.fatal(s, e);
			throw new OpenIDRuntimeException(e);
		}
	}

	/**
	 * コンシューママネージャを取得します。
	 * 
	 * @return コンシューママネージャ
	 */
	public ConsumerManager getConsumerManager() {
		return consumerManager;
	}

}
