package jp.sourceforge.tsukuyomi.openid;

/**
 * OpenID コンシューマに対するインタフェースです。
 * 
 * @author asuka
 */
public interface OpenIDConsumer {
	/**
	 * OpenID Identifier で OpenID プロバイダを探しに行った際、OpenID プロバイダを取得できるかを調べます。
	 * 
	 * @param identifier OpenID Identifier
	 * @return 取得できた場合 true
	 */
	boolean findProvider(String identifier);
	
	/**
	 * アソシエーション確立を行います。
	 * 
	 * @return 認証サーバが要求する OpenID のバージョン
	 */
	String associate();
	
	/**
	 * 認証リクエストを取得します。
	 * 
	 * @return 認証リクエスト
	 */
	AuthenticationRequest getAuthenticationRequest();
	
	/**
	 * 認証応答結果に対するベリファイを行います。
	 * 
	 * @return ベリファイに成功した場合、ベリファイされた OpenID Identifier。失敗した場合は null
	 */
	String verify();
	
	/**
	 * プロバイダに対してリクエストを送るまでの一連の処理を行います。
	 */
	void request();
}
