/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;

public class FetchRequest
extends AxMessage {
    private static Logger _log = Logger.getLogger(FetchRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected FetchRequest() {
        this._parameters.set(new Parameter("mode", "fetch_request"));
        if (DEBUG) {
            _log.debug((Object)"Created empty fetch request.");
        }
    }

    public static FetchRequest createFetchRequest() {
        return new FetchRequest();
    }

    protected FetchRequest(ParameterList params) {
        this._parameters = params;
    }

    public static FetchRequest createFetchRequest(ParameterList params) throws MessageException {
        FetchRequest req = new FetchRequest(params);
        if (!req.isValid()) {
            throw new MessageException("Invalid parameters for a fetch request");
        }
        if (DEBUG) {
            _log.debug((Object)("Created fetch request from parameter list:\n" + params));
        }
        return req;
    }

    public void addAttribute(String alias, String typeUri, boolean required, int count) {
        Parameter newParam;
        this._parameters.set(new Parameter("type." + alias, typeUri));
        String level = required ? "required" : "if_available";
        Parameter levelParam = this._parameters.getParameter(level);
        if (levelParam == null) {
            newParam = new Parameter(level, this.multivalEncode(alias));
        } else {
            newParam = new Parameter(level, levelParam.getValue() + "," + this.multivalEncode(alias));
            this._parameters.removeParameters(level);
        }
        this._parameters.set(newParam);
        if (count > 1) {
            this._parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to fetch request; type: " + typeUri + " alias: " + alias + " count: " + count + " required: " + required));
        }
    }

    public void addAttribute(String alias, String typeUri, boolean required) {
        this.addAttribute(alias, typeUri, required, 1);
    }

    public void setCount(String alias, int count) {
        if (count > 1) {
            this._parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public int getCount(String alias) {
        if (this._parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this._parameters.getParameterValue("count." + alias));
        }
        return 1;
    }

    public void setUpdateUrl(String updateUrl) throws MessageException {
        try {
            new URL(updateUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid update_url: " + updateUrl);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting fetch request update_url: " + updateUrl));
        }
        this._parameters.set(new Parameter("update_url", updateUrl));
    }

    public String getUpdateUrl() {
        return this._parameters.hasParameter("update_url") ? this._parameters.getParameterValue("update_url") : null;
    }

    public Map getAttributes(boolean required) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        String level = required ? "required" : "if_available";
        Parameter param = this._parameters.getParameter(level);
        if (param != null) {
            String[] values = param.getValue().split(",");
            for (int i = 0; i < values.length; ++i) {
                String alias = this.multivalDecode(values[i]);
                attributes.put(alias, this._parameters.getParameterValue("type." + alias));
            }
        }
        return attributes;
    }

    public Map getAttributes() {
        Map attributes = this.getAttributes(true);
        attributes.putAll(this.getAttributes(false));
        return attributes;
    }

    public boolean isValid() {
        String value;
        int i;
        String[] values;
        if (!this._parameters.hasParameter("required") && !this._parameters.hasParameter("if_available")) {
            _log.warn((Object)"One of 'required' or 'if_available' parameters must be present.");
            return false;
        }
        if (!this._parameters.hasParameter("mode") || !"fetch_request".equals(this._parameters.getParameterValue("mode"))) {
            _log.warn((Object)("Invalid mode value in fetch_request: " + this._parameters.getParameterValue("mode")));
            return false;
        }
        if (this._parameters.hasParameter("required")) {
            values = this._parameters.getParameterValue("required").split(",");
            for (i = 0; i < values.length; ++i) {
                value = this.multivalDecode(values[i]);
                if (this._parameters.hasParameter("type." + value)) continue;
                _log.warn((Object)("Type missing for attribute alias: " + value));
                return false;
            }
        }
        if (this._parameters.hasParameter("if_available")) {
            values = this._parameters.getParameterValue("if_available").split(",");
            for (i = 0; i < values.length; ++i) {
                value = this.multivalDecode(values[i]);
                if (this._parameters.hasParameter("type." + value)) continue;
                _log.warn((Object)("Type missing for attribute alias: " + value));
                return false;
            }
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.equals("required") || paramName.equals("if_available") || paramName.equals("update_url")) continue;
            _log.warn((Object)("Invalid parameter name in fetch request: " + paramName));
        }
        return true;
    }
}

