/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class AuthImmediateFailure
extends Message {
    private static Logger _log = Logger.getLogger(AuthImmediateFailure.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("openid.mode");
    protected static final List optionalFields = Arrays.asList("openid.ns", "openid.user_setup_url");

    protected AuthImmediateFailure(String url, String returnTo, boolean compatibility) {
        if (compatibility) {
            this.set("openid.mode", "id_res");
            this.set("openid.user_setup_url", url);
        } else {
            this.set("openid.mode", "setup_needed");
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
        }
        this._destinationUrl = returnTo;
    }

    protected AuthImmediateFailure(ParameterList params) {
        super(params);
    }

    public static AuthImmediateFailure createAuthImmediateFailure(String url, String returnTo, boolean compatibility) throws MessageException {
        AuthImmediateFailure fail = new AuthImmediateFailure(url, returnTo, compatibility);
        if (!fail.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        return fail;
    }

    public static AuthImmediateFailure createAuthImmediateFailure(ParameterList params) throws MessageException {
        AuthImmediateFailure fail = new AuthImmediateFailure(params);
        if (!fail.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            _log.debug((Object)("Retrieved auth immediate failure from message parameters:\n" + fail.keyValueFormEncoding()));
        }
        return fail;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public String getUserSetupUrl() {
        return this.getParameterValue("openid.user_setup_url");
    }

    public boolean isValid() {
        boolean compatibility;
        if (!super.isValid()) {
            return false;
        }
        boolean bl = compatibility = !this.isVersion2();
        if (compatibility) {
            try {
                new URL(this.getUserSetupUrl());
            }
            catch (MalformedURLException e) {
                _log.error((Object)"Error verifying auth immediate response validity.", (Throwable)e);
                return false;
            }
            return "id_res".equals(this.getParameterValue("openid.mode"));
        }
        return "setup_needed".equals(this.getParameterValue("openid.mode"));
    }
}

