/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.HtmlResult;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.util.HttpClientFactory;

public class HtmlResolver {
    private static Logger _log = Logger.getLogger(HtmlResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private int _maxRedirects = 10;
    private int _maxHtmlSize = 100000;
    private int _connTimeout = 3000;
    private int _socketTimeout = 5000;

    public int getMaxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this._maxRedirects = maxRedirects;
    }

    public int getMaxHtmlSize() {
        return this._maxHtmlSize;
    }

    public void setMaxHtmlSize(int maxHtmlSize) {
        this._maxHtmlSize = maxHtmlSize;
    }

    public int getConnTimeout() {
        return this._connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this._connTimeout = connTimeout;
    }

    public int getSocketTimeout() {
        return this._socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this._socketTimeout = socketTimeout;
    }

    public HtmlResult discover(UrlIdentifier identifier) throws DiscoveryException {
        HtmlResult result = new HtmlResult();
        String htmlData = this.call(identifier.getUrl(), result);
        this.parseHtml(htmlData, result);
        _log.info((Object)("HTML discovery succeeded on: " + identifier));
        return result;
    }

    private String call(URL url, HtmlResult result) throws DiscoveryException {
        HttpClient client = HttpClientFactory.getInstance(this._maxRedirects, Boolean.TRUE, this._socketTimeout, this._connTimeout, "ignoreCookies");
        GetMethod get = new GetMethod(url.toString());
        get.setFollowRedirects(true);
        try {
            int totalRead;
            int statusCode;
            if (DEBUG) {
                _log.debug((Object)("Fetching " + url + "..."));
            }
            if ((statusCode = client.executeMethod((HttpMethod)get)) != 200) {
                throw new DiscoveryException("GET failed on " + url + " Received status code: " + statusCode);
            }
            result.setClaimed(new UrlIdentifier(get.getURI().toString()));
            InputStream htmlInput = get.getResponseBodyAsStream();
            if (htmlInput == null) {
                throw new DiscoveryException("Cannot open inputstream for GET response from " + url);
            }
            byte[] data = new byte[this._maxHtmlSize];
            int currentRead = 0;
            for (totalRead = 0; totalRead < this._maxHtmlSize && (currentRead = htmlInput.read(data, totalRead, this._maxHtmlSize - totalRead)) != -1; totalRead += currentRead) {
            }
            htmlInput.close();
            if (totalRead <= 0) {
                throw new DiscoveryException("No HTML data read from " + url);
            }
            if (DEBUG) {
                _log.debug((Object)("Read " + totalRead + " bytes."));
            }
            String string = new String(data, 0, totalRead);
            return string;
        }
        catch (IOException e) {
            throw new DiscoveryException("Fatal transport error: ", e);
        }
        finally {
            get.releaseConnection();
        }
    }

    private void parseHtml(String htmlData, HtmlResult result) throws DiscoveryException {
        Object idp1Endpoint = null;
        Object idp2Endpoint = null;
        if (DEBUG) {
            _log.debug((Object)("Parsing HTML data:\n" + htmlData));
        }
        try {
            Parser parser = Parser.createParser((String)htmlData, null);
            NodeList heads = parser.parse((NodeFilter)new TagNameFilter("HEAD"));
            if (heads.size() != 1) {
                throw new DiscoveryException("HTML response must have exactly one HEAD element, found " + heads.size() + " : " + heads.toHtml());
            }
            Node head = heads.elementAt(0);
            SimpleNodeIterator i = head.getChildren().elements();
            while (i.hasMoreNodes()) {
                List<String> relations;
                Node node = i.nextNode();
                if (!(node instanceof TagNode)) continue;
                TagNode link = (TagNode)node;
                String href = link.getAttribute("href");
                String rel = link.getAttribute("rel");
                if (rel == null || (relations = Arrays.asList(rel.split(" "))) == null) continue;
                if (relations.contains("openid.server")) {
                    if (result.getIdp1Endpoint() != null) {
                        throw new DiscoveryException("More than one openid.server entries found");
                    }
                    if (DEBUG) {
                        _log.debug((Object)("Found OpenID1 endpoint: " + idp1Endpoint));
                    }
                    result.setEndpoint1(href);
                }
                if (relations.contains("openid.delegate")) {
                    if (result.getDelegate1() != null) {
                        throw new DiscoveryException("More than one openid.delegate entries found");
                    }
                    if (DEBUG) {
                        _log.debug((Object)("Found OpenID1 delegate: " + href));
                    }
                    result.setDelegate1(href);
                }
                if (relations.contains("openid2.provider")) {
                    if (result.getIdp2Endpoint() != null) {
                        throw new DiscoveryException("More than one openid.server entries found");
                    }
                    if (DEBUG) {
                        _log.debug((Object)("Found OpenID2 endpoint: " + idp2Endpoint));
                    }
                    result.setEndpoint2(href);
                }
                if (!relations.contains("openid2.local_id")) continue;
                if (result.getDelegate2() != null) {
                    throw new DiscoveryException("More than one openid2.local_id entries found");
                }
                if (DEBUG) {
                    _log.debug((Object)("Found OpenID2 localID: " + href));
                }
                result.setDelegate2(href);
            }
            if (DEBUG) {
                _log.debug((Object)("HTML discovery result:\n" + result));
            }
        }
        catch (ParserException e) {
            throw new DiscoveryException("Error parsing HTML message", e);
        }
    }
}

