/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;

public class DirectError
extends Message {
    private static Logger _log = Logger.getLogger(DirectError.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("ns", "error");
    protected static final List optionalFields = Arrays.asList("contact", "reference");

    protected DirectError(String msg) {
        this(msg, false);
    }

    protected DirectError(String msg, boolean compatibility) {
        this.set("error", msg);
        if (compatibility) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
    }

    protected DirectError(ParameterList params) {
        super(params);
    }

    public static DirectError createDirectError(String msg) {
        return DirectError.createDirectError(msg, false);
    }

    public static DirectError createDirectError(String msg, boolean compatibility) {
        DirectError err = new DirectError(msg, compatibility);
        if (!err.isValid()) {
            _log.error((Object)("Invalid " + (compatibility ? "OpenID1" : "OpenID2") + " direct error message created for message: " + msg));
        }
        _log.debug((Object)("Created direct error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public static DirectError createDirectError(ParameterList params) {
        DirectError err = new DirectError(params);
        if (!err.isValid()) {
            _log.error((Object)("Invalid direct error message created: " + err.keyValueFormEncoding()));
        }
        _log.debug((Object)("Created direct error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }

    public void setErrorMsg(String msg) {
        this.set("error", msg);
    }

    public String getErrorMsg() {
        return this.getParameterValue("error");
    }

    public void setContact(String contact) {
        this.set("contact", contact);
    }

    public void setReference(String reference) {
        this.set("reference", reference);
    }
}

