/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openid4java.association.Association;
import org.openid4java.consumer.ConsumerAssociationStore;

public class InMemoryConsumerAssociationStore
implements ConsumerAssociationStore {
    private static Logger _log = Logger.getLogger(InMemoryConsumerAssociationStore.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Map _idpMap = new HashMap();

    public synchronized void save(String idpUrl, Association association) {
        this.removeExpired();
        HashMap<String, Association> handleMap = (HashMap<String, Association>)this._idpMap.get(idpUrl);
        if (handleMap == null) {
            handleMap = new HashMap<String, Association>();
            this._idpMap.put(idpUrl, handleMap);
        }
        String handle = association.getHandle();
        if (DEBUG) {
            _log.debug((Object)("Adding association to the in-memory store: " + handle + " with OP: " + idpUrl));
        }
        handleMap.put(association.getHandle(), association);
    }

    public synchronized Association load(String idpUrl, String handle) {
        Map handleMap;
        this.removeExpired();
        if (this._idpMap.containsKey(idpUrl) && (handleMap = (Map)this._idpMap.get(idpUrl)).containsKey(handle)) {
            return (Association)handleMap.get(handle);
        }
        return null;
    }

    public synchronized Association load(String idpUrl) {
        this.removeExpired();
        Association latest = null;
        if (this._idpMap.containsKey(idpUrl)) {
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            for (String handle : handleMap.keySet()) {
                Association association = (Association)handleMap.get(handle);
                if (latest != null && !latest.getExpiry().before(association.getExpiry())) continue;
                latest = association;
            }
        }
        return latest;
    }

    public synchronized void remove(String idpUrl, String handle) {
        this.removeExpired();
        if (this._idpMap.containsKey(idpUrl)) {
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            _log.info((Object)("Removing association: " + handle + " widh OP: " + idpUrl));
            handleMap.remove(handle);
            if (handleMap.size() == 0) {
                this._idpMap.remove(idpUrl);
            }
        }
    }

    private synchronized void removeExpired() {
        HashSet<String> idpToRemove = new HashSet<String>();
        for (String idpUrl : this._idpMap.keySet()) {
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            HashSet<String> handleToRemove = new HashSet<String>();
            for (String handle : handleMap.keySet()) {
                Association association = (Association)handleMap.get(handle);
                if (!association.hasExpired()) continue;
                handleToRemove.add(handle);
            }
            for (String handle : handleToRemove) {
                _log.info((Object)("Removing expired association: " + handle + " with OP: " + idpUrl));
                handleMap.remove(handle);
            }
            if (handleMap.size() != 0) continue;
            idpToRemove.add(idpUrl);
        }
        for (String idpUrl : idpToRemove) {
            this._idpMap.remove(idpUrl);
        }
    }

    protected synchronized int size() {
        int total = 0;
        for (String idpUrl : this._idpMap.keySet()) {
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            total += handleMap.size();
        }
        return total;
    }
}

