/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Column;
import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.DBConfig;
import com.ozacc.mail.trotter.ListReader;
import com.ozacc.mail.trotter.Person;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.NoSuchElementException;

class DBListReader
implements ListReader {
    private Config config;
    private DBConfig db;
    private List columnList;
    private int cnt;
    private boolean flag;
    private boolean hasNext;
    private Connection conn;
    private Statement stmt;
    private ResultSet rs;
    private static DBListReader instance;

    private DBListReader(Config config) {
        this.config = config;
        this.db = config.getDbConfig();
        this.columnList = config.getColumnList();
        this.cnt = this.columnList.size();
    }

    static synchronized ListReader getInstance(Config config) {
        if (instance == null) {
            instance = new DBListReader(config);
        }
        return instance;
    }

    public void open() throws IOException {
        try {
            Class.forName(this.db.getDriver());
            this.conn = DriverManager.getConnection(this.db.getURL(), this.db.getUser(), this.db.getPassword());
            this.stmt = this.conn.createStatement();
            this.rs = this.stmt.executeQuery(this.db.getSql());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30c9\u30e9\u30a4\u30d0 (" + this.db.getDriver() + ") \u304c\u30af\u30e9\u30b9\u30d1\u30b9\u4e0a\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        catch (SQLException sQLException) {
            throw new IOException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3068\u306e\u63a5\u7d9a\u3001\u3082\u3057\u304f\u306fSQL\u30af\u30a8\u30ea\u306e\u5b9f\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() throws IOException {
        block13: {
            block12: {
                if (this.rs != null) {
                    this.rs.close();
                }
                if (this.stmt == null) break block12;
                this.stmt.close();
            }
            Object var3_1 = null;
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
                break block13;
            }
            catch (SQLException sQLException) {}
            break block13;
            {
                catch (SQLException sQLException) {
                    Object var3_2 = null;
                    try {
                        if (this.conn != null) {
                            this.conn.close();
                        }
                        break block13;
                    }
                    catch (SQLException sQLException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public Person next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Person person = new Person();
        for (int i = 0; i < this.cnt; ++i) {
            Column column = (Column)this.columnList.get(i);
            String string = column.getName();
            try {
                if (column.getType() == 1) {
                    person.setName(this.rs.getString(string));
                    continue;
                }
                if (column.getType() == 2) {
                    person.setEmail(this.rs.getString(string));
                    continue;
                }
                person.put(string, this.rs.getString(string));
                continue;
            }
            catch (SQLException sQLException) {
                throw new NoSuchElementException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30a2\u30af\u30bb\u30b9\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            }
        }
        this.flag = false;
        this.hasNext = false;
        return person;
    }

    public boolean hasNext() {
        if (this.flag) {
            return this.hasNext;
        }
        try {
            this.hasNext = this.rs.next();
            this.flag = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.hasNext;
    }
}

