/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter.emp;

import com.ozacc.mail.trotter.emp.ActionParser;
import com.ozacc.mail.trotter.emp.BaseAction;
import com.ozacc.mail.trotter.emp.Config;
import com.ozacc.mail.trotter.emp.ConfigReader;
import com.ozacc.mail.trotter.emp.EMPConfigException;
import com.ozacc.mail.trotter.emp.EMPException;
import com.ozacc.mail.trotter.emp.InternetMailReader;
import com.ozacc.mail.trotter.emp.Mail;
import com.ozacc.mail.trotter.emp.XMLConfigReader;
import java.util.List;
import org.apache.log4j.Logger;

public class ErrorMailProcessor {
    private Config config;
    private static Logger logger = Logger.getLogger((String)(class$com$ozacc$mail$trotter$emp$ErrorMailProcessor == null ? (class$com$ozacc$mail$trotter$emp$ErrorMailProcessor = ErrorMailProcessor.class$("com.ozacc.mail.trotter.emp.ErrorMailProcessor")) : class$com$ozacc$mail$trotter$emp$ErrorMailProcessor).getName());
    static /* synthetic */ Class class$com$ozacc$mail$trotter$emp$ErrorMailProcessor;

    public ErrorMailProcessor(String string) throws EMPConfigException {
        this.genConfig(string);
    }

    private void genConfig(String string) throws EMPConfigException {
        XMLConfigReader xMLConfigReader = new XMLConfigReader(string);
        this.config = ((ConfigReader)xMLConfigReader).getConfig();
    }

    public Config getConfig() {
        return this.config;
    }

    public static void main(String[] stringArray) {
        ErrorMailProcessor errorMailProcessor;
        if (stringArray.length < 1) {
            ErrorMailProcessor.printUsage();
        }
        try {
            errorMailProcessor = new ErrorMailProcessor(stringArray[0]);
        }
        catch (EMPConfigException eMPConfigException) {
            eMPConfigException.printStackTrace();
            return;
        }
        Config config = errorMailProcessor.getConfig();
        List list = ErrorMailProcessor.getActionList(config);
        ErrorMailProcessor.initActions(list);
        ErrorMailProcessor.execute(config, list);
        ErrorMailProcessor.endActions(list);
    }

    private static void execute(Config config, List list) {
        InternetMailReader internetMailReader = new InternetMailReader(config);
        internetMailReader.open();
        while (internetMailReader.hasNext()) {
            Mail mail = internetMailReader.next();
            if (mail == null) continue;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                BaseAction baseAction = (BaseAction)list.get(i);
                try {
                    baseAction.execute(mail);
                    continue;
                }
                catch (Exception exception) {
                    logger.fatal((Object)exception.getMessage());
                    internetMailReader.close();
                    ErrorMailProcessor.endActions(list);
                }
            }
        }
        internetMailReader.close();
    }

    private static List getActionList(Config config) {
        ActionParser actionParser = new ActionParser(config);
        try {
            return actionParser.parseActions();
        }
        catch (EMPException eMPException) {
            logger.fatal((Object)eMPException.getMessage());
            System.err.println(eMPException.getMessage());
            return null;
        }
    }

    private static void printUsage() {
        System.out.println("\u4f7f\u7528\u65b9\u6cd5");
        System.out.println("java com.ozacc.bulkmail.emp.ErrorMailProcessor [\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9]");
    }

    private static void initActions(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BaseAction baseAction = (BaseAction)list.get(i);
            baseAction.init();
        }
    }

    private static void endActions(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BaseAction baseAction = (BaseAction)list.get(i);
            baseAction.end();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

