/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENNA_DELIMITED_SYM = 686,
     SENNA_KWIC_SYM = 687,
     SENNA_MECAB_SYM = 688,
     SENNA_NGRAM_SYM = 689,
     SENNA_NORMALIZE_SYM = 690,
     SENNA_SECTIONALIZE_SYM = 691,
     SENNA_SPLIT_ALPHA_SYM = 692,
     SENNA_SPLIT_DIGIT_SYM = 693,
     SENNA_SPLIT_SYMBOL_SYM = 694,
     SENNA_SYM = 695,
     SENSITIVE_SYM = 696,
     SEPARATOR_SYM = 697,
     SERIALIZABLE_SYM = 698,
     SERIAL_SYM = 699,
     SESSION_SYM = 700,
     SET = 701,
     SET_VAR = 702,
     SHARE_SYM = 703,
     SHIFT_LEFT = 704,
     SHIFT_RIGHT = 705,
     SHOW = 706,
     SHUTDOWN = 707,
     SIGNED_SYM = 708,
     SIMPLE_SYM = 709,
     SLAVE = 710,
     SMALLINT = 711,
     SNAPSHOT_SYM = 712,
     SOUNDS_SYM = 713,
     SOURCE_SYM = 714,
     SPATIAL_SYM = 715,
     SPECIFIC_SYM = 716,
     SQLEXCEPTION_SYM = 717,
     SQLSTATE_SYM = 718,
     SQLWARNING_SYM = 719,
     SQL_BIG_RESULT = 720,
     SQL_BUFFER_RESULT = 721,
     SQL_CACHE_SYM = 722,
     SQL_CALC_FOUND_ROWS = 723,
     SQL_NO_CACHE_SYM = 724,
     SQL_SMALL_RESULT = 725,
     SQL_SYM = 726,
     SQL_THREAD = 727,
     SSL_SYM = 728,
     STARTING = 729,
     START_SYM = 730,
     STATUS_SYM = 731,
     STD_SYM = 732,
     STDDEV_SAMP_SYM = 733,
     STOP_SYM = 734,
     STORAGE_SYM = 735,
     STRAIGHT_JOIN = 736,
     STRING_SYM = 737,
     SUBDATE_SYM = 738,
     SUBJECT_SYM = 739,
     SUBSTRING = 740,
     SUBSTRING_INDEX = 741,
     SUM_SYM = 742,
     SUPER_SYM = 743,
     SUSPEND_SYM = 744,
     SWAPS_SYM = 745,
     SWITCHES_SYM = 746,
     SYSDATE = 747,
     TABLES = 748,
     TABLESPACE = 749,
     TABLE_SYM = 750,
     TEMPORARY = 751,
     TEMPTABLE_SYM = 752,
     TERMINATED = 753,
     TEXT_STRING = 754,
     TEXT_SYM = 755,
     TIMESTAMP = 756,
     TIMESTAMP_ADD = 757,
     TIMESTAMP_DIFF = 758,
     TIME_SYM = 759,
     TINYBLOB = 760,
     TINYINT = 761,
     TINYTEXT = 762,
     TO_SYM = 763,
     TRAILING = 764,
     TRANSACTION_SYM = 765,
     TRIGGER_SYM = 766,
     TRIGGERS_SYM = 767,
     TRIM = 768,
     TRUE_SYM = 769,
     TRUNCATE_SYM = 770,
     TYPES_SYM = 771,
     TYPE_SYM = 772,
     UDF_RETURNS_SYM = 773,
     UDF_SONAME_SYM = 774,
     ULONGLONG_NUM = 775,
     UNCOMMITTED_SYM = 776,
     UNDEFINED_SYM = 777,
     UNDERSCORE_CHARSET = 778,
     UNDO_SYM = 779,
     UNICODE_SYM = 780,
     UNION_SYM = 781,
     UNIQUE_SYM = 782,
     UNIQUE_USERS = 783,
     UNIX_TIMESTAMP = 784,
     UNKNOWN_SYM = 785,
     UNLOCK_SYM = 786,
     UNSIGNED = 787,
     UNTIL_SYM = 788,
     UPDATE_SYM = 789,
     UPGRADE_SYM = 790,
     USAGE = 791,
     USER = 792,
     USE_FRM = 793,
     USE_SYM = 794,
     USING = 795,
     UTC_DATE_SYM = 796,
     UTC_TIMESTAMP_SYM = 797,
     UTC_TIME_SYM = 798,
     VAR_SAMP_SYM = 799,
     VALUES = 800,
     VALUE_SYM = 801,
     VARBINARY = 802,
     VARCHAR = 803,
     VARIABLES = 804,
     VARIANCE_SYM = 805,
     VARYING = 806,
     VIEW_SYM = 807,
     WARNINGS = 808,
     WEEK_SYM = 809,
     WHEN_SYM = 810,
     WHERE = 811,
     WHILE_SYM = 812,
     WITH = 813,
     WORK_SYM = 814,
     WRITE_SYM = 815,
     X509_SYM = 816,
     XA_SYM = 817,
     XOR = 818,
     YEARWEEK = 819,
     YEAR_MONTH_SYM = 820,
     YEAR_SYM = 821,
     ZEROFILL = 822,
     TABLE_REF_PRIORITY = 823,
     ELSE = 824,
     THEN_SYM = 825,
     CASE_SYM = 826,
     BETWEEN_SYM = 827,
     NEG = 828
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENNA_DELIMITED_SYM 686
#define SENNA_KWIC_SYM 687
#define SENNA_MECAB_SYM 688
#define SENNA_NGRAM_SYM 689
#define SENNA_NORMALIZE_SYM 690
#define SENNA_SECTIONALIZE_SYM 691
#define SENNA_SPLIT_ALPHA_SYM 692
#define SENNA_SPLIT_DIGIT_SYM 693
#define SENNA_SPLIT_SYMBOL_SYM 694
#define SENNA_SYM 695
#define SENSITIVE_SYM 696
#define SEPARATOR_SYM 697
#define SERIALIZABLE_SYM 698
#define SERIAL_SYM 699
#define SESSION_SYM 700
#define SET 701
#define SET_VAR 702
#define SHARE_SYM 703
#define SHIFT_LEFT 704
#define SHIFT_RIGHT 705
#define SHOW 706
#define SHUTDOWN 707
#define SIGNED_SYM 708
#define SIMPLE_SYM 709
#define SLAVE 710
#define SMALLINT 711
#define SNAPSHOT_SYM 712
#define SOUNDS_SYM 713
#define SOURCE_SYM 714
#define SPATIAL_SYM 715
#define SPECIFIC_SYM 716
#define SQLEXCEPTION_SYM 717
#define SQLSTATE_SYM 718
#define SQLWARNING_SYM 719
#define SQL_BIG_RESULT 720
#define SQL_BUFFER_RESULT 721
#define SQL_CACHE_SYM 722
#define SQL_CALC_FOUND_ROWS 723
#define SQL_NO_CACHE_SYM 724
#define SQL_SMALL_RESULT 725
#define SQL_SYM 726
#define SQL_THREAD 727
#define SSL_SYM 728
#define STARTING 729
#define START_SYM 730
#define STATUS_SYM 731
#define STD_SYM 732
#define STDDEV_SAMP_SYM 733
#define STOP_SYM 734
#define STORAGE_SYM 735
#define STRAIGHT_JOIN 736
#define STRING_SYM 737
#define SUBDATE_SYM 738
#define SUBJECT_SYM 739
#define SUBSTRING 740
#define SUBSTRING_INDEX 741
#define SUM_SYM 742
#define SUPER_SYM 743
#define SUSPEND_SYM 744
#define SWAPS_SYM 745
#define SWITCHES_SYM 746
#define SYSDATE 747
#define TABLES 748
#define TABLESPACE 749
#define TABLE_SYM 750
#define TEMPORARY 751
#define TEMPTABLE_SYM 752
#define TERMINATED 753
#define TEXT_STRING 754
#define TEXT_SYM 755
#define TIMESTAMP 756
#define TIMESTAMP_ADD 757
#define TIMESTAMP_DIFF 758
#define TIME_SYM 759
#define TINYBLOB 760
#define TINYINT 761
#define TINYTEXT 762
#define TO_SYM 763
#define TRAILING 764
#define TRANSACTION_SYM 765
#define TRIGGER_SYM 766
#define TRIGGERS_SYM 767
#define TRIM 768
#define TRUE_SYM 769
#define TRUNCATE_SYM 770
#define TYPES_SYM 771
#define TYPE_SYM 772
#define UDF_RETURNS_SYM 773
#define UDF_SONAME_SYM 774
#define ULONGLONG_NUM 775
#define UNCOMMITTED_SYM 776
#define UNDEFINED_SYM 777
#define UNDERSCORE_CHARSET 778
#define UNDO_SYM 779
#define UNICODE_SYM 780
#define UNION_SYM 781
#define UNIQUE_SYM 782
#define UNIQUE_USERS 783
#define UNIX_TIMESTAMP 784
#define UNKNOWN_SYM 785
#define UNLOCK_SYM 786
#define UNSIGNED 787
#define UNTIL_SYM 788
#define UPDATE_SYM 789
#define UPGRADE_SYM 790
#define USAGE 791
#define USER 792
#define USE_FRM 793
#define USE_SYM 794
#define USING 795
#define UTC_DATE_SYM 796
#define UTC_TIMESTAMP_SYM 797
#define UTC_TIME_SYM 798
#define VAR_SAMP_SYM 799
#define VALUES 800
#define VALUE_SYM 801
#define VARBINARY 802
#define VARCHAR 803
#define VARIABLES 804
#define VARIANCE_SYM 805
#define VARYING 806
#define VIEW_SYM 807
#define WARNINGS 808
#define WEEK_SYM 809
#define WHEN_SYM 810
#define WHERE 811
#define WHILE_SYM 812
#define WITH 813
#define WORK_SYM 814
#define WRITE_SYM 815
#define X509_SYM 816
#define XA_SYM 817
#define XOR 818
#define YEARWEEK 819
#define YEAR_MONTH_SYM 820
#define YEAR_SYM 821
#define ZEROFILL 822
#define TABLE_REF_PRIORITY 823
#define ELSE 824
#define THEN_SYM 825
#define CASE_SYM 826
#define BETWEEN_SYM 827
#define NEG 828




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1669 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 214 of yacc.c.  */
#line 1684 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  482
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   44596

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  593
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  678
/* YYNRULES -- Number of rules. */
#define YYNRULES  2092
/* YYNRULES -- Number of states. */
#define YYNSTATES  3755

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   828

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   586,     2,     2,     2,   579,   574,     2,
     583,   584,   577,   576,   585,   575,   591,   578,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   592,   589,
       2,     2,     2,     2,   590,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   580,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   587,   573,   588,   581,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   582
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   119,   121,
     123,   128,   130,   133,   134,   139,   140,   143,   147,   149,
     152,   153,   157,   158,   164,   166,   170,   174,   178,   182,
     186,   190,   194,   198,   202,   206,   210,   214,   216,   220,
     224,   228,   232,   233,   241,   242,   254,   255,   262,   263,
     267,   272,   273,   277,   279,   280,   283,   284,   287,   290,
     293,   296,   299,   303,   307,   309,   311,   313,   316,   320,
     324,   325,   330,   331,   335,   336,   338,   342,   344,   345,
     347,   351,   353,   354,   358,   359,   361,   365,   367,   372,
     373,   375,   377,   379,   380,   384,   387,   391,   392,   396,
     397,   403,   409,   410,   418,   424,   425,   428,   430,   432,
     434,   438,   440,   442,   446,   447,   449,   451,   453,   455,
     458,   460,   462,   466,   467,   470,   471,   474,   475,   479,
     480,   486,   488,   490,   491,   494,   496,   498,   501,   504,
     507,   508,   515,   518,   519,   522,   524,   526,   530,   531,
     532,   533,   541,   542,   545,   548,   550,   552,   553,   554,
     563,   564,   571,   573,   576,   578,   581,   582,   583,   590,
     591,   592,   599,   600,   603,   604,   610,   611,   613,   614,
     620,   621,   624,   625,   631,   636,   637,   638,   647,   648,
     656,   658,   660,   662,   664,   666,   669,   672,   675,   680,
     685,   686,   691,   692,   693,   699,   700,   708,   709,   710,
     717,   718,   720,   721,   723,   725,   728,   730,   732,   733,
     735,   737,   740,   742,   743,   747,   748,   750,   752,   755,
     757,   760,   764,   768,   772,   776,   780,   784,   788,   792,
     796,   800,   804,   808,   812,   816,   820,   824,   828,   834,
     836,   838,   842,   847,   852,   856,   861,   866,   868,   870,
     872,   874,   876,   878,   880,   882,   884,   886,   888,   890,
     892,   894,   897,   899,   901,   903,   905,   907,   911,   913,
     915,   918,   921,   929,   938,   947,   950,   953,   954,   956,
     959,   960,   962,   965,   966,   971,   975,   979,   983,   985,
     988,   990,   992,   996,   999,  1003,  1006,  1009,  1011,  1015,
    1019,  1022,  1026,  1028,  1030,  1033,  1035,  1037,  1040,  1042,
    1044,  1046,  1049,  1053,  1056,  1060,  1063,  1066,  1070,  1074,
    1078,  1079,  1086,  1087,  1094,  1097,  1099,  1101,  1103,  1105,
    1107,  1109,  1111,  1113,  1115,  1117,  1119,  1122,  1125,  1127,
    1130,  1132,  1135,  1139,  1142,  1144,  1146,  1148,  1150,  1152,
    1154,  1156,  1159,  1160,  1162,  1164,  1170,  1171,  1173,  1176,
    1178,  1180,  1182,  1184,  1185,  1187,  1191,  1195,  1199,  1203,
    1204,  1206,  1207,  1209,  1212,  1214,  1216,  1219,  1222,  1227,
    1229,  1233,  1236,  1238,  1241,  1244,  1247,  1250,  1252,  1255,
    1257,  1259,  1261,  1263,  1265,  1266,  1269,  1271,  1273,  1275,
    1277,  1279,  1280,  1283,  1285,  1287,  1288,  1290,  1291,  1294,
    1296,  1299,  1303,  1306,  1307,  1309,  1310,  1312,  1314,  1317,
    1318,  1320,  1321,  1326,  1328,  1333,  1337,  1339,  1340,  1342,
    1345,  1347,  1351,  1355,  1358,  1361,  1364,  1366,  1368,  1371,
    1374,  1377,  1379,  1382,  1385,  1388,  1391,  1393,  1395,  1396,
    1398,  1400,  1402,  1404,  1405,  1407,  1409,  1411,  1412,  1415,
    1418,  1420,  1422,  1424,  1426,  1428,  1432,  1434,  1437,  1439,
    1442,  1444,  1446,  1448,  1450,  1452,  1454,  1456,  1458,  1463,
    1466,  1468,  1473,  1474,  1476,  1477,  1480,  1482,  1486,  1487,
    1494,  1495,  1501,  1502,  1508,  1509,  1515,  1516,  1528,  1529,
    1531,  1532,  1535,  1538,  1540,  1544,  1547,  1551,  1554,  1559,
    1560,  1567,  1568,  1569,  1578,  1583,  1588,  1592,  1596,  1599,
    1602,  1609,  1615,  1619,  1625,  1627,  1629,  1631,  1632,  1634,
    1635,  1637,  1638,  1640,  1642,  1643,  1646,  1648,  1649,  1651,
    1653,  1655,  1656,  1662,  1666,  1667,  1673,  1677,  1681,  1682,
    1686,  1687,  1690,  1692,  1696,  1697,  1699,  1701,  1702,  1705,
    1707,  1711,  1712,  1719,  1720,  1727,  1728,  1734,  1735,  1737,
    1739,  1740,  1747,  1748,  1750,  1752,  1755,  1757,  1759,  1761,
    1762,  1768,  1769,  1775,  1776,  1778,  1780,  1783,  1785,  1787,
    1789,  1791,  1793,  1796,  1797,  1803,  1804,  1806,  1808,  1809,
    1814,  1819,  1823,  1829,  1831,  1835,  1839,  1845,  1847,  1851,
    1854,  1856,  1858,  1859,  1866,  1868,  1872,  1876,  1877,  1880,
    1881,  1886,  1887,  1890,  1892,  1895,  1900,  1903,  1907,  1908,
    1912,  1913,  1914,  1921,  1924,  1926,  1928,  1931,  1934,  1943,
    1948,  1949,  1951,  1954,  1956,  1958,  1960,  1962,  1964,  1966,
    1968,  1970,  1972,  1974,  1976,  1977,  1980,  1985,  1989,  1991,
    1993,  1998,  1999,  2000,  2002,  2004,  2005,  2008,  2011,  2013,
    2015,  2016,  2019,  2023,  2027,  2031,  2034,  2038,  2043,  2047,
    2052,  2056,  2061,  2063,  2067,  2072,  2076,  2080,  2087,  2089,
    2095,  2102,  2108,  2116,  2123,  2132,  2138,  2145,  2150,  2155,
    2161,  2165,  2170,  2172,  2176,  2180,  2184,  2188,  2192,  2196,
    2201,  2206,  2210,  2214,  2218,  2222,  2226,  2230,  2232,  2234,
    2236,  2238,  2240,  2242,  2244,  2246,  2248,  2250,  2252,  2254,
    2256,  2258,  2260,  2262,  2264,  2267,  2269,  2273,  2275,  2277,
    2279,  2281,  2285,  2288,  2291,  2294,  2297,  2301,  2305,  2311,
    2318,  2323,  2328,  2336,  2341,  2344,  2351,  2357,  2364,  2371,
    2376,  2381,  2385,  2390,  2397,  2406,  2413,  2422,  2429,  2434,
    2441,  2446,  2453,  2458,  2463,  2468,  2473,  2480,  2489,  2492,
    2495,  2500,  2503,  2511,  2519,  2523,  2528,  2533,  2540,  2547,
    2552,  2559,  2566,  2573,  2578,  2585,  2590,  2597,  2606,  2617,
    2630,  2637,  2642,  2649,  2656,  2658,  2665,  2670,  2679,  2690,
    2695,  2697,  2701,  2706,  2713,  2720,  2729,  2736,  2743,  2748,
    2755,  2762,  2771,  2776,  2781,  2788,  2793,  2796,  2801,  2806,
    2811,  2818,  2823,  2828,  2832,  2841,  2848,  2853,  2860,  2864,
    2869,  2876,  2885,  2890,  2899,  2906,  2915,  2922,  2931,  2934,
    2939,  2944,  2949,  2956,  2965,  2974,  2979,  2987,  2995,  3003,
    3010,  3017,  3024,  3031,  3038,  3045,  3046,  3052,  3063,  3067,
    3072,  3076,  3079,  3082,  3085,  3090,  3097,  3102,  3107,  3114,
    3121,  3128,  3135,  3140,  3147,  3152,  3159,  3164,  3169,  3174,
    3179,  3186,  3191,  3198,  3203,  3210,  3215,  3220,  3227,  3232,
    3239,  3244,  3251,  3256,  3261,  3268,  3273,  3280,  3281,  3285,
    3289,  3290,  3292,  3293,  3296,  3298,  3302,  3307,  3312,  3318,
    3323,  3328,  3333,  3339,  3344,  3345,  3346,  3354,  3365,  3370,
    3376,  3381,  3387,  3392,  3397,  3402,  3407,  3412,  3418,  3419,
    3428,  3429,  3433,  3437,  3439,  3444,  3445,  3447,  3448,  3451,
    3452,  3454,  3455,  3459,  3462,  3466,  3469,  3471,  3474,  3476,
    3479,  3481,  3483,  3485,  3488,  3489,  3491,  3492,  3495,  3497,
    3501,  3503,  3507,  3508,  3511,  3513,  3517,  3518,  3520,  3521,
    3524,  3529,  3535,  3537,  3539,  3541,  3543,  3547,  3551,  3555,
    3556,  3563,  3564,  3571,  3572,  3581,  3586,  3587,  3596,  3597,
    3608,  3615,  3616,  3625,  3626,  3637,  3644,  3646,  3649,  3652,
    3653,  3658,  3659,  3671,  3675,  3682,  3683,  3687,  3688,  3689,
    3695,  3696,  3698,  3699,  3701,  3702,  3705,  3706,  3709,  3712,
    3715,  3716,  3723,  3724,  3726,  3730,  3732,  3734,  3736,  3740,
    3742,  3744,  3746,  3748,  3750,  3752,  3754,  3756,  3758,  3760,
    3762,  3764,  3766,  3768,  3770,  3772,  3774,  3776,  3778,  3780,
    3782,  3784,  3786,  3788,  3790,  3792,  3794,  3795,  3797,  3799,
    3800,  3803,  3804,  3806,  3807,  3808,  3812,  3813,  3814,  3818,
    3821,  3822,  3823,  3828,  3833,  3836,  3837,  3840,  3843,  3847,
    3851,  3853,  3856,  3857,  3859,  3860,  3865,  3870,  3873,  3874,
    3876,  3878,  3879,  3881,  3882,  3884,  3887,  3889,  3893,  3897,
    3899,  3901,  3903,  3905,  3906,  3909,  3911,  3913,  3915,  3917,
    3919,  3921,  3923,  3925,  3927,  3929,  3931,  3932,  3933,  3940,
    3941,  3943,  3947,  3949,  3952,  3953,  3956,  3960,  3962,  3965,
    3967,  3968,  3972,  3973,  3979,  3982,  3984,  3985,  3989,  3996,
    3997,  4004,  4009,  4016,  4021,  4026,  4031,  4037,  4042,  4044,
    4048,  4050,  4051,  4054,  4055,  4057,  4058,  4059,  4068,  4069,
    4070,  4077,  4078,  4080,  4082,  4084,  4086,  4088,  4091,  4093,
    4095,  4097,  4101,  4106,  4107,  4111,  4115,  4117,  4120,  4123,
    4124,  4128,  4129,  4135,  4139,  4141,  4145,  4147,  4151,  4153,
    4155,  4156,  4158,  4159,  4164,  4165,  4167,  4171,  4173,  4175,
    4177,  4178,  4179,  4186,  4187,  4188,  4200,  4204,  4206,  4210,
    4214,  4216,  4220,  4221,  4223,  4224,  4229,  4230,  4237,  4238,
    4244,  4245,  4252,  4254,  4258,  4262,  4268,  4269,  4272,  4273,
    4276,  4278,  4280,  4282,  4286,  4287,  4289,  4290,  4292,  4294,
    4298,  4300,  4302,  4305,  4308,  4311,  4313,  4315,  4317,  4319,
    4320,  4324,  4325,  4329,  4332,  4337,  4342,  4347,  4352,  4353,
    4358,  4365,  4382,  4385,  4388,  4389,  4396,  4402,  4405,  4408,
    4411,  4413,  4419,  4425,  4428,  4431,  4433,  4438,  4442,  4445,
    4448,  4451,  4455,  4458,  4461,  4464,  4466,  4468,  4472,  4477,
    4481,  4485,  4488,  4491,  4495,  4499,  4503,  4507,  4511,  4515,
    4520,  4522,  4524,  4526,  4528,  4529,  4531,  4532,  4535,  4536,
    4538,  4540,  4542,  4543,  4546,  4547,  4550,  4551,  4554,  4557,
    4558,  4563,  4564,  4569,  4571,  4573,  4574,  4576,  4577,  4579,
    4581,  4582,  4587,  4591,  4593,  4594,  4598,  4603,  4606,  4608,
    4610,  4612,  4614,  4616,  4618,  4620,  4622,  4623,  4625,  4626,
    4630,  4634,  4636,  4638,  4640,  4643,  4644,  4648,  4652,  4655,
    4658,  4659,  4664,  4665,  4667,  4669,  4672,  4673,  4678,  4684,
    4685,  4686,  4687,  4688,  4707,  4710,  4711,  4713,  4714,  4716,
    4718,  4719,  4721,  4723,  4724,  4727,  4730,  4732,  4736,  4741,
    4745,  4749,  4750,  4753,  4756,  4758,  4762,  4766,  4767,  4771,
    4772,  4776,  4779,  4783,  4785,  4787,  4790,  4791,  4794,  4796,
    4798,  4801,  4804,  4806,  4808,  4810,  4812,  4814,  4817,  4820,
    4822,  4824,  4826,  4828,  4830,  4832,  4834,  4837,  4840,  4843,
    4846,  4849,  4851,  4853,  4855,  4857,  4859,  4861,  4863,  4867,
    4873,  4875,  4877,  4879,  4881,  4883,  4887,  4892,  4898,  4900,
    4906,  4910,  4913,  4915,  4919,  4922,  4924,  4926,  4928,  4930,
    4932,  4934,  4936,  4938,  4940,  4942,  4944,  4946,  4948,  4950,
    4954,  4957,  4959,  4961,  4963,  4965,  4967,  4969,  4971,  4973,
    4975,  4977,  4979,  4981,  4983,  4985,  4987,  4989,  4991,  4993,
    4995,  4997,  4999,  5001,  5003,  5005,  5007,  5009,  5011,  5013,
    5015,  5017,  5019,  5021,  5023,  5025,  5027,  5029,  5031,  5033,
    5035,  5037,  5039,  5041,  5043,  5045,  5047,  5049,  5051,  5053,
    5055,  5057,  5059,  5061,  5063,  5065,  5067,  5069,  5071,  5073,
    5075,  5077,  5079,  5081,  5083,  5085,  5087,  5089,  5091,  5093,
    5095,  5097,  5099,  5101,  5103,  5105,  5107,  5109,  5111,  5113,
    5115,  5117,  5119,  5121,  5123,  5125,  5127,  5129,  5131,  5133,
    5135,  5137,  5139,  5141,  5143,  5145,  5147,  5149,  5151,  5153,
    5155,  5157,  5159,  5161,  5163,  5165,  5167,  5169,  5171,  5173,
    5175,  5177,  5179,  5181,  5183,  5185,  5187,  5189,  5191,  5193,
    5195,  5197,  5199,  5201,  5203,  5205,  5207,  5209,  5211,  5213,
    5215,  5217,  5219,  5221,  5223,  5225,  5227,  5229,  5231,  5233,
    5235,  5237,  5239,  5241,  5243,  5245,  5247,  5249,  5251,  5253,
    5255,  5257,  5259,  5261,  5263,  5265,  5267,  5269,  5271,  5273,
    5275,  5277,  5279,  5281,  5283,  5285,  5287,  5289,  5291,  5293,
    5295,  5297,  5299,  5301,  5303,  5305,  5307,  5309,  5311,  5313,
    5315,  5317,  5319,  5321,  5323,  5325,  5327,  5329,  5331,  5333,
    5335,  5337,  5339,  5341,  5343,  5345,  5347,  5349,  5351,  5353,
    5355,  5357,  5359,  5361,  5363,  5365,  5367,  5369,  5371,  5373,
    5375,  5377,  5379,  5381,  5383,  5385,  5387,  5389,  5391,  5393,
    5395,  5397,  5399,  5401,  5403,  5405,  5407,  5409,  5411,  5413,
    5415,  5417,  5419,  5421,  5423,  5425,  5427,  5429,  5431,  5433,
    5435,  5437,  5439,  5441,  5443,  5445,  5447,  5449,  5451,  5453,
    5455,  5457,  5459,  5461,  5463,  5465,  5467,  5469,  5471,  5473,
    5475,  5477,  5479,  5481,  5483,  5485,  5487,  5489,  5491,  5493,
    5495,  5497,  5499,  5501,  5503,  5504,  5509,  5510,  5512,  5514,
    5518,  5519,  5522,  5524,  5526,  5528,  5530,  5531,  5533,  5534,
    5536,  5538,  5540,  5541,  5544,  5547,  5550,  5552,  5555,  5560,
    5566,  5571,  5578,  5581,  5585,  5589,  5593,  5599,  5601,  5605,
    5609,  5612,  5615,  5618,  5620,  5622,  5627,  5632,  5634,  5636,
    5638,  5640,  5642,  5643,  5648,  5650,  5652,  5654,  5658,  5662,
    5664,  5666,  5669,  5672,  5673,  5677,  5682,  5686,  5687,  5695,
    5697,  5700,  5702,  5704,  5706,  5708,  5710,  5712,  5713,  5719,
    5721,  5723,  5725,  5727,  5729,  5733,  5740,  5747,  5754,  5762,
    5766,  5775,  5784,  5793,  5794,  5796,  5798,  5801,  5802,  5804,
    5806,  5810,  5811,  5815,  5816,  5820,  5821,  5825,  5826,  5830,
    5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,
    5852,  5855,  5858,  5860,  5864,  5867,  5870,  5873,  5876,  5879,
    5882,  5885,  5888,  5889,  5891,  5895,  5897,  5900,  5903,  5906,
    5908,  5912,  5916,  5918,  5920,  5924,  5926,  5930,  5935,  5941,
    5943,  5944,  5948,  5952,  5954,  5956,  5957,  5960,  5963,  5966,
    5969,  5970,  5973,  5976,  5978,  5981,  5984,  5987,  5990,  5993,
    5994,  5998,  5999,  6001,  6002,  6006,  6009,  6010,  6012,  6015,
    6016,  6018,  6023,  6028,  6034,  6037,  6041,  6042,  6044,  6045,
    6050,  6051,  6053,  6055,  6056,  6059,  6062,  6064,  6065,  6067,
    6069,  6070,  6076,  6083,  6084,  6085,  6088,  6091,  6095,  6097,
    6099,  6101,  6103,  6105,  6107,  6109,  6111,  6113,  6115,  6117,
    6118,  6122,  6124,  6127,  6129,  6132,  6136,  6140,  6144,  6145,
    6147,  6148,  6152,  6156,  6157,  6166,  6167,  6171,  6173,  6177,
    6178,  6181,  6185,  6191,  6192,  6196,  6201,  6206,  6207,  6222,
    6231,  6239,  6240,  6241,  6242,  6243,  6244,  6260,  6261,  6262,
    6263,  6264,  6277,  6282,  6287,  6291,  6296,  6300,  6303,  6305,
    6309,  6315,  6317,  6319,  6320,  6322,  6324,  6325,  6328,  6329,
    6330,  6334,  6335
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     594,     0,    -1,     3,    -1,    -1,   597,   595,   589,   596,
      -1,   597,     3,    -1,    -1,     3,    -1,   598,    -1,  1208,
      -1,   797,    -1,   838,    -1,   828,    -1,   627,    -1,   610,
      -1,   840,    -1,   830,    -1,  1214,    -1,   615,    -1,   599,
      -1,  1048,    -1,  1079,    -1,  1004,    -1,  1006,    -1,   603,
      -1,  1085,    -1,  1183,    -1,  1174,    -1,   608,    -1,  1012,
      -1,  1099,    -1,  1103,    -1,  1166,    -1,   845,    -1,   853,
      -1,   857,    -1,   601,    -1,  1095,    -1,  1217,    -1,   848,
      -1,   833,    -1,  1015,    -1,  1091,    -1,   826,    -1,  1181,
      -1,  1215,    -1,  1216,    -1,   865,    -1,  1149,    -1,  1065,
      -1,   815,    -1,   818,    -1,  1059,    -1,  1172,    -1,  1040,
      -1,  1102,    -1,  1263,    -1,   600,   370,  1143,    -1,   106,
      -1,   129,    -1,   370,  1143,   175,   602,    -1,  1140,    -1,
     590,  1145,    -1,    -1,   151,  1143,   604,   605,    -1,    -1,
     540,   606,    -1,   606,   585,   607,    -1,   607,    -1,   590,
    1145,    -1,    -1,   202,   609,  1145,    -1,    -1,    53,   287,
     508,   611,   612,    -1,   613,    -1,   612,   585,   613,    -1,
     274,   145,  1140,    -1,   288,   145,  1140,    -1,   277,   145,
    1140,    -1,   278,   145,   989,    -1,   273,   145,   989,    -1,
     286,   145,   989,    -1,   282,   145,  1140,    -1,   281,   145,
    1140,    -1,   283,   145,  1140,    -1,   284,   145,  1140,    -1,
     285,   145,  1140,    -1,   614,    -1,   275,   145,  1140,    -1,
     276,   145,   990,    -1,   396,   145,  1140,    -1,   397,   145,
     989,    -1,    -1,    87,   712,   495,   715,  1137,   616,   699,
      -1,    -1,    87,   787,   217,  1143,   788,   344,  1137,   617,
     583,   792,   584,    -1,    -1,    87,    94,   715,  1143,   618,
     709,    -1,    -1,    87,   619,  1230,    -1,    87,   537,   620,
    1199,    -1,    -1,  1143,   591,  1143,    -1,  1143,    -1,    -1,
     622,   624,    -1,    -1,   623,   625,    -1,    68,  1140,    -1,
     241,   471,    -1,   335,   471,    -1,    80,   471,    -1,   389,
     471,    96,    -1,   311,   471,    96,    -1,   626,    -1,   624,
      -1,   121,    -1,   892,   121,    -1,   471,   429,   112,    -1,
     471,   429,   228,    -1,    -1,    48,   621,   628,   629,    -1,
      -1,   583,   630,   584,    -1,    -1,   631,    -1,   631,   585,
     886,    -1,   886,    -1,    -1,   633,    -1,   633,   585,   635,
      -1,   635,    -1,    -1,  1143,   634,   738,    -1,    -1,   637,
      -1,   637,   585,   638,    -1,   638,    -1,   639,   634,  1143,
     738,    -1,    -1,   229,    -1,   357,    -1,   221,    -1,    -1,
     640,   656,   589,    -1,   656,   589,    -1,   641,   656,   589,
      -1,    -1,   642,   643,   589,    -1,    -1,   109,   654,   644,
     738,   655,    -1,   109,  1143,    76,   172,   651,    -1,    -1,
     109,   648,   199,   172,   645,   649,   656,    -1,   109,  1143,
      92,   172,   646,    -1,    -1,   647,   598,    -1,   153,    -1,
      82,    -1,   650,    -1,   649,   585,   650,    -1,   653,    -1,
     989,    -1,   463,   652,  1141,    -1,    -1,   546,    -1,   651,
      -1,  1143,    -1,   464,    -1,   892,   173,    -1,   462,    -1,
    1143,    -1,   654,   585,  1143,    -1,    -1,   111,   886,    -1,
      -1,   657,   598,    -1,    -1,   414,   658,   886,    -1,    -1,
     213,   659,   664,   141,   213,    -1,   669,    -1,   684,    -1,
      -1,   660,   693,    -1,   687,    -1,   689,    -1,   248,  1144,
      -1,   235,  1144,    -1,   347,  1143,    -1,    -1,   161,   662,
    1143,   226,   661,   663,    -1,    61,  1143,    -1,    -1,   330,
     175,    -1,   175,    -1,  1143,    -1,   663,   585,  1143,    -1,
      -1,    -1,    -1,   665,   886,   570,   666,   641,   667,   668,
      -1,    -1,   135,   664,    -1,   569,   641,    -1,   670,    -1,
     673,    -1,    -1,    -1,   571,   671,   886,   672,   675,   683,
     141,   571,    -1,    -1,   571,   674,   676,   683,   141,   571,
      -1,   677,    -1,   675,   677,    -1,   680,    -1,   676,   680,
      -1,    -1,    -1,   555,   678,   886,   679,   570,   641,    -1,
      -1,    -1,   555,   681,   886,   682,   570,   641,    -1,    -1,
     569,   641,    -1,    -1,  1144,   592,   685,   693,   686,    -1,
      -1,  1144,    -1,    -1,  1144,   592,   688,   691,   686,    -1,
      -1,   690,   691,    -1,    -1,    28,   692,   642,   640,   141,
      -1,   269,   641,   141,   269,    -1,    -1,    -1,   557,   694,
     886,   128,   695,   641,   141,   557,    -1,    -1,   404,   641,
     533,   696,   886,   141,   404,    -1,    27,    -1,     8,    -1,
     223,    -1,   534,    -1,   115,    -1,   583,   700,    -1,   716,
     702,    -1,   252,  1137,    -1,   583,   252,  1137,   584,    -1,
     728,   584,   716,   702,    -1,    -1,   705,   584,   701,  1221,
      -1,    -1,    -1,  1112,   708,   705,   703,  1218,    -1,    -1,
    1112,   708,   583,   705,   584,   704,  1221,    -1,    -1,    -1,
     430,   706,   875,   879,   707,   726,    -1,    -1,    18,    -1,
      -1,   710,    -1,   711,    -1,   710,   711,    -1,   721,    -1,
     720,    -1,    -1,   713,    -1,   714,    -1,   714,   713,    -1,
     496,    -1,    -1,   213,   892,   152,    -1,    -1,   718,    -1,
     719,    -1,   719,   717,    -1,   719,    -1,   719,   718,    -1,
     719,   585,   718,    -1,   143,  1032,   722,    -1,   517,  1032,
     722,    -1,   292,  1032,   990,    -1,   307,  1032,   990,    -1,
      24,  1032,   989,    -1,   361,  1032,  1140,    -1,    68,  1032,
    1140,    -1,    23,  1032,   990,    -1,   358,  1032,   989,    -1,
     358,  1032,   111,    -1,    57,  1032,   989,    -1,   114,  1032,
     989,    -1,   423,  1032,   723,    -1,   387,  1032,   724,    -1,
     384,  1032,   989,    -1,   385,  1032,   989,    -1,   526,  1032,
     583,  1090,   584,    -1,   720,    -1,   721,    -1,   224,  1032,
     725,    -1,    96,   122,  1032,  1140,    -1,   217,   122,  1032,
    1140,    -1,    77,  1032,  1140,    -1,   769,   760,  1032,   762,
      -1,   769,    64,  1032,   768,    -1,  1145,    -1,   111,    -1,
     165,    -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,
     386,    -1,   383,    -1,   989,    -1,   335,    -1,   164,    -1,
     243,    -1,   984,    -1,   874,   878,    -1,   482,    -1,   391,
      -1,   108,    -1,   227,    -1,   729,    -1,   728,   585,   729,
      -1,   730,    -1,   731,    -1,   736,   732,    -1,   736,   774,
      -1,   782,   794,   788,   583,   792,   584,   788,    -1,   734,
     783,   794,   788,   583,   792,   584,   788,    -1,   734,   170,
     238,   794,   583,   792,   584,   774,    -1,   735,   732,    -1,
     734,   733,    -1,    -1,   733,    -1,    58,   886,    -1,    -1,
     735,    -1,    79,   794,    -1,    -1,  1136,   737,   738,   756,
      -1,   746,   753,   750,    -1,   747,   755,   750,    -1,   167,
     748,   750,    -1,    37,    -1,    37,   754,    -1,    42,    -1,
      41,    -1,   742,   754,   770,    -1,   742,   770,    -1,   743,
     754,   771,    -1,   743,   771,    -1,    32,   754,    -1,    32,
      -1,   744,   754,   770,    -1,   745,   754,   771,    -1,   547,
     754,    -1,   566,   753,   750,    -1,   100,    -1,   504,    -1,
     501,   753,    -1,    97,    -1,   505,    -1,    39,   753,    -1,
     741,    -1,   296,    -1,   265,    -1,   268,   547,    -1,   268,
     744,   770,    -1,   507,   770,    -1,   500,   753,   770,    -1,
     298,   770,    -1,   266,   770,    -1,   108,   748,   750,    -1,
     339,   748,   750,    -1,   165,   748,   750,    -1,    -1,   144,
     739,   583,   796,   584,   770,    -1,    -1,   446,   740,   583,
     796,   584,   770,    -1,   268,   770,    -1,   444,    -1,   187,
      -1,   186,    -1,   365,    -1,   318,    -1,   256,    -1,   317,
      -1,   367,    -1,   319,    -1,    56,    -1,   326,    -1,   323,
      56,    -1,   742,   551,    -1,   548,    -1,   323,   548,    -1,
     340,    -1,   326,   548,    -1,   323,    56,   551,    -1,   326,
     551,    -1,   227,    -1,   506,    -1,   456,    -1,   297,    -1,
      31,    -1,   391,    -1,   127,    -1,   127,   369,    -1,    -1,
     754,    -1,   749,    -1,   583,   338,   585,   338,   584,    -1,
      -1,   751,    -1,   751,   752,    -1,   752,    -1,   453,    -1,
     532,    -1,   567,    -1,    -1,   754,    -1,   583,   267,   584,
      -1,   583,   520,   584,    -1,   583,   107,   584,    -1,   583,
     338,   584,    -1,    -1,   749,    -1,    -1,   757,    -1,   757,
     758,    -1,   758,    -1,   337,    -1,   892,   337,    -1,   111,
     759,    -1,   344,   534,   334,   885,    -1,    23,    -1,   444,
     111,   546,    -1,   773,   238,    -1,   527,    -1,   527,   238,
      -1,    68,  1140,    -1,    64,   766,    -1,   334,   885,    -1,
    1127,    -1,    56,   446,    -1,    55,    -1,  1145,    -1,    32,
      -1,   761,    -1,   111,    -1,    -1,   760,   762,    -1,  1145,
      -1,    32,    -1,   764,    -1,   111,    -1,  1145,    -1,    -1,
      64,   768,    -1,   766,    -1,   111,    -1,    -1,   111,    -1,
      -1,    20,   771,    -1,    46,    -1,   525,   771,    -1,   760,
     761,   771,    -1,    32,   772,    -1,    -1,    32,    -1,    -1,
      20,    -1,   525,    -1,   760,   761,    -1,    -1,   372,    -1,
      -1,   394,  1137,   775,   776,    -1,   778,    -1,   583,   777,
     584,   778,    -1,   777,   585,  1143,    -1,  1143,    -1,    -1,
     779,    -1,   779,   780,    -1,   780,    -1,   344,   115,   781,
      -1,   344,   534,   781,    -1,   289,   177,    -1,   289,   360,
      -1,   289,   454,    -1,   411,    -1,    49,    -1,   446,   337,
      -1,   335,     5,    -1,   446,   111,    -1,   784,    -1,   178,
     785,    -1,   460,   785,    -1,   372,   238,    -1,   527,   785,
      -1,   238,    -1,   217,    -1,    -1,   784,    -1,   237,    -1,
     217,    -1,   216,    -1,    -1,   527,    -1,   178,    -1,   460,
      -1,    -1,   540,   789,    -1,   517,   789,    -1,    44,    -1,
     425,    -1,   200,    -1,   790,    -1,   791,    -1,   791,   585,
     790,    -1,   440,    -1,   335,   440,    -1,   435,    -1,   335,
     435,    -1,   437,    -1,   438,    -1,   439,    -1,   431,    -1,
     433,    -1,   434,    -1,   436,    -1,   989,    -1,   792,   585,
     793,   982,    -1,   793,   982,    -1,  1143,    -1,  1143,   583,
     338,   584,    -1,    -1,  1136,    -1,    -1,   591,  1143,    -1,
    1125,    -1,   796,   585,  1125,    -1,    -1,    13,   811,   495,
    1137,   798,   804,    -1,    -1,    13,    94,   803,   799,   710,
      -1,    -1,    13,   374,   621,   800,   622,    -1,    -1,    13,
     179,   621,   801,   622,    -1,    -1,    13,  1239,  1233,  1240,
     552,  1137,   802,  1243,    18,  1245,  1248,    -1,    -1,  1143,
      -1,    -1,   124,   494,    -1,   215,   494,    -1,   806,    -1,
     804,   585,   806,    -1,     6,   810,    -1,   805,   730,   813,
      -1,     6,   731,    -1,   805,   583,   728,   584,    -1,    -1,
      53,   810,  1136,   807,   736,   813,    -1,    -1,    -1,   312,
     810,  1136,   808,   738,   756,   809,   813,    -1,   129,   810,
    1136,   812,    -1,   129,   170,   238,   794,    -1,   129,   372,
     238,    -1,   129,   784,  1136,    -1,   123,   237,    -1,   137,
     237,    -1,    13,   810,  1136,   446,   111,  1127,    -1,    13,
     810,  1136,   129,   111,    -1,   401,   814,  1137,    -1,    83,
     508,   760,   762,   767,    -1,   717,    -1,   169,    -1,   975,
      -1,    -1,    67,    -1,    -1,   214,    -1,    -1,   411,    -1,
      49,    -1,    -1,     8,  1143,    -1,   164,    -1,    -1,   508,
      -1,   145,    -1,    18,    -1,    -1,   475,   455,   820,   816,
     824,    -1,   479,   455,   820,    -1,    -1,   455,   475,   820,
     817,   824,    -1,   455,   479,   820,    -1,   475,   510,   819,
      -1,    -1,   558,    78,   457,    -1,    -1,   821,   822,    -1,
     823,    -1,   822,   585,   823,    -1,    -1,   472,    -1,   398,
      -1,    -1,   533,   825,    -1,   614,    -1,   825,   585,   614,
      -1,    -1,   410,  1168,   827,  1008,   175,  1140,    -1,    -1,
      26,  1168,   829,  1008,   508,  1140,    -1,    -1,    57,  1168,
     831,  1008,   832,    -1,    -1,   382,    -1,   156,    -1,    -1,
     402,   847,  1168,   834,  1008,   835,    -1,    -1,   836,    -1,
     837,    -1,   837,   836,    -1,   382,    -1,   156,    -1,   538,
      -1,    -1,    14,   847,  1168,   839,  1008,    -1,    -1,    58,
    1168,   841,  1008,   842,    -1,    -1,   843,    -1,   844,    -1,
     844,   843,    -1,   382,    -1,   159,    -1,   299,    -1,   156,
      -1,    54,    -1,   172,   535,    -1,    -1,   348,   847,  1168,
     846,  1008,    -1,    -1,   336,    -1,   258,    -1,    -1,   401,
    1168,   849,   851,    -1,   401,   537,   620,   850,    -1,  1146,
     508,  1146,    -1,   850,   585,  1146,   508,  1146,    -1,   852,
      -1,   851,   585,   852,    -1,  1137,   508,  1137,    -1,    47,
     217,   854,   229,   856,    -1,   855,    -1,   854,   585,   855,
      -1,  1137,   861,    -1,  1143,    -1,   111,    -1,    -1,   257,
     217,   226,    47,   858,   859,    -1,   860,    -1,   859,   585,
     860,    -1,  1137,   861,   864,    -1,    -1,   862,   863,    -1,
      -1,   785,   583,   958,   584,    -1,    -1,   214,   247,    -1,
     866,    -1,   430,   868,    -1,   583,   867,   584,  1221,    -1,
     430,   870,    -1,   583,   867,   584,    -1,    -1,   870,   869,
    1218,    -1,    -1,    -1,   871,   875,   879,   872,   873,   878,
      -1,   978,   984,    -1,  1000,    -1,   874,    -1,  1000,   874,
      -1,   874,  1000,    -1,   175,   931,   967,   972,   969,   978,
     984,   991,    -1,   175,   130,   967,   984,    -1,    -1,   876,
      -1,   876,   877,    -1,   877,    -1,   481,    -1,   204,    -1,
     125,    -1,   470,    -1,   465,    -1,   466,    -1,   468,    -1,
     469,    -1,   467,    -1,    12,    -1,    -1,   172,   534,    -1,
     262,   229,   448,   310,    -1,   879,   585,   880,    -1,   880,
      -1,   577,    -1,   881,   883,   882,   884,    -1,    -1,    -1,
    1131,    -1,   886,    -1,    -1,    18,  1143,    -1,    18,  1140,
      -1,  1143,    -1,  1140,    -1,    -1,   583,   584,    -1,   886,
     890,   886,    -1,   886,   563,   886,    -1,   886,   891,   886,
      -1,   333,   886,    -1,   887,   232,   514,    -1,   887,   232,
     892,   514,    -1,   887,   232,   158,    -1,   887,   232,   892,
     158,    -1,   887,   232,   530,    -1,   887,   232,   892,   530,
      -1,   887,    -1,   887,   232,   337,    -1,   887,   232,   892,
     337,    -1,   887,   146,   888,    -1,   887,   894,   888,    -1,
     887,   894,   895,   583,  1227,   584,    -1,   888,    -1,   889,
     229,   583,  1227,   584,    -1,   889,   892,   229,   583,  1227,
     584,    -1,   889,   229,   583,   886,   584,    -1,   889,   229,
     583,   886,   585,   920,   584,    -1,   889,   892,   229,   583,
     886,   584,    -1,   889,   892,   229,   583,   886,   585,   920,
     584,    -1,   889,   572,   889,    16,   888,    -1,   889,   892,
     572,   889,    16,   888,    -1,   889,   458,   252,   889,    -1,
     889,   252,   897,   971,    -1,   889,   892,   252,   897,   971,
      -1,   889,   395,   889,    -1,   889,   892,   395,   889,    -1,
     889,    -1,   889,   573,   889,    -1,   889,   574,   889,    -1,
     889,   449,   889,    -1,   889,   450,   889,    -1,   889,   576,
     889,    -1,   889,   575,   889,    -1,   889,   576,   896,   960,
      -1,   889,   575,   896,   960,    -1,   889,   577,   889,    -1,
     889,   578,   889,    -1,   889,   579,   889,    -1,   889,   126,
     889,    -1,   889,   313,   889,    -1,   889,   580,   889,    -1,
     897,    -1,   354,    -1,   351,    -1,    16,    -1,    15,    -1,
     333,    -1,   332,    -1,   586,    -1,   332,    -1,   145,    -1,
     184,    -1,   198,    -1,   244,    -1,   271,    -1,   328,    -1,
      12,    -1,    17,    -1,   225,   886,    -1,  1133,    -1,   897,
      64,  1145,    -1,  1128,    -1,  1126,    -1,   910,    -1,   906,
      -1,   897,   353,   897,    -1,   576,   897,    -1,   575,   897,
      -1,   581,   897,    -1,   893,   897,    -1,   583,  1227,   584,
      -1,   583,   886,   584,    -1,   583,   886,   585,   920,   584,
      -1,   424,   583,   886,   585,   920,   584,    -1,   152,   583,
    1227,   584,    -1,   587,  1143,   886,   588,    -1,   289,   923,
       9,   583,   889,   900,   584,    -1,    20,   583,   886,   584,
      -1,    32,   897,    -1,    51,   583,   886,    18,   918,   584,
      -1,   571,   927,   929,   928,   141,    -1,    83,   583,   886,
     585,   918,   584,    -1,    83,   583,   886,   540,   761,   584,
      -1,   111,   583,  1133,   584,    -1,   545,   583,  1134,   584,
      -1,   180,   583,   584,    -1,   181,   583,   886,   584,    -1,
     182,   583,   886,   585,   886,   584,    -1,   183,   583,   886,
     585,   886,   585,   886,   584,    -1,     7,   583,   886,   585,
     886,   584,    -1,     7,   583,   886,   585,   225,   886,   960,
     584,    -1,   404,   583,   886,   585,   886,   584,    -1,    22,
     583,   886,   584,    -1,    22,   583,   886,   585,   886,   584,
      -1,    56,   583,   920,   584,    -1,    56,   583,   920,   540,
     761,   584,    -1,    55,   583,   886,   584,    -1,    62,   583,
     920,   584,    -1,    65,   583,   886,   584,    -1,    73,   583,
     920,   584,    -1,    74,   583,   886,   585,   920,   584,    -1,
      84,   583,   886,   585,   886,   585,   886,   584,    -1,    90,
     885,    -1,    93,   885,    -1,    93,   583,   886,   584,    -1,
      91,   885,    -1,    98,   583,   886,   585,   896,   960,   584,
      -1,    99,   583,   886,   585,   896,   960,   584,    -1,    94,
     583,   584,    -1,   100,   583,   886,   584,    -1,   105,   583,
     886,   584,    -1,   136,   583,   886,   585,   920,   584,    -1,
     272,   583,   886,   585,   920,   584,    -1,   140,   583,   886,
     584,    -1,   140,   583,   886,   585,   886,   584,    -1,   110,
     583,   886,   585,  1141,   584,    -1,   139,   583,   886,   585,
    1141,   584,    -1,   118,   583,   886,   584,    -1,   118,   583,
     886,   585,   886,   584,    -1,   119,   583,   886,   584,    -1,
     119,   583,   886,   585,   886,   584,    -1,   155,   583,   886,
     585,   886,   585,   886,   584,    -1,   155,   583,   886,   585,
     886,   585,   886,   585,   886,   584,    -1,   155,   583,   886,
     585,   886,   585,   886,   585,   886,   585,   886,   584,    -1,
     171,   583,   886,   585,   338,   584,    -1,   176,   583,   886,
     584,    -1,   176,   583,   886,   585,   886,   584,    -1,   162,
     583,   886,   585,   920,   584,    -1,   899,    -1,   190,   583,
     963,   585,   886,   584,    -1,   209,   583,   886,   584,    -1,
     213,   583,   886,   585,   886,   585,   886,   584,    -1,   223,
     583,   886,   585,   886,   585,   886,   585,   886,   584,    -1,
     896,   960,   576,   886,    -1,   896,    -1,   242,   583,   584,
      -1,   242,   583,   886,   584,    -1,   249,   583,   886,   585,
     886,   584,    -1,   259,   583,   886,   585,   886,   584,    -1,
     259,   583,   886,   585,   886,   585,   886,   584,    -1,   194,
     583,   886,   585,   920,   584,    -1,   246,   583,   886,   585,
     920,   584,    -1,   264,   583,   886,   584,    -1,   264,   583,
     886,   585,   886,   584,    -1,   279,   583,   886,   585,   886,
     584,    -1,   279,   583,   886,   585,   886,   585,   886,   584,
      -1,   302,   583,   886,   584,    -1,   306,   583,   886,   584,
      -1,   313,   583,   886,   585,   886,   584,    -1,   314,   583,
     886,   584,    -1,   334,   885,    -1,   334,   583,   886,   584,
      -1,   361,   583,   886,   584,    -1,   343,   583,   886,   584,
      -1,   368,   583,   889,   229,   886,   584,    -1,   380,   583,
     886,   584,    -1,   388,   583,   886,   584,    -1,   388,   583,
     584,    -1,   405,   583,   886,   585,   886,   585,   886,   584,
      -1,   416,   583,   886,   585,   886,   584,    -1,   419,   583,
     886,   584,    -1,   419,   583,   886,   585,   886,   584,    -1,
     422,   583,   584,    -1,   432,   583,   920,   584,    -1,   483,
     583,   886,   585,   886,   584,    -1,   483,   583,   886,   585,
     225,   886,   960,   584,    -1,   428,   583,   886,   584,    -1,
     485,   583,   886,   585,   886,   585,   886,   584,    -1,   485,
     583,   886,   585,   886,   584,    -1,   485,   583,   886,   175,
     886,   172,   886,   584,    -1,   485,   583,   886,   175,   886,
     584,    -1,   486,   583,   886,   585,   886,   585,   886,   584,
      -1,   492,   885,    -1,   492,   583,   886,   584,    -1,   504,
     583,   886,   584,    -1,   501,   583,   886,   584,    -1,   501,
     583,   886,   585,   886,   584,    -1,   502,   583,   961,   585,
     886,   585,   886,   584,    -1,   503,   583,   961,   585,   886,
     585,   886,   584,    -1,   513,   583,   886,   584,    -1,   513,
     583,   245,   886,   175,   886,   584,    -1,   513,   583,   509,
     886,   175,   886,   584,    -1,   513,   583,    43,   886,   175,
     886,   584,    -1,   513,   583,   245,   175,   886,   584,    -1,
     513,   583,   509,   175,   886,   584,    -1,   513,   583,    43,
     175,   886,   584,    -1,   513,   583,   886,   175,   886,   584,
      -1,   515,   583,   886,   585,   886,   584,    -1,  1143,   591,
    1143,   583,   919,   584,    -1,    -1,  1139,   583,   898,   901,
     584,    -1,   528,   583,  1124,   585,   338,   585,   338,   585,
     920,   584,    -1,   529,   583,   584,    -1,   529,   583,   886,
     584,    -1,   537,   583,   584,    -1,   541,   885,    -1,   543,
     885,    -1,   542,   885,    -1,   554,   583,   886,   584,    -1,
     554,   583,   886,   585,   886,   584,    -1,   566,   583,   886,
     584,    -1,   564,   583,   886,   584,    -1,   564,   583,   886,
     585,   886,   584,    -1,    29,   583,   989,   585,   886,   584,
      -1,   157,   583,   960,   175,   886,   584,    -1,    80,   583,
     886,   585,   886,   584,    -1,   188,   583,   886,   584,    -1,
     188,   583,   886,   585,   886,   584,    -1,   189,   583,   886,
     584,    -1,   189,   583,   886,   585,   886,   584,    -1,   186,
     583,   920,   584,    -1,   256,   583,   920,   584,    -1,   317,
     583,   920,   584,    -1,   309,   583,   886,   584,    -1,   309,
     583,   886,   585,   886,   584,    -1,   315,   583,   886,   584,
      -1,   315,   583,   886,   585,   886,   584,    -1,   316,   583,
     886,   584,    -1,   316,   583,   886,   585,   886,   584,    -1,
     318,   583,   920,   584,    -1,   319,   583,   920,   584,    -1,
     365,   583,   886,   585,   886,   584,    -1,   364,   583,   886,
     584,    -1,   364,   583,   886,   585,   886,   584,    -1,   366,
     583,   886,   584,    -1,   366,   583,   886,   585,   886,   584,
      -1,   367,   583,   920,   584,    -1,   185,   583,   886,   584,
      -1,   185,   583,   886,   585,   886,   584,    -1,   254,   583,
     886,   584,    -1,   254,   583,   886,   585,   886,   584,    -1,
      -1,   558,   381,   154,    -1,   229,    41,   310,    -1,    -1,
     902,    -1,    -1,   903,   904,    -1,   905,    -1,   904,   585,
     905,    -1,   881,   886,   882,   884,    -1,    25,   583,   916,
     584,    -1,    25,   583,   125,   916,   584,    -1,    35,   583,
     916,   584,    -1,    36,   583,   916,   584,    -1,    38,   583,
     916,   584,    -1,    85,   583,   966,   577,   584,    -1,    85,
     583,   916,   584,    -1,    -1,    -1,    85,   583,   125,   907,
     920,   908,   584,    -1,   197,   583,  1124,   585,   338,   585,
     338,   585,   916,   584,    -1,   308,   583,   916,   584,    -1,
     308,   583,   125,   916,   584,    -1,   293,   583,   916,   584,
      -1,   293,   583,   125,   916,   584,    -1,   477,   583,   916,
     584,    -1,   550,   583,   916,   584,    -1,   478,   583,   916,
     584,    -1,   544,   583,   916,   584,    -1,   487,   583,   916,
     584,    -1,   487,   583,   125,   916,   584,    -1,    -1,   196,
     583,   913,   909,   920,   915,   914,   584,    -1,    -1,   590,
     911,   912,    -1,  1145,   447,   886,    -1,  1145,    -1,   590,
    1158,  1145,   795,    -1,    -1,   125,    -1,    -1,   442,  1125,
      -1,    -1,   979,    -1,    -1,   966,   917,   886,    -1,    32,
     753,    -1,    56,   753,   770,    -1,   326,   753,    -1,   453,
      -1,   453,   227,    -1,   532,    -1,   532,   227,    -1,   100,
      -1,   504,    -1,    97,    -1,   108,   748,    -1,    -1,   920,
      -1,    -1,   921,   922,    -1,   886,    -1,   922,   585,   886,
      -1,   924,    -1,   583,   924,   584,    -1,    -1,   925,   926,
      -1,  1133,    -1,   926,   585,  1133,    -1,    -1,   886,    -1,
      -1,   569,   886,    -1,   555,   886,   570,   886,    -1,   929,
     555,   886,   570,   886,    -1,   942,    -1,   933,    -1,   932,
      -1,   930,    -1,   932,   585,   930,    -1,   930,   941,   930,
      -1,   930,   481,   942,    -1,    -1,   930,   941,   930,   344,
     934,   886,    -1,    -1,   930,   481,   942,   344,   935,   886,
      -1,    -1,   930,   941,   930,   540,   936,   583,   959,   584,
      -1,   930,   324,   236,   942,    -1,    -1,   930,   249,   952,
     236,   930,   344,   937,   886,    -1,    -1,   930,   249,   952,
     236,   942,   938,   540,   583,   959,   584,    -1,   930,   324,
     249,   952,   236,   942,    -1,    -1,   930,   416,   952,   236,
     930,   344,   939,   886,    -1,    -1,   930,   416,   952,   236,
     942,   940,   540,   583,   959,   584,    -1,   930,   324,   416,
     952,   236,   942,    -1,   236,    -1,   219,   236,    -1,    88,
     236,    -1,    -1,   943,  1137,   965,   954,    -1,    -1,   587,
    1143,   930,   249,   355,   236,   930,   344,   944,   886,   588,
      -1,   951,   950,   947,    -1,   583,   950,   945,  1221,   584,
     965,    -1,    -1,   950,   946,   932,    -1,    -1,    -1,   948,
     875,   879,   949,   726,    -1,    -1,   430,    -1,    -1,   355,
      -1,    -1,   172,   236,    -1,    -1,   539,   955,    -1,   169,
     955,    -1,   214,   955,    -1,    -1,   784,   953,   956,   583,
     957,   584,    -1,    -1,   958,    -1,   958,   585,  1143,    -1,
    1143,    -1,   372,    -1,  1143,    -1,   959,   585,  1143,    -1,
     962,    -1,   101,    -1,   102,    -1,   103,    -1,   104,    -1,
     206,    -1,   207,    -1,   208,    -1,   304,    -1,   305,    -1,
     427,    -1,   565,    -1,   962,    -1,   174,    -1,   105,    -1,
     554,    -1,   209,    -1,   306,    -1,   314,    -1,   380,    -1,
     428,    -1,   302,    -1,   566,    -1,   100,    -1,   504,    -1,
      97,    -1,   501,    -1,    -1,    18,    -1,   145,    -1,    -1,
     964,  1143,    -1,    -1,    12,    -1,    -1,    -1,   556,   968,
     886,    -1,    -1,    -1,   201,   970,   886,    -1,   149,   897,
      -1,    -1,    -1,   195,    45,   973,   974,    -1,   973,   585,
    1132,   982,    -1,  1132,   982,    -1,    -1,   558,    89,    -1,
     558,   418,    -1,   352,    45,   976,    -1,   976,   585,   977,
      -1,   977,    -1,  1134,   982,    -1,    -1,   979,    -1,    -1,
     352,    45,   980,   981,    -1,   981,   585,  1132,   982,    -1,
    1132,   982,    -1,    -1,    19,    -1,   116,    -1,    -1,   985,
      -1,    -1,   985,    -1,   253,   986,    -1,   987,    -1,   987,
     585,   987,    -1,   987,   341,   987,    -1,  1126,    -1,   520,
      -1,   267,    -1,   338,    -1,    -1,   253,   987,    -1,   338,
      -1,   203,    -1,   267,    -1,   520,    -1,   107,    -1,   166,
      -1,   338,    -1,   520,    -1,   267,    -1,   107,    -1,   166,
      -1,    -1,    -1,   374,  1143,   992,   583,   993,   584,    -1,
      -1,   994,    -1,   994,   585,   995,    -1,   995,    -1,   881,
     886,    -1,    -1,   997,   998,    -1,   998,   585,   999,    -1,
     999,    -1,   590,  1145,    -1,  1145,    -1,    -1,   226,  1001,
    1002,    -1,    -1,   356,  1142,  1003,  1113,  1116,    -1,   131,
    1142,    -1,   996,    -1,    -1,   128,  1005,   920,    -1,   129,
    1011,  1168,  1010,  1008,   812,    -1,    -1,   129,   217,  1143,
     344,  1137,  1007,    -1,   129,    94,  1010,  1143,    -1,   129,
     179,  1010,  1143,   591,  1143,    -1,   129,   179,  1010,  1143,
      -1,   129,   374,  1010,   621,    -1,   129,   537,   620,  1198,
      -1,   129,   552,  1010,  1008,   812,    -1,   129,   511,  1010,
     621,    -1,  1009,    -1,  1008,   585,  1009,    -1,  1137,    -1,
      -1,   213,   152,    -1,    -1,   496,    -1,    -1,    -1,   223,
    1013,  1018,   811,  1020,  1014,  1022,  1038,    -1,    -1,    -1,
     405,  1016,  1019,  1020,  1017,  1022,    -1,    -1,   270,    -1,
     113,    -1,   204,    -1,  1047,    -1,   113,    -1,   226,  1021,
      -1,  1021,    -1,  1009,    -1,  1025,    -1,   583,   584,  1025,
      -1,   583,  1024,   584,  1025,    -1,    -1,   446,  1023,  1029,
      -1,  1024,   585,  1130,    -1,  1130,    -1,   545,  1028,    -1,
     546,  1028,    -1,    -1,   705,  1026,  1218,    -1,    -1,   583,
     705,   584,  1027,  1221,    -1,  1028,   585,  1033,    -1,  1033,
      -1,  1029,   585,  1030,    -1,  1030,    -1,  1134,  1031,  1037,
      -1,   145,    -1,   447,    -1,    -1,  1031,    -1,    -1,   583,
    1034,  1035,   584,    -1,    -1,  1036,    -1,  1036,   585,  1037,
      -1,  1037,    -1,   886,    -1,   111,    -1,    -1,    -1,   344,
     132,  1039,   238,   534,  1045,    -1,    -1,    -1,   534,  1041,
    1047,   811,   931,   446,  1043,  1042,   967,   978,   988,    -1,
    1043,   585,  1044,    -1,  1044,    -1,  1134,  1031,  1037,    -1,
    1045,   585,  1046,    -1,  1046,    -1,  1134,  1031,  1037,    -1,
      -1,   270,    -1,    -1,   115,  1049,  1057,  1050,    -1,    -1,
     175,  1137,  1051,   967,   978,   988,    -1,    -1,  1054,  1052,
     175,   931,   967,    -1,    -1,   175,  1054,  1053,   540,   931,
     967,    -1,  1055,    -1,  1054,   585,  1055,    -1,  1143,  1056,
     965,    -1,  1143,   591,  1143,  1056,   965,    -1,    -1,   591,
     577,    -1,    -1,  1058,  1057,    -1,   382,    -1,   270,    -1,
     214,    -1,   515,  1060,  1009,    -1,    -1,   495,    -1,    -1,
    1062,    -1,  1063,    -1,  1062,   585,  1063,    -1,    86,    -1,
     300,    -1,    40,   230,    -1,    81,   491,    -1,   359,   160,
      -1,   231,    -1,   490,    -1,   459,    -1,    12,    -1,    -1,
     172,   381,   338,    -1,    -1,   451,  1066,  1067,    -1,    95,
    1078,    -1,  1074,   493,  1073,  1078,    -1,  1074,   512,  1073,
    1078,    -1,   495,   476,  1073,  1078,    -1,   347,   493,  1073,
    1078,    -1,    -1,   143,   722,  1068,  1070,    -1,  1074,    66,
    1075,  1137,  1073,  1078,    -1,   329,   287,   172,   455,   558,
     275,   145,  1140,    16,   276,   145,   990,    16,   280,   145,
     989,    -1,  1071,   263,    -1,   455,   205,    -1,    -1,    33,
     150,  1076,  1077,  1069,   983,    -1,   786,  1075,  1137,  1073,
     967,    -1,    67,   516,    -1,   495,   516,    -1,  1072,   142,
      -1,   373,    -1,    85,   583,   577,   584,   553,    -1,    85,
     583,   577,   584,   147,    -1,   553,   983,    -1,   147,   983,
      -1,   378,    -1,   377,  1061,  1064,   983,    -1,  1157,   476,
    1078,    -1,   220,   476,    -1,   320,   476,    -1,  1074,   376,
      -1,  1157,   549,  1078,    -1,   760,  1078,    -1,    65,  1078,
      -1,    30,   263,    -1,   263,    -1,   193,    -1,   193,   172,
    1146,    -1,    87,    94,   715,  1143,    -1,    87,   495,  1137,
      -1,    87,   552,  1137,    -1,   287,   476,    -1,   455,   476,
      -1,    87,   374,   621,    -1,    87,   179,   621,    -1,   374,
     476,  1078,    -1,   179,   476,  1078,    -1,   374,    63,   621,
      -1,   179,    63,   621,    -1,   440,   476,  1073,  1078,    -1,
     476,    -1,   263,    -1,   287,    -1,    32,    -1,    -1,   480,
      -1,    -1,  1075,  1143,    -1,    -1,   177,    -1,   175,    -1,
     229,    -1,    -1,   229,  1140,    -1,    -1,   175,   990,    -1,
      -1,   252,  1140,    -1,   556,   886,    -1,    -1,  1082,  1137,
    1080,  1084,    -1,    -1,  1082,  1083,  1081,   865,    -1,   116,
      -1,   117,    -1,    -1,   156,    -1,    -1,  1125,    -1,  1143,
      -1,    -1,   168,   847,  1086,  1087,    -1,  1087,   585,  1088,
      -1,  1088,    -1,    -1,  1168,  1089,  1090,    -1,   493,   558,
     390,   262,    -1,   381,    47,    -1,   205,    -1,   373,    -1,
     263,    -1,   476,    -1,   455,    -1,   287,    -1,   120,    -1,
     409,    -1,    -1,  1008,    -1,    -1,   408,  1092,  1093,    -1,
    1093,   585,  1094,    -1,  1094,    -1,   455,    -1,   287,    -1,
     381,    47,    -1,    -1,   379,  1096,  1097,    -1,  1071,   263,
    1098,    -1,   508,  1140,    -1,    27,   886,    -1,    -1,   239,
    1100,  1101,   886,    -1,    -1,    77,    -1,   381,    -1,   539,
    1143,    -1,    -1,   257,    96,  1104,  1105,    -1,   257,   495,
    1137,   175,   287,    -1,    -1,    -1,    -1,    -1,  1111,  1110,
     218,  1142,  1106,  1112,   226,  1107,   495,  1137,  1108,   763,
    1109,  1113,  1116,  1119,  1120,  1123,    -1,   175,   287,    -1,
      -1,   258,    -1,    -1,    75,    -1,   270,    -1,    -1,   405,
      -1,   214,    -1,    -1,    66,  1114,    -1,  1114,  1115,    -1,
    1115,    -1,   498,    45,  1125,    -1,   350,   138,    45,  1125,
      -1,   138,    45,  1125,    -1,   148,    45,  1125,    -1,    -1,
     255,  1117,    -1,  1117,  1118,    -1,  1118,    -1,   498,    45,
    1125,    -1,   474,    45,  1125,    -1,    -1,   214,   338,   255,
      -1,    -1,   583,  1121,   584,    -1,   583,   584,    -1,  1121,
     585,  1122,    -1,  1122,    -1,  1134,    -1,   590,  1145,    -1,
      -1,   446,  1045,    -1,   499,    -1,   325,    -1,   523,   499,
      -1,  1124,  1141,    -1,  1141,    -1,   203,    -1,    34,    -1,
     362,    -1,  1128,    -1,   576,  1129,    -1,   575,  1129,    -1,
    1124,    -1,  1129,    -1,   337,    -1,   158,    -1,   514,    -1,
     203,    -1,    34,    -1,   523,   203,    -1,   523,    34,    -1,
     100,  1124,    -1,   504,  1124,    -1,   501,  1124,    -1,   338,
      -1,   267,    -1,   520,    -1,   107,    -1,   166,    -1,  1134,
      -1,  1131,    -1,  1143,   591,   577,    -1,  1143,   591,  1143,
     591,   577,    -1,   886,    -1,  1143,    -1,  1135,    -1,  1143,
      -1,  1135,    -1,  1143,   591,  1143,    -1,   591,  1143,   591,
    1143,    -1,  1143,   591,  1143,   591,  1143,    -1,  1143,    -1,
    1143,   591,  1143,   591,  1143,    -1,  1143,   591,  1143,    -1,
     591,  1143,    -1,  1143,    -1,  1143,   591,  1143,    -1,   591,
    1143,    -1,  1143,    -1,   210,    -1,   212,    -1,   499,    -1,
     499,    -1,   499,    -1,  1139,    -1,  1147,    -1,  1139,    -1,
    1148,    -1,  1143,    -1,  1140,    -1,   251,    -1,  1145,    -1,
    1145,   590,  1145,    -1,    91,   885,    -1,  1148,    -1,    20,
      -1,    26,    -1,    28,    -1,    46,    -1,    47,    -1,    55,
      -1,    57,    -1,    61,    -1,    68,    -1,    70,    -1,    80,
      -1,   106,    -1,   128,    -1,   141,    -1,   151,    -1,   168,
      -1,   199,    -1,   202,    -1,   241,    -1,   335,    -1,   347,
      -1,   370,    -1,   402,    -1,   408,    -1,   410,    -1,   417,
      -1,   426,    -1,   429,    -1,   453,    -1,   455,    -1,   475,
      -1,   479,    -1,   515,    -1,   525,    -1,   562,    -1,   535,
      -1,     5,    -1,     7,    -1,     8,    -1,     9,    -1,    10,
      -1,    11,    -1,    17,    -1,    23,    -1,    24,    -1,    25,
      -1,    30,    -1,    33,    -1,    37,    -1,    40,    -1,    42,
      -1,    41,    -1,    44,    -1,    50,    -1,    52,    -1,    54,
      -1,    59,    -1,    60,    -1,    63,    -1,    65,    -1,    66,
      -1,    69,    -1,    71,    -1,    72,    -1,    75,    -1,    77,
      -1,    78,    -1,    81,    -1,    86,    -1,    89,    -1,    96,
      -1,    97,    -1,   100,    -1,   105,    -1,   112,    -1,   114,
      -1,   120,    -1,   122,    -1,   124,    -1,   131,    -1,   132,
      -1,   133,    -1,   144,    -1,   143,    -1,   142,    -1,   147,
      -1,   149,    -1,   150,    -1,   154,    -1,   156,    -1,   159,
      -1,   160,    -1,   173,    -1,   123,    -1,   137,    -1,   177,
      -1,   163,    -1,   164,    -1,   165,    -1,   174,    -1,   187,
      -1,   186,    -1,   190,    -1,   193,    -1,   191,    -1,   200,
      -1,   205,    -1,   209,    -1,   211,    -1,   228,    -1,   215,
      -1,   216,    -1,   233,    -1,   234,    -1,   220,    -1,   224,
      -1,   230,    -1,   231,    -1,   398,    -1,   243,    -1,   247,
      -1,   250,    -1,   256,    -1,   258,    -1,   261,    -1,   263,
      -1,   292,    -1,   287,    -1,   274,    -1,   278,    -1,   275,
      -1,   276,    -1,   288,    -1,   277,    -1,   280,    -1,   273,
      -1,   286,    -1,   282,    -1,   281,    -1,   283,    -1,   284,
      -1,   285,    -1,   290,    -1,   291,    -1,   294,    -1,   295,
      -1,   299,    -1,   300,    -1,   301,    -1,   302,    -1,   303,
      -1,   306,    -1,   307,    -1,   312,    -1,   310,    -1,   314,
      -1,   317,    -1,   318,    -1,   319,    -1,   320,    -1,   322,
      -1,   321,    -1,   323,    -1,   326,    -1,   327,    -1,   330,
      -1,   329,    -1,   331,    -1,   340,    -1,   341,    -1,   343,
      -1,   345,    -1,   346,    -1,   358,    -1,   359,    -1,   360,
      -1,   361,    -1,   363,    -1,   365,    -1,   367,    -1,   371,
      -1,   373,    -1,   375,    -1,   376,    -1,   377,    -1,   378,
      -1,   380,    -1,   381,    -1,   382,    -1,   383,    -1,   384,
      -1,   385,    -1,   386,    -1,   387,    -1,   392,    -1,   393,
      -1,   396,    -1,   397,    -1,   400,    -1,   403,    -1,   406,
      -1,   409,    -1,   412,    -1,   413,    -1,   418,    -1,   420,
      -1,   421,    -1,   423,    -1,   424,    -1,   425,    -1,   428,
      -1,   431,    -1,   432,    -1,   433,    -1,   434,    -1,   435,
      -1,   436,    -1,   437,    -1,   438,    -1,   439,    -1,   440,
      -1,   444,    -1,   443,    -1,   445,    -1,   454,    -1,   448,
      -1,   452,    -1,   457,    -1,   458,    -1,   459,    -1,   467,
      -1,   466,    -1,   469,    -1,   472,    -1,   476,    -1,   480,
      -1,   482,    -1,   483,    -1,   484,    -1,   488,    -1,   489,
      -1,   490,    -1,   491,    -1,   493,    -1,   494,    -1,   496,
      -1,   497,    -1,   500,    -1,   510,    -1,   512,    -1,   501,
      -1,   502,    -1,   503,    -1,   504,    -1,   516,    -1,   517,
      -1,   518,    -1,   179,    -1,   521,    -1,   522,    -1,   530,
      -1,   533,    -1,   537,    -1,   538,    -1,   549,    -1,   552,
      -1,   546,    -1,   553,    -1,   554,    -1,   559,    -1,   561,
      -1,   566,    -1,    -1,   446,  1151,  1150,  1152,    -1,    -1,
     349,    -1,  1153,    -1,  1152,   585,  1153,    -1,    -1,  1154,
    1159,    -1,  1156,    -1,   191,    -1,   258,    -1,   445,    -1,
      -1,   345,    -1,    -1,   191,    -1,   258,    -1,   445,    -1,
      -1,   191,   591,    -1,   258,   591,    -1,   445,   591,    -1,
    1160,    -1,  1156,  1161,    -1,  1155,  1162,  1031,  1165,    -1,
    1155,   510,   233,   250,  1163,    -1,   590,  1145,  1031,   886,
      -1,   590,   590,  1158,  1162,  1031,  1165,    -1,   760,   765,
      -1,   321,  1031,   886,    -1,   321,   762,   767,    -1,   361,
    1031,  1164,    -1,   361,   172,  1146,  1031,  1164,    -1,  1143,
      -1,  1143,   591,  1143,    -1,   111,   591,  1143,    -1,   390,
     521,    -1,   390,    69,    -1,   403,   390,    -1,   443,    -1,
     499,    -1,   361,   583,   499,   584,    -1,   343,   583,   499,
     584,    -1,   886,    -1,   111,    -1,   344,    -1,    12,    -1,
      32,    -1,    -1,   262,  1168,  1167,  1169,    -1,   495,    -1,
     493,    -1,  1170,    -1,  1169,   585,  1170,    -1,  1137,   965,
    1171,    -1,   390,    -1,   560,    -1,   270,   560,    -1,   390,
     258,    -1,    -1,   531,  1173,  1168,    -1,   199,  1137,   347,
     965,    -1,   199,  1138,    61,    -1,    -1,   199,  1138,   390,
    1175,  1176,   967,   984,    -1,  1177,    -1,  1143,  1178,    -1,
     164,    -1,   330,    -1,   164,    -1,   330,    -1,   371,    -1,
     243,    -1,    -1,  1180,  1179,   583,  1036,   584,    -1,   145,
      -1,   184,    -1,   244,    -1,   198,    -1,   271,    -1,   415,
     620,  1182,    -1,  1186,   344,  1185,  1197,   175,  1199,    -1,
    1186,   344,   179,  1197,   175,  1199,    -1,  1186,   344,   374,
    1197,   175,  1199,    -1,    12,  1187,   585,   192,   349,   175,
    1199,    -1,   192,   620,  1184,    -1,  1186,   344,  1185,  1197,
     508,  1199,  1204,  1205,    -1,  1186,   344,   179,  1197,   508,
    1199,  1204,  1205,    -1,  1186,   344,   374,  1197,   508,  1199,
    1204,  1205,    -1,    -1,   495,    -1,  1188,    -1,    12,  1187,
      -1,    -1,   373,    -1,  1189,    -1,  1188,   585,  1189,    -1,
      -1,   430,  1190,  1201,    -1,    -1,   223,  1191,  1201,    -1,
      -1,   534,  1192,  1201,    -1,    -1,   394,  1193,  1201,    -1,
     115,    -1,   536,    -1,   217,    -1,    13,    -1,    87,    -1,
     129,    -1,   151,    -1,   400,    -1,   452,    -1,   375,    -1,
     163,    -1,   192,   349,    -1,   451,    95,    -1,   488,    -1,
      87,   496,   493,    -1,   262,   493,    -1,   406,   455,    -1,
     406,    60,    -1,    87,   552,    -1,   451,   552,    -1,    87,
     420,    -1,    13,   420,    -1,    87,   537,    -1,    -1,    16,
      -1,  1196,  1194,  1195,    -1,  1196,    -1,   484,   499,    -1,
     234,   499,    -1,    59,   499,    -1,   577,    -1,  1143,   591,
     577,    -1,   577,   591,   577,    -1,  1137,    -1,  1146,    -1,
    1198,   585,  1146,    -1,  1200,    -1,  1199,   585,  1200,    -1,
    1146,   211,    45,   499,    -1,  1146,   211,    45,   361,   499,
      -1,  1146,    -1,    -1,   583,  1202,   584,    -1,  1202,   585,
    1203,    -1,  1203,    -1,  1143,    -1,    -1,   407,  1195,    -1,
     407,   473,    -1,   407,   561,    -1,   407,   331,    -1,    -1,
     558,  1206,    -1,  1206,  1207,    -1,  1207,    -1,   192,   349,
      -1,   291,   989,    -1,   294,   989,    -1,   290,   989,    -1,
     295,   989,    -1,    -1,    28,  1209,  1210,    -1,    -1,   559,
      -1,    -1,    16,   335,    52,    -1,    16,    52,    -1,    -1,
     399,    -1,   335,   399,    -1,    -1,   426,    -1,    70,  1210,
    1211,  1212,    -1,   417,  1210,  1211,  1212,    -1,   417,  1210,
     508,  1213,  1143,    -1,   426,  1143,    -1,   399,   426,  1143,
      -1,    -1,  1219,    -1,    -1,   526,  1225,  1220,   866,    -1,
      -1,  1219,    -1,  1222,    -1,    -1,  1223,  1224,    -1,   979,
     983,    -1,   985,    -1,    -1,   125,    -1,    12,    -1,    -1,
     430,  1228,   868,  1226,  1229,    -1,   583,  1228,   867,  1226,
    1229,   584,    -1,    -1,    -1,  1235,  1231,    -1,  1234,  1232,
      -1,  1236,  1233,  1241,    -1,  1241,    -1,  1249,    -1,  1258,
      -1,  1252,    -1,  1241,    -1,  1249,    -1,  1258,    -1,  1252,
      -1,  1251,    -1,  1234,    -1,  1235,    -1,    -1,   112,   145,
    1146,    -1,  1237,    -1,  1237,  1238,    -1,  1238,    -1,   354,
     405,    -1,    11,   145,   522,    -1,    11,   145,   301,    -1,
      11,   145,   497,    -1,    -1,  1238,    -1,    -1,   471,   429,
     112,    -1,   471,   429,   228,    -1,    -1,  1240,   552,  1137,
    1242,  1243,    18,  1245,  1248,    -1,    -1,   583,  1244,   584,
      -1,  1143,    -1,  1244,   585,  1143,    -1,    -1,  1246,  1247,
      -1,   430,   881,   868,    -1,   583,   881,   867,   584,  1221,
      -1,    -1,   558,    58,   349,    -1,   558,    50,    58,   349,
      -1,   558,   258,    58,   349,    -1,    -1,   511,   881,   621,
     697,   698,   344,   881,  1137,   172,   881,   134,   424,  1250,
     656,    -1,    10,   881,   179,  1143,   413,   727,   519,  1140,
      -1,   881,   179,  1143,   413,   727,   519,  1140,    -1,    -1,
      -1,    -1,    -1,    -1,   881,   179,   621,   583,  1253,   632,
     584,  1254,   413,  1255,   738,  1256,   623,  1257,   656,    -1,
      -1,    -1,    -1,    -1,   374,   881,   621,  1259,   583,  1260,
     636,   584,  1261,   623,  1262,   656,    -1,   562,  1265,  1264,
    1266,    -1,   562,   141,  1264,  1268,    -1,   562,   370,  1264,
      -1,   562,    70,  1264,  1267,    -1,   562,   417,  1264,    -1,
     562,   392,    -1,  1125,    -1,  1125,   585,  1125,    -1,  1125,
     585,  1125,   585,   989,    -1,    28,    -1,   475,    -1,    -1,
     236,    -1,   412,    -1,    -1,   346,   363,    -1,    -1,    -1,
     489,  1269,  1270,    -1,    -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1229,  1229,  1242,  1241,  1266,  1273,  1275,  1279,  1280,
    1285,  1286,  1287,  1288,  1289,  1290,  1291,  1292,  1293,  1294,
    1295,  1296,  1297,  1298,  1299,  1300,  1301,  1302,  1303,  1304,
    1305,  1306,  1307,  1308,  1309,  1310,  1311,  1312,  1313,  1314,
    1315,  1316,  1317,  1318,  1319,  1320,  1321,  1322,  1323,  1324,
    1325,  1326,  1327,  1328,  1329,  1330,  1331,  1335,  1344,  1345,
    1350,  1359,  1366,  1376,  1375,  1386,  1388,  1392,  1393,  1396,
    1409,  1408,  1427,  1426,  1437,  1438,  1441,  1446,  1451,  1456,
    1461,  1465,  1470,  1474,  1478,  1482,  1486,  1491,  1495,  1499,
    1515,  1519,  1531,  1530,  1553,  1552,  1579,  1578,  1591,  1590,
    1598,  1606,  1620,  1635,  1654,  1655,  1659,  1660,  1665,  1667,
    1669,  1671,  1673,  1675,  1677,  1683,  1684,  1685,  1689,  1693,
    1701,  1700,  1713,  1715,  1718,  1720,  1724,  1728,  1735,  1737,
    1741,  1742,  1747,  1766,  1792,  1794,  1798,  1799,  1803,  1829,
    1830,  1831,  1832,  1836,  1837,  1841,  1842,  1847,  1850,  1877,
    1876,  1937,  1952,  1951,  1998,  2024,  2024,  2056,  2057,  2062,
    2064,  2069,  2092,  2098,  2113,  2114,  2118,  2122,  2131,  2136,
    2141,  2149,  2164,  2182,  2183,  2187,  2187,  2239,  2238,  2267,
    2266,  2270,  2271,  2273,  2273,  2284,  2286,  2288,  2338,  2378,
    2396,  2395,  2414,  2433,  2435,  2436,  2440,  2461,  2484,  2489,
    2504,  2484,  2523,  2525,  2526,  2530,  2531,  2536,  2543,  2535,
    2562,  2561,  2577,  2578,  2582,  2583,  2588,  2593,  2587,  2610,
    2615,  2609,  2630,  2640,  2645,  2644,  2680,  2681,  2686,  2685,
    2718,  2718,  2733,  2732,  2769,  2781,  2786,  2780,  2812,  2811,
    2834,  2836,  2841,  2843,  2845,  2850,  2851,  2852,  2858,  2867,
    2868,  2868,  2872,  2874,  2873,  2876,  2875,  2881,  2897,  2880,
    2911,  2912,  2915,  2916,  2919,  2920,  2923,  2924,  2927,  2928,
    2931,  2932,  2935,  2938,  2939,  2941,  2943,  2946,  2947,  2950,
    2951,  2952,  2955,  2956,  2957,  2958,  2959,  2960,  2961,  2962,
    2963,  2978,  2984,  2985,  2986,  2987,  2992,  2997,  3002,  3017,
    3018,  3019,  3020,  3021,  3022,  3026,  3043,  3059,  3069,  3070,
    3071,  3072,  3073,  3074,  3077,  3078,  3079,  3082,  3083,  3084,
    3087,  3088,  3091,  3092,  3093,  3094,  3097,  3098,  3102,  3103,
    3107,  3108,  3118,  3132,  3140,  3160,  3167,  3176,  3178,  3182,
    3186,  3187,  3191,  3196,  3195,  3217,  3218,  3219,  3220,  3222,
    3223,  3225,  3227,  3228,  3230,  3232,  3235,  3237,  3240,  3241,
    3243,  3245,  3246,  3247,  3248,  3261,  3262,  3264,  3266,  3278,
    3280,  3282,  3284,  3285,  3286,  3287,  3288,  3289,  3291,  3293,
    3295,  3295,  3297,  3297,  3299,  3300,  3309,  3310,  3311,  3314,
    3315,  3316,  3317,  3318,  3322,  3326,  3327,  3331,  3332,  3336,
    3337,  3338,  3339,  3340,  3344,  3345,  3346,  3347,  3348,  3351,
    3353,  3354,  3358,  3359,  3360,  3363,  3370,  3371,  3374,  3375,
    3378,  3379,  3380,  3383,  3384,  3387,  3388,  3389,  3390,  3393,
    3394,  3397,  3398,  3401,  3402,  3405,  3406,  3407,  3408,  3410,
    3411,  3417,  3423,  3429,  3435,  3436,  3452,  3453,  3457,  3458,
    3462,  3470,  3474,  3475,  3478,  3479,  3483,  3492,  3496,  3497,
    3500,  3510,  3511,  3515,  3516,  3519,  3520,  3523,  3524,  3525,
    3526,  3535,  3536,  3539,  3540,  3543,  3544,  3545,  3554,  3556,
    3558,  3563,  3562,  3574,  3575,  3578,  3579,  3583,  3584,  3587,
    3588,  3591,  3592,  3593,  3594,  3595,  3598,  3599,  3600,  3601,
    3602,  3605,  3606,  3607,  3619,  3620,  3623,  3624,  3627,  3628,
    3632,  3633,  3634,  3637,  3638,  3639,  3640,  3653,  3654,  3655,
    3658,  3659,  3663,  3664,  3667,  3668,  3671,  3676,  3681,  3686,
    3691,  3696,  3701,  3706,  3712,  3718,  3723,  3728,  3739,  3740,
    3743,  3744,  3755,  3756,  3759,  3760,  3763,  3764,  3772,  3771,
    3798,  3797,  3811,  3810,  3829,  3828,  3848,  3846,  3866,  3867,
    3869,  3870,  3871,  3872,  3873,  3876,  3884,  3885,  3889,  3894,
    3893,  3901,  3910,  3900,  3922,  3929,  3933,  3940,  3947,  3953,
    3959,  3965,  3972,  3990,  4011,  4016,  4020,  4027,  4028,  4031,
    4032,  4036,  4037,  4038,  4042,  4043,  4044,  4047,  4048,  4049,
    4050,  4058,  4057,  4068,  4076,  4075,  4085,  4095,  4104,  4105,
    4112,  4112,  4118,  4119,  4123,  4124,  4125,  4129,  4130,  4147,
    4148,  4153,  4152,  4163,  4162,  4173,  4172,  4182,  4183,  4184,
    4189,  4188,  4200,  4201,  4204,  4205,  4208,  4209,  4210,  4214,
    4213,  4226,  4225,  4242,  4243,  4246,  4247,  4250,  4251,  4252,
    4253,  4254,  4255,  4259,  4258,  4270,  4271,  4272,  4277,  4276,
    4282,  4289,  4294,  4302,  4303,  4306,  4318,  4327,  4328,  4331,
    4344,  4345,  4350,  4349,  4359,  4360,  4363,  4376,  4376,  4386,
    4387,  4396,  4397,  4406,  4415,  4417,  4420,  4450,  4454,  4453,
    4475,  4483,  4475,  4489,  4490,  4491,  4492,  4493,  4496,  4503,
    4510,  4512,  4523,  4524,  4527,  4528,  4534,  4535,  4536,  4537,
    4543,  4549,  4555,  4569,  4572,  4574,  4580,  4590,  4591,  4592,
    4605,  4631,  4638,  4645,  4646,  4649,  4650,  4651,  4652,  4653,
    4657,  4658,  4662,  4711,  4716,  4757,  4759,  4761,  4763,  4765,
    4767,  4769,  4771,  4775,  4777,  4779,  4781,  4783,  4785,  4788,
    4792,  4798,  4802,  4808,  4812,  4822,  4824,  4830,  4833,  4835,
    4837,  4838,  4840,  4843,  4845,  4847,  4849,  4851,  4853,  4855,
    4857,  4859,  4861,  4863,  4865,  4867,  4869,  4871,  4874,  4874,
    4875,  4875,  4876,  4876,  4877,  4877,  4879,  4880,  4881,  4882,
    4883,  4884,  4887,  4888,  4892,  4897,  4898,  4905,  4906,  4907,
    4908,  4909,  4911,  4912,  4913,  4914,  4915,  4919,  4920,  4925,
    4930,  4934,  4935,  4939,  4940,  4944,  4951,  4953,  4959,  4961,
    4972,  4974,  4985,  4996,  5007,  5018,  5020,  5022,  5024,  5026,
    5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,  5048,  5050,
    5052,  5057,  5062,  5064,  5066,  5071,  5073,  5075,  5077,  5079,
    5084,  5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,  5101,
    5103,  5105,  5107,  5111,  5113,  5123,  5125,  5127,  5129,  5131,
    5134,  5143,  5148,  5153,  5155,  5157,  5159,  5161,  5163,  5165,
    5167,  5172,  5177,  5179,  5181,  5183,  5185,  5187,  5189,  5195,
    5197,  5199,  5201,  5203,  5205,  5207,  5209,  5211,  5212,  5218,
    5223,  5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,  5246,
    5253,  5255,  5257,  5259,  5261,  5263,  5265,  5267,  5269,  5271,
    5273,  5275,  5277,  5279,  5281,  5296,  5295,  5435,  5439,  5444,
    5446,  5448,  5450,  5452,  5454,  5459,  5461,  5463,  5465,  5467,
    5472,  5476,  5478,  5480,  5482,  5484,  5486,  5490,  5493,  5496,
    5498,  5500,  5502,  5504,  5506,  5508,  5511,  5514,  5516,  5518,
    5520,  5522,  5524,  5527,  5529,  5531,  5533,  5538,  5539,  5540,
    5544,  5545,  5549,  5549,  5555,  5559,  5566,  5597,  5599,  5601,
    5603,  5605,  5607,  5609,  5612,  5614,  5611,  5617,  5619,  5626,
    5628,  5630,  5632,  5634,  5636,  5638,  5640,  5642,  5645,  5644,
    5659,  5658,  5673,  5679,  5685,  5698,  5699,  5703,  5706,  5711,
    5714,  5726,  5725,  5741,  5742,  5743,  5744,  5745,  5746,  5747,
    5748,  5749,  5750,  5751,  5755,  5756,  5760,  5760,  5765,  5766,
    5769,  5770,  5773,  5773,  5778,  5779,  5782,  5783,  5786,  5787,
    5790,  5796,  5806,  5807,  5816,  5821,  5822,  5842,  5844,  5848,
    5846,  5863,  5861,  5879,  5877,  5884,  5893,  5891,  5909,  5908,
    5918,  5929,  5927,  5946,  5945,  5956,  5966,  5967,  5968,  5973,
    5973,  5992,  5990,  6009,  6031,  6079,  6078,  6101,  6119,  6101,
    6126,  6130,  6156,  6157,  6159,  6161,  6164,  6165,  6171,  6178,
    6187,  6186,  6193,  6194,  6198,  6202,  6206,  6212,  6220,  6229,
    6230,  6231,  6232,  6233,  6234,  6235,  6236,  6237,  6238,  6239,
    6240,  6243,  6244,  6263,  6264,  6265,  6266,  6267,  6268,  6269,
    6270,  6271,  6275,  6276,  6277,  6278,  6281,  6283,  6284,  6287,
    6288,  6291,  6293,  6297,  6299,  6298,  6312,  6315,  6314,  6329,
    6335,  6348,  6350,  6353,  6355,  6359,  6360,  6373,  6391,  6395,
    6396,  6400,  6413,  6415,  6419,  6418,  6451,  6453,  6457,  6458,
    6459,  6464,  6470,  6474,  6475,  6479,  6483,  6490,  6497,  6506,
    6510,  6511,  6512,  6517,  6521,  6529,  6530,  6531,  6532,  6533,
    6534,  6538,  6539,  6540,  6541,  6542,  6545,  6548,  6547,  6576,
    6577,  6580,  6581,  6584,  6599,  6599,  6610,  6611,  6615,  6627,
    6660,  6659,  6672,  6671,  6680,  6692,  6703,  6702,  6719,  6726,
    6726,  6738,  6745,  6761,  6780,  6792,  6796,  6802,  6812,  6813,
    6816,  6824,  6825,  6829,  6830,  6838,  6847,  6837,  6857,  6864,
    6856,  6874,  6886,  6887,  6888,  6892,  6893,  6896,  6897,  6900,
    6909,  6910,  6911,  6913,  6912,  6922,  6923,  6926,  6927,  6928,
    6928,  6929,  6929,  6933,  6934,  6937,  6939,  6942,  6950,  6951,
    6955,  6956,  6961,  6960,  6973,  6974,  6977,  6982,  6990,  6991,
    6994,  6996,  6996,  7004,  7013,  7003,  7035,  7036,  7039,  7046,
    7047,  7050,  7059,  7060,  7066,  7065,  7079,  7078,  7087,  7086,
    7094,  7093,  7103,  7104,  7107,  7114,  7127,  7128,  7132,  7133,
    7136,  7137,  7138,  7141,  7151,  7153,  7155,  7157,  7160,  7161,
    7164,  7168,  7172,  7176,  7180,  7184,  7188,  7192,  7196,  7204,
    7207,  7216,  7215,  7229,  7237,  7246,  7255,  7264,  7274,  7273,
    7276,  7286,  7296,  7300,  7305,  7304,  7309,  7319,  7324,  7330,
    7335,  7340,  7342,  7344,  7346,  7348,  7350,  7358,  7367,  7369,
    7371,  7373,  7382,  7390,  7398,  7400,  7402,  7412,  7419,  7425,
    7433,  7441,  7445,  7449,  7456,  7463,  7473,  7483,  7493,  7504,
    7513,  7527,  7540,  7541,  7543,  7545,  7548,  7549,  7552,  7553,
    7556,  7557,  7560,  7561,  7564,  7565,  7567,  7569,  7572,  7584,
    7583,  7598,  7597,  7607,  7608,  7611,  7612,  7616,  7617,  7618,
    7626,  7625,  7637,  7638,  7641,  7641,  7642,  7643,  7644,  7645,
    7646,  7647,  7648,  7649,  7650,  7651,  7654,  7655,  7659,  7658,
    7667,  7668,  7671,  7672,  7673,  7677,  7676,  7686,  7690,  7694,
    7706,  7706,  7714,  7715,  7716,  7721,  7731,  7730,  7746,  7764,
    7775,  7782,  7792,  7763,  7797,  7806,  7807,  7810,  7811,  7823,
    7827,  7828,  7829,  7831,  7833,  7836,  7837,  7840,  7845,  7852,
    7857,  7863,  7865,  7868,  7869,  7872,  7877,  7883,  7885,  7892,
    7893,  7894,  7897,  7899,  7904,  7905,  7910,  7911,  7917,  7935,
    7943,  7948,  7967,  7969,  7980,  7993,  8014,  8015,  8016,  8025,
    8026,  8027,  8032,  8033,  8034,  8035,  8036,  8056,  8075,  8076,
    8077,  8080,  8081,  8082,  8083,  8091,  8106,  8107,  8110,  8116,
    8127,  8130,  8167,  8171,  8179,  8183,  8251,  8266,  8290,  8291,
    8307,  8317,  8320,  8321,  8322,  8326,  8330,  8331,  8356,  8368,
    8381,  8393,  8394,  8403,  8404,  8413,  8414,  8415,  8418,  8431,
    8444,  8458,  8459,  8460,  8461,  8462,  8463,  8464,  8465,  8466,
    8467,  8468,  8469,  8470,  8471,  8472,  8473,  8474,  8475,  8476,
    8477,  8478,  8479,  8480,  8481,  8482,  8483,  8484,  8485,  8486,
    8487,  8488,  8489,  8490,  8491,  8492,  8493,  8494,  8504,  8505,
    8506,  8507,  8508,  8509,  8510,  8511,  8512,  8513,  8514,  8515,
    8516,  8517,  8518,  8519,  8520,  8521,  8522,  8523,  8524,  8525,
    8526,  8527,  8528,  8529,  8530,  8531,  8532,  8533,  8534,  8535,
    8536,  8537,  8538,  8539,  8540,  8541,  8542,  8543,  8544,  8545,
    8546,  8547,  8548,  8549,  8550,  8551,  8552,  8553,  8554,  8555,
    8556,  8557,  8558,  8559,  8560,  8561,  8562,  8563,  8564,  8565,
    8566,  8567,  8568,  8569,  8570,  8571,  8572,  8573,  8574,  8575,
    8576,  8577,  8578,  8579,  8580,  8581,  8582,  8583,  8584,  8585,
    8586,  8587,  8588,  8589,  8590,  8591,  8592,  8593,  8594,  8595,
    8596,  8597,  8598,  8599,  8600,  8601,  8602,  8603,  8604,  8605,
    8606,  8607,  8608,  8609,  8610,  8611,  8612,  8613,  8614,  8615,
    8616,  8617,  8618,  8619,  8620,  8621,  8622,  8623,  8624,  8625,
    8626,  8627,  8628,  8629,  8630,  8631,  8632,  8633,  8634,  8635,
    8636,  8637,  8638,  8639,  8640,  8641,  8642,  8643,  8644,  8645,
    8646,  8647,  8648,  8649,  8650,  8651,  8652,  8653,  8654,  8655,
    8656,  8657,  8658,  8659,  8660,  8661,  8662,  8663,  8664,  8665,
    8666,  8667,  8668,  8669,  8670,  8671,  8672,  8673,  8674,  8675,
    8676,  8677,  8678,  8679,  8680,  8681,  8682,  8683,  8684,  8685,
    8686,  8687,  8688,  8689,  8690,  8691,  8692,  8693,  8694,  8695,
    8696,  8697,  8698,  8699,  8700,  8701,  8702,  8703,  8704,  8705,
    8706,  8707,  8708,  8709,  8710,  8711,  8712,  8713,  8714,  8715,
    8716,  8717,  8718,  8719,  8720,  8721,  8722,  8723,  8724,  8725,
    8726,  8727,  8728,  8729,  8730,  8731,  8732,  8733,  8734,  8735,
    8736,  8737,  8738,  8739,  8746,  8745,  8759,  8760,  8763,  8764,
    8767,  8767,  8845,  8846,  8847,  8848,  8852,  8853,  8857,  8858,
    8859,  8860,  8864,  8865,  8866,  8867,  8871,  8872,  8875,  8957,
    8970,  8974,  8979,  8986,  9001,  9014,  9035,  9042,  9080,  9123,
    9137,  9138,  9139,  9140,  9144,  9145,  9152,  9161,  9162,  9163,
    9164,  9165,  9173,  9172,  9188,  9189,  9192,  9193,  9196,  9204,
    9205,  9206,  9207,  9212,  9211,  9232,  9244,  9257,  9256,  9275,
    9276,  9280,  9281,  9285,  9286,  9287,  9288,  9290,  9289,  9300,
    9301,  9302,  9303,  9304,  9310,  9315,  9322,  9335,  9347,  9354,
    9359,  9367,  9380,  9394,  9396,  9399,  9400,  9407,  9409,  9413,
    9414,  9417,  9417,  9418,  9418,  9419,  9419,  9420,  9420,  9421,
    9422,  9423,  9424,  9425,  9426,  9427,  9428,  9429,  9430,  9431,
    9432,  9433,  9434,  9435,  9436,  9437,  9438,  9439,  9440,  9441,
    9442,  9443,  9448,  9449,  9453,  9454,  9458,  9468,  9478,  9491,
    9505,  9518,  9531,  9544,  9545,  9554,  9555,  9564,  9589,  9591,
    9598,  9602,  9605,  9606,  9609,  9630,  9631,  9635,  9639,  9643,
    9650,  9651,  9654,  9655,  9659,  9660,  9666,  9672,  9678,  9688,
    9687,  9697,  9698,  9702,  9703,  9704,  9708,  9709,  9710,  9714,
    9715,  9719,  9729,  9736,  9746,  9755,  9769,  9770,  9775,  9774,
    9815,  9816,  9817,  9821,  9821,  9845,  9846,  9850,  9851,  9852,
    9856,  9861,  9866,  9873,  9894,  9916,  9918,  9920,  9925,  9926,
    9927,  9928,  9932,  9933,  9934,  9935,  9936,  9946,  9947,  9952,
    9965,  9978,  9980,  9982,  9987,  9992,  9994,  9996, 10002, 10003,
   10009, 10010, 10012, 10018, 10017, 10032, 10033, 10037, 10042, 10050,
   10050, 10068, 10077, 10090, 10091, 10093, 10095, 10108, 10106, 10172,
   10183, 10201, 10228, 10236, 10244, 10256, 10197, 10286, 10310, 10319,
   10328, 10285, 10349, 10353, 10357, 10361, 10365, 10369, 10375, 10382,
   10389, 10398, 10399, 10403, 10404, 10405, 10409, 10410, 10414, 10415,
   10415, 10420, 10421
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENNA_DELIMITED_SYM", "SENNA_KWIC_SYM", "SENNA_MECAB_SYM",
  "SENNA_NGRAM_SYM", "SENNA_NORMALIZE_SYM", "SENNA_SECTIONALIZE_SYM",
  "SENNA_SPLIT_ALPHA_SYM", "SENNA_SPLIT_DIGIT_SYM",
  "SENNA_SPLIT_SYMBOL_SYM", "SENNA_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM",
  "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SMALLINT", "SNAPSHOT_SYM",
  "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'",
  "$accept", "query", "@1", "opt_end_of_input", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "@2", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "@3", "change", "@4", "master_defs", "master_def", "master_file_def",
  "create", "@5", "@6", "@7", "@8", "clear_privileges", "sp_name",
  "sp_a_chistics", "sp_c_chistics", "sp_chistic", "sp_c_chistic",
  "sp_suid", "call", "@9", "opt_sp_cparam_list", "opt_sp_cparams",
  "sp_cparams", "sp_fdparam_list", "sp_fdparams", "sp_init_param",
  "sp_fdparam", "sp_pdparam_list", "sp_pdparams", "sp_pdparam",
  "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1", "sp_decls", "sp_decl",
  "@10", "@11", "sp_cursor_stmt", "@12", "sp_handler_type",
  "sp_hcond_list", "sp_hcond_element", "sp_cond", "opt_value", "sp_hcond",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "@13", "@14", "@15",
  "@16", "@17", "sp_opt_fetch_noise", "sp_fetch_list", "sp_if", "@18",
  "@19", "@20", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "@21", "@22", "searched_case_stmt", "@23",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "@24", "@25", "searched_when_clause", "@26", "@27",
  "else_clause_opt", "sp_labeled_control", "@28", "sp_opt_label",
  "sp_labeled_block", "@29", "sp_unlabeled_block", "@30",
  "sp_block_content", "@31", "sp_unlabeled_control", "@32", "@33", "@34",
  "trg_action_time", "trg_event", "create2", "create2a", "@35", "create3",
  "@36", "@37", "create_select", "@38", "@39", "opt_as",
  "opt_create_database_options", "create_database_options",
  "create_database_option", "opt_table_options", "table_options",
  "table_option", "opt_if_not_exists", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "default_charset", "default_collation",
  "storage_engines", "row_types", "raid_types", "merge_insert_types",
  "opt_select_from", "udf_type", "field_list", "field_list_item",
  "column_def", "key_def", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "@40", "type", "@41",
  "@42", "spatial_type", "char", "nchar", "varchar", "nvarchar",
  "int_type", "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "opt_field_length", "field_length",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@43", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "opt_senna_list", "opt_senna_item", "key_list",
  "key_part", "opt_ident", "opt_component", "string_list", "alter", "@44",
  "@45", "@46", "@47", "@48", "ident_or_empty", "alter_list", "add_column",
  "alter_list_item", "@49", "@50", "@51", "opt_column", "opt_ignore",
  "opt_restrict", "opt_place", "opt_to", "slave", "@52", "@53", "start",
  "start_transaction_opts", "slave_thread_opts", "@54",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@55", "backup", "@56", "checksum", "@57",
  "opt_checksum_type", "repair", "@58", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@59", "check", "@60",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@61", "opt_no_write_to_binlog", "rename", "@62", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@63", "preload_list",
  "preload_keys", "cache_keys_spec", "@64", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@65", "select_part2", "@66", "@67", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "interval_expr", "simple_expr", "@68",
  "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@69", "udf_expr_list3", "udf_expr", "sum_expr", "@70",
  "@71", "@72", "variable", "@73", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@74",
  "cast_type", "opt_expr_list", "expr_list", "@75", "expr_list2",
  "ident_list_arg", "ident_list", "@76", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@77", "@78", "@79", "@80", "@81",
  "@82", "@83", "normal_join", "table_factor", "@84", "@85",
  "select_derived", "@86", "select_derived2", "@87", "@88",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@89", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_stamp",
  "interval_time_st", "date_time_type", "table_alias", "opt_table_alias",
  "opt_all", "where_clause", "@90", "having_clause", "@91", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@92", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@93", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@94",
  "select_var_list", "select_var_ident", "into", "@95", "into_destination",
  "@96", "do", "@97", "drop", "@98", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@99", "@100", "replace", "@101",
  "@102", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@103", "fields", "insert_values",
  "@104", "@105", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@106", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@107", "update", "@108", "@109",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@110", "single_multi", "@111", "@112",
  "@113", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@114", "show_param", "@115", "@116", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@117", "@118",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@119", "flush_options", "flush_option", "@120",
  "opt_table_list", "reset", "@121", "reset_options", "reset_option",
  "purge", "@122", "purge_options", "purge_option", "kill", "@123",
  "kill_option", "use", "load", "@124", "load_data", "@125", "@126",
  "@127", "@128", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@129", "opt_option", "option_value_list", "option_type_value",
  "@130", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@131",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@132", "handler", "@133", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@134",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@135", "@136", "@137",
  "@138", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@139", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@140",
  "union_opt", "union_order_or_limit", "@141", "order_or_limit",
  "union_option", "take_first_select", "subselect", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "definer_tail",
  "no_definer_tail", "definer_opt", "no_definer", "definer",
  "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@142", "view_list_opt",
  "view_list", "view_select", "@143", "view_select_aux",
  "view_check_option", "trigger_tail", "@144", "udf_tail", "sf_tail",
  "@145", "@146", "@147", "@148", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "xa", "xid", "begin_or_start", "opt_join_or_resume",
  "opt_one_phase", "opt_suspend", "@154", "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   124,    38,    45,    43,    42,    47,    37,
      94,   126,   828,    40,    41,    44,    33,   123,   125,    59,
      64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   593,   594,   595,   594,   594,   596,   596,   597,   597,
     598,   598,   598,   598,   598,   598,   598,   598,   598,   598,
     598,   598,   598,   598,   598,   598,   598,   598,   598,   598,
     598,   598,   598,   598,   598,   598,   598,   598,   598,   598,
     598,   598,   598,   598,   598,   598,   598,   598,   598,   598,
     598,   598,   598,   598,   598,   598,   598,   599,   600,   600,
     601,   602,   602,   604,   603,   605,   605,   606,   606,   607,
     609,   608,   611,   610,   612,   612,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   613,   614,   614,
     614,   614,   616,   615,   617,   615,   618,   615,   619,   615,
     615,   620,   621,   621,   622,   622,   623,   623,   624,   624,
     624,   624,   624,   624,   624,   625,   625,   625,   626,   626,
     628,   627,   629,   629,   630,   630,   631,   631,   632,   632,
     633,   633,   634,   635,   636,   636,   637,   637,   638,   639,
     639,   639,   639,   640,   640,   641,   641,   642,   642,   644,
     643,   643,   645,   643,   643,   647,   646,   648,   648,   649,
     649,   650,   651,   651,   652,   652,   653,   653,   653,   653,
     653,   654,   654,   655,   655,   657,   656,   658,   656,   659,
     656,   656,   656,   660,   656,   656,   656,   656,   656,   656,
     661,   656,   656,   662,   662,   662,   663,   663,   665,   666,
     667,   664,   668,   668,   668,   669,   669,   671,   672,   670,
     674,   673,   675,   675,   676,   676,   678,   679,   677,   681,
     682,   680,   683,   683,   685,   684,   686,   686,   688,   687,
     690,   689,   692,   691,   693,   694,   695,   693,   696,   693,
     697,   697,   698,   698,   698,   699,   699,   699,   699,   700,
     701,   700,   702,   703,   702,   704,   702,   706,   707,   705,
     708,   708,   709,   709,   710,   710,   711,   711,   712,   712,
     713,   713,   714,   715,   715,   716,   716,   717,   717,   718,
     718,   718,   719,   719,   719,   719,   719,   719,   719,   719,
     719,   719,   719,   719,   719,   719,   719,   719,   719,   719,
     719,   719,   719,   719,   719,   720,   721,   722,   723,   723,
     723,   723,   723,   723,   724,   724,   724,   725,   725,   725,
     726,   726,   727,   727,   727,   727,   728,   728,   729,   729,
     730,   730,   731,   731,   731,   731,   731,   732,   732,   733,
     734,   734,   735,   737,   736,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     739,   738,   740,   738,   738,   738,   741,   741,   741,   741,
     741,   741,   741,   741,   742,   743,   743,   744,   744,   745,
     745,   745,   745,   745,   746,   746,   746,   746,   746,   747,
     747,   747,   748,   748,   748,   749,   750,   750,   751,   751,
     752,   752,   752,   753,   753,   754,   754,   754,   754,   755,
     755,   756,   756,   757,   757,   758,   758,   758,   758,   758,
     758,   758,   758,   758,   758,   758,   759,   759,   760,   760,
     761,   761,   762,   762,   763,   763,   764,   764,   765,   765,
     766,   767,   767,   768,   768,   769,   769,   770,   770,   770,
     770,   770,   770,   771,   771,   772,   772,   772,   772,   773,
     773,   775,   774,   776,   776,   777,   777,   778,   778,   779,
     779,   780,   780,   780,   780,   780,   781,   781,   781,   781,
     781,   782,   782,   782,   783,   783,   784,   784,   785,   785,
     786,   786,   786,   787,   787,   787,   787,   788,   788,   788,
     789,   789,   789,   789,   790,   790,   791,   791,   791,   791,
     791,   791,   791,   791,   791,   791,   791,   791,   792,   792,
     793,   793,   794,   794,   795,   795,   796,   796,   798,   797,
     799,   797,   800,   797,   801,   797,   802,   797,   803,   803,
     804,   804,   804,   804,   804,   805,   806,   806,   806,   807,
     806,   808,   809,   806,   806,   806,   806,   806,   806,   806,
     806,   806,   806,   806,   806,   806,   806,   810,   810,   811,
     811,   812,   812,   812,   813,   813,   813,   814,   814,   814,
     814,   816,   815,   815,   817,   815,   815,   818,   819,   819,
     821,   820,   822,   822,   823,   823,   823,   824,   824,   825,
     825,   827,   826,   829,   828,   831,   830,   832,   832,   832,
     834,   833,   835,   835,   836,   836,   837,   837,   837,   839,
     838,   841,   840,   842,   842,   843,   843,   844,   844,   844,
     844,   844,   844,   846,   845,   847,   847,   847,   849,   848,
     848,   850,   850,   851,   851,   852,   853,   854,   854,   855,
     856,   856,   858,   857,   859,   859,   860,   862,   861,   863,
     863,   864,   864,   865,   866,   866,   867,   867,   869,   868,
     871,   872,   870,   873,   873,   873,   873,   873,   874,   874,
     875,   875,   876,   876,   877,   877,   877,   877,   877,   877,
     877,   877,   877,   877,   878,   878,   878,   879,   879,   879,
     880,   881,   882,   883,   883,   884,   884,   884,   884,   884,
     885,   885,   886,   886,   886,   886,   886,   886,   886,   886,
     886,   886,   886,   887,   887,   887,   887,   887,   887,   888,
     888,   888,   888,   888,   888,   888,   888,   888,   888,   888,
     888,   888,   888,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   890,   890,
     891,   891,   892,   892,   893,   893,   894,   894,   894,   894,
     894,   894,   895,   895,   896,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   898,   897,   897,   897,   897,
     897,   897,   897,   897,   897,   897,   897,   897,   897,   897,
     897,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   899,   899,   899,
     899,   899,   899,   899,   899,   899,   899,   900,   900,   900,
     901,   901,   903,   902,   904,   904,   905,   906,   906,   906,
     906,   906,   906,   906,   907,   908,   906,   906,   906,   906,
     906,   906,   906,   906,   906,   906,   906,   906,   909,   906,
     911,   910,   912,   912,   912,   913,   913,   914,   914,   915,
     915,   917,   916,   918,   918,   918,   918,   918,   918,   918,
     918,   918,   918,   918,   919,   919,   921,   920,   922,   922,
     923,   923,   925,   924,   926,   926,   927,   927,   928,   928,
     929,   929,   930,   930,   931,   932,   932,   933,   933,   934,
     933,   935,   933,   936,   933,   933,   937,   933,   938,   933,
     933,   939,   933,   940,   933,   933,   941,   941,   941,   943,
     942,   944,   942,   942,   942,   946,   945,   948,   949,   947,
     950,   951,   952,   952,   953,   953,   954,   954,   954,   954,
     956,   955,   957,   957,   958,   958,   958,   959,   959,   960,
     960,   960,   960,   960,   960,   960,   960,   960,   960,   960,
     960,   961,   961,   962,   962,   962,   962,   962,   962,   962,
     962,   962,   963,   963,   963,   963,   964,   964,   964,   965,
     965,   966,   966,   967,   968,   967,   969,   970,   969,   971,
     971,   972,   972,   973,   973,   974,   974,   974,   975,   976,
     976,   977,   978,   978,   980,   979,   981,   981,   982,   982,
     982,   983,   983,   984,   984,   985,   986,   986,   986,   987,
     987,   987,   987,   988,   988,   989,   989,   989,   989,   989,
     989,   990,   990,   990,   990,   990,   991,   992,   991,   993,
     993,   994,   994,   995,   997,   996,   998,   998,   999,   999,
    1001,  1000,  1003,  1002,  1002,  1002,  1005,  1004,  1006,  1007,
    1006,  1006,  1006,  1006,  1006,  1006,  1006,  1006,  1008,  1008,
    1009,  1010,  1010,  1011,  1011,  1013,  1014,  1012,  1016,  1017,
    1015,  1018,  1018,  1018,  1018,  1019,  1019,  1020,  1020,  1021,
    1022,  1022,  1022,  1023,  1022,  1024,  1024,  1025,  1025,  1026,
    1025,  1027,  1025,  1028,  1028,  1029,  1029,  1030,  1031,  1031,
    1032,  1032,  1034,  1033,  1035,  1035,  1036,  1036,  1037,  1037,
    1038,  1039,  1038,  1041,  1042,  1040,  1043,  1043,  1044,  1045,
    1045,  1046,  1047,  1047,  1049,  1048,  1051,  1050,  1052,  1050,
    1053,  1050,  1054,  1054,  1055,  1055,  1056,  1056,  1057,  1057,
    1058,  1058,  1058,  1059,  1060,  1060,  1061,  1061,  1062,  1062,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1064,
    1064,  1066,  1065,  1067,  1067,  1067,  1067,  1067,  1068,  1067,
    1067,  1067,  1067,  1067,  1069,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1070,  1070,  1071,  1071,  1072,  1072,  1073,  1073,  1074,  1074,
    1075,  1075,  1076,  1076,  1077,  1077,  1078,  1078,  1078,  1080,
    1079,  1081,  1079,  1082,  1082,  1083,  1083,  1084,  1084,  1084,
    1086,  1085,  1087,  1087,  1089,  1088,  1088,  1088,  1088,  1088,
    1088,  1088,  1088,  1088,  1088,  1088,  1090,  1090,  1092,  1091,
    1093,  1093,  1094,  1094,  1094,  1096,  1095,  1097,  1098,  1098,
    1100,  1099,  1101,  1101,  1101,  1102,  1104,  1103,  1103,  1106,
    1107,  1108,  1109,  1105,  1105,  1110,  1110,  1111,  1111,  1111,
    1112,  1112,  1112,  1113,  1113,  1114,  1114,  1115,  1115,  1115,
    1115,  1116,  1116,  1117,  1117,  1118,  1118,  1119,  1119,  1120,
    1120,  1120,  1121,  1121,  1122,  1122,  1123,  1123,  1124,  1124,
    1124,  1124,  1125,  1125,  1125,  1126,  1127,  1127,  1127,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,
    1128,  1129,  1129,  1129,  1129,  1129,  1130,  1130,  1131,  1131,
    1132,  1133,  1133,  1134,  1134,  1135,  1135,  1135,  1136,  1136,
    1136,  1136,  1137,  1137,  1137,  1138,  1139,  1139,  1140,  1141,
    1142,  1143,  1143,  1144,  1144,  1145,  1145,  1145,  1146,  1146,
    1146,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,
    1147,  1147,  1147,  1147,  1147,  1147,  1147,  1147,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1150,  1149,  1151,  1151,  1152,  1152,
    1154,  1153,  1155,  1155,  1155,  1155,  1156,  1156,  1157,  1157,
    1157,  1157,  1158,  1158,  1158,  1158,  1159,  1159,  1160,  1160,
    1161,  1161,  1161,  1161,  1161,  1161,  1161,  1162,  1162,  1162,
    1163,  1163,  1163,  1163,  1164,  1164,  1164,  1165,  1165,  1165,
    1165,  1165,  1167,  1166,  1168,  1168,  1169,  1169,  1170,  1171,
    1171,  1171,  1171,  1173,  1172,  1174,  1174,  1175,  1174,  1176,
    1176,  1177,  1177,  1178,  1178,  1178,  1178,  1179,  1178,  1180,
    1180,  1180,  1180,  1180,  1181,  1182,  1182,  1182,  1182,  1183,
    1184,  1184,  1184,  1185,  1185,  1186,  1186,  1187,  1187,  1188,
    1188,  1190,  1189,  1191,  1189,  1192,  1189,  1193,  1189,  1189,
    1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,
    1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,
    1189,  1189,  1194,  1194,  1195,  1195,  1196,  1196,  1196,  1197,
    1197,  1197,  1197,  1198,  1198,  1199,  1199,  1200,  1200,  1200,
    1201,  1201,  1202,  1202,  1203,  1204,  1204,  1204,  1204,  1204,
    1205,  1205,  1206,  1206,  1207,  1207,  1207,  1207,  1207,  1209,
    1208,  1210,  1210,  1211,  1211,  1211,  1212,  1212,  1212,  1213,
    1213,  1214,  1215,  1215,  1216,  1217,  1218,  1218,  1220,  1219,
    1221,  1221,  1221,  1223,  1222,  1224,  1224,  1225,  1225,  1225,
    1226,  1227,  1227,  1228,  1229,  1230,  1230,  1230,  1231,  1231,
    1231,  1231,  1232,  1232,  1232,  1232,  1232,  1233,  1233,  1234,
    1235,  1236,  1236,  1236,  1237,  1238,  1238,  1238,  1239,  1239,
    1240,  1240,  1240,  1242,  1241,  1243,  1243,  1244,  1244,  1246,
    1245,  1247,  1247,  1248,  1248,  1248,  1248,  1250,  1249,  1251,
    1251,  1253,  1254,  1255,  1256,  1257,  1252,  1259,  1260,  1261,
    1262,  1258,  1263,  1263,  1263,  1263,  1263,  1263,  1264,  1264,
    1264,  1265,  1265,  1266,  1266,  1266,  1267,  1267,  1268,  1269,
    1268,  1270,  1270
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       4,     1,     2,     0,     4,     0,     2,     3,     1,     2,
       0,     3,     0,     5,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     1,     3,     3,
       3,     3,     0,     7,     0,    11,     0,     6,     0,     3,
       4,     0,     3,     1,     0,     2,     0,     2,     2,     2,
       2,     2,     3,     3,     1,     1,     1,     2,     3,     3,
       0,     4,     0,     3,     0,     1,     3,     1,     0,     1,
       3,     1,     0,     3,     0,     1,     3,     1,     4,     0,
       1,     1,     1,     0,     3,     2,     3,     0,     3,     0,
       5,     5,     0,     7,     5,     0,     2,     1,     1,     1,
       3,     1,     1,     3,     0,     1,     1,     1,     1,     2,
       1,     1,     3,     0,     2,     0,     2,     0,     3,     0,
       5,     1,     1,     0,     2,     1,     1,     2,     2,     2,
       0,     6,     2,     0,     2,     1,     1,     3,     0,     0,
       0,     7,     0,     2,     2,     1,     1,     0,     0,     8,
       0,     6,     1,     2,     1,     2,     0,     0,     6,     0,
       0,     6,     0,     2,     0,     5,     0,     1,     0,     5,
       0,     2,     0,     5,     4,     0,     0,     8,     0,     7,
       1,     1,     1,     1,     1,     2,     2,     2,     4,     4,
       0,     4,     0,     0,     5,     0,     7,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     0,     1,     1,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     1,
       1,     3,     4,     4,     3,     4,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     3,     1,     1,
       2,     2,     7,     8,     8,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     4,     3,     3,     3,     1,     2,
       1,     1,     3,     2,     3,     2,     2,     1,     3,     3,
       2,     3,     1,     1,     2,     1,     1,     2,     1,     1,
       1,     2,     3,     2,     3,     2,     2,     3,     3,     3,
       0,     6,     0,     6,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     2,
       1,     2,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     1,     1,     5,     0,     1,     2,     1,
       1,     1,     1,     0,     1,     3,     3,     3,     3,     0,
       1,     0,     1,     2,     1,     1,     2,     2,     4,     1,
       3,     2,     1,     2,     2,     2,     2,     1,     2,     1,
       1,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     0,     2,     1,     1,     0,     1,     0,     2,     1,
       2,     3,     2,     0,     1,     0,     1,     1,     2,     0,
       1,     0,     4,     1,     4,     3,     1,     0,     1,     2,
       1,     3,     3,     2,     2,     2,     1,     1,     2,     2,
       2,     1,     2,     2,     2,     2,     1,     1,     0,     1,
       1,     1,     1,     0,     1,     1,     1,     0,     2,     2,
       1,     1,     1,     1,     1,     3,     1,     2,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     2,
       1,     4,     0,     1,     0,     2,     1,     3,     0,     6,
       0,     5,     0,     5,     0,     5,     0,    11,     0,     1,
       0,     2,     2,     1,     3,     2,     3,     2,     4,     0,
       6,     0,     0,     8,     4,     4,     3,     3,     2,     2,
       6,     5,     3,     5,     1,     1,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     2,     1,     0,     1,     1,
       1,     0,     5,     3,     0,     5,     3,     3,     0,     3,
       0,     2,     1,     3,     0,     1,     1,     0,     2,     1,
       3,     0,     6,     0,     6,     0,     5,     0,     1,     1,
       0,     6,     0,     1,     1,     2,     1,     1,     1,     0,
       5,     0,     5,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     0,     5,     0,     1,     1,     0,     4,
       4,     3,     5,     1,     3,     3,     5,     1,     3,     2,
       1,     1,     0,     6,     1,     3,     3,     0,     2,     0,
       4,     0,     2,     1,     2,     4,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     4,     3,     1,     1,
       4,     0,     0,     1,     1,     0,     2,     2,     1,     1,
       0,     2,     3,     3,     3,     2,     3,     4,     3,     4,
       3,     4,     1,     3,     4,     3,     3,     6,     1,     5,
       6,     5,     7,     6,     8,     5,     6,     4,     4,     5,
       3,     4,     1,     3,     3,     3,     3,     3,     3,     4,
       4,     3,     3,     3,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     3,     1,     1,     1,
       1,     3,     2,     2,     2,     2,     3,     3,     5,     6,
       4,     4,     7,     4,     2,     6,     5,     6,     6,     4,
       4,     3,     4,     6,     8,     6,     8,     6,     4,     6,
       4,     6,     4,     4,     4,     4,     6,     8,     2,     2,
       4,     2,     7,     7,     3,     4,     4,     6,     6,     4,
       6,     6,     6,     4,     6,     4,     6,     8,    10,    12,
       6,     4,     6,     6,     1,     6,     4,     8,    10,     4,
       1,     3,     4,     6,     6,     8,     6,     6,     4,     6,
       6,     8,     4,     4,     6,     4,     2,     4,     4,     4,
       6,     4,     4,     3,     8,     6,     4,     6,     3,     4,
       6,     8,     4,     8,     6,     8,     6,     8,     2,     4,
       4,     4,     6,     8,     8,     4,     7,     7,     7,     6,
       6,     6,     6,     6,     6,     0,     5,    10,     3,     4,
       3,     2,     2,     2,     4,     6,     4,     4,     6,     6,
       6,     6,     4,     6,     4,     6,     4,     4,     4,     4,
       6,     4,     6,     4,     6,     4,     4,     6,     4,     6,
       4,     6,     4,     4,     6,     4,     6,     0,     3,     3,
       0,     1,     0,     2,     1,     3,     4,     4,     5,     4,
       4,     4,     5,     4,     0,     0,     7,    10,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       1,     0,     3,     2,     3,     2,     1,     2,     1,     2,
       1,     1,     1,     2,     0,     1,     0,     2,     1,     3,
       1,     3,     0,     2,     1,     3,     0,     1,     0,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     3,     0,
       6,     0,     6,     0,     8,     4,     0,     8,     0,    10,
       6,     0,     8,     0,    10,     6,     1,     2,     2,     0,
       4,     0,    11,     3,     6,     0,     3,     0,     0,     5,
       0,     1,     0,     1,     0,     2,     0,     2,     2,     2,
       0,     6,     0,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     0,
       2,     0,     1,     0,     0,     3,     0,     0,     3,     2,
       0,     0,     4,     4,     2,     0,     2,     2,     3,     3,
       1,     2,     0,     1,     0,     4,     4,     2,     0,     1,
       1,     0,     1,     0,     1,     2,     1,     3,     3,     1,
       1,     1,     1,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     0,     6,     0,
       1,     3,     1,     2,     0,     2,     3,     1,     2,     1,
       0,     3,     0,     5,     2,     1,     0,     3,     6,     0,
       6,     4,     6,     4,     4,     4,     5,     4,     1,     3,
       1,     0,     2,     0,     1,     0,     0,     8,     0,     0,
       6,     0,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     3,     4,     0,     3,     3,     1,     2,     2,     0,
       3,     0,     5,     3,     1,     3,     1,     3,     1,     1,
       0,     1,     0,     4,     0,     1,     3,     1,     1,     1,
       0,     0,     6,     0,     0,    11,     3,     1,     3,     3,
       1,     3,     0,     1,     0,     4,     0,     6,     0,     5,
       0,     6,     1,     3,     3,     5,     0,     2,     0,     2,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     3,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     0,
       3,     0,     3,     2,     4,     4,     4,     4,     0,     4,
       6,    16,     2,     2,     0,     6,     5,     2,     2,     2,
       1,     5,     5,     2,     2,     1,     4,     3,     2,     2,
       2,     3,     2,     2,     2,     1,     1,     3,     4,     3,
       3,     2,     2,     3,     3,     3,     3,     3,     3,     4,
       1,     1,     1,     1,     0,     1,     0,     2,     0,     1,
       1,     1,     0,     2,     0,     2,     0,     2,     2,     0,
       4,     0,     4,     1,     1,     0,     1,     0,     1,     1,
       0,     4,     3,     1,     0,     3,     4,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     3,
       3,     1,     1,     1,     2,     0,     3,     3,     2,     2,
       0,     4,     0,     1,     1,     2,     0,     4,     5,     0,
       0,     0,     0,    18,     2,     0,     1,     0,     1,     1,
       0,     1,     1,     0,     2,     2,     1,     3,     4,     3,
       3,     0,     2,     2,     1,     3,     3,     0,     3,     0,
       3,     2,     3,     1,     1,     2,     0,     2,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     3,     5,
       1,     1,     1,     1,     1,     3,     4,     5,     1,     5,
       3,     2,     1,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     4,     0,     1,     1,     3,
       0,     2,     1,     1,     1,     1,     0,     1,     0,     1,
       1,     1,     0,     2,     2,     2,     1,     2,     4,     5,
       4,     6,     2,     3,     3,     3,     5,     1,     3,     3,
       2,     2,     2,     1,     1,     4,     4,     1,     1,     1,
       1,     1,     0,     4,     1,     1,     1,     3,     3,     1,
       1,     2,     2,     0,     3,     4,     3,     0,     7,     1,
       2,     1,     1,     1,     1,     1,     1,     0,     5,     1,
       1,     1,     1,     1,     3,     6,     6,     6,     7,     3,
       8,     8,     8,     0,     1,     1,     2,     0,     1,     1,
       3,     0,     3,     0,     3,     0,     3,     0,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     3,     2,     2,     2,     2,     2,     2,
       2,     2,     0,     1,     3,     1,     2,     2,     2,     1,
       3,     3,     1,     1,     3,     1,     3,     4,     5,     1,
       0,     3,     3,     1,     1,     0,     2,     2,     2,     2,
       0,     2,     2,     1,     2,     2,     2,     2,     2,     0,
       3,     0,     1,     0,     3,     2,     0,     1,     2,     0,
       1,     4,     4,     5,     2,     3,     0,     1,     0,     4,
       0,     1,     1,     0,     2,     2,     1,     0,     1,     1,
       0,     5,     6,     0,     0,     2,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     2,     1,     2,     3,     3,     3,     0,     1,
       0,     3,     3,     0,     8,     0,     3,     1,     3,     0,
       2,     3,     5,     0,     3,     4,     4,     0,    14,     8,
       7,     0,     0,     0,     0,     0,    15,     0,     0,     0,
       0,    12,     4,     4,     3,     4,     3,     2,     1,     3,
       5,     1,     1,     0,     1,     1,     0,     2,     0,     0,
       3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       0,     2,  2038,   655,     0,  1979,     0,     0,     0,     0,
       0,  1981,    98,    58,  1284,  1393,  1394,  1206,  1223,     0,
     655,   101,     0,    70,  1225,  1430,     0,     0,   655,     0,
    1425,     0,     0,   655,  1228,  1418,     0,   101,  1981,     0,
     690,  1816,  1321,     0,     0,     0,  1304,  1873,  1273,     0,
       0,     0,     0,     3,     8,    19,     0,    36,    24,    28,
      14,    18,    13,    10,    50,    51,    43,    12,    16,    40,
      11,    15,    33,    39,    34,    35,    47,   683,    22,    23,
      29,    41,    54,    20,    52,    49,    21,  1395,    25,    42,
      37,    30,    55,    31,    48,    32,    53,    27,    44,    26,
       9,    17,    45,    46,    38,    56,     0,   558,     0,   590,
       0,     0,  2039,  2029,   657,   656,     0,  1865,  1864,   623,
    1981,     0,  1578,  1579,  1580,  1581,  1582,  1583,  1584,  1542,
    1585,  1586,  1587,  1543,  1544,  1588,  1589,  1590,  1591,  1593,
    1592,  1594,  1545,  1546,  1595,  1596,  1597,  1547,  1548,  1598,
    1599,  1549,  1600,  1601,  1602,  1550,  1603,  1551,  1604,  1605,
    1606,  1607,  1608,  1552,  1609,  1610,  1611,  1612,  1613,  1614,
    1615,  1553,  1616,  1617,  1618,  1619,  1635,  1620,  1554,  1621,
    1622,  1623,  1636,  1555,  1626,  1625,  1624,  1627,  1628,  1629,
    1556,  1630,  1631,  1632,  1633,  1638,  1639,  1640,  1557,  1634,
    1641,  1637,  1799,  1643,  1642,  1644,  1646,  1645,  1558,  1647,
    1559,  1648,  1649,  1526,  1650,  1527,  1652,  1653,  1656,  1657,
    1651,  1658,  1659,  1654,  1655,  1560,  1661,  1662,  1663,  1664,
    1665,  1666,  1667,  1677,  1670,  1672,  1673,  1675,  1671,  1676,
    1680,  1679,  1681,  1682,  1683,  1678,  1669,  1674,  1684,  1685,
    1668,  1686,  1687,  1688,  1689,  1690,  1691,  1692,  1693,  1694,
    1696,  1695,  1697,  1698,  1699,  1700,  1701,  1703,  1702,  1704,
    1705,  1706,  1708,  1707,  1709,  1561,  1710,  1711,  1712,  1713,
    1714,  1562,  1715,  1716,  1717,  1718,  1719,  1720,  1721,  1563,
    1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,
    1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1660,  1740,
    1564,  1741,  1742,  1565,  1743,  1566,  1744,  1745,  1567,  1746,
    1747,  1748,  1749,  1750,  1751,  1568,  1752,  1569,  1753,  1754,
    1755,  1756,  1757,  1758,  1759,  1760,  1761,  1762,  1764,  1763,
    1765,  1767,  1768,  1570,  1766,  1571,  1769,  1770,  1771,  1773,
    1772,  1774,  1775,  1572,  1776,  1573,  1777,  1778,  1779,  1780,
    1781,  1782,  1783,  1784,  1785,  1786,  1787,  1788,  1789,  1792,
    1793,  1794,  1795,  1790,  1791,  1574,  1796,  1797,  1798,  1800,
    1801,  1575,  1802,  1803,  1577,  1804,  1805,  1808,  1806,  1807,
    1809,  1810,  1811,  1812,  1576,  1813,   120,  1531,   103,  1532,
    1541,     0,   625,   641,  1982,  1983,   273,   515,   516,   272,
     514,   101,  2029,     0,   269,   270,     0,  1298,  1026,  1221,
    1221,     0,  1221,  1224,  1221,   101,  1221,     0,    63,  1400,
       0,     0,     0,     0,  1525,     0,  1231,  1432,  1436,     0,
       0,  1862,     0,     0,     0,     0,   101,   658,     0,  1282,
       0,   621,     0,  1983,  1994,   684,   688,   700,  1817,  1814,
    1378,   610,   610,   610,   608,   610,  1305,     0,     0,  1282,
    1435,  2081,     0,     0,     0,  2077,     0,  2082,     0,   690,
       0,     0,     1,     5,     0,     0,  1631,  1391,  1389,  1522,
       0,   550,   559,   554,   552,     0,     0,  2040,  2027,  2028,
     639,     0,  1980,     0,   667,   677,   122,     0,    72,     0,
       0,     0,  1986,     0,     0,     0,     0,    99,   721,   721,
    2029,  2031,  2033,   273,   271,     0,  1302,  1301,  1300,     0,
    1298,  1207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1221,    65,     0,  1907,  1922,  1923,  1919,  1924,  1925,
    1929,     0,  1921,  1913,     0,  1928,  1917,  1926,     0,  1911,
       0,  1927,  1932,  1915,  1920,  1899,     0,  1905,  1909,  1524,
    1126,  1876,  1877,     0,  1537,  1528,  1536,  1535,    71,  1233,
    1234,  1232,   589,  1433,  1434,     0,  1447,     0,     0,     0,
     653,     0,  1373,  1372,     0,  1426,  1995,     0,     0,   630,
    1236,  1283,     0,  1235,  1423,     0,  1422,  1419,  1421,     0,
    1907,  1894,     0,  1989,  1986,  1996,   713,   706,   705,   708,
     709,   712,   710,   711,   707,   704,   721,   701,   703,  1820,
       0,     0,   449,     0,  1386,     0,     0,     0,  1386,     0,
    1161,  1379,     0,  1829,  1356,   512,   511,     0,   510,  1830,
    1355,  1372,     0,     0,     0,  1340,     0,  1306,  1345,     0,
    1831,     0,  1375,     0,  1161,  1386,     0,  1322,     0,     0,
       0,     0,   604,   614,   606,   601,     0,   607,   603,  1303,
    1220,  1874,   589,  1484,  1483,  1529,  2078,  1482,  2086,  2088,
    2074,  2076,  2083,   686,     0,  2000,     6,    57,     0,  1397,
    2036,  2037,  2035,   465,   104,   104,   548,     0,     0,     0,
       0,     0,  1218,     0,     0,   669,   679,   124,   121,   102,
       0,   627,   643,  1985,     0,     0,  1987,  1991,   783,   782,
       0,    96,   730,  1538,  1959,   100,  1955,  2034,   721,   721,
     721,     0,  2016,     0,  2022,  2023,  2026,  2025,  2024,     0,
    2015,  2018,  2019,  2021,  2020,  2040,  2032,     0,   517,     0,
    1285,  1288,  1292,  1296,  1299,  1579,  1542,     0,  1587,     0,
       0,  1495,     0,     0,     0,     0,  1547,     0,     0,  1601,
       0,     0,  1552,     0,     0,     0,   730,   730,   730,     0,
       0,     0,  1614,  1615,  1504,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1492,     0,  1505,     0,     0,
       0,     0,     0,     0,     0,  1643,     0,     0,  1644,     0,
       0,     0,  1494,  1649,     0,     0,     0,     0,     0,     0,
       0,  1664,     0,     0,  1502,     0,     0,  1032,     0,  1691,
    1693,     0,     0,     0,  1697,     0,     0,  1698,  1699,  1700,
    1479,   785,     0,   730,  1491,  1501,  1712,  1718,  1485,     0,
    1720,     0,  1721,     0,  1728,     0,     0,     0,     0,     0,
       0,  1750,  1752,  1754,     0,     0,  1779,     0,     0,     0,
     730,  1478,  1792,  1793,  1794,  1795,     0,  1493,  1574,  1503,
       0,     0,     0,  1804,   730,   730,   730,     0,     0,     0,
    1810,     0,  1813,  1036,     0,     0,     0,     0,   784,     0,
    1000,     0,  1028,   742,   748,   762,     0,   870,   777,   864,
     800,   799,  1027,  1489,   798,   797,  1490,   795,  1512,  1531,
    1511,  1222,  1211,  1213,     0,  1214,  1217,  1953,  1215,   591,
       0,     0,    64,  1414,  1408,  1410,  1413,  1409,     0,  1415,
    1412,  1411,  1865,  1401,  1403,  1404,  1908,  1906,  1940,  1939,
       0,  1941,  1937,  1930,  1960,  1934,  1960,  1936,  1935,  1960,
    1931,  1938,  1960,  1903,     0,  1127,  1128,     0,  1875,     0,
    1523,     0,  1431,  1448,     0,  1449,  1437,  1445,   672,     0,
    1126,  1863,  1866,     0,     0,    60,    61,     0,   660,     0,
     659,   663,     0,     0,     0,  1239,  1229,  1238,  1424,     0,
       0,  1906,  1903,  1990,     0,  1992,  2007,   689,  1997,   719,
     691,   718,     0,   702,  1815,  1818,  1826,  1354,  1382,   448,
       0,     0,  1353,  1337,     0,   273,     0,     0,     0,     0,
    1323,  1328,   307,     0,  1344,  1162,     0,  1386,     0,  1348,
    1361,  1349,     0,  1376,     0,  1386,  1318,     0,     0,  1310,
    1315,  1311,     0,  1317,  1316,  1319,  1307,  1308,  1376,  1333,
    1362,  1376,  1338,  1343,  1352,  1380,  1381,     0,  1332,  1339,
       0,  1350,  1376,  1376,  1386,  1386,   617,   616,   615,   611,
     612,   617,     0,  1069,     0,     0,  2075,  2089,  2073,  2084,
    2085,  2072,   687,  2001,   685,  2002,     0,     7,     4,  1392,
    1390,  1398,  1399,   466,   465,   264,   267,   266,     0,   555,
     553,   465,  2030,     0,     0,   640,     0,     0,   671,   666,
     670,   668,   507,   506,   509,     0,   678,     0,   125,   127,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,    87,   629,   628,
     626,   651,   650,   648,     0,   649,   647,   642,   644,   645,
    1984,  1988,   274,   465,     0,  1540,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2017,    92,     0,     0,     0,
    1290,  1286,  1296,     0,     0,     0,  1126,     0,     0,     0,
    1131,     0,   814,  1131,  1131,  1131,     0,     0,  1026,  1026,
       0,  1026,     0,     0,     0,     0,  1131,   838,   841,     0,
     839,     0,     0,     0,     0,     0,  1498,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1026,     0,     0,     0,
       0,  1005,     0,     0,     0,     0,   794,     0,     0,     0,
       0,  1026,     0,     0,     0,     0,  1032,     0,  1030,     0,
    1131,     0,     0,  1131,     0,     0,     0,     0,     0,  1026,
    1026,  1026,   735,     0,   886,     0,     0,     0,     0,     0,
    1026,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1026,  1131,  1131,     0,     0,     0,  1131,     0,   908,
       0,  1500,     0,     0,     0,  1499,     0,     0,  1497,  1496,
    1480,     0,     0,     0,   931,   933,   932,  1131,     0,  1131,
       0,     0,     0,  1037,     0,   803,   802,   804,  2013,     0,
       0,     0,     0,     0,     0,   781,   780,   779,   778,     0,
       0,     0,   786,     0,   787,   788,     0,   789,   790,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   805,
    1100,  1101,  1102,  1103,  1113,  1104,  1105,  1106,  1115,  1120,
    1107,  1108,  1116,  1117,  1118,  1109,  1119,  1114,  1110,  1121,
       0,  1099,     0,     0,     0,  1481,   925,     0,     0,  1209,
       0,   593,   592,  1216,   591,     0,    66,    68,  1407,     0,
       0,  1416,  1933,     0,  1914,  1918,  1912,  1916,     0,     0,
    1904,     0,  1910,  1130,  1639,  1707,     0,  1133,  1879,  1226,
    1444,  1446,     0,     0,  1438,     0,     0,   654,    62,     0,
       0,  1427,     0,     0,     0,     0,   632,  1237,     0,  1420,
       0,     0,     0,     0,     0,  1993,  2009,  2008,  1998,   721,
    1152,   722,   724,   723,  1511,  1820,  1823,  1824,  1827,  1825,
       0,  1822,  1821,  1836,     0,  1384,  1387,  1388,     0,     0,
    1364,  1363,  1359,  1360,     0,  1171,  1172,  1170,  1165,  1166,
    1169,  1368,  1366,  1357,     0,  1386,     0,  1367,  1365,  1312,
    1313,  1314,     0,  1161,     0,  1386,  1386,  1376,     0,  1386,
    1386,  1347,  1351,     0,   605,   614,   602,   609,  1081,  1080,
       0,  1045,     0,  1044,  1043,  1042,     0,  1080,  2079,  2087,
    2091,     0,  1161,  2006,  2004,   265,  1260,  1260,     0,     0,
       0,     0,     0,     0,     0,   105,   114,   587,   587,  1260,
    1260,   587,  1260,  1260,  1260,     0,     0,  1260,     0,     0,
     587,     0,  1260,   585,     0,     0,  1260,  1260,  1260,   587,
       0,  1260,  1260,  1260,  1260,  1260,   597,  1260,  1260,  1260,
     584,   277,   299,   300,   549,     0,   563,   586,  2041,  2042,
     556,   624,  1219,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   652,   646,    97,   465,   731,  1539,     0,  1956,
       0,  2067,     0,     0,   103,  2043,   275,   520,  1179,  1180,
     522,  1176,  1177,     0,  1175,   521,   533,   534,   535,   528,
     536,   530,   531,   532,   526,  1178,   519,   523,   524,   537,
     518,     0,     0,  1133,     0,  1293,  1069,  1297,  1296,  1294,
       0,     0,     0,  1132,  1131,     0,  1011,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   984,     0,  1011,     0,   844,     0,     0,     0,     0,
       0,     0,  1511,     0,     0,     0,     0,     0,  2013,     0,
       0,     0,     0,     0,     0,   821,     0,     0,     0,     0,
       0,     0,     0,  1124,  1122,  1125,  1123,     0,     0,  1006,
     998,     0,     0,     0,     0,   871,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1033,  1034,  1131,
       0,     0,     0,  1131,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   893,     0,     0,     0,     0,     0,   898,     0,
       0,     0,     0,     0,     0,     0,     0,  1131,     0,     0,
       0,  1112,     0,  1111,     0,     0,     0,     0,     0,     0,
       0,     0,   928,     0,   930,     0,     0,  1514,  1513,     0,
       0,     0,     0,     0,  1038,   690,     0,   807,  1026,   806,
       0,  1832,  1001,  1003,     0,   733,   732,   734,   745,   738,
     743,   736,   740,     0,   792,  1584,   746,     0,   774,     0,
    1140,   775,   760,   765,   766,     0,     0,   763,   764,   768,
     870,   767,   870,   771,   772,   773,   776,     0,     0,     0,
       0,     0,   796,   801,  1029,   972,  1515,  1212,  1210,  1954,
    1208,    69,     0,     0,  1402,  1417,  1405,  1964,     0,  1963,
    1949,  1952,  1522,     0,     0,     0,  1889,  1883,  1890,  1892,
    1886,  1891,  1893,  1884,  1885,  1880,  1887,  1134,  1163,     0,
       0,   673,   674,   677,     0,  1869,  1870,  1868,  1867,  1429,
    1428,     0,   661,   664,   665,   637,   636,   638,   631,   633,
     634,   257,  1243,     0,     0,     0,  1249,  1230,  1240,   622,
       0,     0,     0,     0,     0,   717,  1069,  1200,   714,   695,
    1163,  1153,   694,   725,     0,  1819,     0,  1790,  1847,     0,
       0,     0,     0,     0,  1837,  1383,     0,  1334,     0,  1358,
    1371,  1370,  1329,     0,     0,     0,  1327,  1377,     0,  1346,
    1309,  1369,  1326,  1133,  1376,  1324,  1325,   619,   618,   613,
    1080,  1069,     0,     0,  1066,  1082,     0,  1082,  1069,  1069,
       0,  1069,  1126,  1077,     0,     0,  2090,  1154,  2005,  1258,
    1259,  1261,     0,     0,   108,   111,   109,     0,   110,     0,
       0,   588,   542,   508,   508,   567,     0,   337,   542,   501,
     565,     0,     0,     0,     0,     0,     0,     0,     0,  1260,
       0,   578,   561,     0,     0,     0,     0,   579,     0,   562,
    1260,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   600,   599,   598,     0,     0,     0,     0,   278,   465,
     340,     0,   594,   337,   343,  1518,  2045,  1096,     0,  1095,
     126,    80,    76,    88,  1184,  1185,  1183,  1181,  1182,    89,
      78,    79,    83,    82,    84,    85,    86,    81,    77,    90,
      91,    75,     0,  1957,     0,     0,   241,   240,     0,  2061,
       0,  2045,     0,   340,    93,  1450,   276,   279,   529,   527,
       0,    94,  1069,  1152,  1296,  1133,     0,  1126,     0,   813,
     828,     0,     0,   977,     0,     0,   979,   980,   981,     0,
     832,     0,   830,   833,   834,   835,  1026,     0,     0,     0,
       0,  1026,   983,     0,   840,     0,     0,   845,   846,     0,
     819,     0,   853,     0,   855,     0,  1026,     0,   849,     0,
     810,     0,     0,  1026,     0,   861,     0,   822,     0,     0,
     963,     0,   946,   942,     0,   944,     0,     0,  1026,  1026,
       0,   866,     0,     0,   872,  1026,     0,   965,     0,   947,
       0,   878,     0,  1026,     0,  1031,     0,     0,     0,   990,
     882,   883,     0,   988,   949,     0,     0,   885,   951,     0,
     953,     0,   948,   955,   956,   887,   889,   888,   958,     0,
       0,   960,     0,   962,     0,   891,   892,     0,     0,     0,
     896,     0,  1026,   902,   899,   992,   994,     0,     0,     0,
       0,     0,   996,   909,   911,     0,     0,     0,   910,     0,
       0,     0,     0,     0,     0,     0,   915,     0,     0,   929,
     995,   820,   993,   934,     0,   937,     0,   936,     0,     0,
       0,     0,  2010,  2010,     0,   811,     0,     0,     0,     0,
       0,  1516,   739,   744,   737,   741,     0,     0,     0,     0,
     758,   757,     0,   770,   769,     0,  1140,   761,     0,   869,
       0,   971,   721,  1026,     0,    67,  1406,  1961,     0,     0,
       0,     0,     0,     0,     0,     0,  1878,  1164,  1270,  1530,
    1439,     0,   681,  1871,  1872,     0,   635,   700,     0,  1262,
    1247,  1254,  1248,     0,     0,     0,  1246,  1507,  1506,  1513,
    1996,     0,     0,     0,     0,  1999,  1133,  1133,  1194,     0,
       0,   692,   697,   693,   696,     0,   720,   729,   728,  1508,
    1515,     0,     0,     0,     0,   451,   453,   452,   461,     0,
     450,     0,     0,  1832,     0,   457,   459,   458,  1842,   456,
    1385,  1161,  1342,  1341,  1168,  1167,     0,  1320,  1336,  1386,
       0,  2003,  1075,     0,  1068,  1067,  1083,     0,  1069,  1082,
    1082,     0,  1048,  1047,  1274,  1277,     0,  1046,  1086,  1073,
     700,  2080,  2092,     0,   464,   463,   306,   460,   305,   113,
     112,   118,   119,   342,   543,   502,   503,     0,     0,     0,
     508,   336,   542,   335,   338,   517,     0,   289,   286,   569,
     292,   288,   304,     0,     0,   293,   542,   576,   577,   591,
     282,     0,   318,   319,   317,   301,   284,   285,   571,  1148,
    1150,  1158,   291,   290,   287,   296,   297,   315,   314,   295,
     316,   582,   313,   311,   308,   310,   309,   312,   294,   283,
    1416,   564,     0,   326,   328,   329,  1521,     0,   596,   566,
       0,   330,   331,     0,     0,     0,     0,   680,     0,  1958,
       0,  2068,   244,   242,   243,     0,   128,   324,   325,   323,
     322,     0,     0,   247,     0,   245,     0,     0,  1452,  1451,
     246,   260,   465,   280,   525,     0,  1133,  1173,  1289,  1295,
       0,     0,     0,   978,  1012,     0,   423,   423,  1022,  1020,
     412,   423,  1016,  1021,  1018,     0,     0,     0,     0,     0,
       0,     0,   985,   982,     0,     0,     0,  1515,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1009,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   967,  1035,   991,   989,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   997,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1039,   816,  2014,  2014,   808,
    1833,  1834,  1835,   544,  1002,     0,   751,  1026,   749,  1139,
     755,     0,     0,   759,     0,   926,     0,   973,   974,     0,
    1025,  1517,  1962,  1951,  1950,  1965,  1965,  1965,     0,  1135,
       0,  1227,  1450,   675,     0,   676,   662,   721,  1244,  1256,
       0,  1264,     0,     0,  1241,  1251,     0,     0,     0,  1250,
       0,  1896,  1897,  1895,  1163,  1141,     0,     0,  1205,     0,
    1201,   715,     0,   727,   726,     0,  1849,     0,  1848,  1860,
    1861,  1858,  1859,  1857,  1838,     0,  1844,  1843,     0,     0,
       0,  1854,  1845,     0,     0,  1335,     0,  1330,   620,     0,
    1069,  1082,  1069,  1055,     0,     0,  1069,  1051,  1049,  1053,
       0,  1133,     0,     0,     0,     0,  1070,   721,  1510,  1155,
    1158,   339,   542,   504,   505,   517,     0,     0,     0,     0,
     461,   302,   575,   574,   303,     0,     0,  1159,  1160,  1151,
       0,   568,   340,   595,   481,   408,   357,   348,   423,   351,
     350,   394,   365,   362,   412,   410,   380,   412,   412,   387,
     386,   404,   390,   370,   467,   467,   369,   407,   467,   391,
     389,   393,     0,   395,   412,   400,   388,   392,   409,   385,
     382,   406,   423,   423,   363,   366,   405,   467,     0,   398,
     423,   431,   368,   467,   473,     0,     0,   423,   429,  1520,
    2047,     0,  2049,  1094,     0,   139,   721,     0,   129,   131,
     132,     0,  2049,     0,   250,   275,   261,     0,   281,     0,
    1291,     0,  1287,   794,   825,   829,   939,     0,  1013,   424,
     467,     0,  1023,   414,   413,  1015,  1017,  1019,   815,   831,
     836,   941,   818,   817,     0,     0,     0,     0,   851,   854,
     856,   847,   852,   850,     0,   940,   863,   860,   862,   823,
       0,   964,   943,   945,   865,   876,  1007,  1010,     0,     0,
       0,   877,   873,   966,   874,     0,   879,   848,   880,     0,
       0,     0,     0,   950,   884,   952,   954,   959,   957,   961,
     890,   827,     0,   895,   897,   809,   794,   900,     0,   906,
     904,     0,     0,   912,     0,     0,   921,     0,   919,     0,
     920,     0,   922,   923,     0,   935,   938,  1040,     0,  2011,
       0,     0,  1004,   747,     0,   753,  1026,   750,   756,   722,
     721,   924,     0,  1970,  1970,  1970,  1269,  1268,     0,  1267,
    1271,     0,   682,   258,     0,     0,     0,  1265,  1253,  2000,
    1242,  1245,  1515,  1898,   699,     0,  1136,  1204,  1202,     0,
    1195,  1197,  1199,     0,  1509,     0,     0,  1853,  1839,   462,
       0,     0,     0,     0,  1840,     0,  1126,  1076,     0,     0,
    1042,  1069,  1069,     0,  1042,     0,     0,     0,  1276,  1152,
    1278,  1084,  1088,  1089,  1087,  1078,     0,  1157,     0,     0,
       0,   581,     0,   594,   583,   431,  1149,   298,   327,   487,
     356,   349,   367,   416,   411,     0,   416,   416,   473,   475,
     469,   473,     0,   376,   394,   371,     0,   467,   384,   375,
     396,   399,   401,   403,   416,     0,   467,   364,   373,   360,
     416,   439,     0,     0,     0,   435,     0,   480,     0,   442,
     344,   432,   434,     0,     0,   397,   467,   353,   474,   473,
     355,   467,   473,   416,     0,   430,   416,     0,  2046,     0,
    2053,     0,     0,   142,   140,   141,     0,   135,   137,   132,
       0,  2062,     0,     0,  2060,  2053,   248,  2000,  1450,     0,
     253,     0,  1158,   540,  1174,     0,     0,     0,     0,     0,
    1014,     0,     0,   986,   842,   843,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   812,     0,     0,
       0,     0,     0,     0,     0,   918,   916,   917,     0,  1041,
    2012,   545,   752,     0,   725,   975,     0,     0,  1969,  1967,
       0,  1968,  1966,  1942,     0,  1901,  1902,  1900,  1888,     0,
       0,  1440,  1163,  1255,  1257,  1263,  1252,     0,  1137,  1152,
    1453,  1198,     0,   716,  1851,  1850,  1852,  1846,     0,     0,
       0,     0,  1074,  1069,  1056,     0,  1060,  1065,  1061,     0,
    1052,  1050,     0,  1173,     0,  1090,  1163,  1158,     0,     0,
       0,     0,     0,     0,     0,     0,   580,  1486,   570,   572,
       0,     0,     0,   482,   483,   488,   490,   420,   421,   422,
     377,   417,   419,     0,   379,   347,   468,   476,   477,     0,
     472,   470,   473,   372,   402,   378,     0,   374,   361,   445,
     444,   730,   437,   447,     0,     0,   443,   433,   441,   436,
     352,   354,   358,   359,   345,     0,   346,  1519,  2048,     0,
     557,   721,   721,  2050,  2059,  2069,   139,     0,     0,     0,
     130,   133,  2044,   251,   249,     0,  1996,    95,     0,   539,
       0,   826,   427,   425,   428,   426,     0,   837,   857,     0,
     824,  1008,   999,  1131,   867,     0,   875,   881,   969,   968,
     894,   901,   905,   903,   907,   913,   914,  1026,   754,   976,
    1948,  1947,  1946,  1943,     0,     0,     0,     0,     0,     0,
    1971,  1973,  1266,     0,     0,   259,   714,   320,  1145,  1158,
       0,  1163,     0,  1461,  1196,  1856,  1855,  1841,     0,     0,
       0,     0,     0,     0,     0,  1097,  1275,  1085,     0,  1079,
    1156,     0,     0,   517,  1488,  1487,   594,   493,   494,   495,
       0,     0,     0,   486,   489,   418,     0,   546,   478,   471,
       0,   446,   730,   440,     0,     0,     0,   690,     0,   106,
     136,     0,   721,  2063,   255,   254,  1158,     0,     0,     0,
       0,     0,     0,  1944,  1974,  1977,  1975,  1976,  1978,  1972,
       0,     0,   321,     0,     0,  1142,  1144,  1138,  1186,     0,
       0,     0,     0,  1454,  1456,     0,  1203,     0,  1071,  1057,
       0,  1062,     0,  1054,     0,  1092,     0,   517,   332,   573,
     497,     0,   496,     0,   491,   492,   487,     0,   467,     0,
     467,   438,     0,  2054,     0,  2051,     0,  2070,   138,     0,
       0,  2000,   538,   541,   415,   858,     0,   987,   868,   927,
    1272,  1280,     0,  1441,  1146,  1147,  1158,     0,   698,     0,
       0,     0,     0,  1455,     0,     0,  1462,  1464,     0,     0,
       0,     0,  1098,     0,  1093,   334,   333,   499,   500,   498,
     484,   485,   381,   547,   383,  2055,  2056,  2000,   116,   115,
     107,     0,   175,     0,  2064,   256,     0,     0,     0,   454,
    1143,  1187,  1459,  1460,     0,  1457,     0,     0,  1463,     0,
       0,  1059,  1064,  1091,  2052,   117,     0,   193,   179,     0,
       0,     0,   177,   207,  2071,     0,     0,   181,   205,   206,
     182,   185,   186,     0,  1533,     0,  1534,  2057,   106,   859,
    1279,  1281,     0,  1442,     0,  1458,  1466,  1465,     0,  1072,
     192,   195,     0,     0,   198,   188,   187,   189,     0,     0,
       0,   176,   175,   175,   235,   184,   232,   231,   224,   175,
    2065,   455,  1453,   721,     0,   194,     0,     0,     0,   178,
     208,   219,   222,   214,   175,     0,   175,     0,   147,     0,
       0,  2058,   175,  1461,     0,     0,  1190,  1192,     0,   190,
       0,     0,     0,     0,   175,   215,     0,     0,     0,   145,
     238,     0,   143,   226,   226,  2066,  1467,  1193,  1188,   721,
    1331,     0,   180,   199,   216,   222,   212,   220,   175,     0,
     234,   146,     0,   236,     0,   175,     0,   225,   227,   229,
       0,  1469,  1191,   191,   196,   175,     0,   213,     0,     0,
     211,     0,   175,   158,   157,     0,   149,   171,   233,     0,
     148,     0,     0,  1476,     0,   175,   217,     0,   175,     0,
     175,     0,     0,     0,     0,     0,   144,  1468,  1471,     0,
       0,  1473,  1474,     0,  1443,   197,   202,     0,   209,   175,
     239,     0,   152,   172,   173,     0,   155,  1475,  1470,     0,
    1477,   198,   175,   201,   175,   237,     0,     0,   150,   164,
     151,   162,   154,     0,  1472,   203,   175,   175,   170,   168,
     175,   159,   166,   161,     0,   167,   174,   165,     0,   156,
       0,   153,   169,   163,   160
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    52,   484,  1108,    53,    54,    55,    56,    57,   995,
      58,   542,   942,  1416,  1417,    59,   435,    60,   720,  1155,
    1156,  1157,    61,  1636,  2525,  1173,   412,   430,  1633,  1119,
    3457,  1555,  3510,  1556,    62,   506,   718,  1137,  1138,  2827,
    2828,  3103,  2829,  3096,  3097,  3098,  3099,  3655,  3604,  3632,
    3656,  3693,  3726,  3732,  3733,  3675,  3740,  3741,  3742,  3748,
    3743,  3676,  3728,  3605,  3545,  3578,  3574,  3546,  3641,  3573,
    3663,  3597,  3598,  3665,  3706,  3723,  3547,  3548,  3579,  3622,
    3549,  3580,  3645,  3602,  3646,  3666,  3707,  3603,  3623,  3669,
    3626,  3550,  3609,  3657,  3551,  3610,  3552,  3553,  3587,  3608,
    3585,  3607,  3672,  3652,  2098,  2505,  2104,  2515,  3107,  2520,
    3286,  3461,  1926,  2327,  3172,  2837,  1624,  1114,  1115,   413,
     414,   415,   514,  2105,  1590,  2106,  2107,  1592,  1593,  1041,
    2478,  2469,  2455,  3335,  2511,  2482,  2483,  2484,  2485,  2433,
    2434,  2016,  2017,  2063,  2493,  2811,  3035,  3055,  2812,  2813,
    2814,  2815,  2816,  2817,  2818,  2852,  2853,  3230,  3231,  3232,
    2848,  2849,  3086,  3070,  3071,  3072,  3252,  3042,  2367,  2368,
    3563,  2377,  2378,  2415,  2706,  2416,  1118,  3043,  3080,  3240,
    3073,  2492,  3029,  3223,  3372,  3224,  3225,  3226,  3444,  2018,
    2432,  1134,  1135,   666,   416,  1189,  1656,  1657,  1658,  3111,
    3112,  2423,  2942,  3376,    63,  1121,   703,   705,   704,  2066,
     491,  1594,  1595,  1596,  2749,  2755,  3366,  2020,   111,  1413,
    2489,  2054,    64,  1091,  1086,    65,   677,   672,   673,  1089,
    1090,  1524,  1978,    66,   609,    67,   501,    68,   509,  1160,
      69,  1003,  1918,  1919,  1920,    70,   710,    71,   510,  1167,
    1168,  1169,    72,   993,   116,    73,   598,   998,  1000,  1001,
      74,   503,   504,  1129,    75,  1443,  1901,  1902,   715,   716,
    1136,  2665,    76,    77,   481,   455,   615,   456,   457,  1470,
    1938,  3336,   626,   627,   628,  2351,  1020,  1021,  1022,  1943,
    1471,  2356,  1175,  2957,   913,   914,   915,  1350,  1351,  3074,
     916,  1360,  1837,   917,   918,  1865,   919,  2902,  2300,  2301,
    2302,  2647,  2648,   920,  2141,  2865,  2179,   921,  1343,  1822,
    1730,  3129,  2886,  1675,  2124,  2545,  2649,   531,   532,   922,
    1267,  1268,  1269,  1747,  1334,  2271,  1814,  1531,  1532,  1533,
    1534,  3006,  3005,  3007,  3350,  3195,  3352,  3199,  1989,  1535,
    1536,  3489,  2391,  2720,  2409,  2410,  3206,  1980,  1537,  2397,
    3205,  2736,  3012,  3358,  3493,  2068,  3354,  1400,  1792,  1401,
    1727,   977,   978,  1676,  1898,  2315,  3179,  3340,  2290,  2976,
    3338,  3415,  1597,  2459,  2460,  1940,  1941,  2413,  2739,  2759,
    1044,  3337,  2317,  1498,  1499,  2842,  1659,  2079,  3478,  3564,
    3615,  3616,  3617,  2688,  2689,  2980,  2981,  1942,  2348,  2690,
    3180,    78,   418,    79,  1868,  1875,   712,   534,   427,    80,
     436,  1899,    81,   449,  1458,   582,   602,  1006,  1007,  1927,
    2328,  2335,  1928,  2340,  2969,  2330,  2668,  2669,  2001,  2002,
    2331,  2671,  2966,  2958,  2959,  2661,  3170,    82,   469,  2731,
    2404,  2405,  3470,  3471,   603,    83,   417,   760,  1663,  1194,
    1662,   761,   762,  1196,   529,   530,    84,   467,  1065,  1066,
    1067,  1513,    85,   460,   667,  1494,  2381,  1962,   594,   669,
    1505,   670,  1506,  1485,  1957,  1032,    86,   699,   698,    87,
     487,  1110,    88,   543,   953,   954,  1421,  1876,    89,   450,
     607,   608,    90,   444,   595,  1451,    91,   437,   585,    92,
      93,   586,   986,  2662,  3334,  3519,  3592,  1442,   987,  2521,
    3343,  3423,  3424,  3426,  3486,  3487,  3661,  3683,  3700,  3701,
    3704,   923,   686,   924,  3216,   925,   926,  2336,  2337,  2740,
     927,  3472,   928,  2064,   680,   433,   929,   576,   687,  2320,
     930,  3555,   733,   734,   399,   400,    94,   629,   459,  1024,
    1025,  1026,  1480,  1481,   671,  2279,  1482,  1483,  1954,  1949,
    2988,  2712,  2704,    95,   589,   955,   991,   992,  1907,    96,
     468,    97,   979,  1437,  1438,  1895,  2314,  1896,    98,   611,
      99,   565,  1431,   566,   957,   567,   568,   969,   964,   972,
     966,  3324,  3162,  3163,  1883,   938,   735,   736,  1424,  1878,
    1879,  2953,  3165,  3330,  3331,   100,   120,   405,   512,   727,
    1014,   101,   102,   103,   104,  1017,  1103,  1934,  1104,  1105,
    1106,  1544,  1468,  2627,  1341,  1816,  2939,   517,   750,   742,
     497,   498,   499,   520,   521,   112,   113,   743,   744,  2101,
    2496,  2821,  3090,  3091,  3273,  3270,   745,  3589,   746,   747,
    2506,  3279,  3460,  3558,  3612,   748,  2095,  2825,  3389,  3512,
     105,   688,   478,  1101,  1096,  1098,  1540,  1996
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3243
static const int yypact[] =
{
    3974, -3243,  1045,   893,   716, -3243,   200, 42910,    97,   716,
     716,   115,   698, -3243, -3243, -3243, -3243, -3243,  2628, 42910,
     893, -3243, 20996, -3243, -3243, -3243,   233,   716,   893, 42910,
   -3243,   273,   842,   893, -3243, -3243,   716, -3243,   115, 42910,
   -3243,   376, -3243,   -81,   838,   310,   461, -3243, -3243, 42910,
    2630,  -120,  1021,  1048, -3243, -3243,   736, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, 21556, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243,  1012, 42910, 42910, -3243,
   42910,   683, -3243,  1163, -3243, -3243,   716, -3243, -3243, -3243,
     115, 20996, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,   697, -3243,
   -3243,   786, -3243, -3243, -3243,  1351,  1169, -3243, -3243, -3243,
   -3243, -3243,   185,   895, -3243,   888,  1187,    72, -3243,  1214,
    1214, 42910,  1214, -3243,  1214, -3243,  1214,   716, -3243, -3243,
    3847, 42910,  1059,   111,   -62, 37870,  1390,   176, -3243,  1170,
   20996, -3243,   716,  1286,   223, 42910, -3243, -3243,   716,   203,
     849, -3243,  3920,   106, -3243, -3243, -3243,  2402, -3243, -3243,
    5712, -3243, -3243, -3243,   883, -3243, -3243, 20996,   716,  1196,
   -3243, -3243,   141,   141,   141, -3243,   141, -3243,   141, -3243,
    -120,   909, -3243, -3243,   906, 42910,   498, -3243, -3243,   886,
     -45, -3243, -3243, -3243, -3243, 20996,  1353,  1033, -3243, -3243,
   -3243, 20996, -3243,   -26, -3243, -3243,   923, 42910, -3243, 20996,
   20996,   147,   879,   508, 42910, 35630,  1107, -3243,   367,   859,
    1163,  1504, -3243,  1169, -3243, 42910, -3243, -3243, -3243, 39550,
      72, -3243, 12970,  1365, 42910, 42910,  1180, 42910, 42910, 35630,
   20996,  1214,   986,  3586,  1171,  1116,   892, -3243, -3243, -3243,
   -3243,  1217, -3243, -3243,  1070, -3243, -3243, -3243,    96, -3243,
      24, -3243, -3243, -3243, -3243, -3243,  1227,   989, -3243, -3243,
      76, -3243, -3243, 42910, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243,  1364, -3243, -3243, 12970,   198,  1533,  1410, 20996,
   -3243,  -172, -3243, -3243,  1329, -3243, -3243, 35630, 20996, -3243,
   -3243, -3243, 18743, -3243, -3243,  1551, -3243,  1030, -3243, 20996,
    1171, -3243,  1305,  1238,   879,  1125, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243,  1076,  2402, -3243, -3243,
    1404,  1527, -3243,  1244,   -13,  1216,  1117,   264,   -13, 37870,
    1459, -3243,   150, -3243,  1569, -3243, -3243,  1271, -3243, -3243,
   -3243,  1276,  1278,  1470,  1283, -3243,   178,  2819, -3243,  1295,
   -3243,    38, -3243,  -112,  1459,   -13,   833, -3243,  1515,  1644,
      95,  -128, -3243,   711, -3243, -3243,  1711, -3243, -3243, -3243,
   -3243, -3243,  1364, -3243, -3243, -3243,  1206, -3243,  1451,  1310,
   -3243, -3243,    68, -3243,  1222,   661,  1808, -3243,   581, 36190,
   -3243, -3243, -3243,  1703, -3243, -3243, -3243, 35630,  1387,  1306,
   20996,   463, -3243, 40110, 20996, -3243,   -27, 12970, -3243, -3243,
    4157,   137,  2555, -3243,  1771,  1431, -3243, -3243, -3243, -3243,
    1683, -3243,  1260,  1284,  1673,  1308, -3243, -3243, -3243, -3243,
   -3243,  1716, -3243,  1349, -3243, -3243, -3243, -3243, -3243,  1729,
   -3243, -3243, -3243, -3243, -3243,  1033, -3243, 20996,  -137, 20996,
   -3243,  1321, -3243,  1324, -3243,  1339,  1343,  1345,  1361,  1366,
   15905, -3243,  1373,  1375,  1377,  1380,  1392,  1397,  1398,  1401,
    1407,  1409,  1419,  1420,  1423,  1425,  1260,  1260,  1429,  1430,
    1436,  1437,   728,  1439, -3243,  1443,  1450,  1453,  1456,  1457,
    1461,  1469,  1472,  1473,  1477, -3243,  1479, -3243,  1481,  1483,
    1484,  1490,  1493,  1497,  1499,  1502,  1509,  1511,  1518,  1519,
    1521,  1524, -3243,  1526,  1529,  1535, 12970,  1537,  1538,  1546,
    1547,  1549,  1552,  1553, -3243,  1554,  1557,  1558,  1562,  1564,
    1565,  1566,  1567,  1572,  1573,  1575,  1576,  1581,  1585,  1586,
   -3243, -3243, 12970,  1588, -3243, -3243,  1591,  1597, -3243,  1608,
    1610,  1617,  1621,  1624,  1629,  1630,  1634,  1635,  1638,  1640,
    1641,  1643,  1645,  1652,  1655,  1657,  1660,  1661,  1662,  1671,
    1675, -3243,   876,  1678,  1680,  1176,  1684, -3243,  1685, -3243,
     160,  1686,  1687,  1696,  1260,  1260,  1260,  1697,  1699,  1701,
    1702,  1704,  1706, 12970, 15905, 15905, 15905,  8274, -3243, 42910,
   -3243, 42910,   425,  2798, -3243,  4053, 15905,  4534,   391, -3243,
   -3243, -3243,  1355,  1599, -3243, -3243, -3243, -3243, -3243,  1710,
    1656, -3243, -3243,  1665, 20996, -3243, -3243, -3243,  1413,   125,
   20996,  1516, -3243, -3243, -3243, -3243, -3243, -3243,  2070, -3243,
   -3243, -3243,  1715,  1709, -3243, -3243, -3243, -3243, -3243, -3243,
    1802, -3243, -3243, -3243,  1717, -3243,  1717, -3243, -3243,  1717,
   -3243, -3243,  1717,    16,  2925, -3243, -3243, 42910, -3243, 43470,
   -3243, 18743,   425, -3243,  2012, -3243, -3243,  2065, -3243,  2040,
     179,  1745, -3243, 20996, 37870, -3243, -3243,   116,  1746,  1825,
    1749, -3243,  1852, 20996, 20996, -3243, -3243, -3243, -3243,   849,
     136,  1776,    70, -3243, 42910, -3243,   322, -3243, -3243, -3243,
    1778, -3243, 12970, -3243,  1780, -3243,   889, -3243,  2137, -3243,
    1868, 12970, -3243, -3243,  1794,  1169, 42910, 42910, 20996, 20996,
   -3243, -3243, -3243,   885, -3243, -3243, 42910,   -13, 35630, -3243,
   -3243, -3243,  2203,   833, 42910,   -13, -3243,  2155,  1896, -3243,
   -3243, -3243,  2228, -3243, -3243,  2219,  1807, -3243,   833, -3243,
   -3243,   833, -3243, -3243, -3243, -3243, -3243, 20996, -3243, -3243,
     833, -3243,   833,   833,   -13,   -13,  1866, -3243, -3243,  1819,
   -3243,  1866,  1950,   366,   141,  2045, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243,   820, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243,    89, -3243, -3243, -3243,  1415,  1690,
    1690,  3339, -3243,   238, 20996,  1826,  1868, 20996, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243,  1827, -3243,  1829,  1832,   425,
    2273,  2274,  2279,  2288,  2292,  2306,  2309,  2311,  2312,  2315,
    2319,  2322,  2323,  2325,  2330,  1891, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243,  1943, -3243, -3243, -3243, -3243,  1817,
   -3243, -3243, -3243,   104,  1897, -3243, 37870,  2440, 35630,  2307,
   42910, 42910, 42910, 20996, 42910, -3243, -3243,  3113,  3113,  2149,
    1321, -3243,    78, 42910,  2326, 25492,   155, 12970, 12970, 12970,
     326,  1939,  2433,  2486,  2486,  2486, 12970, 12970, -3243, -3243,
   12970, -3243, 12970, 12970, 12970, 12970,   331, -3243, -3243,  8861,
   -3243,  1918, 12970, 12970,  2004, 12970,  1599, 12970, 12970, 22116,
   12970, 12970, 12970, 12970, 12970,   613, 12970,  4534, 12970, 12970,
   12970,  1920, 12970, 12970, 12970, 12970, -3243, 12970, 12970,   228,
   12970,  2380,   703, 12970, 12970, 12970, -3243,  9448, 12970, 12970,
   12970, -3243, 12970, 12970, 12970, 12970, -3243,  2497, -3243, 22116,
    1067, 12970, 12970,  1240, 12970, 12970, 12970, 12970, 12970, -3243,
   -3243, -3243, -3243,  8861, -3243, 12970, 12970, 12970, 12970, 12970,
   -3243, 15905, 12970, 10035, 12970, 12970, 12970, 12970,  1924, 12970,
   12970, -3243,  2486,  2486, 12970, 12970, 12970,  1277,  8861, -3243,
   12970,  1599,  3314,  3314, 12970,  1599,  7100, 12970, -3243, -3243,
   -3243,   703, 10622,  1928, -3243, -3243, -3243,  2486, 22116,  2486,
   12970, 12970, 12970,   425,  1954,  2433,  2433,  2433, -3243,  8274,
     230,  1933, 12970, 23236,  1931, -3243, -3243, -3243, -3243, 12970,
   12970, 12970, -3243, 15905, -3243, -3243,  1061, -3243, -3243, -3243,
   13557, 15905,  1936, 15905, 15905, 15905, 15905, 15905,  2272, 15905,
   15905, 15905, 15905, 15905, 15905, 15905, 15905, 15905,   866,  2433,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
    1952, -3243, 37870, 15905, 12970, -3243, -3243, 42910, 42910, -3243,
   35630, -3243, -3243, -3243,   125, 37870,  1944, -3243, -3243,  2140,
    3586, 20996, -3243, 42910, -3243, -3243, -3243, -3243, 19303, 19303,
   -3243, 19303, -3243, -3243,    93,   101,  3541,  1976, -3243, -3243,
   -3243, -3243,  2328, 20996, -3243,   518, 20996,  1826, -3243, 12970,
    1868, -3243, 35630, 35630, 20996, 20996,   610, -3243,   719, -3243,
    1868,  2345, 19303, 19303, 19303, -3243, -3243, -3243, -3243, -3243,
     694, -3243,   425, -3243,  1953, -3243, -3243, -3243, -3243, -3243,
   40670,   214, -3243, -3243,  1868,  2368, -3243,   425,  1965, 42910,
   -3243, -3243, -3243, -3243,   -28, -3243, -3243, -3243, -3243,   205,
   -3243, -3243, -3243, -3243,  2097,   -13, 42910, -3243, -3243, -3243,
   -3243, -3243,  2173,  1459,  2819,   -13,   -13,   833, 20996,   -13,
     -13, -3243, -3243,  1520, -3243,   711, -3243, -3243, -3243, -3243,
   42910,  2958,  2115,  1985, -3243, -3243, 20996, -3243,  1988, -3243,
    2404,  2529,  1459, -3243, -3243, -3243,    57,    57,  1868,  2108,
    2114,  2116,  2119,  2124,  2168, -3243, -3243,  2748,  2532,    57,
      57,  2532,    57,    57,    57,  2102,  2490,    57,  2376,  2135,
    1596,  2394,    57, -3243,  2138,  2511,    57,    57,    57,  2532,
    2589,    57,    57,    57,    57,    57,   162,    57,    57,    57,
   -3243,  4510, -3243, -3243,  2050, 19865, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, 41230, -3243, 12970,  1939,  1868,  1868,   747,
    1868,  1939,  1868,  1868,  1868,  1868,  1868,  1939,  1868,  1868,
    1939,  4157, -3243, -3243, -3243,   120, -3243, -3243,   -77, -3243,
   42910, -3243,   375,  2053,  -152, -3243,  3726, -3243, -3243, -3243,
   -3243, -3243, -3243,   957, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,  2052, -3243,
   -3243, 20996,  2098,  1976, 25492, -3243,   366, -3243,  2059, -3243,
     647,   410,   243, -3243,  2486,  2062, -3243,  2071,  2073,  2075,
    2079,   317,   673,  -171,  2082,  1255,  2083,   852,   902,   249,
     915, -3243,  2088,  2078,  1257, -3243,   925,   946,  1618,  1631,
     962,  2096,  2093,   247,   267,   975,  1002,   274, -3243,  2103,
    1010,  2514,  1020,  1074,   279, -3243,  1646,  1081,  1089,   297,
    2109,   302,   307, -3243, -3243, -3243, -3243,  2107,  1138, -3243,
   -3243,   394,  1653,  1140,  1151, -3243,  1664,  1183,  1192,   321,
    2110,  1197,   340,  1225,  1230,  2113,  2120,  2125, -3243,  2486,
    2117,  1676,  1718,  2486,  2121,   360,  1239,  1723,   373,   400,
    2128,  2131,  2132,  1727,  1733,  1735,   470,  1266,   482,  2134,
    3200,  1757, -3243,  1759,  1270,  1275,  1294,   556, -3243,  1327,
    1792,  2136,  2142,  2144,  1342,   235,  1344,  2486,  2145,  1806,
     596, -3243,  2139, -3243,  2152,  1811, 11209, 11796, 12383,   121,
    1357,   575, -3243,  1816, -3243,  2150,  2156, -3243,  2093,  2160,
     600,   665,  1821, 12970,  -164, -3243,  -120, -3243, -3243, -3243,
     138,    81, -3243,  2252, 42910,  1292,   110, -3243, -3243, -3243,
   -3243, -3243, -3243,    34, -3243,  2164, -3243,  2174,  2141,  8274,
     762,  2141,  3316,  2809,  2809, 15905,  2649,  3377,  3093,  1063,
    4534,  1063,  4534,  2141,  2141,  2141, -3243,  2175, 15905, 15905,
   15905, 12970, -3243,  2433,   425,  2166,  -217, -3243, -3243, -3243,
   -3243, -3243,  1516,  2442, -3243,  1826, -3243, -3243,   869, -3243,
    2148, -3243,  2170,  2211,  2266,  2282, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,  1459,   719,
    2261,  2195, -3243, -3243,  2227,  2533, -3243, -3243, -3243,   425,
   -3243,  2284, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
      25, -3243, -3243,  2212,  2212, 17612, -3243, -3243, -3243, -3243,
    2450,  2626,  2636,  2641,   581, -3243,   365, -3243,  1018,  2577,
    1459, -3243,  2651, 38430, 26054, -3243,  2221,  2596,  2242,    57,
   33950,   821, 23799, 34510, -3243, -3243,   747, -3243,    30, -3243,
   -3243, -3243, -3243,   885,   885,  2277, -3243, -3243,  2504, -3243,
   -3243, -3243, -3243,  1976,   833, -3243, -3243, -3243,  2258, -3243,
   -3243,   366,  2613,  2615, -3243,  2501,   586,  2501,   366,   366,
   22116,   366,  1363, -3243,  1939,  2549, -3243, -3243, -3243, -3243,
   -3243, -3243, 36750, 35070, -3243, -3243, -3243,  2762, -3243,  2770,
     754, -3243, 22676,   608,   608, -3243,   189,   190, 22676, -3243,
   -3243, 22676,   747,  1939, 22676,  1939,  1868,  1868,  1378,    57,
    1939, -3243, -3243,  2647,  2648, 22676, 22676, -3243, 37870, -3243,
      57,   726,   747,   747, 22676, 22116,  2964,  1868,  1939,  1939,
    2393, -3243, -3243, -3243, 20996,  1166, 37870,  2305, -3243,  5652,
   17052, 42910,   730,   126, -3243,  2301,  2313, -3243,   968, -3243,
     425, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243,  2396, -3243,  2462,  2327, -3243, -3243,    83, -3243,
      71,  2313, 20996, 16492, -3243,   107, -3243,  3463, -3243, -3243,
    4024, -3243,   366,  2541,    94,  1976,  2321,   155, 14144, -3243,
   -3243, 12970,  2331, -3243, 12970, 12970, -3243, -3243, -3243,   270,
   -3243, 37310, -3243, -3243, -3243, -3243, -3243, 12970, 37310,   270,
   12970, -3243, -3243,  2332, -3243,  2682,  2682, -3243, -3243,  1599,
   -3243, 42910, -3243, 12970, -3243, 12970, -3243,  1599, -3243, 12970,
   -3243, 12970, 12970, -3243,  2571, -3243, 12970, -3243, 12970, 12970,
   -3243, 12970, -3243, -3243, 12970, -3243, 12970, 12970, -3243, -3243,
    2583, -3243, 12970, 12970, -3243, -3243, 12970, -3243, 12970, -3243,
   12970, -3243, 12970, -3243, 12970, -3243, 15905, 22116,  2339, -3243,
   -3243, -3243,  2340, -3243, -3243, 12970, 12970, -3243, -3243, 12970,
   -3243, 12970, -3243, -3243, -3243, -3243, -3243, -3243, -3243, 12970,
   12970, -3243, 12970, -3243, 12970, -3243, -3243, 12970, 12970, 12970,
   -3243, 12970, -3243, -3243, -3243, -3243, -3243, 14731, 12970, 12970,
   12970,  2341, -3243, -3243, -3243, 12970, 12970, 12970, -3243, 12970,
     380, 12970,  1694, 12970,  2633, 12970, -3243, 12970,  2590, -3243,
   -3243, -3243, -3243, -3243, 12970, -3243, 12970, -3243,   193, 12970,
   12970,  2786, -3243, -3243,  2346, -3243,  2342,  2348,  2349, 37870,
   12970, -3243, -3243, -3243, -3243, -3243,   613,   721,  2347, 15905,
   -3243,  3316, 15905, -3243, -3243,  8274,   762,  3316,  2660, -3243,
    2352, -3243, -3243,  2358, 42910, -3243, -3243, -3243, 42910,  2369,
   26616, 35630, 35630, 35630,  2364, 12970, -3243, -3243,  2610, -3243,
   -3243, 20996,  2735, -3243, -3243, 35630, -3243,  2402, 22116, -3243,
    2366, -3243,  2366,  1184,  2385,  1016, -3243, -3243, -3243,  2362,
    1125,  2789, 35630, 35630, 35630, -3243,  1976,  1976,   406,  2441,
    2756, -3243, -3243, -3243, -3243, 41790, -3243, -3243, -3243, -3243,
     761, 42910,  2727, 42910,  7687, -3243, -3243, -3243,  2926, 12970,
   -3243, 35630,   468,    81,    57, -3243, -3243, -3243, -3243, -3243,
   -3243,  1459, -3243, -3243, -3243, -3243,  2717, -3243, -3243,   -13,
    1520,   717, -3243,  3175, -3243, -3243, -3243,  2757,   366,  2501,
    2501,  2761,  2657,   -64,  2418, -3243,    57,  2958,    19, -3243,
    2402, -3243, -3243, 12970, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, 12970,  2766,  2767,
     608, -3243, 22676, -3243, -3243,  -137,   103, -3243, -3243, -3243,
   -3243, -3243, -3243, 35070,  1868, -3243, 22676, -3243, -3243,   129,
   -3243,  1868, -3243, -3243, -3243, -3243, -3243, -3243, -3243,  2421,
   -3243,  1052, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   20996, -3243,  1051, -3243, -3243, -3243, -3243, 42910, -3243, -3243,
   20996, -3243, -3243,  4946, 42910, 42910,  2989, -3243, 42910, -3243,
      71, -3243, -3243, -3243, -3243,  2664, 42910, -3243, -3243, -3243,
   -3243,  2491,  2991, -3243, 20996, -3243,  2427,  1086, -3243, -3243,
   -3243,  2996,  4991, -3243, -3243,  2434,  1976,  2763, -3243, -3243,
   12970,  1838,  1860, -3243,   425,  1871,  2437,  2437, -3243, -3243,
    2445,  2437,  2802, -3243,  2804,  2448,  2455,  2461,  1895,  2465,
    2467,  1370, -3243, -3243,  4534,  4534,  2468,  2453,  1908,  1978,
    2469,  2472,  2008,  1402,  2019,  2473,  2475,  2035,  2042,  1447,
    2055,  2084,  2099,  2111,  2476,  2541,  2478,  1498,  1505,  2480,
    2118,  2123,   733,  2162,  2481,   756,  2917, -3243, -3243, -3243,
    2167,  2169,  2180,  2182,  2204,  2218,  2226,  2235,  2237,  1534,
    2250,  2260,  2482, 12970,  2276,   944,   770,  1540, -3243,  2300,
    1603,  1616,  2310, 12970,  2324, 12970,  2382, 12970,  2387,  2405,
    2483,  2411,  2431, 12970,  1334,   425, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243,  2479,   425,  2493, -3243, -3243, -3243,   391,
   -3243,   784,  2494, -3243, 15905, -3243, 12970,  2489, -3243,  2495,
   -3243, -3243, -3243, -3243, -3243,   353,   353,   353, 15318,   425,
    2935, -3243,    53, -3243,  2837, -3243, -3243,  1076,  2500, -3243,
      57, 15318,  2212,  2659, -3243, -3243,  1184, 22116, 26054, -3243,
   35630,  1308,  1308,  1308,  1459,  2892,  2261,  2261, -3243, 24362,
   -3243, -3243,  2642, -3243, -3243, 27178, -3243,  1164, -3243, -3243,
   15905,  1450, -3243,   425, -3243, 36750, -3243,   425,    57,  2509,
    2513, -3243, -3243, 42350, 12970, -3243,  2952, -3243, -3243,  2516,
     366,  2746,   366, -3243,  2866,  2867,   366, -3243, -3243, -3243,
   22116,  1976, 15318,   608,   608,   608, -3243,  1076,   425,  2519,
    1052,   425, 22676, -3243, -3243,  -137,  2531,  2995,  3005, 22676,
    2926, -3243, -3243, -3243, -3243,  4946, 22116, -3243, -3243, -3243,
    2534, -3243, 17052, -3243, -3243, -3243,  2437,  2437,  2437, -3243,
   -3243, -3243, -3243, -3243,  2445,  2758, -3243,  2445,  2445, -3243,
   -3243, -3243, -3243, -3243,   259,   220, -3243, -3243,   259, -3243,
   -3243, -3243,    79,   712,  2445, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243,  2437,  2437, -3243, -3243, -3243,   259,  2437, -3243,
    2437,  3193, -3243,   222,    59,  2437,  2437,  2437,  2542,  2544,
   -3243,  1088, -3243, -3243,  2614,    80, -3243,  2554,  2558, -3243,
   -3243,  1868, -3243,  2560, -3243,  4510, -3243,   720, -3243, 42910,
   -3243,   885, -3243,  4534, -3243, -3243, -3243,   167, -3243, -3243,
     259,  1007, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, 12970,  2561,  2566,  2567, -3243, -3243,
   -3243, -3243, -3243, -3243, 12970, -3243, -3243, -3243, -3243, -3243,
   12970, -3243, -3243, -3243, -3243, -3243,  2711, -3243,  2816, 12970,
   12970, -3243, -3243, -3243, -3243, 12970, -3243, -3243, -3243, 12970,
    3114,  2775,  2574, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, 12970, -3243, -3243, -3243,  4534, -3243, 12970, -3243,
   -3243, 12970, 12970, -3243, 12970, 12970, -3243,  2474, -3243,  2499,
   -3243,  2510, -3243, -3243,  2821, -3243, -3243,   425, 12970, -3243,
    2576, 42910, -3243, -3243,  2579, -3243, -3243, -3243, -3243,   425,
   -3243, -3243,  1049,  2603,  2603,  2603,  1450,   425,  1099, -3243,
   -3243,  2940, -3243,  1778, 22116, 15318,  2585,  2588, -3243,   661,
   -3243, -3243,  2591,  1308, -3243,  3129,  2975, -3243, -3243, 37870,
    2594, -3243, -3243,  2871, -3243,    52,  2793, -3243, -3243, -3243,
     468,  2685,  2698,    57,   425,  1868,  1647,  1985,  2962,  2460,
    2663,   366,   366,  3492,  2665, 12970, 12970,  2616, -3243,  2541,
   -3243,  3032, -3243, -3243, -3243,  1778, 12970, -3243,  2623,  2631,
   42910, -3243,  3421,   730, -3243,  3193, -3243, -3243, -3243,   505,
   -3243, -3243, -3243,   795, -3243,  2635,   795,   795,  3178,   114,
   -3243,  3178, 37310, -3243,  1244, -3243,  2661,   259, -3243, -3243,
    2670, -3243, -3243, -3243,   795,  2666,   259, -3243, -3243, -3243,
     795, -3243, 37870,  1868,  3233, -3243,  2708, -3243,  3132,  3006,
   -3243,  3193, -3243,  3008,  2910, -3243,   259, -3243, -3243,  3178,
   -3243,   259,  3178,   795,  2914, -3243,   795, 42910, -3243, 42910,
    2696,   740,  1868, -3243, -3243, -3243,  2671,  2674, -3243, -3243,
   20996, -3243, 42910,  4946, -3243,  2696, -3243,   661,   107,  2659,
   -3243,  1133,  1052,  2673, -3243,  2676,  2678,  2684,  2689,  2692,
   -3243,  1135,  2523, -3243, -3243, -3243,   828,  2548,   141,  2693,
    2695,  2550,  1623,  2552,  2568,  2959,  3130, -3243,  2578,  2699,
    2601,  2605,  2607,  2609,  2625, -3243, -3243, -3243,  2700,   425,
   -3243, -3243, -3243,  2703, 38430, -3243,  2791,  2792, -3243, -3243,
    2794, -3243, -3243,   108,  2018, -3243, -3243, -3243, -3243, 15318,
    3050, -3243,   204, -3243, -3243, -3243, -3243, 12970, -3243,  2541,
    3226, -3243, 24362, -3243, -3243, -3243, -3243, -3243,  2710,  2715,
    7687,  3287, -3243,   366, -3243,  2768, -3243, -3243, -3243,  2772,
     425,   425, 42910,  2763,  3074, -3243,   204,  1052, 42910, 42910,
    1143,   703,   703,   703,  1025,  1025, -3243, -3243, -3243, -3243,
      27,    36, 42910, -3243, -3243,  1043, -3243, -3243, -3243, -3243,
   -3243,   795, -3243,   141, -3243, -3243, -3243, -3243, -3243, 37310,
   -3243, -3243,  3178, -3243, -3243, -3243,   141, -3243, -3243, -3243,
   -3243,  1260, -3243, -3243,  2980,  2769, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243,  2732, -3243, -3243, -3243,   984,
   -3243, -3243, -3243, -3243, -3243, -3243,   708, 42910,  3146,  2907,
   -3243, -3243, -3243, -3243, -3243,  2737,  1125, -3243, 42910, -3243,
    2984, -3243, -3243, -3243, -3243, -3243,  2986, -3243, -3243, 12970,
   -3243, -3243, -3243,  2486, -3243, 12970, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243,   151,  2978,  1939,  1939,  1939,  1939,
    2018, -3243, -3243,  2795,  2833, -3243,  1018, -3243,   825,  1052,
   12970,  1459,   133,  3075, -3243, -3243, -3243, -3243,  3058,  3681,
   12970,  2752, 12970,  2753,  1160, -3243, -3243, -3243,  2754, -3243,
   -3243,  1177,  1179,  -137, -3243, -3243,   730, -3243, -3243, -3243,
     466,   466,  1219, -3243, -3243, -3243,  1262, -3243, -3243, -3243,
    1279, -3243,  1260, -3243,  3280,  2990,  3283, -3243,  -120, -3243,
   -3243,  4946, -3243, -3243, -3243, -3243,  1052,  2759,  2760,   846,
    2764,  2627,  2773, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   22116, 20996, -3243,   312, 12970, -3243, -3243,   425,  2972,  3302,
    3305,  3213,  3308,   133, -3243,  -106, -3243,  3209, -3243,   425,
   42910,   425, 42910, -3243, 42910, 41230,  2965,  -137, -3243, -3243,
   -3243,  3351, -3243,   188, -3243, -3243,  1043, 42910,   259,   141,
     259, -3243,  3009, -3243,  3011, -3243,  2780,  3403, -3243,  3231,
    4946,   661, -3243, -3243, -3243, -3243, 12970, -3243, -3243, -3243,
    2783, -3243,    57, -3243, -3243, -3243,  1052, 42910, -3243,   141,
     141,  3324,   141, -3243,  3325,  3326,  -106, -3243,   747, 12970,
    1293,  1296, -3243,  2788,  2790, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243,   661, -3243, -3243,
   -3243,  3257, 32260,  2957, -3243, -3243,  2629, 22116, 15318,  1378,
   -3243, -3243, -3243, -3243,   141, -3243,   141,   141, -3243,  3366,
     170, -3243, -3243, -3243, -3243, -3243, 42910,    82, -3243, 44030,
   44030, 42910, -3243,  2828, -3243,  4773,   512, -3243, -3243, -3243,
   -3243, -3243, -3243,  3362, -3243,  2801, -3243, -3243, -3243, -3243,
   -3243, -3243, 35070, -3243,  2812, -3243, -3243, -3243,  3117, -3243,
   -3243, -3243,  3223, 42910, -3243, -3243, -3243, -3243, 12970, 12970,
    2845, -3243, 32260, 32260, -3243, -3243, -3243, -3243,  3373, 32260,
    3403, -3243,  3226,  2818,  3260, -3243,  3182,  3268, 12970,   425,
     425, -3243,   284, -3243, 29435,  2823, 32825, 12970, -3243,   512,
    3362, -3243, 32260,  3075, 12970,  2826,  2829, -3243,  1939, -3243,
    3202,  1362,  2862, 12970, 32260, -3243,  3277,  3151,  2832, -3243,
    2834,   325,  3321, 44030, 44030, -3243,  3219,   425, -3243, -3243,
   -3243, 42910, -3243, -3243, -3243,   495, -3243,   425, 30000,  2863,
   -3243, -3243, 12970, -3243, 38990, 30565,  2848, -3243, -3243, -3243,
    3103,  2860, -3243,  2859, -3243, 32260, 12970, -3243,  3304,  2877,
   -3243,  2637, 32260, -3243, -3243,  3250,  2869,   913, -3243,  2868,
   -3243,  3197, 18174,  3010, 42910, 27740,   425,  2887, 32260,  3056,
   31130,  3292, 42910,  4946,  3293,  3294, -3243, -3243, -3243, 37870,
    1314, -3243, -3243, 22116, -3243, -3243,    23,  2897, -3243, 28305,
   -3243,  2912, -3243, -3243,  3361,  1523, -3243, -3243, -3243, 20427,
    2783, -3243, 32260, -3243, 32260, -3243, 33390, 12970, -3243,  2928,
   -3243, -3243, -3243,  4773, -3243, -3243, 31695, 28870, -3243, -3243,
   24925, -3243, -3243, -3243,  3306, -3243,   425, -3243,  1599, -3243,
   33390, -3243, -3243, -3243, -3243
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3243, -3243, -3243, -3243, -3243, -3242, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243,  1605, -3243, -3243, -3243, -3243, -3243,
    1857, -1448, -3243, -3243, -3243, -3243, -3243,   372,    40,  2776,
     -78, -3106, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243,   386,   387, -3243, -3243,   225, -3243, -3243,  -810, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243,  -252,  -213, -3243,
   -3243, -3243, -3243,   526, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243,  -215, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243,  -136, -3243, -3243,   -91, -3243, -3243,
    -133, -3243, -3243,  -119, -3243, -3243, -3243, -3243,   -96, -3243,
     -93, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,   409,
   -3243, -3243, -1891, -3243, -3243, -3243, -3243,  2363,  -982, -3243,
    3107, -3243,  -406,   700,  1948, -1955, -1050,  -621,  -605, -1656,
   -3243, -3243, -3243,   335,  1057,  1442,   798,  1966,  2005,  1501,
    1556, -3243, -3243,   819, -3243, -2683, -3243, -3243, -3243,   793,
   -3243,   796, -3243, -3243, -3243, -1072,   751,  -995, -3243,   352,
     231,  1291, -3243,   559, -3243,   521, -3243,  -458, -2078, -1976,
   -3243, -3243, -3243,   532,   845,   891, -3243, -2695, -1254, -3243,
   -3243,   164, -3243, -3243, -3243,   166, -3243,   393,   248, -3243,
   -3243, -1518, -1726, -3243, -3243, -2380,  2413,  1512, -3243, -1894,
     333, -1933, -3243,   377, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243,  1571, -3243, -3243, -3243,   -89,  -263, -1381,
   -2816, -3243, -3243, -3243, -3243, -3243, -3243,  1193, -3243, -3243,
    2100,  2545, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243,  1712, -3243, -3243, -3243, -3243, -3243, -3243,
    2466, -3243, -3243, -3243,  1318, -3243, -3243, -3243, -3243,  2184,
   -3243, -3243,  2929, -3243, -3243, -3243, -3243,  1319,  1736, -3243,
   -3243, -3243,  2944,  1719,  -477, -1790, -3243,  3166, -3243, -3243,
   -3243, -1306, -1978, -3243,  3025,   318, -2314,  2186,  -502,   710,
   -3243,   503,  -767,  3461, -3243, -1316, -1147, -3243, -3243,  -509,
   -3243, -3243, -3243, -1289,  -759, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243,   713, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -1140, -3243,  1522, -3243, -1141, -3243, -3243,
   -3243,  2398, -3243, -3243, -3243, -3243, -3243, -1935, -1525,   940,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -1919,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -1406, -3243, -1794,
   -3243, -3243, -1132, -3243, -3243,   227, -2110, -1230,  2353,   315,
   -3243, -3243,  -980,  2458, -1628, -3243, -3243, -3243,  1383, -3243,
   -3243, -3243, -3243, -3243,   920, -2077, -1078, -3243, -3243, -2653,
    -641, -1867,  -616, -3243, -1902,   479, -1175, -1927, -3243, -3243,
   -3243, -3243,    45, -3243, -3243, -3243,   507,  1754, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243,  2308,  -358,  1925, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243,  2714,  2694,  1800,
   -3243, -3243, -1961, -3243, -3243,  1777, -3243,   739, -1900,  2026,
    1035, -3243, -3243,  1037, -2673, -3243, -3243, -3243, -3243, -3243,
   -3243,   974,     6,   196,  3241, -3243, -3243, -3243, -3243, -3243,
   -3243,  2963,  2525, -1462,  3186, -3243, -3243, -3243, -3243, -3243,
    2207, -3243, -3243, -3243, -3243, -3243, -3243, -3243,  3267, -3243,
    -994, -3243,  -500, -3243, -3243,  -620, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243,  2334, -3243,  1251, -3243, -3243,
   -3243,  2736, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,  1082,
     156, -3243,   328,   139, -3243,   271, -3243, -3243, -3243,    41,
   -3243,  -783,  -686, -1029,   699, -2665, -1301,  1084,  2742, -2815,
   -1191, -1270, -1288, -1853,    21, -3243,    -7,  -485,  -918,  -752,
    1843, -1672,  -434,  -531, -3243,  1815, -3243, -3243, -3243, -3243,
    2296, -3243, -3243, -3243, -3243,  1394, -3243, -3243, -3243,  1075,
   -3243,   782,   599, -3243, -3243,  2681, -3243,  2351, -3243, -3243,
   -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243, -3243,
   -3243, -3243,  2787,  3346,  3190, -3243,  2827, -3243, -3243, -3243,
   -3243, -3243,   478, -3243,  1032, -3243, -1200,  2632,   454, -3243,
    1496,  -718,  -976, -3243,   475, -3243, -3243,  1167,  3353,  3199,
   -3243, -3243, -3243, -3243, -3243, -2283,  -609, -3243, -2361, -3243,
   -3243, -3243, -3243,  1541, -1194,  2477,  1189, -3243, -3243, -3243,
    3291,  3395,  3406, -3243, -3243,   -92, -3243,  3322,  -285, -3243,
    1722, -3243,   988, -3243, -3243,   723,  3310, -3243, -3243,  3311,
   -3243, -3243, -3243, -3243, -3243,  3313, -3243, -3243, -3243, -3243,
   -3243,  1307, -3243, -3243, -3243, -3243, -3243, -3243
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2041
static const short yytable[] =
{
     397,   578,   665,   694,   730,  1405,  1018,  1711,   937,  1226,
    1445,  1202,   397,  1111,  1500,   397,   741,   749,  1040,  1217,
    1218,  1220,   397,  1073,  1045,  2272,  1677,  2418,  1542,  2380,
    2719,  2316,   397,  1870,  2334,  2113,  2527,  1828,  1701,  2019,
    1807,  1709,   397,   432,  1836,  1074,  2393,   396,  1045,  2364,
    2369,  2372,  2035,  2546,  2403,  2746,  2407,  2679,  1806,  3010,
    2549,  2384,  2385,  1678,  1679,  1680,   999,  1683,  1684,  2402,
    1686,  1591,  3025,  2353,  1515,  1977,  1692,  1516,  1748, -1129,
     397, -1522,  1116,  1850,  1852,  2435,  1284,  3017,  1519,  1520,
    3048,  3078,  -551,  3049,   975,  2437, -1881, -1523,  1117,  1311,
     397,   397,  1315,   397, -1882,  1720,   996,  -262,   488,   679,
    -252, -1945,  3058,  1309,   397,  2456,  2457,   757,  3077,   970,
    1740,  3184,   511,  -263,  3323,  1345,  1346,  1324,  1325,  1326,
    1750,  1993,  1545,  1754,  3237,  3050,  1345,  1346,  1760,  1761,
    1762,  2115,   505,  1449,  1770,  1335,  1336,  1337,   493,  1769,
     494,  3370,  2523,  1345,  1346,  3120,   967,  1379,  3721,  2424,
    1781,  1080,  1782,  1783,  1939,  2424,  1077,  1788,  2436,   632,
     633,  2439,   571,   975,  1411,   683,  1122,  2382,  1411,  2507,
    2051,  1915,  2448,  2449,  2427,  1345,  1346,  1805,  2733,  1809,
    1132,  2458,  2282,  2401,  1318,  1428,   106,   975,  2502,   723,
    1113,  3207,  1999,   713,  3367,  1042,  2117,  3218,  1345,  1346,
    3156,  1133,  2516,  1046,  1838,  1113,  1669,  1841,  1842,  1843,
    1844,   976,  1846,  1847,  1848,  1849,  1851,  1853,  1854,  1855,
    1856,  1113,  2747,  2734,   751,  1960,  1179,  1180,  1181,  1030,
    3038,  1054,  3038,  1069,  1005,  1345,  1346,  2427,  2427,  1462,
    1345,  1346,  3039,   583,  3039,   592,   700,  3571,  1345,  1346,
    1986,  2100,  1345,  1346,  1345,  1346,  3040,  2518,  3040,   632,
     633,  3419,  2276,   983,  3116,   632,  3044,   632,   633,  3038,
    2728,  3420,  1345,  1346,  2092, -1522,   526,  2425,  2426,  1345,
    1346,  3039,  3174,  1158,  1345,  1346,  2255,   496,  2508,  3498,
     976,  3093,  2536,  3581,  1099,  3040,  2503,  2052,  1405,  3094,
     479,  1460,  1345,  1346,   632,   633,   600,  1345,  1346,   981,
     522,  2518,  1345,  1346,   976,  1723,  2537,   575,  1724,   438,
   -1129, -1522,  1345,  1346,  1466,  2129,  1345,  1346,  1673,  2277,
    1345,  1346,   527,  1673,   684,  2388, -1881, -1523,  1084,  2667,
    1598,  3509,  3243,  2963, -1882,  1345,  1346,  3217,  1035,  2428,
    -341,  3247,  3339,  1319,  1071,  3019,  2303,  2538,  3484,  2131,
    2539,  2283,  2674,   984,  2304,  1345,  1346,   738,  2540,  1936,
    1187,  3260,  2450,  2096,   401,  3157,  3262,  3368,  1345,  1346,
    1429,  2269,  3485,  1405,   461,  1345,  1346,  1405,   462,  3217,
    2479,  3474,  2097,  1188,  1072,  2270,  1378,  1916,  1538,   452,
    2238,  2347,  3572,  2132,   397,  1345,  1346,   121,   994,  1093,
    3281,  1085,  2093,  3015,   397,  1345,  1346,  1502,   397,   756,
   -1522,  2071,  2737,   397,  3117,  1508,  2081,  3095,   397,   507,
    1345,  1346,  2087,  1036,  1463,  2090, -1523,  1467,  1961, -1129,
     439,  1674,   701,  3653,   528,  1402,  1691,  1043,  2519,  3289,
     397,   588,  2509,   480,  1521,  1522,  1599,  2750,   985,  1731,
    1185,  1081,  1347,   601,  2714,  1348,  2729,   702,   397,  2723,
    1100,  3369,   724,  3421,  3509,  1345,  1346,  2528,   397,  1347,
    1543,  3749,  1348,  1116,   397,  2346,  3332,  1345,  1346,  2745,
     397,   572,   397,   397,  2000,  3118,  2732,   397,   397,  1117,
     593,  1430,  2519,  2752,  1070,  3440,   706,  1503,   397,  1159,
    2490,  1347,   397,  1973,  1348,  3499,  2278,   397,   397,   573,
     397,   397,   397,   397,  2122,  1950,  1412,  2686,  1801,   516,
    1412,  1591,  2019,  1031,  1347,  1486,  1963,  1348,  2284,  2748,
    3439,   968,  1116,  2510,  3360,  2613,  -508,   584,  2735,   714,
    1448,  2429,  -341,  1917,  2285,  1430,   397,  2838,  1117, -1129,
    3371,  1345,  1346,  3185,  2392,  1951,   971,   935,   936,  2424,
    1518,  1347,   397,  2383,  1348,  2019,  1347,  2526,  1082,  1348,
     397,   397,  3722,  2424,  1347,   397,  2541,  1348,  1347,  3476,
    1347,  1348,   397,  1348,  1840,  2724,  2725,  1083,  3176,  2198,
     990,  1345,  1346,  2202,   613,  1345,  1346,  2504,  1347,  1002,
    2293,  1348,  2294,  1005,  1450,  1347,  1047,  3051,  1348,  1489,
    1347,  3422,   397,  1348, -1522,  3160,  2354,  1807,  1037,  3238,
     685,  1601,  2847,  1545,  1863,  2288,  1005,  2241,  1347, -1881,
   -1523,  1348,  2117,  1347,  1055,  2338,  1348, -1882,  1347,  1320,
    1547,  1348,  1345,  1346,  -134, -1129, -1945, -1522,  1347,  1664,
    2053,  1348,  1347,  1349,   404,  1348,  1347,  2274,  -551,  1348,
    1345,  1346, -1881, -1523,  1349,  2116,  3416,  3119,  1345,  1346,
   -1882,  1347,   397,  -262,  1348, -1129,  -252, -1945,  2291,   445,
     397,  1349,  1807,   397,  2744,  2256,   397,   397,  3458,  -263,
    1127,  1347,  2297,  2298,  1348,  2970,  2430,  -341,  2684,  2685,
    2406,  1127,  1127,  2542,  1347,   458,  2275,  1348,   440,  1725,
    3475,  1347,  1726,  1349,  1348,   505,  1345,  1346,  2487, -1129,
   -1129,   739,  1627,  3462,  1403,  3041,  3283,  3041,  1345,  1346,
     397,  1347,   397,  3502,  1348,  3504,  1349,  1807,  3569,  1038,
    2952,  1347,  2687,  2623,  1348,   465,  1915,  3045,  2809,  1602,
    2965,  1345,  1346,  3075,  2543,  2461,  1347,  3514,  1186,  1348,
    1191,  3582,  2334,   515,  3041,  1345,  1346,  2999,  1904,  2138,
    1964,  3003,   406,  1349,  3220,  1528,  1528,   539,  1349,  1345,
    1346,  3441,  2544,  3000,  1952,  2847,  1349,  3004,  2990,  3018,
    1349,  2709,  1349,  1405,  1817,  1818,  1039,  2974,   597,  2411,
    2239,  1347,  2398,  3520,  1348,  1132,  1402,  2120,  2121,  2710,
    1349,  2152,  2153,  1347,  2139,  2399,  1348,  1349,   708,  3601,
     728,   729,  1349,  1345,  1346,  3561,  1133,  1833,  2438,  3221,
    2440,  2154,  2155,  3624,  2074,  2445,  2554,  2555,  2158,  2159,
    1349,  1345,  1346,  2165,  2166,  1349,  2421,  1345,  1346,  1936,
    1349,  2463,  1969,  2465,  2466,  2470,   407,  3442,   740,  1869,
    1349,  2170,  2171,  1405,  1349,  1966,  2173,  2174,  1349,  2424,
    2452,  2175,  2176,   685,  2488,  1971,  1972,  1045,  2840,  1975,
    1976,  1998,   397,  1349,   397,  2187,  2188,  1347,  1905,  1823,
    1348,  2289,  3443,  2075, -2003,  -513,  3583,  1345,  1346, -2040,
    1937,  1911,  1912,  1349,  2191,  2192,  1045,   397, -1396,  3093,
    1345,  1346,  3203,   397,  1500,  1500,  1349,  3094,  1178,  3114,
    1345,  1346,  2718,  1349,  2204,  2205,  3110,  1347,  1529,  1529,
    1348,  1347,  1530,  1530,  1348,  1409,   466,  2208,  2209,  1345,
    1346,  1345,  1346,  1349,  3242,  1910,  1999,  2711,  1862,  2453,
     397,  1126,   397,  1349,   397,  1929,  2640,  1345,  1346,  2180,
    2389,  1871,  2422,  3438,  2210,  2211,   397,   397,  1349,  3694,
    1345,  1346,  1916,  2371,  2119,  2547,   397,   397,  1347,  1955,
    2552,  1348,  2400,  3395,  1116,  3695,  2587,   397,  1075,  1591,
    3714,    40,  2408, -2003,  2076,  2560,  1347,  1345,  1346,  1348,
    1117,   482,  2565,  1953,  1347,  1345,  1346,  1348,   850,   397,
     397,   397,   397,  1349,  3384,  1345,  1346,  2574,  2575,   397,
    1807,   397,  3385,  1338,  2579,  1349,  1541,   397,  1127,  2586,
    3644,   483,  2584,   850,  2218,  2219,   106,  3496,  2670,  1492,
    1493,  2454,  1076,  2004,  3624,  3095,  2221,  2222,  2753,  3584,
     397,  2757,  1347,  1043,   685,  1348,  1490,  1491,  1906,  1673,
    1476, -1396,  3196,  3197,  1347,  2077,  1501,  1348,  3222,  1345,
    1346,  2602,  2635,  3190,  1507,  1857,  1345,  1346,  1517,  2296,
    3515,  2642,  3341,  3009,  1345,  1346,   485,  1347,  3156,  1087,
    1348,  2655,  2656,  2657,  3116,  1403,  2918,   397,  1858,  1349,
     397,  1347,  2072,  2073,  1348,  2080,  3210,  2082,  2083,  2084,
    2085,  2086,   794,  2088,  2089,  1347,   604,  2529,  1348,   107,
    2230,  2231,  2681,  2682,  2683,  1600,  3534,  1477,  1917,  1921,
    1921,   114,  1495,  1345,  1346,  1345,  1346,   490,   408,  1349,
    2258,  3378,  2650,  1349,    51,  1922,  1345,  1346,  2758,   397,
    3271,   397,  1541,   397,   397,   397,   397,   397,   495,  1347,
    2244,  2245,  1348,  1088,  2263,  2264,   397,  1016,   397,  1361,
    2349,   807,  1749,  -268,   409,  1127,  1708,  1347,  1345,  1346,
    1348,   850,   881,  1347,  1635,   453,  1348,  1345,  1346,   117,
    1349,   118,  1345,  1346,   725,  3011,  3011,  3011,  3285,  1829,
    1631,  1632,   397,  1496,   108,   410,  1224,   881,  1349,   115,
     605,  2556,  2118,   739,  1478,   411,  1349,  2472,  2473,  2561,
    1345,  1346,  3386,  1016,  2019,  1345,  1346,   858,  3227,  2265,
    2266,  1224,  1673,  1347,  1345,  1346,  1348,  2130,  3349,   109,
    3052,  1859,   397,  3053,  1923,  1924,  1347,  2078,  2000,  1348,
    1345,  1346,  1345,  1346,  3117,   496,  1347,  2474,   726,  1348,
    2350,  1345,  1346,  3157,  1349,  1345,  1346,   502,   507,  1673,
    1345,  1346,   834,   463,   508,  1347,  1349,  1347,  1348,  2475,
    1348, -2000,  1925,  3109,   606,  2636,  2637,  1345,  1346,  1345,
    1346,  1225,   959,  1347,  3361,  3362,  1348,  2894,  2895,  1349,
    3490,   397,  3491,  3272,  2866,  2867,  1347,  3228,  2948,  1348,
     708,  2476,  3220,  1349,  1479,   117,   397,   118,   429,  2273,
    2898,  2899,  1345,  1346,  2303,  3121,   442,  1349,   464,  1345,
    1346,   448,  2695,  1347,  2920,  2921,  1348,  1345,  1346,  1345,
    1346,  1347,  3229,   855,  1348,  1753, -1129,   511,  2945,  2946,
     740,  1347,  1345,  1346,  1348,   881,  1364,  1345,  1346,   446,
    3158,   975,   513,  3413,   409,  1345,  1346,  3221,   960,  1807,
     523,  1349,  2108,   728,   729,   397,   587,  2109,  1830,  1224,
     397,   397,  1787,   397,   525,  1497,   570,  2338,   397,  1349,
    3414, -2040,  3298,  3299,   397,  1349,   397,  1345,  1346,   110,
    1425,   397,   397,  1426,   397,  1347,  1427,   533,  1348,   961,
    3465,  3466,  1347,   632,   633,  1348,   397,  2136,  1860,   397,
    1347,   676,  1807,  1348,   962,   397,   397,   397,   397,  1881,
    1881, -1129,  1881,  2307,  2308,   397,   397,   397,  2357,  1310,
    2406,   591,  1345,  1346,  1903,  1349,   601,   990,  1807,  2021,
     632,   633,  2024,   397,  3418,  1002,  1914,   573,  1349,  1546,
    2973,  2036,   397,  1881,  1881,  1881,  2461,  2137,  1349,  1347,
    2044,  1347,  1348,   695,  1348,   696,  2944,  2887,   707,   397,
    2140,   850,  1347,   579,   708,  1348,   717,  1349,   976,  1349,
    2145,   397,   737,  1345,  1346,   106,  2370,   931,  2374,  2379,
    1345,  1346,  3159,   397,   934,  1349,   941,  3119,  2919,   397,
    2639,  2146, -1129,  3160,  1347, -1129,   958,  1348,  1349,  1974,
    -589,  2441,  2442,  1347,   956,   889,  1348,  2149,  1347,  1345,
    1346,  1348,  2497,  2498,  2985,  1345,  1346,  1992, -1129,  2477,
    2156,  3529,  2464,   965, -1129,  1349,   963,  2986,  2417,  2370,
    2443,   973,  3518,  1349,   974,  1831,  1347, -1129,   109,  1348,
     988,  1347, -1129,  1349,  1348,   989,  3591,  2157,   397, -1129,
    1347,  1832,   997,  1348,   580,  2161,   397,  3455,  1008, -1129,
    2676,  2677,  3013,  3014,  1042,  2163,  1347,  2987,  1347,  1348,
    3161,  1348, -1129,  3115,  1921,  1009, -1129,  1347,  1345,  1346,
    1348,  1347,  1042,   397,  1348, -1129,  1347,  1793,  1793,  1348,
    1638,  1345,  1346,  1345,  1346,  2761,  2762,  1349,  1345,  1346,
    1374,  1375,  1376,  1377,  1349,  1347,  1345,  1346,  1348,  1012,
   -1129,  1016,  1349,  1019,   397,   674,   675,   397,   678,  2164,
     581,  1345,  1346,  2011,  1013,   975,  2168,  1027,  1345,  1346,
    2835,  2762,  3088,  3089,  2169,   881,  1807,  1028,  1347,  1345,
    1346,  1348,  2111,  3168,  3169,  1347,  3139, -1129,  1348,  1639,
    1029,  1345,  1346,  1347,  2670,  1347,  1348,  2370,  1348,  1224,
    1034,  1349,  3033,  1349,  2370,  3036,  3037, -1129,  1347,  1345,
    1346,  1348,  1043,  1347,  1349, -1129,  1348,  3287,  3288,  3294,
    3296,  1347,  3054,  2178,  1348,  2182,  1641,  3363,  3288,  1923,
    1924,  1018,  1033,  1345,  1346, -1129,  2183, -1129,  1345,  1346,
    2715,  1048,  1345,  1346,  3433,  3434,  1349,  1049,  1345,  1346,
    1345,  1346,  1050,  1347,  1051,  1349,  1348,  1052,  1548,  1314,
    1349,  3436,  3288,  3437,  3288,  1045,  2033,  2673,  2185,  2717,
    1549,  1068,  1345,  1346,  1345,  1346,  1053,  2186,  1078, -1129,
     689,   690,  2190,   691,  3236,   692,  1079,  3241,  1349,  1092,
    1642,  1094,   976,  1349,  2666,  1142,  1143,  1095,  1347,  1097,
    2646,  1348,  1349,  3446,  3447,  3153,  1102,  1345,  1346, -1129,
    2193,  1107,  1500,  1132,  1113,  2194,  1123,   397,  1349, -1129,
    1349,  1345,  1346,  1170,  2206,  3261,  1345,  1346,  3263,  1349,
    1171,  1345,  1346,  1349,  1133,  1172,  1345,  1346,  1349,  2134,
    2708,  2144, -1129,  1174, -1129,  2633,  3448,  3449, -1129,  1347,
     398,  2220,  1348,  1345,  1346,  2227,  1347,  1349,  1124,  1348,
    2228,  1644,   428,  3450,  3449,   434, -1129,  3575,  3576,  2615,
    2693,  1161,   443, -1129,  1176,  1345,  1346,  3531,  3434,  2229,
    3532,  3434,   454, -1129,  1177,  1347,  1345,  1346,  1348, -1129,
    1349,  1347,   470,  1178,  1348,  1182, -1129,  1349,  3718,  3719,
   -1129,  1183, -1129, -1129,  2938,  1349,  1193,  1349,  1184, -1129,
    1345,  1346,  2232,  3364,  3365,  1195,  1153,  1154,   397, -1129,
    1349, -1129,  1197,  1345,  1346,  1349,  1198,  2237,  1199,  2240,
     489,  1550,  3643,  1349,  2977,  2978,   397,   397,  2954,  2955,
    1404,  1202,  2257,   397,  1200,   397,   397, -1129, -1129,  1201,
     492,   398, -1129,   398,  1347,  2864,  1203,  1348,  1204,  2751,
    1205,  3658,  3658,  1206,   489,  1349,  2754,  1347,  2034,  1347,
    1348, -1129,  1348,  1162,  1347,  1207,  1163,  1348,  3166,  3167,
    1208,  1209,  1347,   397,  1210,  1348,  3729,  2874,  3379,  1164,
    1211, -1129,  1212,  1345,  1346,   397,   397,  1347,  1410, -1129,
    1348,  1551,  1213,  1214,  1347,   397,  1215,  1348,  1216,  2370,
    1349,   397,  1219,  1221,   397,  1347,  3192,   397,  1348,  1222,
    1223, -1129,  1227,  1345,  1346,  1552,  1228,  1347,   397,   397,
    1348,   397,  2880,  1229,  1345,  1346,  1230,   397,   397,  1231,
    1232,  3234,  3235,  1655,  1233,  1347,  1638,   397,  1348,   397,
    1345,  1346,  1234,   397,   397,  1235,  1236,  1345,  1346,  3245,
    1237,  1349,  1238, -1129,  1239,  3248,  1240,  1241,  1349,  1347,
    1345,  1346,  1348,  1242,  1347,  2471,  1243,  1348,  1347,  1553,
    1244,  1348,  1245,  2889,  1347,  1246,  1347,  1348,  3264,  1348,
    2890,  3266,  1247, -1129,  1248,   397,   397,  1349,   685,  1345,
    1346,  1249,  1250,  1349,  1251,  1639,  1415,  1252,  1347,  1253,
    1347,  1348,  1254,  1348,  1345,  1346,  1165,  1418,  1255,  2912,
    1257,  1258,  1807,  2513,   397,  2922,  1345,  1346, -1129,  1259,
    1260,   397,  1261,  1345,  1346,  1262,  1263,  1264,  1345,  1346,
    1265,  1266,  1641,  1347,   397,  1270,  1348,  1271,  1272,  1273,
    1274,  3405,  3406,  3407,  3408,  1275,  1276,  1347,  1277,  1278,
    1348,  1554,  1347,  3400,  1279,  1348,  1349,  1347,  1280,  1281,
    1348,  1283,  1347, -1129,  1285,  1348,  3402,  1345,  1346,  1349,
    1286,  1349,  1345,  1346,  1345,  1346,  1349, -1129,  2924,  1347,
     397,  1287,  1348,  1288,  1349,  1345,  1346,  1345,  1346,  1166,
    1289,  2925,  2147, -1129,  1290, -1129,  1642,  1291,  3305,  1349,
    3325,  1347,  1292,  1293,  1348,  2148,  1349,  1294,  1295,  1345,
    1346,  1296,  1347,  1297,  1298,  1348,  1299,  1349,  1300,  1807,
    2167, -1129, -1129,  1345,  1346,  1301, -1129,  2181,  1302,  1349,
    1303,  1345,  1346,  1304,  1305,  1306,  1347,  1407,  2184,  1348,
    1345,  1346,  1345,  1346,  1307,  2982,  1408,  1349,  1308,  1347,
    2200,  1312,  1348,  1313,   536,  1345,  1346,  1316,  1317,  1321,
    1322,  2417,   397,  1419,   569,  1345,  1346,  1644,   577,  1323,
    1327,  1349,  1328,   489,  1329,  1330,  1349,  1331,   596,  1332,
    1349,  1345,  1346,  1406,  1420,  1422,  1349,   397,  1349,  1440,
    1423,   397,  2201,   397,   397,   397,   397,  2207,  3326,  3327,
     489,  2215,  3328,  3329,   397,  1345,  1346,  2216,   397,  2217,
    1349,   397,  1349,  1441,  3100,  1345,  1346,  1444,   697,  1347,
    1446,  1452,  1348,  1453,  1454,   397,   397,   397,   489,  1345,
    1346,  2225,  1903,  2226,   489,   535,  3104,   537,   397,   538,
     719,   540,   489,   489,   397,  1349,   397,   731,   577,  1347,
    1455,  1461,  1348,  1469,   397,  1475,  1484,   575,   758,  1349,
    1347,  1488,   763,  1348,  1349,  1504,  2233,   932,   933,  1349,
     398,   398,   577,   489,  1349,  1509,  1347,  1510,  1511,  1348,
    2243,  1512,  1514,  1347,  1807,  2248,  1348,  1345,  1346,  1523,
    2259,  1349,  1345,  1346,  1525,  2267,  1347,  1527,  1539,  1348,
    1603,  1127,  3702,  1604,   616,  1807,   980,  1605,  1606,  1607,
    1345,  1346,  2844,  1349,  1608,   397,  1345,  1346,  1226,  1311,
    1315,  1807,   489,  1609,  1349,  1347,   397,  1610,  1348,   397,
     577,   489,  3301,  3640,  2845,   489,  1345,  1346,  2646,  3702,
    1347,  1611,   489,  1348,  1612,  2846,  1613,  1614,  1349,  1655,
    1615,  1884,  1347,  1885,  1616,  1348,   940,  1617,  1618,  1347,
    1619,  1349,  1348,   397,  1347,  1620,  1621,  1348,  1622,  2861,
     397,  1626,   577,   397,  3381,  1628,  1630,   397,   397,  1345,
    1346,   397,  2869,  1661,  1931,  1932,  1933,  1402,  1673,   397,
    1638,  1666,  1695,  1320,  1715,  1729,  1746,   397,  1778,  1813,
    3191,  2764,  1804,  1347,  1345,  1346,  1348,  1819,  1347,  1839,
    1347,  1348,  1824,  1348,  1845,  1345,  1346,   617,  1861,  1872,
    1873,  1347,  1897,  1347,  1348,  2833,  1348,  1930,  1345,  1346,
    3731,  1349,  1112,  1956,  1944,  3181,  1900,  3377,  1982,  1958,
     577,  3731,  1965,   489,  1968,  1347,  1130,   489,  1348,  1639,
    3377,  1990,  2870,  1345,  1346,  1345,  1346,  1345,  1346,  1347,
    1991,  1349,  1348,  1994,  1997,  3731,  1995,  1347,  3250,  2005,
    1348,  3239,  1349,  1345,  1346,  2006,  1347,  2007,  1347,  1348,
    2008,  1348,  2873,  1345,  1346,  2009,  1641,  2010,  1349,  2011,
     489,  1347,  1192,  2875,  1348,  1349,   618,  3274,  2370,  1161,
    2028,  1347,  2029,  2031,  1348,  3451,  1345,  1346,  1349,  2878,
    1345,  1346,  1345,  1346,  1345,  1346,  2879,  1347,  2417,  2032,
    1348,  2037,  2039,  2040,  2045,  2059,  2099,  2110,  2112,  2881,
    1345,  1346,  1345,  1346,  1345,  1346,  2123,  1349,  1345,  1346,
    2116,  1347,  1345,  1346,  1348,  2143,  2125,  2126,   471,  2127,
    1642,  1347,  1349,  2128,  1348,  2292,  2133,  2135,  2882,  2357,
     397,   397,  2142,   397,  1349,  1347,  2644,  1018,  1348,  1983,
    2150,  1349,   397,  2883,  2151,   119,  1349,  2160,   397,  2162,
     402,   403,  2177,  2172,  2189,  2884,  1984,  2195,   397,  2280,
     472,  2199,  2892,  2196,  2306,  2203,   397,  2893,   441,  1985,
    2197,  1162,  2212,   447,  1163,  2213,  2214,   451,  2223,  2311,
    2234,  1377,   419,   397,  2246,  1349,  2235,  1164,  2236,  2242,
    1349,  1644,  1349,  1347,  2260,   397,  1348,  2247,  1347,  2309,
    2261,  1348,   397,  1349,  2262,  1349,  2896,  -793,  2982,   397,
    -970,  2903,  1342,  2904,  1344,   397,  1347,  2286,  2295,  1348,
    2319,  2310,  1347,  3503,  2905,  1348,  2906,  1349,  2850,  3387,
    3388,   473,  2855,  3606,  2312,  1361,  2467,   489,  3689,  2468,
    2321,  1349,  1347,   489,  1986,  1348,  1361,  2323,  2907,  1349,
    2313,  2324,  2325,  3522,  3523,  2329,  3525,   500,  1349,  2341,
    1349,  2342,  2908,  1937,  3194,  2370,  -340,   420,  2617,   711,
    2909,  2343,  2361,  1349,  3648,  2011,  2344,   721,   722,  2910,
    1433,  2911,  1436,  1349,   489,  1347,  1936,  2012,  1348,  2362,
    3753,  1056,   397,  2363,  2913,  2386,   489,   577,  3565,  1349,
    3566,  3567,  2387,  2390,  2914,   421,   489,   489,   939,  2394,
    1347,  2395,  2412,  1348,  1165,  3685,  2396,  1465,  2419,  1057,
    2917,  1347,  3690,  1349,  1348,  1474,  2420,   619,   620,   621,
     622,   623,   624,  1349,  1347,  2500,  1987,  1348,  3709,   398,
     398,   489,   489,   625,  2923,  2446,  2447,  1349,  2480,   398,
    3459,   577,  2494,  1541,  2926,  2499,  2495,   398,  1667,  1347,
    1058,  1347,  1348,  1347,  1348,  1059,  1348,   826,  2928,  2566,
    2501,  3456,  3736,  1655,  3737,  2533,  2553,  1010,  -340,  1347,
     489,  2576,  1348,  2588,  2589,  2608,  2013,  2626,  2620,  1347,
    2629,  2638,  1348,  2630,   397,  1361,  2645,  1166,   545,  2631,
    2632,  1988, -1024,  1352,  1353,  1349,  2653,  2658,  3511,  2664,
    1349,  2672,  1347,  2678,  2660,  1348,  1347,   397,  1347,  1348,
    1347,  1348,  1364,  1348,  2680,  1132,  2930,   489,  1349,  2675,
     489,  2932,   397,  1364,  1349,  2691,  1347,  2697,  1347,  1348,
    1347,  1348,  1354,  1348,  1347,  2692,  1133,  1348,  1347,  2933,
    2705,  1348,  2716,  2722,  1349,  2935,  1355,  2726,   -59,  3032,
     474,  2727,   422,  2730,  2742,  2743,  2756,  2822,  2826,  2832,
    2831,  2834,   546,   397,  2836,  2936,  2841,  2839,  1125,   577,
    2847,   577,   475,   398,   398,  1634,   489,   398,  2851,  2856,
    1356,  2857,  2858,  3056,  3057,   397,   763,  1349,  1668,  2859,
     547,  3060,  1357,  1361,  2304,  2860,  1982,   476,  3083,  2862,
    1060,  2863,  2868,  2871,   548,   397,  2872,  2876,  3145,  2877,
    2885,  3562,  1349,  2888,  2891,  2897,  2915,  2960,  2934,  1358,
    2941,  1638,  1702,  1349,  2950,  2462,   549,  2943,  2947,  2951,
     397,  3511,   397,  3146,  2962,  2964,  1349,  2975,   550,  1921,
    2983,  3614,  2991,   397,  3147,   397,  2992,  2995,  1366,  1367,
    2996,  2998,  3001,  3002,  3016,   477,  3021,  3297,   541,  1366,
    1367,  1349,  1702,  1349,  3020,  1349,  3022,   551,  3027,  1061,
    -340,  3278,  1364,   590,   423,  3084,  1359,  3034,  2370,   599,
    1639,  1349,  3300,  3092,  3304,  3087,  3306,  3614,  3101,   424,
    1127,  1349,   552,  3102,  3106,  3123,  2900,   397,   553,   681,
    3124,  3125,  3307,  3128,  3130,  3135,  3136,  1637,  3137,  3148,
    3150,  3164,  3310,  3152,  1349,   425,  3171,  1641,  1349,  3175,
    1349,  1808,  1349,  3169,  3177,   397,  3178,  1983,  1062,  3182,
     426,  3183,  2695,  3186,  3188,  3312,   577,   554,  1349,  3313,
    1349,  3314,  1349,  3315,  1984,   397,  1349,  3189,  3193,  3202,
    1349,   397,   397, -1058,  3204, -1063,  3208,  1985,  2014,  3316,
    3078,  3468,  3075,  3559,  3209,   397,  3061,  3744,  3233,  1361,
    1638,  3244,  1370,  1371,  1372,  1373,  1374,  1375,  1376,  1377,
    1364,  1642,   397,  1370,  1371,  1372,  1373,  1374,  1375,  1376,
    1377,  3744,  3254,  3255,  3256,   577,  3258,  3259,  1414,  3246,
    1866,  1867,  3265,   577,  3269,  3275,  3290,  3062,   577,  3276,
    3291,  3063,  3292,  1982,   489,  3717,  1877,   771,  3293,  3308,
     397,  1882,  1882,  3294,  1882,  -340,  3295,  3302,  1063,  1639,
    3303,   397,  1986,  3311,  3309,  3317,   489,  3318,  3333,   489,
    3320,  3321,  3342,  3322,  3345,   577,   577,   489,   489,  3346,
     555,  1447,  1644,  3348,  3064,  1882,  1882,  1882,  3351,  1064,
    3357,  1456,  3353,  1640,  3382,  3383,  1641,  3296,  3392,   556,
    3393,  3394,  3397,  1948,  3398,   557,  1361,  3404,  3411,  3410,
    3425,   558,  1959,  3211,  3427,  3430,  3432,  3435,  3452,  3453,
     794,  3454,  -560,  3463,  3464,  1557,  3477,  3479,  3467,  1967,
    3480,  3481,  1558,  3482,  3488,   559,  3497,  3469,  3505,  2490,
    3506,   489,  1559,  1560,  3507,  3513,  1366,  1367,  3517,  3524,
    3526,  3527,  3533,  1981,  1987,  2498,   560,   561,  3535,   489,
    1642,  3557,  3568,  -210,  1372,  1373,  1374,  1375,  1376,  1377,
    3586,   805,  1561,  3588,  1983,  3593,  1562,  3594,  3595,   807,
    3601,  -228, -1189,   397,   397,  3618,  1364,  1563,  3619,  3620,
    3638,  1984,  3629,   562,  3639,  3642,  1564,  3644,  3649,  1384,
    3650,  3651,  1565,   397,  2721,   397, -1803,   397,   397,  2224,
    3654,  -479,  3473,  3660,  3670,  1566,   822,  3680,  2065,  1988,
     397,  3681,  1361,  3682,  3684,  3687,  2069,  3688,  1643,  3691,
    1113,  1644,  3697,  1567,  3692,   771,  3703,  3696,  3708,   563,
    3710,   564,  1568,  1569,  3712,  3715,  3716,  3724,  1570,  3725,
     397,  1548,  3727,  2094,  3747,  2901,  1571,  2305,  2091,  3752,
    3590,  1120,  1572,  1549,  1655,  3277,  1559,  1560,  1791,  3280,
    1370,  1371,  1372,  1373,  1374,  1375,  1376,  1377,  3754,  1986,
     834,  3390,  3730,  1361,   489,  3554,  3735,  2114,  1573,  3667,
     397,  3625,  3668,  1364,  3634,  3659,  3633,  3284,  -465,  -465,
    1562,  3211,   524,  1388,  3508,   728,   729,  -465,   794,   397,
    3065,  1563,  3554,  3554,   397,  3108,  1625,  3066,  1645,  2058,
    1564,  3359,  1366,  1367,  1646,  2517,  1647,  1648,  1649,  1650,
    1651,  1652,  1653,  1654,  1574,   397,  1575,  2824,   850,  1566,
    3028,  2062,  2015,  1576,  2491,  3067,   397,  3251,  3023,  3085,
     854,   855,  2431,  2003,  1113,  3554,  3554,  1567,  3046,   805,
    1982,  3047,  3554,  3375,  3219,  2022,  2023,   807,  2025,  2026,
    2027,  1987,  3257,  2030,  3249,  3024,  2989,  3554,  2038,  3554,
    3495,  1660,  2041,  2042,  2043,  3554,  1572,  2046,  2047,  2048,
    2049,  2050,  3500,  2055,  2056,  2057,  1389,  3554,  3374,  3445,
    1392,  3396,  2524,  3380,   822,  1979,  3554,  3554,  1393,  1364,
    2481,  1577,  2326,  1655,   397,  1623,  1526,  3068,  1913,  2322,
    2663,  3554,  1109,  1131,  1550,   693,  1578,   397,  3554,  1366,
    1367,  1579,  1023,  2345,  3412,  1935,  1988,  3319,  3554,  3154,
    2997,  2550,  3494,  3155,  1745,  3554,  1794,  2281,  1372,  1373,
    1374,  1375,  1376,  1377,  1693,   397,  3026,   397,  3554,  2643,
    1575,  3554,  3356,  3554,  3662,   397,  1886,  1576,   834,  3344,
    1364,  1580,   397,  2352,  1394,  1439,   397,  1581,  1457,  2318,
    1582,  2332,  3554,  3173,  3008,  1887,   943,  2968,  2967,  3720,
     682,  1983,   397,  3560,  1551,  3554,   764,  3554,  1665,   397,
    3069,  1970,  1190,  1583,  1584,  1888,  1585,   668,  1984,  3554,
    3554,  2760,   881,  3554,  3212,   728,   729,  3213,  1552,  1889,
    1586,  1985,  1396,   397,  2961,  1459,   850,   887,  3613,  1559,
    1560,  3483,  3636,   889,  1874,  1577,   890,  3528,   854,   855,
    3734,  2971,  1587,  3253,  1473,  1366,  1367,  2713,  2339,  1982,
    1578,  1945,  3187,  1370,  1371,  1372,  1373,  1374,  1375,  1376,
    1377,  -465,  -465,  1562,  1890,  1891,  2358,  2360,  2993,  3347,
    -465,   944,  1553,   577,  1563,   577,   577,  1908,   612,  1464,
    1011,  1432,  3403,  1564,  2652,  3409,   614,   518,  3214,  3215,
    1629,   755,  1892,  1015,  2628,  1815,  1986,  2940,   519,   709,
    3105,  1581,  1566,  2512,  1582,     0,  1366,  1367,  3282,   752,
     753,  2854,   754,  1808,     0,     0,  3198,  1113,     0,     0,
    1567,     0,     0,     0,     0,   577,   577,  1583,  1584,   945,
    1585,     0,     0,     0,     0,  2065,  1588,     0,     0,   544,
     545,  2065,     0,     0,  2065,  1589,     0,  2065,  1397,  1572,
       0,  1893,     0,   946,  1554,     0,     0,     0,  2065,  2065,
    1399,   577,     0,     0,     0,     0,  1587,  2065,  1808,  1370,
    1371,  1372,  1373,  1374,  1375,  1376,  1377,   489,     0,   577,
    1983,     0,     0,  2065,  2486,     0,     0,     0,  1987,     0,
       0,     0,  1894,     0,     0,     0,     0,  1984,     0,     0,
     881,     0,  3212,     0,  -560,  3213,     0,     0,  -560,     0,
    1985,     0,   610,   545,   546,   887,     0,     0,     0,     0,
       0,   889,     0,  1575,   890,   489,  2065,     0,     0,     0,
    1576,  1371,  1372,  1373,  1374,  1375,  1376,  1377,     0,   947,
       0,     0,   547,     0,     0,     0,     0,   948,     0,     0,
       0,     0,     0,  1988,   577,     0,   548,     1,  2102,     0,
    1588,   577,     0,     0,     0,     0,     0,     2,     3,  1589,
       0,     0,     0,   912,  2557,   949,  3214,  3215,   549,     0,
       4,     0,     5,     0,     0,  1986,     0,   546,     0,     0,
     550,     0,     0,     0,     0,     0,     0,     0,  1577,     0,
       0,     6,     7,     0,     0,  3428,     0,     8,     0,     0,
       0,     9,    10,  1578,     0,   547,     0,     0,  3544,   551,
    1702,   950,     0,     0,    11,     0,   982,     0,  2522,   548,
       0,     0,     0,     0,     0,  2444,     0,  3030,  3031,     0,
       0,    12,   951,     0,   552,  2854,  2451,     0,  2854,  2854,
     553,   549,     0,     0,     0,     0,     0,     0,     0,   952,
      13,   118,     0,   550,  1581,  2854,     0,  1582,     0,    14,
      15,    16,     0,     0,     0,     0,     0,  1987,     0,  3059,
       0,     0,    17,    18,  3076,  3079,  3081,  3082,     0,   554,
    1583,  1584,   551,  1585,     0,  3611,     0,     0,     0,     0,
       0,     0,   577,     0,     0,    19,     0,     0,     0,     0,
    3628,  1638,  3628,     0,     0,     0,     0,   552,  3635,     0,
       0,     0,    20,   553,     0,     0,     0,  2651,     0,  1587,
       0,  1877,     0,   980,   577,   577,   577,     0,     0,     0,
       0,     0,  1988,     0,   489,     0,    21,     0,   577,     0,
       0,  1808,     0,    22,  3628,     0,    23,     0,  1139,  1361,
       0,  3679,   554,     0,     0,   577,   577,   577,     0,     0,
    1639,     0,     0,     0,     0,     0,     0,    24,  2694,     0,
       0,     0,     0,     0,  2696,     0,  2698,     0,     0,     0,
       0,  3628,     0,    25,   577,     0,  3628,     0,     0,     0,
       0,     0,   555,     0,     0,     0,     0,  1641,     0,     0,
       0,    26,     0,     0,     0,  3628,    27,     0,     0,     0,
       0,   556,     0,  1588,     0,     0,     0,   557,     0,     0,
       0,     0,  1589,   558,     0,     0,     0,     0,     0,     0,
       0,     0,  3628,  3628,     0,     0,  3751,     0,     0,     0,
       0,     0,     0,     0,     0,  2065,     0,   559,     0,     0,
       0,     0,  1362,     0,     0,     0,   577,  1256,     0,  2065,
       0,  1642,     0,     0,     0,   555,     0,     0,   560,   561,
       0,     0,     0,     0,     0,  1363,     0,     0,     0,  2103,
       0,     0,     0,  1282,   556,     0,     0,     0,     0,     0,
     557,     0,    28,   489,     0,     0,   558,     0,     0,     0,
    2763,     0,     0,   489,     0,   562,     0,  2819,  2820,     0,
       0,  2823,     0,     0,    29,     0,     0,     0,     0,  2830,
     559,     0,     0,    30,     0,     0,     0,   489,     0,  1643,
       0,     0,  1644,     0,  1333,     0,  1364,     0,  1340,     0,
       0,   560,   561,    31,     0,    32,    33,     0,     0,    34,
       0,   563,    35,   564,    36,   728,   729,     0,     0,    37,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
      39,     0,     0,     0,    40,     0,     0,     0,   562,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,    42,     0,     0,     0,    43,
    1140,  1141,  1142,  1143,  1144,  1145,     0,     0,  1146,  1147,
    1148,  1149,  1150,  1151,     0,  1152,     0,     0,  1365,    44,
       0,     0,     0,    45,   563,  1646,   564,  1647,  1648,  1649,
    1650,  1651,  1652,  1653,  1654,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1472,     0,     0,     0,     0,     0,    46,
       0,     0,  1487,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1366,  1367,     0,    47,     0,     0,    48,     0,
       0,  1368,     0,    49,     0,     0,     0,     0,     0,     0,
    2339,  2972,     0,   577,     0,     0,     0,     0,     0,     0,
       0,     0,   577,  1559,  1560,     0,    50,     0,  2651,     0,
       0,     0,     0,     0,  1655,     0,     0,     0,   577,     0,
       0,     0,     0,  1153,  1154,     0,  1948,    51,     0,     0,
       0,     0,     0,     0,     0,  -465,  -465,  1562,     0,     0,
       0,     0,     0,  1808,  -465,     0,     0,     0,  1563,     0,
       0,     0,     0,     0,     0,  2065,     0,  1564,     0,     0,
       0,     0,  2065,     0,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,  2065,  1566,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1113,     0,     0,  1567,  1369,  1370,  1371,  1372,  1373,
    1374,  1375,  1376,  1377,     0,  1380,  1381,  1382,  1383,  1384,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1572,     0,     0,     0,     0,  1670,  1671,
    1672,     0,     0,     0,     0,     0,     0,  1681,  1682,     0,
       0,  1685,     0,  1687,  1688,  1689,  1690,     0,     0,     0,
    1694,     0,  3113,  1696,  1697,     0,  1698,     0,  1699,  1700,
       0,  1703,  1704,  1705,  1706,  1707,     0,  1710,     0,  1712,
    1713,  1714,     0,  1716,  1717,  1718,  1719,     0,  1721,  1722,
       0,  1728,     0,     0,  1732,  1733,  1734,     0,  1736,  1737,
    1738,  1739,     0,  1741,  1742,  1743,  1744,  1575,     0,     0,
       0,     0,  1751,  1752,  1576,  1755,  1756,  1757,  1758,  1759,
    1385,  1386,  1387,  1388,  1763,     0,  1764,  1765,  1766,  1767,
    1768,     0,     0,  1771,  1773,  1774,  1775,  1776,  1777,     0,
    1779,  1780,     0,     0,     0,  1784,  1785,  1786,     0,  1789,
       0,  1790,     0,     0,     0,  1795,     0,  1799,  1800,     0,
       0,     0,     0,  1803,  3151,     0,     2,     3,     0,     0,
       0,  1810,  1811,  1812,     0,     0,     0,     0,     0,     4,
    1340,     0,  1577,  1820,     0,     0,     0,  1808,     0,     0,
    1825,  1826,  1827,     0,     0,     0,     0,  1578,     0,     0,
       6,     7,   577,     0,     0,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,     0,  1389,     0,  1390,  1391,
    1392,     0,     0,    11,     0,     0,     0,     0,  1393,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      12,     0,     0,  3113,     0,  1864,     0,     0,  1581,     0,
       0,  1582,     0,     0,     0,     0,     0,     0,     0,    13,
       0,     0,     0,     0,     0,   577,     0,     0,    14,    15,
      16,     0,     0,     0,  1583,  1584,     0,  1585,     0,     0,
       0,    17,    18,     0,     0,   577,     0,     0,     0,     0,
    1909,     0,     0,     0,  1394,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    19,     0,     0,     0,     0,     0,
    3267,     0,  3268,  1587,     0,     0,     0,     0,     0,     0,
       0,    20,     0,   489,     0,  2830,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1395,  1396,     0,     0,    21,     0,     0,     0,     0,
       0,     0,    22,     0,     0,    23,     0,  2765,  2766,     0,
       0,     0,     0,  2767,     0,  2768,     0,  2769,  2770,     0,
       0,     0,     0,     0,     0,     0,    24,  2358,     0,     0,
       0,     0,  2771,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    25,     0,  1559,  1560,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   577,     0,  1588,     0,     0,
      26,     0,     0,     0,     0,    27,  1589,     0,     0,     0,
       0,     0,     0,  2772,     0,  3355,  2773,     0,  1562,     0,
       0,  3113,  3113,     0,  2774,     0,     0,     0,     0,  1563,
       0,     0,     0,     0,     0,  3373,  2070,     0,  1564,     0,
       0,     0,     0,  2775,     0,     0,     0,     0,     0,     0,
       0,     0,   577,     0,     0,     0,     0,  1566,  1397,     0,
    2776,     0,     0,     0,     0,     0,     0,     0,     0,  1398,
    1399,     0,  1113,     0,     0,  1567,     0,     0,     0,     0,
       0,  2777,     0,  2778,     0,     0,     0,     0,     0,     0,
    3391,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3113,  2779,  2780,  1572,     0,     0,     0,     0,     0,
       0,     0,     0,    29,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    31,  2781,    32,    33,     0,     0,    34,     0,
       0,    35,     0,    36,     0,     0,     0,     0,    37,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,    39,
       0,     0,  2782,    40,     0,     0,     0,     0,  1575,     0,
       0,  2783,  2784,     0,  2785,  1576,     0,     0,     0,    41,
       0,     0,     0,     0,    42,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2786,  2787,  2788,     0,     0,     0,    44,     0,
       0,     0,    45,  1808,   489,     0,     0,  2250,  2252,  2254,
       0,     0,     0,  2789,  2790,  2791,     0,     0,     0,  2792,
       0,     0,  2793,  3355,  2268,  3355,     0,  3492,  2069,     0,
       0,     0,     0,  1577,     0,  2794,  2795,     0,    46,     0,
    3501,     0,     0,     0,     0,     0,     0,     0,  1578,     0,
    2287,     0,     0,     0,    47,     0,     0,    48,     0,     0,
       0,  2796,    49,  2797,     0,     0,     0,     0,     0,     0,
    3521,     0,  2299,     0,     0,     0,     0,  3556,     0,     0,
       0,     0,     0,     0,     0,    50,     0,  2798,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1581,
       0,     0,  1582,     0,  3556,  3556,    51,     0,     0,     0,
    1808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1583,  1584,     0,  1585,  3570,
       0,     0,     0,     0,  3577,     0,     0,     0,     0,     0,
    2799,     0,  2800,     0,     0,     0,     0,  3556,  3556,     0,
       0,     0,  2801,     0,  3556,   577,     0,     0,     0,     0,
       0,     0,     0,     0,  1587,     0,  3596,     0,     0,  3556,
       0,  3556,     0,     0,     0,     0,     0,  3556,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3556,
       0,     0,     0,     0,     0,     0,  2802,  2803,  3556,  3556,
    2804,  2805,  2806,  2807,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3556,     0,     0,     0,     0,     0,     0,
    3556,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3556,     0,     0,     0,  3664,     0,     0,  3556,     0,     0,
       0,     0,     0,  2808,  2809,     0,     0,  3677,     0,     0,
    3556,     0,     0,  3556,     0,  3556,     0,     0,  1588,     0,
       0,     0,  2810,     0,     0,     0,     0,  1589,     0,     0,
       0,     0,     0,     0,  3556,  1808,     0,  3705,     0,     0,
       0,     0,     0,     0,     0,  3713,     0,  3556,     0,  3556,
       0,     0,   577,     0,     0,     0,  1808,     0,     0,     0,
       0,  3556,  3556,     0,     0,  3556,     0,     0,     0,     0,
       0,     0,  1808,     0,     0,     0,     0,     0,     0,  3745,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2531,
       0,     0,  2532,     0,     0,  2534,  2535,     0,     0,     0,
       0,     0,     0,  3745,     0,     0,     0,     0,  2548,     0,
       0,  2551,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2558,     0,  2559,     0,     0,     0,
    2562,     0,  2563,  2564,     0,     0,     0,  2567,     0,  2568,
    2569,     0,  2570,     0,     0,  2571,     0,  2572,  2573,     0,
       0,     0,     0,  2577,  2578,     0,     0,  2580,     0,  2581,
       0,  2582,     0,  2583,     0,  2585,     0,     0,  1557,     0,
       0,     0,     0,     0,     0,  1558,  2590,  2591,     0,     0,
    2592,     0,  2593,     0,     0,  1559,  1560,     0,     0,     0,
    2594,  2595,     0,  2596,     0,  2597,     0,     0,  2598,  2599,
    2600,     0,  2601,     0,     0,     0,     0,     0,  2604,  2605,
    2606,  2607,     0,     0,     0,  1561,  2609,  2610,  2611,  1562,
    2612,     0,  2614,     0,  2616,     0,  2618,     0,  2619,     0,
    1563,     0,     0,     0,     0,  2621,     0,  2622,     0,  1564,
    2624,  2625,     0,     0,     0,  1565,     0,     0,     0,     0,
       0,  2634,   630,     0,   592,   631,     0,     0,  1566,     0,
       0,     0,     0,     0,     0,     0,  2641,     0,     0,     0,
       0,     0,     0,  1113,     0,     0,  1567,   632,   633,     0,
       0,     0,     0,     0,     0,  1568,  2659,   634,     0,   635,
       0,  1570,     0,     0,     0,     0,     0,     0,     0,  1571,
       0,     0,     0,     0,     0,  1572,     0,   636,     0,   637,
       0,     0,     0,     0,     0,     0,     0,   638,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1573,     0,     0,     0,  2703,     0,     0,     0,     0,
    2707,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1374,   639,     0,     0,     0,   640,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1575,
       0,     0,     0,     0,  2738,     0,  1576,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2741,   641,
       0,   642,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   643,     0,   644,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   645,   646,
       0,     0,   647,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1577,     0,     0,     0,     0,   648,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1578,
       0,     0,     0,     0,  1579,     0,     0,     0,     0,     0,
     649,     0,     0,     0,     0,   650,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2843,     0,     0,     0,     0,     0,     0,     0,   651,
       0,     0,     0,     0,  1580,     0,     0,     0,     0,     0,
    1581,     0,     0,  1582,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   652,     0,     0,     0,  1583,  1584,     0,  1585,
       0,   653,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1586,     0,     0,     0,     0,     0,   654,
       0,     0,     0,     0,  2916,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2927,  1587,  2929,     0,  2931,     0,
       0,     0,     0,     0,  2937,   655,   656,     0,     0,   657,
     658,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2949,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   659,     0,     0,     0,     0,   660,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   661,     0,  1588,
       0,     0,     0,     0,     0,  2994,     0,     0,  1589,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1828,     0,
       0,     0,   662,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   663,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1828,     0,     0,     0,   664,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3122,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3126,     0,     0,     0,     0,
       0,  3127,     0,     0,     0,     0,     0,     0,     0,     0,
    3131,  3132,     0,     0,     0,     0,  3133,     0,     0,     0,
    3134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3138,     0,     0,     0,     0,     0,  3140,
       0,     0,  3141,  3142,     0,  3143,  3144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3200,  3201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2738,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2738,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2703,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3399,     0,     0,     0,     0,     0,  3401,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3417,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3429,     0,  3431,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2738,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3516,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3530,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3599,
    3600,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3621,
       0,     0,     0,     0,     0,     0,     0,     0,  3631,     0,
       0,     0,     0,     0,     0,  3637,     0,     0,     0,     0,
       0,     0,     0,     0,  3647,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   122,     0,   765,   124,   125,
     126,   127,     0,  3671,     0,     0,     0,   128,     0,     0,
     766,     0,   767,   130,   131,   768,   133,  3686,   134,   769,
     135,     0,   770,   136,   771,   772,   773,   137,   774,     0,
     138,   139,   140,  1796,   141,     0,   142,   143,     0,     0,
     144,   775,   145,     0,   146,   776,   777,   148,     0,   149,
     150,   151,   778,   152,     0,   779,   154,     0,   155,   156,
     157,   158,   159,   780,   781,   160,     0,   161,   162,     0,
     782,   164,     0,   783,   784,   785,   165,     0,  3746,   166,
     786,   787,     0,   788,   789,     0,   167,   168,   790,   791,
     792,     0,     0,     0,     0,   793,   171,   794,     0,     0,
     795,   796,   172,     0,   173,     0,     0,     0,   797,   798,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   799,   182,     0,   800,
     801,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   802,     0,   191,   803,   192,   804,   805,   193,
     194,     0,   806,   195,   196,   197,   807,     0,   198,     0,
       0,   808,     0,   199,   200,     0,   809,   201,     0,   202,
     810,   811,   812,   813,     0,   814,   815,   204,   816,   817,
     818,   206,     0,   207,   819,     0,   820,   821,     0,   208,
     209,     0,   210,   822,     0,   211,     0,     0,     0,   823,
     213,   214,   215,   824,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   825,   219,   826,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   827,   226,     0,  1797,   828,   227,     0,   829,
     228,     0,     0,     0,   830,     0,   831,     0,   230,   832,
       0,   231,     0,   232,   833,     0,     0,   834,     0,     0,
       0,     0,   835,   233,   234,   235,   236,   237,   238,   836,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   837,
     248,   249,   250,   838,   251,   252,     0,     0,     0,   253,
     254,   255,   839,   257,     0,     0,   840,   259,   841,   842,
     260,     0,   261,   843,   844,   845,   846,   847,   848,   849,
     266,   267,   268,   269,     0,   850,   270,   271,     0,   272,
     273,   274,   851,   852,   853,   275,     0,   854,   855,     0,
     276,   277,     0,   856,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   857,   858,   286,   859,   860,   861,   862,   863,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     864,   297,   298,   299,   300,   301,   302,   303,   865,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   866,   867,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   868,   318,   319,   869,
     320,   321,   870,   322,   871,   324,   325,     0,   872,   327,
       0,   328,   873,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,   874,   875,   355,
     356,     0,   357,   876,   359,   877,   878,   879,   360,   361,
     362,   363,   880,   364,   365,     0,   366,   367,     0,   881,
     368,   882,   883,   884,   885,     0,     0,     0,     0,  1798,
     373,     0,   374,   886,   887,   888,   376,   377,   378,     0,
     889,   379,   380,   890,     0,   381,     0,     0,   891,   892,
     382,     0,     0,   383,     0,   384,     0,   893,   386,     0,
       0,   894,   895,   896,   897,   898,   387,     0,     0,   388,
     899,     0,   389,   390,   900,     0,     0,     0,     0,   392,
       0,   393,   394,     0,   901,     0,   902,     0,     0,     0,
       0,   903,     0,     0,     0,   904,   905,     0,     0,     0,
       0,   906,     0,   907,     0,     0,   908,   909,     0,     0,
     910,   911,   122,     0,   765,   124,   125,   126,   127,  2699,
       0,     0,     0,     0,   128,     0,     0,   766,     0,   767,
     130,   131,   768,   133,     0,   134,   769,   135,     0,  2700,
     136,   771,   772,   773,   137,   774,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   775,   145,
       0,   146,   776,   777,   148,     0,   149,   150,   151,   778,
     152,     0,   779,   154,     0,   155,   156,   157,   158,   159,
     780,   781,   160,     0,   161,   162,     0,   782,   164,     0,
     783,   784,   785,   165,     0,     0,   166,   786,   787,     0,
     788,   789,     0,   167,   168,   790,   791,   792,     0,     0,
       0,     0,   793,   171,   794,     0,     0,   795,  2701,   172,
       0,   173,     0,     0,     0,   797,   798,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   799,   182,     0,   800,   801,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   802,
       0,   191,   803,   192,   804,   805,   193,   194,     0,   806,
     195,   196,   197,   807,     0,   198,     0,     0,   808,     0,
     199,   200,     0,   809,   201,     0,   202,   810,   811,   812,
     813,     0,   814,   815,   204,   816,   817,   818,   206,     0,
     207,   819,     0,   820,   821,     0,   208,   209,     0,   210,
     822,     0,   211,     0,     0,     0,   823,   213,   214,   215,
     824,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     825,   219,   826,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   827,
     226,     0,     0,   828,   227,     0,   829,   228,     0,     0,
       0,   830,     0,   831,     0,   230,   832,     0,   231,     0,
     232,   833,     0,     0,   834,     0,     0,     0,     0,   835,
     233,   234,   235,   236,   237,   238,   836,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   837,   248,   249,   250,
     838,   251,   252,     0,     0,     0,   253,   254,   255,   839,
     257,     0,     0,   840,   259,   841,   842,   260,     0,   261,
     843,   844,   845,   846,   847,   848,   849,   266,   267,   268,
     269,     0,   850,   270,   271,     0,   272,   273,   274,   851,
     852,   853,   275,     0,   854,   855,     0,   276,   277,     0,
     856,  2702,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   857,   858,
     286,   859,   860,   861,   862,   863,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   864,   297,   298,
     299,   300,   301,   302,   303,   865,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   866,   867,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   868,   318,   319,   869,   320,   321,   870,
     322,   871,   324,   325,     0,   872,   327,     0,   328,   873,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,   874,   875,   355,   356,     0,   357,
     876,   359,   877,   878,   879,   360,   361,   362,   363,   880,
     364,   365,     0,   366,   367,     0,   881,   368,   882,   883,
     884,   885,     0,     0,     0,     0,     0,   373,     0,   374,
     886,   887,   888,   376,   377,   378,     0,   889,   379,   380,
     890,     0,   381,     0,     0,   891,   892,   382,     0,     0,
     383,     0,   384,     0,   893,   386,     0,     0,   894,   895,
     896,   897,   898,   387,     0,     0,   388,   899,     0,   389,
     390,   900,     0,     0,     0,     0,   392,     0,   393,   394,
       0,   901,     0,   902,     0,     0,     0,     0,   903,     0,
       0,     0,   904,   905,     0,     0,     0,     0,   906,     0,
     907,     0,     0,   908,   909,     0,     0,   910,   911,   122,
       0,   765,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   766,     0,   767,   130,   131,   768,
     133,     0,   134,   769,   135,     0,   770,   136,   771,   772,
     773,   137,   774,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   775,   145,     0,   146,   776,
     777,   148,     0,   149,   150,   151,   778,   152,     0,   779,
     154,     0,   155,   156,   157,   158,   159,   780,   781,   160,
       0,   161,   162,     0,   782,   164,     0,   783,   784,   785,
     165,     0,     0,   166,   786,   787,     0,   788,   789,     0,
     167,   168,   790,   791,   792,     0,     0,     0,     0,   793,
     171,   794,     0,     0,   795,   796,   172,     0,   173,     0,
       0,     0,   797,   798,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     799,   182,     0,   800,   801,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   802,     0,   191,   803,
     192,   804,   805,   193,   194,     0,   806,   195,   196,   197,
     807,     0,   198,     0,     0,   808,     0,   199,   200,     0,
     809,   201,     0,   202,   810,   811,   812,   813,     0,   814,
     815,   204,   816,   817,   818,   206,     0,   207,   819,     0,
     820,   821,     0,   208,   209,     0,   210,   822,     0,   211,
       0,     0,     0,   823,   213,   214,   215,   824,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   825,   219,   826,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   827,   226,     0,     0,
     828,   227,     0,   829,   228,     0,     0,     0,   830,     0,
     831,     0,   230,   832,     0,   231,     0,   232,   833,     0,
       0,   834,     0,     0,     0,     0,   835,   233,   234,   235,
     236,   237,   238,   836,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   837,   248,   249,   250,   838,   251,   252,
       0,     0,     0,   253,   254,   255,   839,   257,     0,     0,
     840,   259,   841,   842,   260,     0,   261,   843,   844,   845,
     846,   847,   848,   849,   266,   267,   268,   269,     0,   850,
     270,   271,     0,   272,   273,   274,   851,   852,   853,   275,
       0,   854,   855,     0,   276,   277,     0,   856,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   857,   858,   286,   859,   860,
     861,   862,   863,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   864,   297,   298,   299,   300,   301,
     302,   303,   865,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   866,   867,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     868,   318,   319,   869,   320,   321,   870,   322,   871,   324,
     325,     0,   872,   327,  1338,   328,   873,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,   874,   875,   355,   356,     0,   357,   876,   359,   877,
     878,   879,   360,   361,   362,   363,   880,   364,   365,     0,
     366,   367,     0,   881,   368,   882,   883,   884,   885,     0,
       0,     0,     0,     0,   373,     0,   374,   886,   887,   888,
     376,   377,   378,     0,   889,   379,   380,   890,     0,   381,
       0,     0,   891,   892,   382,     0,     0,   383,     0,   384,
       0,   893,   386,     0,     0,   894,   895,   896,   897,   898,
     387,     0,     0,   388,   899,     0,   389,   390,   900,     0,
       0,     0,     0,   392,     0,   393,   394,     0,   901,     0,
     902,     0,     0,     0,     0,   903,     0,     0,     0,   904,
     905,     0,     0,     0,     0,   906,     0,  1339,     0,     0,
     908,   909,     0,     0,   910,   911,   122,     0,   765,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   766,     0,   767,   130,   131,   768,   133,     0,   134,
     769,   135,     0,   770,   136,   771,   772,   773,   137,   774,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   775,   145,     0,   146,   776,   777,   148,     0,
     149,   150,   151,   778,   152,     0,   779,   154,     0,   155,
     156,   157,   158,   159,   780,   781,   160,     0,   161,   162,
       0,   782,   164,     0,   783,   784,   785,   165,     0,     0,
     166,   786,   787,     0,   788,   789,     0,   167,   168,   790,
     791,   792,     0,     0,     0,     0,   793,   171,   794,     0,
       0,   795,   796,   172,     0,   173,     0,     0,     0,   797,
     798,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   799,   182,     0,
     800,   801,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   802,     0,   191,   803,   192,   804,   805,
     193,   194,     0,   806,   195,   196,   197,   807,     0,   198,
       0,     0,   808,     0,   199,   200,     0,   809,   201,     0,
     202,   810,   811,   812,   813,     0,   814,   815,   204,   816,
     817,   818,   206,     0,   207,   819,     0,   820,   821,     0,
     208,   209,     0,   210,   822,     0,   211,     0,     0,     0,
     823,   213,   214,   215,   824,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   825,   219,   826,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   827,   226,     0,     0,   828,   227,     0,
     829,   228,     0,     0,     0,   830,     0,   831,     0,   230,
     832,     0,   231,     0,   232,   833,     0,     0,   834,     0,
       0,     0,     0,   835,   233,   234,   235,   236,   237,   238,
     836,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     837,   248,   249,   250,   838,   251,   252,     0,     0,     0,
     253,   254,   255,   839,   257,     0,     0,   840,   259,   841,
     842,   260,     0,   261,   843,   844,   845,   846,   847,   848,
     849,   266,   267,   268,   269,     0,   850,   270,   271,     0,
     272,   273,   274,   851,   852,   853,   275,     0,   854,   855,
       0,   276,   277,     0,   856,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   857,   858,   286,   859,   860,   861,   862,   863,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   864,   297,   298,   299,   300,   301,   302,   303,   865,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   866,   867,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   868,   318,   319,
     869,   320,   321,   870,   322,   871,   324,   325,     0,   872,
     327,     0,   328,   873,   330,   331,   332,   333,   334,   335,
     336,   337,     0,     0,   338,   339,   340,     0,     0,   341,
       0,     0,     0,   342,   343,   344,   345,     0,   346,   347,
     348,     0,     0,     0,     0,     0,     0,   349,   350,     0,
     351,     0,     0,   352,     0,     0,   353,   354,   874,   875,
     355,   356,     0,   357,   876,   359,   877,   878,   879,   360,
     361,   362,   363,   880,   364,   365,     0,   366,   367,     0,
     881,   368,   882,   883,   884,   885,     0,     0,     0,     0,
       0,   373,     0,   374,   886,   887,   888,   376,   377,   378,
       0,   889,   379,   380,   890,     0,   381,     0,     0,   891,
     892,   382,     0,     0,   383,     0,   384,     0,   893,   386,
       0,     0,   894,   895,   896,   897,   898,   387,     0,     0,
     388,   899,     0,   389,   390,   900,     0,     0,     0,     0,
     392,     0,   393,   394,     0,   901,     0,   902,     0,     0,
       0,     0,   903,     0,     0,     0,   904,   905,     0,     0,
       0,     0,   906,     0,   907,  1626,     0,   908,   909,     0,
       0,   910,   911,   122,     0,   765,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   766,     0,
     767,   130,   131,   768,   133,     0,   134,   769,   135,     0,
     770,   136,   771,   772,   773,   137,   774,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   775,
     145,     0,   146,   776,   777,   148,     0,   149,   150,   151,
     778,   152,     0,   779,   154,     0,   155,   156,   157,   158,
     159,   780,   781,   160,     0,   161,   162,     0,   782,   164,
       0,   783,   784,   785,   165,     0,     0,   166,   786,   787,
       0,   788,   789,     0,   167,   168,   790,   791,   792,     0,
       0,     0,     0,   793,   171,   794,     0,     0,   795,   796,
     172,     0,   173,     0,     0,     0,   797,   798,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   799,   182,     0,   800,   801,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     802,     0,   191,   803,   192,   804,   805,   193,   194,     0,
     806,   195,   196,   197,   807,     0,   198,     0,     0,   808,
       0,   199,   200,     0,   809,   201,     0,   202,   810,   811,
     812,   813,     0,   814,   815,   204,   816,   817,   818,   206,
       0,   207,   819,     0,   820,   821,     0,   208,   209,     0,
     210,   822,     0,   211,     0,     0,     0,   823,   213,   214,
     215,   824,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   825,   219,   826,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     827,   226,     0,     0,   828,   227,     0,   829,   228,     0,
       0,     0,   830,     0,   831,     0,   230,   832,     0,   231,
       0,   232,   833,     0,     0,   834,     0,     0,     0,     0,
     835,   233,   234,   235,   236,   237,   238,   836,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   837,   248,   249,
     250,   838,   251,   252,     0,     0,     0,   253,   254,   255,
     839,   257,     0,     0,   840,   259,   841,   842,   260,     0,
     261,   843,   844,   845,   846,   847,   848,   849,   266,   267,
     268,   269,     0,   850,   270,   271,     0,   272,   273,   274,
     851,   852,   853,   275,     0,   854,   855,     0,   276,   277,
       0,   856,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   857,
     858,   286,   859,   860,   861,   862,   863,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   864,   297,
     298,   299,   300,   301,   302,   303,   865,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   866,   867,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   868,   318,   319,   869,   320,   321,
     870,   322,   871,   324,   325,     0,   872,   327,     0,   328,
     873,   330,   331,   332,   333,   334,   335,   336,   337,     0,
       0,   338,   339,   340,     0,     0,   341,     0,     0,     0,
     342,   343,   344,   345,     0,   346,   347,   348,     0,     0,
       0,     0,     0,     0,   349,   350,     0,   351,     0,     0,
     352,     0,     0,   353,   354,   874,   875,   355,   356,     0,
     357,   876,   359,   877,   878,   879,   360,   361,   362,   363,
     880,   364,   365,     0,   366,   367,     0,   881,   368,   882,
     883,   884,   885,     0,     0,     0,     0,     0,   373,     0,
     374,   886,   887,   888,   376,   377,   378,     0,   889,   379,
     380,   890,     0,   381,     0,     0,   891,   892,   382,     0,
       0,   383,     0,   384,     0,   893,   386,     0,     0,   894,
     895,   896,   897,   898,   387,     0,     0,   388,   899,     0,
     389,   390,   900,     0,     0,     0,     0,   392,     0,   393,
     394,     0,   901,     0,   902,     0,     0,     0,     0,   903,
       0,     0,     0,   904,   905,     0,     0,     0,     0,   906,
       0,   907,  1735,     0,   908,   909,     0,     0,   910,   911,
     122,     0,   765,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   766,     0,   767,   130,   131,
     768,   133,     0,   134,   769,   135,     0,   770,   136,   771,
     772,   773,   137,   774,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   775,   145,     0,   146,
     776,   777,   148,     0,   149,   150,   151,   778,   152,     0,
     779,   154,     0,   155,   156,   157,   158,   159,   780,   781,
     160,     0,   161,   162,     0,   782,   164,     0,   783,   784,
     785,   165,     0,     0,   166,   786,   787,     0,   788,   789,
       0,   167,   168,   790,   791,   792,     0,     0,     0,     0,
     793,   171,   794,     0,     0,   795,   796,   172,     0,   173,
       0,     0,     0,   797,   798,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   799,   182,     0,   800,   801,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   802,     0,   191,
     803,   192,   804,   805,   193,   194,     0,   806,   195,   196,
     197,   807,     0,   198,     0,     0,   808,     0,   199,   200,
       0,   809,   201,     0,   202,   810,   811,   812,   813,     0,
     814,   815,   204,   816,   817,   818,   206,     0,   207,   819,
       0,   820,   821,     0,   208,   209,     0,   210,   822,     0,
     211,     0,     0,     0,   823,   213,   214,   215,   824,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   825,   219,
     826,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   827,   226,     0,
       0,   828,   227,     0,   829,   228,     0,     0,     0,   830,
       0,   831,     0,   230,   832,     0,   231,     0,   232,   833,
       0,     0,   834,     0,     0,     0,     0,   835,   233,   234,
     235,   236,   237,   238,   836,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   837,   248,   249,   250,   838,   251,
     252,     0,     0,     0,   253,   254,   255,   839,   257,     0,
       0,   840,   259,   841,   842,   260,     0,   261,   843,   844,
     845,   846,   847,   848,   849,   266,   267,   268,   269,     0,
     850,   270,   271,     0,   272,   273,   274,   851,   852,   853,
     275,     0,   854,   855,     0,   276,   277,     0,   856,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   857,   858,   286,   859,
     860,   861,   862,   863,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   864,   297,   298,   299,   300,
     301,   302,   303,   865,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   866,
     867,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   868,   318,   319,   869,   320,   321,   870,   322,   871,
     324,   325,     0,   872,   327,     0,   328,   873,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,   874,   875,   355,   356,     0,   357,   876,   359,
     877,   878,   879,   360,   361,   362,   363,   880,   364,   365,
       0,   366,   367,     0,   881,   368,   882,   883,   884,   885,
       0,     0,     0,     0,     0,   373,     0,   374,   886,   887,
     888,   376,   377,   378,     0,   889,   379,   380,   890,     0,
     381,     0,     0,   891,   892,   382,     0,     0,   383,     0,
     384,     0,   893,   386,     0,     0,   894,   895,   896,   897,
     898,   387,     0,     0,   388,   899,     0,   389,   390,   900,
       0,     0,     0,     0,   392,     0,   393,   394,     0,   901,
       0,   902,     0,     0,     0,     0,   903,     0,     0,     0,
     904,   905,     0,     0,     0,     0,   906,     0,   907,  1772,
       0,   908,   909,     0,     0,   910,   911,   122,     0,   765,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   766,     0,   767,   130,   131,   768,   133,     0,
     134,   769,   135,     0,   770,   136,   771,   772,   773,   137,
     774,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   775,   145,     0,   146,   776,   777,   148,
       0,   149,   150,   151,   778,   152,     0,   779,   154,     0,
     155,   156,   157,   158,   159,   780,   781,   160,     0,   161,
     162,     0,   782,   164,     0,   783,   784,   785,   165,     0,
       0,   166,   786,   787,     0,   788,   789,     0,   167,   168,
     790,   791,   792,     0,     0,     0,     0,   793,   171,   794,
       0,     0,   795,   796,   172,     0,   173,     0,     0,     0,
     797,   798,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   799,   182,
       0,   800,   801,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   802,     0,   191,   803,   192,   804,
     805,   193,   194,     0,   806,   195,   196,   197,   807,     0,
     198,     0,     0,   808,     0,   199,   200,     0,   809,   201,
       0,   202,   810,   811,   812,   813,     0,   814,   815,   204,
     816,   817,   818,   206,     0,   207,   819,     0,   820,   821,
       0,   208,   209,     0,   210,   822,     0,   211,     0,     0,
       0,   823,   213,   214,   215,   824,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   825,   219,   826,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   827,   226,     0,     0,   828,   227,
       0,   829,   228,     0,     0,     0,   830,     0,   831,     0,
     230,   832,     0,   231,     0,   232,   833,     0,     0,   834,
       0,     0,     0,     0,   835,   233,   234,   235,   236,   237,
     238,   836,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   837,   248,   249,   250,   838,   251,   252,     0,     0,
       0,   253,   254,   255,   839,   257,     0,     0,   840,   259,
     841,   842,   260,     0,   261,   843,   844,   845,   846,   847,
     848,   849,   266,   267,   268,   269,     0,   850,   270,   271,
       0,   272,   273,   274,   851,   852,   853,   275,     0,   854,
     855,     0,   276,   277,     0,   856,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   857,   858,   286,   859,   860,   861,   862,
     863,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   864,   297,   298,   299,   300,   301,   302,   303,
     865,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   866,   867,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   868,   318,
     319,   869,   320,   321,   870,   322,   871,   324,   325,     0,
     872,   327,     0,   328,   873,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,     0,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,   874,
     875,   355,   356,     0,   357,   876,   359,   877,   878,   879,
     360,   361,   362,   363,   880,   364,   365,     0,   366,   367,
       0,   881,   368,   882,   883,   884,   885,     0,     0,     0,
       0,     0,   373,     0,   374,   886,   887,   888,   376,   377,
     378,     0,   889,   379,   380,   890,     0,   381,     0,     0,
     891,   892,   382,     0,     0,   383,     0,   384,     0,   893,
     386,     0,     0,   894,   895,   896,   897,   898,   387,     0,
       0,   388,   899,     0,   389,   390,   900,     0,     0,     0,
       0,   392,     0,   393,   394,     0,   901,     0,   902,     0,
       0,     0,     0,   903,     0,     0,     0,   904,   905,     0,
       0,     0,     0,   906,     0,   907,  1802,     0,   908,   909,
       0,     0,   910,   911,   122,     0,   765,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   766,
       0,   767,   130,   131,   768,   133,     0,   134,   769,   135,
       0,   770,   136,   771,   772,   773,   137,   774,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
     775,   145,     0,   146,   776,   777,   148,     0,   149,   150,
     151,   778,   152,     0,   779,   154,     0,   155,   156,   157,
     158,   159,   780,   781,   160,     0,   161,   162,     0,   782,
     164,     0,   783,   784,   785,   165,     0,     0,   166,   786,
     787,     0,   788,   789,     0,   167,   168,   790,   791,   792,
       0,     0,     0,     0,   793,   171,   794,     0,     0,   795,
     796,   172,     0,   173,     0,     0,     0,   797,   798,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,   799,   182,     0,   800,   801,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,   802,     0,   191,   803,   192,   804,   805,   193,   194,
       0,   806,   195,   196,   197,   807,     0,   198,     0,     0,
     808,     0,   199,   200,  2249,   809,   201,     0,   202,   810,
     811,   812,   813,     0,   814,   815,   204,   816,   817,   818,
     206,     0,   207,   819,     0,   820,   821,     0,   208,   209,
       0,   210,   822,     0,   211,     0,     0,     0,   823,   213,
     214,   215,   824,     0,   216,   217,     0,     0,     0,   218,
       0,     0,   825,   219,   826,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,   827,   226,     0,     0,   828,   227,     0,   829,   228,
       0,     0,     0,   830,     0,   831,     0,   230,   832,     0,
     231,     0,   232,   833,     0,     0,   834,     0,     0,     0,
       0,   835,   233,   234,   235,   236,   237,   238,   836,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   837,   248,
     249,   250,   838,   251,   252,     0,     0,     0,   253,   254,
     255,   839,   257,     0,     0,   840,   259,   841,   842,   260,
       0,   261,   843,   844,   845,   846,   847,   848,   849,   266,
     267,   268,   269,     0,   850,   270,   271,     0,   272,   273,
     274,   851,   852,   853,   275,     0,   854,   855,     0,   276,
     277,     0,   856,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     857,   858,   286,   859,   860,   861,   862,   863,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   864,
     297,   298,   299,   300,   301,   302,   303,   865,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,   866,   867,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,   868,   318,   319,   869,   320,
     321,   870,   322,   871,   324,   325,     0,   872,   327,     0,
     328,   873,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,   874,   875,   355,   356,
       0,   357,   876,   359,   877,   878,   879,   360,   361,   362,
     363,   880,   364,   365,     0,   366,   367,     0,   881,   368,
     882,   883,   884,   885,     0,     0,     0,     0,     0,   373,
       0,   374,   886,   887,   888,   376,   377,   378,     0,   889,
     379,   380,   890,     0,   381,     0,     0,   891,   892,   382,
       0,     0,   383,     0,   384,     0,   893,   386,     0,     0,
     894,   895,   896,   897,   898,   387,     0,     0,   388,   899,
       0,   389,   390,   900,     0,     0,     0,     0,   392,     0,
     393,   394,     0,   901,     0,   902,     0,     0,     0,     0,
     903,     0,     0,     0,   904,   905,     0,     0,     0,     0,
     906,     0,   907,     0,     0,   908,   909,     0,     0,   910,
     911,   122,     0,   765,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   766,     0,   767,   130,
     131,   768,   133,     0,   134,   769,   135,     0,   770,   136,
     771,   772,   773,   137,   774,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   775,   145,     0,
     146,   776,   777,   148,     0,   149,   150,   151,   778,   152,
       0,   779,   154,     0,   155,   156,   157,   158,   159,   780,
     781,   160,     0,   161,   162,     0,   782,   164,     0,   783,
     784,   785,   165,     0,     0,   166,   786,   787,     0,   788,
     789,     0,   167,   168,   790,   791,   792,     0,     0,     0,
       0,   793,   171,   794,     0,     0,   795,   796,   172,     0,
     173,     0,     0,     0,   797,   798,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   799,   182,     0,   800,   801,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   802,     0,
     191,   803,   192,   804,   805,   193,   194,     0,   806,   195,
     196,   197,   807,     0,   198,     0,     0,   808,     0,   199,
     200,  2251,   809,   201,     0,   202,   810,   811,   812,   813,
       0,   814,   815,   204,   816,   817,   818,   206,     0,   207,
     819,     0,   820,   821,     0,   208,   209,     0,   210,   822,
       0,   211,     0,     0,     0,   823,   213,   214,   215,   824,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   825,
     219,   826,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   827,   226,
       0,     0,   828,   227,     0,   829,   228,     0,     0,     0,
     830,     0,   831,     0,   230,   832,     0,   231,     0,   232,
     833,     0,     0,   834,     0,     0,     0,     0,   835,   233,
     234,   235,   236,   237,   238,   836,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   837,   248,   249,   250,   838,
     251,   252,     0,     0,     0,   253,   254,   255,   839,   257,
       0,     0,   840,   259,   841,   842,   260,     0,   261,   843,
     844,   845,   846,   847,   848,   849,   266,   267,   268,   269,
       0,   850,   270,   271,     0,   272,   273,   274,   851,   852,
     853,   275,     0,   854,   855,     0,   276,   277,     0,   856,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   857,   858,   286,
     859,   860,   861,   862,   863,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   864,   297,   298,   299,
     300,   301,   302,   303,   865,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     866,   867,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   868,   318,   319,   869,   320,   321,   870,   322,
     871,   324,   325,     0,   872,   327,     0,   328,   873,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,   874,   875,   355,   356,     0,   357,   876,
     359,   877,   878,   879,   360,   361,   362,   363,   880,   364,
     365,     0,   366,   367,     0,   881,   368,   882,   883,   884,
     885,     0,     0,     0,     0,     0,   373,     0,   374,   886,
     887,   888,   376,   377,   378,     0,   889,   379,   380,   890,
       0,   381,     0,     0,   891,   892,   382,     0,     0,   383,
       0,   384,     0,   893,   386,     0,     0,   894,   895,   896,
     897,   898,   387,     0,     0,   388,   899,     0,   389,   390,
     900,     0,     0,     0,     0,   392,     0,   393,   394,     0,
     901,     0,   902,     0,     0,     0,     0,   903,     0,     0,
       0,   904,   905,     0,     0,     0,     0,   906,     0,   907,
       0,     0,   908,   909,     0,     0,   910,   911,   122,     0,
     765,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   766,     0,   767,   130,   131,   768,   133,
       0,   134,   769,   135,     0,   770,   136,   771,   772,   773,
     137,   774,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,   775,   145,     0,   146,   776,   777,
     148,     0,   149,   150,   151,   778,   152,     0,   779,   154,
       0,   155,   156,   157,   158,   159,   780,   781,   160,     0,
     161,   162,     0,   782,   164,     0,   783,   784,   785,   165,
       0,     0,   166,   786,   787,     0,   788,   789,     0,   167,
     168,   790,   791,   792,     0,     0,     0,     0,   793,   171,
     794,     0,     0,   795,   796,   172,     0,   173,     0,     0,
       0,   797,   798,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,   799,
     182,     0,   800,   801,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,   802,     0,   191,   803,   192,
     804,   805,   193,   194,     0,   806,   195,   196,   197,   807,
       0,   198,     0,     0,   808,     0,   199,   200,  2253,   809,
     201,     0,   202,   810,   811,   812,   813,     0,   814,   815,
     204,   816,   817,   818,   206,     0,   207,   819,     0,   820,
     821,     0,   208,   209,     0,   210,   822,     0,   211,     0,
       0,     0,   823,   213,   214,   215,   824,     0,   216,   217,
       0,     0,     0,   218,     0,     0,   825,   219,   826,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,   827,   226,     0,     0,   828,
     227,     0,   829,   228,     0,     0,     0,   830,     0,   831,
       0,   230,   832,     0,   231,     0,   232,   833,     0,     0,
     834,     0,     0,     0,     0,   835,   233,   234,   235,   236,
     237,   238,   836,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   837,   248,   249,   250,   838,   251,   252,     0,
       0,     0,   253,   254,   255,   839,   257,     0,     0,   840,
     259,   841,   842,   260,     0,   261,   843,   844,   845,   846,
     847,   848,   849,   266,   267,   268,   269,     0,   850,   270,
     271,     0,   272,   273,   274,   851,   852,   853,   275,     0,
     854,   855,     0,   276,   277,     0,   856,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   857,   858,   286,   859,   860,   861,
     862,   863,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   864,   297,   298,   299,   300,   301,   302,
     303,   865,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,   866,   867,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,   868,
     318,   319,   869,   320,   321,   870,   322,   871,   324,   325,
       0,   872,   327,     0,   328,   873,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
     874,   875,   355,   356,     0,   357,   876,   359,   877,   878,
     879,   360,   361,   362,   363,   880,   364,   365,     0,   366,
     367,     0,   881,   368,   882,   883,   884,   885,     0,     0,
       0,     0,     0,   373,     0,   374,   886,   887,   888,   376,
     377,   378,     0,   889,   379,   380,   890,     0,   381,     0,
       0,   891,   892,   382,     0,     0,   383,     0,   384,     0,
     893,   386,     0,     0,   894,   895,   896,   897,   898,   387,
       0,     0,   388,   899,     0,   389,   390,   900,     0,     0,
       0,     0,   392,     0,   393,   394,     0,   901,     0,   902,
       0,     0,     0,     0,   903,     0,     0,     0,   904,   905,
       0,     0,     0,     0,   906,     0,   907,     0,     0,   908,
     909,     0,     0,   910,   911,   122,     0,   765,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     766,     0,   767,   130,   131,   768,   133,     0,   134,   769,
     135,     0,   770,   136,   771,   772,   773,   137,   774,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   775,   145,     0,   146,   776,   777,   148,     0,   149,
     150,   151,   778,   152,     0,   779,   154,     0,   155,   156,
     157,   158,   159,   780,   781,   160,     0,   161,   162,     0,
     782,   164,     0,   783,   784,   785,   165,     0,     0,   166,
     786,   787,     0,   788,   789,     0,   167,   168,   790,   791,
     792,     0,     0,     0,     0,   793,   171,   794,     0,     0,
     795,   796,   172,     0,   173,     0,     0,     0,   797,   798,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   799,   182,     0,   800,
     801,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   802,     0,   191,   803,   192,   804,   805,   193,
     194,     0,   806,   195,   196,   197,   807,     0,   198,     0,
       0,   808,     0,   199,   200,     0,   809,   201,     0,   202,
     810,   811,   812,   813,     0,   814,   815,   204,   816,   817,
     818,   206,     0,   207,   819,     0,   820,   821,     0,   208,
     209,     0,   210,   822,     0,   211,     0,     0,     0,   823,
     213,   214,   215,   824,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   825,   219,   826,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   827,   226,     0,     0,   828,   227,     0,   829,
     228,     0,     0,     0,   830,     0,   831,     0,   230,   832,
       0,   231,     0,   232,   833,     0,     0,   834,     0,     0,
       0,     0,   835,   233,   234,   235,   236,   237,   238,   836,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   837,
     248,   249,   250,   838,   251,   252,     0,     0,     0,   253,
     254,   255,   839,   257,     0,     0,   840,   259,   841,   842,
     260,     0,   261,   843,   844,   845,   846,   847,   848,   849,
     266,   267,   268,   269,     0,   850,   270,   271,     0,   272,
     273,   274,   851,   852,   853,   275,     0,   854,   855,     0,
     276,   277,     0,   856,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   857,   858,   286,   859,   860,   861,   862,   863,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     864,   297,   298,   299,   300,   301,   302,   303,   865,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   866,   867,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   868,   318,   319,   869,
     320,   321,   870,   322,   871,   324,   325,     0,   872,   327,
       0,   328,   873,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,   874,   875,   355,
     356,     0,   357,   876,   359,   877,   878,   879,   360,   361,
     362,   363,   880,   364,   365,     0,   366,   367,     0,   881,
     368,   882,   883,   884,   885,     0,     0,     0,     0,     0,
     373,     0,   374,   886,   887,   888,   376,   377,   378,     0,
     889,   379,   380,   890,     0,   381,     0,     0,   891,   892,
     382,     0,     0,   383,     0,   384,     0,   893,   386,     0,
       0,   894,   895,   896,   897,   898,   387,     0,     0,   388,
     899,     0,   389,   390,   900,     0,     0,     0,     0,   392,
       0,   393,   394,     0,   901,     0,   902,     0,     0,     0,
       0,   903,     0,     0,     0,   904,   905,     0,     0,     0,
       0,   906,     0,   907,     0,     0,   908,   909,     0,     0,
     910,   911,   122,     0,   765,   124,   125,   126,   127,  1834,
       0,     0,     0,     0,  1835,     0,     0,   766,     0,   767,
     130,   131,   768,   133,     0,   134,   769,   135,     0,   770,
     136,   771,   772,   773,   137,   774,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,   775,   145,
       0,   146,   776,   777,   148,     0,   149,   150,   151,   778,
     152,     0,   779,   154,     0,   155,   156,   157,   158,   159,
     780,   781,   160,     0,   161,   162,     0,   782,   164,     0,
     783,   784,   785,   165,     0,     0,   166,   786,   787,     0,
     788,   789,     0,   167,   168,   790,   791,   792,     0,     0,
       0,     0,   793,   171,   794,     0,     0,   795,   796,   172,
       0,   173,     0,     0,     0,   797,   798,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,   799,   182,     0,   800,   801,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,   802,
       0,   191,   803,   192,   804,   805,   193,   194,     0,   806,
     195,   196,   197,   807,     0,   198,     0,     0,   808,     0,
     199,   200,     0,   809,   201,     0,   202,   810,   811,   812,
     813,     0,   814,   815,   204,   816,   817,   818,   206,     0,
     207,   819,     0,   820,   821,     0,   208,   209,     0,   210,
     822,     0,   211,     0,     0,     0,   823,   213,   214,   215,
     824,     0,   216,   217,     0,     0,     0,   218,     0,     0,
     825,   219,   826,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,   827,
     226,     0,     0,   828,   227,     0,   829,   228,     0,     0,
       0,   830,     0,   831,     0,   230,   832,     0,   231,     0,
     232,   833,     0,     0,   834,     0,     0,     0,     0,   835,
     233,   234,   235,   236,   237,   238,   836,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   837,   248,   249,   250,
     838,   251,   252,     0,     0,     0,   253,   254,   255,   839,
     257,     0,     0,   840,   259,   841,   842,   260,     0,   261,
     843,   844,   845,   846,   847,   848,   849,   266,   267,   268,
     269,     0,   850,   270,   271,     0,   272,   273,   274,   851,
       0,   853,   275,     0,   854,   855,     0,   276,   277,     0,
     856,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   857,   858,
     286,   859,   860,   861,   862,   863,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   864,   297,   298,
     299,   300,   301,   302,   303,   865,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,   866,   867,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,   868,   318,   319,   869,   320,   321,   870,
     322,   871,   324,   325,     0,   872,   327,     0,   328,   873,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,   874,   875,   355,   356,     0,   357,
     876,   359,   877,   878,   879,   360,   361,   362,   363,   880,
     364,   365,     0,   366,   367,     0,   881,   368,   882,   883,
     884,   885,     0,     0,     0,     0,     0,   373,     0,   374,
     886,   887,   888,   376,   377,   378,     0,   889,   379,   380,
     890,     0,   381,     0,     0,   891,   892,   382,     0,     0,
     383,     0,   384,     0,   893,   386,     0,     0,   894,   895,
     896,   897,   898,   387,     0,     0,   388,   899,     0,   389,
     390,   900,     0,     0,     0,     0,   392,     0,   393,   394,
       0,   901,     0,   902,     0,     0,     0,     0,   903,     0,
       0,     0,   904,   905,     0,     0,     0,     0,   906,     0,
     907,     0,     0,   908,   909,     0,     0,   910,   911,   122,
       0,   765,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   766,     0,   767,   130,   131,   768,
     133,     0,   134,   769,   135,     0,   770,   136,   771,   772,
     773,   137,   774,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   775,   145,     0,   146,   776,
     777,   148,     0,   149,   150,   151,   778,   152,     0,   779,
     154,     0,   155,   156,   157,   158,   159,   780,   781,   160,
       0,   161,   162,     0,   782,   164,     0,   783,   784,   785,
     165,     0,     0,   166,   786,   787,     0,   788,   789,     0,
     167,   168,   790,   791,   792,     0,     0,     0,     0,   793,
     171,   794,     0,     0,   795,   796,   172,     0,   173,     0,
       0,     0,   797,   798,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     799,   182,     0,   800,   801,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   802,     0,   191,   803,
     192,   804,   805,   193,   194,     0,   806,   195,   196,   197,
     807,     0,   198,     0,     0,   808,     0,   199,   200,     0,
     809,   201,     0,   202,   810,   811,   812,   813,     0,   814,
     815,   204,   816,   817,   818,   206,     0,   207,   819,     0,
     820,   821,     0,   208,   209,     0,   210,   822,     0,   211,
       0,     0,     0,   823,   213,   214,   215,   824,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   825,   219,  2530,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   827,   226,     0,     0,
     828,   227,     0,   829,   228,     0,     0,     0,   830,     0,
     831,     0,   230,   832,     0,   231,     0,   232,   833,     0,
       0,   834,     0,     0,     0,     0,   835,   233,   234,   235,
     236,   237,   238,   836,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   837,   248,   249,   250,   838,   251,   252,
       0,     0,     0,   253,   254,   255,   839,   257,     0,     0,
     840,   259,   841,   842,   260,     0,   261,   843,   844,   845,
     846,   847,   848,   849,   266,   267,   268,   269,     0,   850,
     270,   271,     0,   272,   273,   274,   851,   852,   853,   275,
       0,   854,   855,     0,   276,   277,     0,   856,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   857,   858,   286,   859,   860,
     861,   862,   863,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   864,   297,   298,   299,   300,   301,
     302,   303,   865,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   866,   867,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     868,   318,   319,   869,   320,   321,   870,   322,   871,   324,
     325,     0,   872,   327,     0,   328,   873,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,   874,   875,   355,   356,     0,   357,   876,   359,   877,
     878,   879,   360,   361,   362,   363,   880,   364,   365,     0,
     366,   367,     0,   881,   368,   882,   883,   884,   885,     0,
       0,     0,     0,     0,   373,     0,   374,   886,   887,   888,
     376,   377,   378,     0,   889,   379,   380,   890,     0,   381,
       0,     0,   891,   892,   382,     0,     0,   383,     0,   384,
       0,   893,   386,     0,     0,   894,   895,   896,   897,   898,
     387,     0,     0,   388,   899,     0,   389,   390,   900,     0,
       0,     0,     0,   392,     0,   393,   394,     0,   901,     0,
     902,     0,     0,     0,     0,   903,     0,     0,     0,   904,
     905,     0,     0,     0,     0,   906,     0,   907,     0,     0,
     908,   909,     0,     0,   910,   911,   122,     0,   765,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   766,     0,   767,   130,   131,   768,   133,     0,   134,
     769,   135,     0,   770,   136,   771,   772,   773,   137,   774,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,   775,   145,     0,   146,   776,   777,   148,     0,
     149,   150,   151,   778,   152,     0,   779,   154,     0,   155,
     156,   157,   158,   159,   780,   781,   160,     0,   161,   162,
       0,   782,   164,     0,   783,   784,   785,   165,     0,     0,
     166,   786,   787,     0,   788,   789,     0,   167,   168,   790,
     791,   792,     0,     0,     0,     0,   793,   171,   794,     0,
       0,   795,   796,   172,     0,   173,     0,     0,     0,   797,
     798,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,   799,   182,     0,
     800,   801,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,   802,     0,   191,   803,   192,   804,   805,
     193,   194,     0,   806,   195,   196,   197,   807,     0,   198,
       0,     0,   808,     0,   199,   200,     0,   809,   201,     0,
     202,   810,   811,   812,   813,     0,   814,   815,   204,   816,
     817,   818,   206,     0,   207,   819,     0,   820,   821,     0,
     208,   209,     0,   210,   822,     0,   211,     0,     0,     0,
     823,   213,   214,   215,   824,     0,   216,   217,     0,     0,
       0,   218,     0,     0,   825,   219,  2603,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,   827,   226,     0,     0,   828,   227,     0,
     829,   228,     0,     0,     0,   830,     0,   831,     0,   230,
     832,     0,   231,     0,   232,   833,     0,     0,   834,     0,
       0,     0,     0,   835,   233,   234,   235,   236,   237,   238,
     836,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     837,   248,   249,   250,   838,   251,   252,     0,     0,     0,
     253,   254,   255,   839,   257,     0,     0,   840,   259,   841,
     842,   260,     0,   261,   843,   844,   845,   846,   847,   848,
     849,   266,   267,   268,   269,     0,   850,   270,   271,     0,
     272,   273,   274,   851,   852,   853,   275,     0,   854,   855,
       0,   276,   277,     0,   856,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   857,   858,   286,   859,   860,   861,   862,   863,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   864,   297,   298,   299,   300,   301,   302,   303,   865,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,   866,   867,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,   868,   318,   319,
     869,   320,   321,   870,   322,   871,   324,   325,     0,   872,
     327,     0,   328,   873,   330,   331,   332,   333,   334,   335,
     336,   337,     0,     0,   338,   339,   340,     0,     0,   341,
       0,     0,     0,   342,   343,   344,   345,     0,   346,   347,
     348,     0,     0,     0,     0,     0,     0,   349,   350,     0,
     351,     0,     0,   352,     0,     0,   353,   354,   874,   875,
     355,   356,     0,   357,   876,   359,   877,   878,   879,   360,
     361,   362,   363,   880,   364,   365,     0,   366,   367,     0,
     881,   368,   882,   883,   884,   885,     0,     0,     0,     0,
       0,   373,     0,   374,   886,   887,   888,   376,   377,   378,
       0,   889,   379,   380,   890,     0,   381,     0,     0,   891,
     892,   382,     0,     0,   383,     0,   384,     0,   893,   386,
       0,     0,   894,   895,   896,   897,   898,   387,     0,     0,
     388,   899,     0,   389,   390,   900,     0,     0,     0,     0,
     392,     0,   393,   394,     0,   901,     0,   902,     0,     0,
       0,     0,   903,     0,     0,     0,   904,   905,     0,     0,
       0,     0,   906,     0,   907,     0,     0,   908,   909,     0,
       0,   910,   911,   122,     0,   765,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   766,     0,
     767,   130,   131,   768,   133,     0,   134,   769,   135,     0,
     770,   136,   771,   772,   773,   137,   774,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   775,
     145,     0,   146,   776,   777,   148,     0,   149,   150,   151,
     778,   152,     0,   779,   154,     0,   155,   156,   157,   158,
     159,   780,   781,   160,     0,   161,   162,     0,   782,   164,
       0,   783,   784,   785,   165,     0,     0,   166,   786,   787,
       0,   788,   789,     0,   167,   168,   790,   791,   792,     0,
       0,     0,     0,   793,   171,   794,     0,     0,   795,  2956,
     172,     0,   173,     0,     0,     0,   797,   798,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   799,   182,     0,   800,   801,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     802,     0,   191,   803,   192,   804,   805,   193,   194,     0,
     806,   195,   196,   197,   807,     0,   198,     0,     0,   808,
       0,   199,   200,     0,   809,   201,     0,   202,   810,   811,
     812,   813,     0,   814,   815,   204,   816,   817,   818,   206,
       0,   207,   819,     0,   820,   821,     0,   208,   209,     0,
     210,   822,     0,   211,     0,     0,     0,   823,   213,   214,
     215,   824,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   825,   219,   826,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     827,   226,     0,     0,   828,   227,     0,   829,   228,     0,
       0,     0,   830,     0,   831,     0,   230,   832,     0,   231,
       0,   232,   833,     0,     0,   834,     0,     0,     0,     0,
     835,   233,   234,   235,   236,   237,   238,   836,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   837,   248,   249,
     250,   838,   251,   252,     0,     0,     0,   253,   254,   255,
     839,   257,     0,     0,   840,   259,   841,   842,   260,     0,
     261,   843,   844,   845,   846,   847,   848,   849,   266,   267,
     268,   269,     0,   850,   270,   271,     0,   272,   273,   274,
     851,   852,   853,   275,     0,   854,   855,     0,   276,   277,
       0,   856,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   857,
     858,   286,   859,   860,   861,   862,   863,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   864,   297,
     298,   299,   300,   301,   302,   303,   865,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   866,   867,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   868,   318,   319,   869,   320,   321,
     870,   322,   871,   324,   325,     0,   872,   327,     0,   328,
     873,   330,   331,   332,   333,   334,   335,   336,   337,     0,
       0,   338,   339,   340,     0,     0,   341,     0,     0,     0,
     342,   343,   344,   345,     0,   346,   347,   348,     0,     0,
       0,     0,     0,     0,   349,   350,     0,   351,     0,     0,
     352,     0,     0,   353,   354,   874,   875,   355,   356,     0,
     357,   876,   359,   877,   878,   879,   360,   361,   362,   363,
     880,   364,   365,     0,   366,   367,     0,   881,   368,   882,
     883,   884,   885,     0,     0,     0,     0,     0,   373,     0,
     374,   886,   887,   888,   376,   377,   378,     0,   889,   379,
     380,   890,     0,   381,     0,     0,   891,   892,   382,     0,
       0,   383,     0,   384,     0,   893,   386,     0,     0,   894,
     895,   896,   897,   898,   387,     0,     0,   388,   899,     0,
     389,   390,   900,     0,     0,     0,     0,   392,     0,   393,
     394,     0,   901,     0,   902,     0,     0,     0,     0,   903,
       0,     0,     0,   904,   905,     0,     0,     0,     0,   906,
       0,   907,     0,     0,   908,   909,     0,     0,   910,   911,
     122,     0,   765,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   766,     0,   767,   130,   131,
     768,   133,     0,   134,   769,   135,     0,   770,   136,   771,
     772,   773,   137,   774,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,   775,   145,     0,   146,
     776,   777,   148,     0,   149,   150,   151,   778,   152,     0,
     779,   154,     0,   155,   156,   157,   158,   159,   780,   781,
     160,     0,   161,   162,     0,   782,   164,     0,   783,   784,
     785,   165,     0,     0,   166,   786,   787,     0,   788,   789,
       0,   167,   168,   790,   791,   792,     0,     0,     0,     0,
     793,   171,   794,     0,     0,   795,   796,   172,     0,   173,
       0,     0,     0,   797,   798,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,   799,   182,     0,   800,   801,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,   802,     0,   191,
     803,   192,   804,   805,   193,   194,     0,   806,   195,   196,
     197,   807,     0,   198,     0,     0,   808,     0,   199,   200,
       0,   809,   201,     0,   202,   810,   811,   812,   813,     0,
     814,   815,   204,   816,   817,   818,   206,     0,   207,   819,
       0,   820,   821,     0,   208,   209,     0,   210,   822,     0,
     211,     0,     0,     0,   823,   213,   214,   215,   824,     0,
     216,   217,     0,     0,     0,   218,     0,     0,   825,   219,
     826,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,   827,   226,     0,
       0,   828,   227,     0,   829,   228,     0,     0,     0,   830,
       0,   831,     0,   230,   832,     0,   231,     0,   232,   833,
       0,     0,   834,     0,     0,     0,     0,   835,   233,   234,
     235,   236,   237,   238,   836,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   837,   248,   249,   250,   838,   251,
     252,     0,     0,     0,   253,   254,   255,   839,   257,     0,
       0,   840,   259,   841,   842,   260,     0,   261,   843,   844,
     845,   846,   847,   848,   849,   266,   267,   268,   269,     0,
     850,   270,   271,     0,   272,   273,   274,   851,     0,   853,
     275,     0,   854,   855,     0,   276,   277,     0,   856,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   857,   858,   286,   859,
     860,   861,   862,   863,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   864,   297,   298,   299,   300,
     301,   302,   303,   865,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,   866,
     867,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,   868,   318,   319,   869,   320,   321,   870,   322,   871,
     324,   325,     0,   872,   327,     0,   328,   873,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,   874,   875,   355,   356,     0,   357,   876,   359,
     877,   878,   879,   360,   361,   362,   363,   880,   364,   365,
       0,   366,   367,     0,   881,   368,   882,   883,   884,   885,
       0,     0,     0,     0,     0,   373,     0,   374,   886,   887,
     888,   376,   377,   378,     0,   889,   379,   380,   890,     0,
     381,     0,     0,   891,   892,   382,     0,     0,   383,     0,
     384,     0,   893,   386,     0,     0,   894,   895,   896,   897,
     898,   387,     0,     0,   388,   899,     0,   389,   390,   900,
       0,     0,     0,     0,   392,     0,   393,   394,     0,   901,
       0,   902,     0,     0,     0,     0,   903,     0,     0,     0,
     904,   905,     0,     0,     0,     0,   906,     0,   907,     0,
       0,   908,   909,     0,     0,   910,   911,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,  2012,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
    2013,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,  1132,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
    1133,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,  2514,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,  1921,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,  2014,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,     0,
       0,   355,   356,     0,   357,   358,   359,     0,     0,     0,
     360,   361,   362,   363,     0,   364,   365,     0,   366,   367,
       0,     0,   368,   369,   370,   371,   372,     0,     0,     0,
       0,     0,   373,     0,   374,     0,     0,   375,   376,   377,
     378,     0,     0,   379,   380,     0,     0,   381,     0,     0,
       0,     0,   382,     0,     0,   383,     0,   384,     0,   385,
     386,     0,     0,     0,     0,     0,     0,     0,   387,     0,
       0,   388,     0,     0,   389,   390,   391,     0,     0,     0,
       0,   392,     0,   393,   394,     0,     0,   122,   395,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,  2061,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,  2012,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
    2013,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,  1132,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
    1133,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,  2014,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,     0,
       0,   355,   356,     0,   357,   358,   359,     0,     0,     0,
     360,   361,   362,   363,     0,   364,   365,     0,   366,   367,
       0,     0,   368,   369,   370,   371,   372,     0,     0,     0,
       0,     0,   373,     0,   374,     0,     0,   375,   376,   377,
     378,     0,     0,   379,   380,     0,     0,   381,     0,     0,
       0,     0,   382,     0,     0,   383,     0,   384,     0,   385,
     386,     0,     0,     0,     0,     0,     0,     0,   387,     0,
       0,   388,     0,     0,   389,   390,   391,     0,     0,     0,
       0,   392,     0,   393,   394,     0,     0,   122,   395,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,  2061,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,  1921,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,     0,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,     0,
       0,   355,   356,     0,   357,   358,   359,     0,     0,     0,
     360,   361,   362,   363,     0,   364,   365,     0,   366,   367,
       0,     0,   368,   369,   370,   371,   372,     0,     0,     0,
       0,     0,   373,     0,   374,     0,     0,   375,   376,   377,
     378,     0,     0,   379,   380,     0,     0,   381,     0,     0,
       0,     0,   382,     0,     0,   383,     0,   384,     0,   385,
     386,     0,     0,     0,     0,     0,     0,     0,   387,     0,
       0,   388,     0,     0,   389,   390,   391,     0,     0,     0,
       0,   392,     0,   393,   394,     0,     0,     0,   395,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,  2333,   130,   131,   132,
     133,     0,   134,   911,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,     0,     0,   355,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,   375,
     376,   377,   378,     0,     0,   379,   380,     0,     0,   381,
       0,     0,     0,     0,   382,     0,     0,   383,     0,   384,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   392,     0,   393,   394,     0,     0,     0,
     395,     0,     0,     0,     0,     0,     0,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,  3698,     0,
     128,     0,     0,   129,  3699,   911,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,  1004,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
       0,     0,   355,   356,     0,   357,   358,   359,     0,     0,
       0,   360,   361,   362,   363,     0,   364,   365,     0,   366,
     367,     0,     0,   368,   369,   370,   371,   372,     0,     0,
       0,     0,     0,   373,     0,   374,     0,     0,   375,   376,
     377,   378,     0,     0,   379,   380,     0,     0,   381,     0,
       0,     0,     0,   382,     0,     0,   383,     0,   384,     0,
     385,   386,     0,     0,     0,     0,     0,     0,     0,   387,
       0,     0,   388,     0,     0,   389,   390,   391,     0,     0,
       0,     0,   392,     0,   393,   394,     0,     0,   122,   395,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,   431,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,     0,     0,   338,   339,   340,     0,
       0,   341,     0,     0,     0,   342,   343,   344,   345,     0,
     346,   347,   348,     0,     0,     0,     0,     0,     0,   349,
     350,     0,   351,     0,     0,   352,     0,     0,   353,   354,
       0,     0,   355,   356,     0,   357,   358,   359,     0,     0,
       0,   360,   361,   362,   363,     0,   364,   365,     0,   366,
     367,     0,     0,   368,   369,   370,   371,   372,     0,     0,
       0,     0,     0,   373,     0,   374,     0,     0,   375,   376,
     377,   378,     0,     0,   379,   380,     0,     0,   381,     0,
       0,     0,     0,   382,     0,     0,   383,     0,   384,     0,
     385,   386,     0,     0,     0,     0,     0,     0,     0,   387,
       0,     0,   388,     0,     0,   389,   390,   391,     0,     0,
       0,     0,   392,     0,   393,   394,     0,     0,     0,   395,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    1880,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,   431,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,   343,   344,
     345,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
     353,   354,     0,     0,   355,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
     375,   376,   377,   378,     0,     0,   379,   380,     0,     0,
     381,     0,     0,     0,     0,   382,     0,     0,   383,     0,
     384,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,     0,     0,   392,     0,   393,   394,     0,     0,
       0,   395,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,  2060,     0,
     130,   131,   132,   133,     0,   134,  2061,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,     0,     0,
     338,   339,   340,     0,     0,   341,     0,     0,     0,   342,
     343,   344,   345,     0,   346,   347,   348,     0,     0,     0,
       0,     0,     0,   349,   350,     0,   351,     0,     0,   352,
       0,     0,   353,   354,     0,     0,   355,   356,     0,   357,
     358,   359,     0,     0,     0,   360,   361,   362,   363,     0,
     364,   365,     0,   366,   367,     0,     0,   368,   369,   370,
     371,   372,     0,     0,     0,     0,     0,   373,     0,   374,
       0,     0,   375,   376,   377,   378,     0,     0,   379,   380,
       0,     0,   381,     0,     0,     0,     0,   382,     0,     0,
     383,     0,   384,     0,   385,   386,     0,     0,     0,     0,
       0,     0,     0,   387,     0,     0,   388,     0,     0,   389,
     390,   391,     0,     0,     0,     0,   392,     0,   393,   394,
       0,     0,     0,   395,     0,     0,     0,     0,     0,     0,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,  3699,   911,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,     0,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,   122,   395,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,   431,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   486,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,     0,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,   122,   395,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,   431,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,     0,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,   122,   395,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,   911,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,     0,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,   122,   395,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,  2061,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,   574,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,   575,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,     0,   395,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  1821,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     574,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
       0,     0,   338,   339,   340,     0,     0,   341,     0,     0,
       0,   342,   343,   344,   345,     0,   346,   347,   348,     0,
       0,     0,     0,     0,     0,   349,   350,     0,   351,     0,
       0,   352,     0,     0,   353,   354,     0,     0,   355,   356,
       0,   357,   358,   359,     0,     0,     0,   360,   361,   362,
     363,     0,   364,   365,     0,   366,   367,     0,   575,   368,
     369,   370,   371,   372,     0,     0,     0,     0,     0,   373,
       0,   374,     0,     0,   375,   376,   377,   378,     0,     0,
     379,   380,     0,     0,   381,     0,     0,     0,     0,   382,
       0,     0,   383,     0,   384,     0,   385,   386,     0,     0,
       0,     0,     0,     0,     0,   387,     0,     0,   388,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   392,     0,
     393,   394,     0,     0,     0,   395,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,  2373,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,   574,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,     0,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,     0,
       0,   355,   356,     0,   357,   358,   359,     0,     0,     0,
     360,   361,   362,   363,     0,   364,   365,     0,   366,   367,
       0,   575,   368,   369,   370,   371,   372,     0,     0,     0,
       0,     0,   373,     0,   374,     0,     0,   375,   376,   377,
     378,     0,     0,   379,   380,     0,     0,   381,     0,     0,
       0,     0,   382,     0,     0,   383,     0,   384,     0,   385,
     386,     0,     0,     0,     0,     0,     0,     0,   387,     0,
       0,   388,     0,     0,   389,   390,   391,     0,     0,     0,
       0,   392,     0,   393,   394,     0,     0,     0,   395,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,  2979,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3536,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,     0,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3537,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3538,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3539,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3540,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3541,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -183,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3542,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,     0,   344,
       0,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
       0,   354,     0,     0,     0,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
       0,   376,   377,   378,     0,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   382,     0,     0,   383,     0,
       0,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,  -183,     0,   392,     0,   393,     0,     0,     0,
       0,   395,     0,     0,     0,     0,  3543,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
    3750,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,     0,     0,   338,   339,   340,     0,     0,
     341,     0,     0,     0,   342,   343,   344,   345,     0,   346,
     347,   348,     0,     0,     0,     0,     0,     0,   349,   350,
       0,   351,     0,     0,   352,     0,     0,   353,   354,     0,
       0,   355,   356,     0,   357,   358,   359,     0,     0,     0,
     360,   361,   362,   363,     0,   364,   365,     0,   366,   367,
       0,     0,   368,   369,   370,   371,   372,     0,     0,     0,
       0,     0,   373,     0,   374,     0,     0,   375,   376,   377,
     378,     0,     0,   379,   380,     0,     0,   381,     0,     0,
       0,     0,   382,     0,     0,   383,     0,   384,     0,   385,
     386,     0,     0,     0,     0,     0,     0,     0,   387,     0,
       0,   388,     0,     0,   389,   390,   391,     0,     0,     0,
       0,   392,     0,   393,   394,     0,     0,     0,   395,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,  1667,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,     0,     0,   338,   339,   340,
       0,     0,   341,     0,     0,     0,   342,   343,   344,   345,
       0,   346,   347,   348,     0,     0,     0,     0,     0,     0,
     349,   350,     0,   351,     0,     0,   352,     0,     0,   353,
     354,     0,     0,   355,   356,     0,   357,   358,   359,     0,
       0,     0,   360,   361,   362,   363,     0,   364,   365,     0,
     366,   367,     0,     0,   368,   369,   370,   371,   372,     0,
       0,     0,     0,     0,   373,     0,   374,     0,     0,   375,
     376,   377,   378,     0,     0,   379,   380,     0,     0,   381,
       0,     0,     0,     0,   382,     0,     0,   383,     0,   384,
       0,   385,   386,     0,     0,     0,     0,     0,     0,     0,
     387,     0,     0,   388,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   392,     0,   393,   394,     0,     0,     0,
     395,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  2359,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,     0,     0,   338,
     339,   340,     0,     0,   341,     0,     0,     0,   342,   343,
     344,   345,     0,   346,   347,   348,     0,     0,     0,     0,
       0,     0,   349,   350,     0,   351,     0,     0,   352,     0,
       0,   353,   354,     0,     0,   355,   356,     0,   357,   358,
     359,     0,     0,     0,   360,   361,   362,   363,     0,   364,
     365,     0,   366,   367,     0,     0,   368,   369,   370,   371,
     372,     0,     0,     0,     0,     0,   373,     0,   374,     0,
       0,   375,   376,   377,   378,     0,     0,   379,   380,     0,
       0,   381,     0,     0,     0,     0,   382,     0,     0,   383,
       0,   384,     0,   385,   386,     0,     0,     0,     0,     0,
       0,     0,   387,     0,     0,   388,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   392,     0,   393,   394,     0,
       0,     0,   395,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  2654,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,     0,
       0,   338,   339,   340,     0,     0,   341,     0,     0,     0,
     342,   343,   344,   345,     0,   346,   347,   348,     0,     0,
       0,     0,     0,     0,   349,   350,     0,   351,     0,     0,
     352,     0,     0,   353,   354,     0,     0,   355,   356,     0,
     357,   358,   359,     0,     0,     0,   360,   361,   362,   363,
       0,   364,   365,     0,   366,   367,     0,     0,   368,   369,
     370,   371,   372,     0,     0,     0,     0,     0,   373,     0,
     374,     0,     0,   375,   376,   377,   378,     0,     0,   379,
     380,     0,     0,   381,     0,     0,     0,     0,   382,     0,
       0,   383,     0,   384,     0,   385,   386,     0,     0,     0,
       0,     0,     0,     0,   387,     0,     0,   388,     0,     0,
     389,   390,   391,     0,     0,     0,     0,   392,     0,   393,
     394,     0,     0,     0,   395,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  2984,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -230,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3536,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,  -200,     0,   182,     0,     0,
       0,  -200,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3537,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3538,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3539,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3540,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -183,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3541,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -183,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3542,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,     0,   344,     0,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,     0,   354,     0,     0,     0,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,     0,   376,   377,   378,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,  -183,     0,   392,
       0,   393,     0,     0,     0,     0,   395,     0,     0,  -200,
     122,  3543,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3536,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  -221,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3537,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3538,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3539,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3540,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3541,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -183,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3542,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,     0,   344,
       0,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
       0,   354,     0,     0,     0,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
       0,   376,   377,   378,     0,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   382,     0,     0,   383,     0,
       0,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
    -221,     0,  -183,     0,   392,     0,   393,     0,     0,     0,
       0,   395,     0,     0,  -221,   122,  3543,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -230,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3536,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,  -218,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3537,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3538,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3539,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3540,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -183,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3541,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -183,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3542,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,     0,   344,     0,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,     0,   354,     0,     0,     0,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,     0,   376,   377,   378,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,  -218,     0,  -183,     0,   392,
       0,   393,     0,     0,     0,     0,   395,     0,     0,  -218,
     122,  3543,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3536,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  3627,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3537,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3538,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3539,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3540,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3541,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -183,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3542,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,     0,   344,
       0,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
       0,   354,     0,     0,     0,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
       0,   376,   377,   378,     0,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   382,     0,     0,   383,     0,
       0,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,  -183,     0,   392,     0,   393,     0,     0,     0,
       0,   395,     0,     0,     0,   122,  3543,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -230,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3536,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,  -223,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3537,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3538,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3539,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3540,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -183,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3541,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -183,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3542,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,     0,   344,     0,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,     0,   354,     0,     0,     0,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,     0,   376,   377,   378,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,  -183,     0,   392,
       0,   393,     0,     0,     0,     0,   395,     0,     0,     0,
     122,  3543,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3536,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  3678,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3537,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3538,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3539,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3540,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3541,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -183,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3542,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,     0,   344,
       0,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
       0,   354,     0,     0,     0,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
       0,   376,   377,   378,     0,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   382,     0,     0,   383,     0,
       0,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,  -183,     0,   392,     0,   393,     0,     0,     0,
       0,   395,     0,     0,     0,   122,  3543,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -230,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3536,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,  3711,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3537,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3538,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3539,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3540,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -183,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3541,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -183,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3542,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,     0,   344,     0,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,     0,   354,     0,     0,     0,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,     0,   376,   377,   378,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,  -183,     0,   392,
       0,   393,     0,     0,     0,     0,   395,     0,     0,     0,
     122,  3543,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3536,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,  -204,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3537,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3538,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3539,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3540,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3541,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -183,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3542,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,     0,   344,
       0,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
       0,   354,     0,     0,     0,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
       0,   376,   377,   378,     0,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   382,     0,     0,   383,     0,
       0,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,  -183,     0,   392,     0,   393,     0,     0,     0,
       0,   395,     0,     0,     0,   122,  3543,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -230,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,  3536,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,     0,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,  3537,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,  3538,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,  3539,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,  3540,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,  -183,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,  3541,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,  -183,     0,   312,     0,     0,   314,
       0,     0,   316,   317,  3542,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,     0,   344,     0,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,     0,   354,     0,     0,     0,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,     0,   376,   377,   378,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,  -183,     0,   392,
       0,   393,     0,     0,     0,     0,   395,     0,     0,     0,
     122,  3543,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,     0,     0,     0,     0,   144,     0,   145,     0,   146,
       0,     0,     0,     0,   149,   150,  3536,     0,   152,     0,
     153,   154,     0,     0,   156,     0,   158,   159,     0,     0,
     160,     0,   161,   162,     0,     0,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,     0,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,     0,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,     0,   184,   185,   186,
       0,     0,   187,     0,   188,   189,     0,     0,     0,   191,
       0,   192,     0,     0,   193,   194,  3537,     0,   195,   196,
     197,     0,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,  3538,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,     0,     0,   220,     0,   221,   222,     0,   223,   224,
    3539,     0,     0,     0,     0,     0,     0,     0,   226,     0,
       0,     0,   227,  3540,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,  3541,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,     0,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,     0,   311,  -183,
       0,   312,     0,     0,   314,     0,     0,   316,   317,  3542,
       0,     0,     0,   319,     0,   320,   321,     0,   322,   323,
     324,     0,     0,   326,     0,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,     0,     0,   338,   339,
     340,     0,     0,   341,     0,     0,     0,   342,     0,   344,
       0,     0,   346,   347,   348,     0,     0,     0,     0,     0,
       0,   349,   350,     0,   351,     0,     0,   352,     0,     0,
       0,   354,     0,     0,     0,   356,     0,   357,   358,   359,
       0,     0,     0,   360,   361,   362,   363,     0,   364,   365,
       0,   366,   367,     0,     0,   368,   369,   370,   371,   372,
       0,     0,     0,     0,     0,   373,     0,   374,     0,     0,
       0,   376,   377,   378,     0,     0,   379,   380,     0,     0,
       0,     0,     0,     0,     0,   382,     0,     0,  3630,     0,
       0,     0,   385,   386,     0,     0,     0,     0,     0,     0,
       0,   387,     0,     0,   388,     0,     0,   389,   390,   391,
       0,     0,  -183,     0,   392,     0,   393,     0,     0,     0,
       0,   395,     0,     0,     0,   122,  3543,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,  1638,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,  1639,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,  1641,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,  1642,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,   728,   729,     0,   275,     0,     0,  1644,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,  3738,  3729,  3739,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
    1655,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2365,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2366,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,  1999,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   574,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,  2000,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2375,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2376,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   574,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2365,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2366,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   574,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,   732,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   574,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,   683,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,   684,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   685,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  2414,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   574,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2365,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   574,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,   574,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,  2355,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,  3673,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,  3674,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,   759,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  1128,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  1946,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
    1947,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,  2067,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,   575,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,  1946,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,  1434,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
    1435,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,   343,   344,   345,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,   353,   354,     0,     0,   355,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,   375,   376,   377,   378,     0,
       0,   379,   380,     0,     0,   381,     0,     0,     0,     0,
     382,     0,     0,   383,     0,   384,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,   394,     0,     0,   122,   395,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,     0,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,     0,     0,     0,     0,
     144,     0,   145,     0,   146,     0,     0,     0,     0,   149,
     150,     0,     0,   152,     0,   153,   154,     0,     0,   156,
       0,   158,   159,     0,     0,   160,     0,   161,   162,     0,
       0,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,     0,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,     0,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,     0,   184,   185,   186,     0,     0,   187,     0,   188,
     189,     0,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,     0,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
       0,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,     0,   311,     0,     0,   312,     0,     0,   314,
       0,     0,   316,   317,     0,     0,     0,     0,   319,     0,
     320,   321,     0,   322,   323,   324,     0,     0,   326,     0,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,     0,     0,   338,   339,   340,     0,     0,   341,     0,
       0,     0,   342,     0,   344,     0,     0,   346,   347,   348,
       0,     0,     0,     0,     0,     0,   349,   350,     0,   351,
       0,     0,   352,     0,     0,     0,   354,     0,     0,     0,
     356,     0,   357,   358,   359,     0,     0,     0,   360,   361,
     362,   363,     0,   364,   365,     0,   366,   367,     0,     0,
     368,   369,   370,   371,   372,     0,     0,     0,     0,     0,
     373,     0,   374,     0,     0,     0,   376,   377,   378,     0,
       0,   379,   380,     0,     0,     0,     0,     0,     0,     0,
     382,     0,     0,   383,     0,     0,     0,   385,   386,     0,
       0,     0,     0,     0,     0,     0,   387,     0,     0,   388,
       0,     0,   389,   390,   391,     0,     0,     0,     0,   392,
       0,   393,     0,     0,     0,     0,   395
};

static const short yycheck[] =
{
       7,   435,   460,   480,   513,   923,   615,  1237,   539,   792,
     990,   770,    19,   699,  1043,    22,   518,   519,   638,   786,
     787,   788,    29,   664,   640,  1815,  1201,  2003,  1106,  1956,
    2391,  1898,    39,  1414,  1925,  1663,  2113,  1353,  1229,  1557,
    1328,  1235,    49,    22,  1360,   665,  1981,     7,   664,  1949,
    1950,  1951,  1570,  2131,  1989,  2435,  1991,  2340,  1328,  2732,
    2138,  1963,  1964,  1203,  1204,  1205,   597,  1208,  1209,  1988,
    1211,  1121,  2755,  1940,  1068,  1523,  1216,  1071,  1269,     3,
      87,     3,   703,  1372,  1373,  2018,   853,  2740,  1082,  1083,
    2785,    32,     3,  2788,    18,  2022,     3,     3,   703,   882,
     107,   108,   885,   110,     3,  1246,   591,     3,    87,   467,
       3,     3,  2807,   880,   121,  2042,  2043,   523,  2813,    95,
    1261,    69,    16,     3,    16,    15,    16,   894,   895,   896,
    1270,  1537,  1114,  1273,    20,    56,    15,    16,  1279,  1280,
    1281,  1666,   121,    27,  1291,   904,   905,   906,   108,  1290,
     110,   115,  2107,    15,    16,  2850,    60,   916,   135,  2012,
    1301,    66,  1302,  1303,  1470,  2018,   666,  1307,  2021,    55,
      56,  2024,    61,    18,    49,    34,   707,   147,    49,   108,
      18,   156,  2035,  2036,    58,    15,    16,  1327,   169,  1329,
     217,  2044,   158,  1987,    34,   179,    11,    18,   115,    52,
     111,  3016,   145,   229,   177,   639,  1668,  3023,    15,    16,
      59,   238,  2103,    63,  1361,   111,  1196,  1364,  1365,  1366,
    1367,   145,  1369,  1370,  1371,  1372,  1373,  1374,  1375,  1376,
    1377,   111,   129,   214,   519,   263,   738,   739,   740,   252,
      20,    63,    20,   205,   602,    15,    16,    58,    58,   179,
      15,    16,    32,    77,    32,    32,   301,   175,    15,    16,
     324,   413,    15,    16,    15,    16,    46,   214,    46,    55,
      56,   138,   191,    75,   107,    55,    56,    55,    56,    20,
     344,   148,    15,    16,   361,   347,   214,  2013,  2014,    15,
      16,    32,  2965,   156,    15,    16,   175,   112,   227,   111,
     145,   221,    32,  3545,   236,    46,   223,   145,  1226,   229,
     430,   175,    15,    16,    55,    56,   113,    15,    16,   582,
     412,   214,    15,    16,   145,    97,    56,   499,   100,    96,
     175,   253,    15,    16,    12,    18,    15,    16,    12,   258,
      15,    16,   270,    12,   203,  1973,   253,   253,   476,  2327,
     112,  3457,  3047,  2667,   253,    15,    16,  3022,    94,   170,
     170,  3056,  3177,   203,   476,  2745,   583,    97,   474,   540,
     100,   337,  2333,   175,   591,    15,    16,    10,   108,   175,
     517,  3076,  2038,     8,   287,   234,  3081,   360,    15,    16,
     374,   555,   498,  1311,   475,    15,    16,  1315,   479,  3064,
    2056,    89,    27,   540,   516,   569,   915,   382,  1094,    37,
     175,  1936,   330,   584,   421,    15,    16,   217,   590,   682,
    3103,   549,   499,  2737,   431,    15,    16,  1047,   435,   521,
     352,  1606,  2410,   440,   267,  1055,  1611,   357,   445,   591,
      15,    16,  1617,   179,   374,  1620,   352,   125,   476,   270,
     217,   125,   497,   128,   382,    64,   125,   253,   405,  3112,
     467,   440,   391,   583,  1084,  1085,   228,  2443,   270,  1252,
     755,   376,   351,   270,  2374,   354,   540,   522,   485,  2398,
     412,   454,   335,   350,  3590,    15,    16,  2115,   495,   351,
    1106,  3733,   354,  1114,   501,   130,  3169,    15,    16,  2432,
     507,   390,   509,   510,   447,   338,  2406,   514,   515,  1114,
     287,   495,   405,  2446,   476,    49,   495,  1048,   525,   382,
     394,   351,   529,  1517,   354,   337,   445,   534,   535,   591,
     537,   538,   539,   540,  1674,   321,   411,   131,  1321,   354,
     411,  1591,  2060,   556,   351,  1030,   341,   354,   514,   446,
    3366,   455,  1173,   482,  3207,   175,   583,   381,   539,   585,
     994,   372,   372,   538,   530,   495,   573,  2522,  1173,   390,
     534,    15,    16,   521,  1980,   361,   552,   537,   538,  2432,
    1080,   351,   589,   553,   354,  2103,   351,  2112,   493,   354,
     597,   598,   569,  2446,   351,   602,   326,   354,   351,  3414,
     351,   354,   609,   354,  1363,  2399,  2400,   512,  2969,  1749,
     589,    15,    16,  1753,   508,    15,    16,   534,   351,   598,
    1850,   354,  1852,   981,   508,   351,   476,   548,   354,  1035,
     351,   498,   639,   354,   556,   484,  1942,  1925,   374,   525,
     499,  1126,   583,  1625,  1403,  1839,  1004,  1787,   351,   556,
     556,   354,  2114,   351,   476,  1925,   354,   556,   351,   499,
    1118,   354,    15,    16,   584,   589,   558,   589,   351,   591,
     508,   354,   351,   563,   559,   354,   351,  1818,   589,   354,
      15,    16,   589,   589,   563,   591,  3339,   520,    15,    16,
     589,   351,   699,   589,   354,   540,   589,   589,  1845,   426,
     707,   563,  1990,   710,  2430,   584,   713,   714,  3391,   589,
     585,   351,  1859,  1860,   354,  2676,   527,   527,  2346,  2347,
    1990,   585,   585,   453,   351,   349,   588,   354,   495,   501,
     418,   351,   504,   563,   354,   714,    15,    16,     8,   560,
     585,   374,  1176,  3396,   353,   525,  3107,   525,    15,    16,
     757,   351,   759,  3448,   354,  3450,   563,  2045,   588,   495,
     407,   351,   356,   570,   354,   455,   156,   547,   548,  1127,
    2670,    15,    16,   551,   504,  2045,   351,  3460,   757,   354,
     759,   269,  2673,   411,   525,    15,    16,  2722,   270,   540,
     585,  2726,    94,   563,   289,   430,   430,   425,   563,    15,
      16,   335,   532,  2722,   590,   583,   563,  2726,  2708,  2742,
     563,   343,   563,  1731,   584,   585,   552,  2684,   446,  1994,
     585,   351,   236,  3476,   354,   217,    64,   584,   585,   361,
     563,   584,   585,   351,   585,   249,   354,   563,   471,   555,
     332,   333,   563,    15,    16,  3518,   238,  1356,  2023,   344,
    2025,   584,   585,   569,   107,  2030,  2145,  2146,   584,   585,
     563,    15,    16,   584,   585,   563,   112,    15,    16,   175,
     563,  2046,  1513,  2048,  2049,  2050,   178,   411,   511,  1410,
     563,   584,   585,  1801,   563,  1505,   584,   585,   563,  2742,
     164,   584,   585,   499,   164,  1515,  1516,  1513,  2526,  1519,
    1520,  1542,   909,   563,   911,   584,   585,   351,   390,  1343,
     354,   149,   446,   166,   253,   217,   404,    15,    16,   552,
     226,  1452,  1453,   563,   584,   585,  1542,   934,   430,   221,
      15,    16,  3009,   940,  1963,  1964,   563,   229,   585,  2841,
      15,    16,  2390,   563,   584,   585,  2837,   351,   583,   583,
     354,   351,   587,   587,   354,   934,   495,   584,   585,    15,
      16,    15,    16,   563,  3042,  1450,   145,   499,  1402,   243,
     977,   508,   979,   563,   981,  1460,  2292,    15,    16,   585,
    1974,  1415,   228,  3363,   584,   585,   993,   994,   563,    76,
      15,    16,   382,   172,   584,  2136,  1003,  1004,   351,  1484,
    2141,   354,   416,  3286,  1625,    92,  2197,  1014,   175,  2059,
    3693,   430,  1992,   352,   267,  2156,   351,    15,    16,   354,
    1625,     0,  2163,  1481,   351,    15,    16,   354,   325,  1036,
    1037,  1038,  1039,   563,    50,    15,    16,  2178,  2179,  1046,
    2328,  1048,    58,   430,  2185,   563,   352,  1054,   585,  2196,
     555,     3,  2193,   325,   584,   585,    11,  3437,  2328,  1038,
    1039,   335,   229,  1548,   569,   357,   584,   585,  2449,   557,
    1077,    19,   351,   253,   499,   354,  1036,  1037,   560,    12,
     191,   583,  3001,  3002,   351,   338,  1046,   354,   583,    15,
      16,  2232,  2286,  2993,  1054,   229,    15,    16,  1077,  1858,
    3461,  2295,  3179,  2731,    15,    16,   370,   351,    59,   398,
     354,  2311,  2312,  2313,   107,   353,   172,  1124,   252,   563,
    1127,   351,  1607,  1608,   354,  1610,  3020,  1612,  1613,  1614,
    1615,  1616,   107,  1618,  1619,   351,   287,  2117,   354,    94,
     584,   585,  2342,  2343,  2344,  1124,  3507,   258,   538,   430,
     430,   258,   267,    15,    16,    15,    16,   145,   460,   563,
     585,  3239,  2303,   563,   583,   446,    15,    16,   116,  1176,
     430,  1178,   352,  1180,  1181,  1182,  1183,  1184,   495,   351,
     584,   585,   354,   472,   584,   585,  1193,   526,  1195,   126,
     172,   166,   125,   495,   496,   585,   583,   351,    15,    16,
     354,   325,   499,   351,  1183,    38,   354,    15,    16,   493,
     563,   495,    15,    16,   335,  2733,  2734,  2735,  3109,   158,
    1180,  1181,  1229,   338,   179,   527,   523,   499,   563,   336,
     381,  2149,   585,   374,   345,   537,   563,    71,    72,  2157,
      15,    16,   258,   526,  2762,    15,    16,   362,   453,   584,
     585,   523,    12,   351,    15,    16,   354,   584,  3193,   214,
     548,   395,  1269,   551,   545,   546,   351,   520,   447,   354,
      15,    16,    15,    16,   267,   112,   351,   111,   399,   354,
     262,    15,    16,   234,   563,    15,    16,   120,   591,    12,
      15,    16,   267,   455,   508,   351,   563,   351,   354,   133,
     354,   584,   583,   583,   455,   584,   585,    15,    16,    15,
      16,   583,   420,   351,  3208,  3209,   354,   584,   585,   563,
    3430,  1328,  3432,   583,  2554,  2555,   351,   532,  2644,   354,
     471,   165,   289,   563,   445,   493,  1343,   495,    20,  1816,
     584,   585,    15,    16,   583,   338,    28,   563,   510,    15,
      16,    33,   591,   351,   584,   585,   354,    15,    16,    15,
      16,   351,   567,   338,   354,   125,     3,    16,   584,   585,
     511,   351,    15,    16,   354,   499,   313,    15,    16,   537,
     331,    18,   213,   558,   496,    15,    16,   344,   496,  2677,
     495,   563,   435,   332,   333,  1402,   226,   440,   337,   523,
    1407,  1408,   125,  1410,   217,   520,   347,  2677,  1415,   563,
     585,   552,   584,   585,  1421,   563,  1423,    15,    16,   374,
     966,  1428,  1429,   969,  1431,   351,   972,   213,   354,   537,
     584,   585,   351,    55,    56,   354,  1443,   585,   572,  1446,
     351,   558,  2730,   354,   552,  1452,  1453,  1454,  1455,  1428,
    1429,    88,  1431,   584,   585,  1462,  1463,  1464,  1943,   583,
    2730,   175,    15,    16,  1443,   563,   270,  1446,  2756,  1558,
      55,    56,  1561,  1480,  3341,  1454,  1455,   591,   563,    64,
    2680,  1570,  1489,  1462,  1463,  1464,  2756,   585,   563,   351,
    1579,   351,   354,   584,   354,   589,  2637,  2575,   145,  1506,
     585,   325,   351,   113,   471,   354,   583,   563,   145,   563,
     585,  1518,   405,    15,    16,    11,  1950,   152,  1952,  1953,
      15,    16,   473,  1530,   344,   563,   540,   520,   584,  1536,
    2289,   585,   169,   484,   351,   172,   420,   354,   563,  1518,
     495,  2026,  2027,   351,   373,   520,   354,   585,   351,    15,
      16,   354,   584,   585,   390,    15,    16,  1536,   195,   393,
     585,  3488,  2047,   493,   201,   563,   349,   403,  2002,  2003,
    2028,   344,  3472,   563,   585,   514,   351,   214,   214,   354,
      47,   351,   219,   563,   354,   175,  3562,   585,  1595,   226,
     351,   530,   263,   354,   204,   585,  1603,  3387,    47,   236,
     584,   585,  2734,  2735,  2038,   585,   351,   443,   351,   354,
     561,   354,   249,  2843,   430,   585,   253,   351,    15,    16,
     354,   351,  2056,  1630,   354,   262,   351,  1312,  1313,   354,
     107,    15,    16,    15,    16,   584,   585,   563,    15,    16,
     577,   578,   579,   580,   563,   351,    15,    16,   354,   344,
       3,   526,   563,   577,  1661,   462,   463,  1664,   465,   585,
     270,    15,    16,    67,   426,    18,   585,   263,    15,    16,
     584,   585,   584,   585,   585,   499,  2964,   150,   351,    15,
      16,   354,  1661,   584,   585,   351,  2916,   324,   354,   166,
     446,    15,    16,   351,  2964,   351,   354,  2131,   354,   523,
     583,   563,  2774,   563,  2138,  2777,  2778,   344,   351,    15,
      16,   354,   253,   351,   563,   352,   354,   584,   585,   584,
     585,   351,  2794,   585,   354,   585,   203,   584,   585,   545,
     546,  2340,   516,    15,    16,    88,   585,   374,    15,    16,
    2381,   172,    15,    16,   584,   585,   563,   476,    15,    16,
      15,    16,   476,   351,   476,   563,   354,   287,    68,   583,
     563,   584,   585,   584,   585,  2381,   170,   583,   585,  2389,
      80,   476,    15,    16,    15,    16,   493,   585,   263,   416,
     473,   474,   585,   476,  3038,   478,   142,  3041,   563,    78,
     267,   585,   145,   563,  2325,   275,   276,   346,   351,   489,
    2302,   354,   563,   584,   585,  2946,   584,    15,    16,   446,
     585,     3,  2841,   217,   111,   585,   429,  1824,   563,   172,
     563,    15,    16,    52,   585,  3079,    15,    16,  3082,   563,
     399,    15,    16,   563,   238,   152,    15,    16,   563,   584,
    2371,   584,   195,   583,   481,  2279,   584,   585,   201,   351,
       7,   585,   354,    15,    16,   585,   351,   563,   552,   354,
     585,   338,    19,   584,   585,    22,   219,  3539,  3540,   175,
    2355,    54,    29,   226,   590,    15,    16,   584,   585,   585,
     584,   585,    39,   236,   211,   351,    15,    16,   354,   526,
     563,   351,    49,   585,   354,   179,   249,   563,   584,   585,
     253,   552,   539,   540,   570,   563,   585,   563,   179,   262,
      15,    16,   585,  3214,  3215,   591,   396,   397,  1925,   556,
     563,   558,   583,    15,    16,   563,   583,   585,   583,   585,
      87,   241,   570,   563,  2686,  2687,  1943,  1944,  2656,  2657,
     585,  2700,   585,  1950,   583,  1952,  1953,   584,   585,   583,
     107,   108,   589,   110,   351,   585,   583,   354,   583,  2444,
     583,  3633,  3634,   583,   121,   563,  2451,   351,   372,   351,
     354,   324,   354,   156,   351,   583,   159,   354,  2954,  2955,
     583,   583,   351,  1990,   583,   354,   463,   585,  3242,   172,
     583,   344,   583,    15,    16,  2002,  2003,   351,   585,   352,
     354,   311,   583,   583,   351,  2012,   583,   354,   583,  2443,
     563,  2018,   583,   583,  2021,   351,  2996,  2024,   354,   583,
     583,   374,   583,    15,    16,   335,   583,   351,  2035,  2036,
     354,  2038,   585,   583,    15,    16,   583,  2044,  2045,   583,
     583,  3036,  3037,   520,   583,   351,   107,  2054,   354,  2056,
      15,    16,   583,  2060,  2061,   583,   583,    15,    16,  3054,
     583,   563,   583,   416,   583,  3060,   583,   583,   563,   351,
      15,    16,   354,   583,   351,  2054,   583,   354,   351,   389,
     583,   354,   583,   585,   351,   583,   351,   354,  3083,   354,
     585,  3086,   583,   446,   583,  2102,  2103,   563,   499,    15,
      16,   583,   583,   563,   583,   166,   590,   583,   351,   583,
     351,   354,   583,   354,    15,    16,   299,    47,   583,   585,
     583,   583,  3410,  2102,  2131,   585,    15,    16,   481,   583,
     583,  2138,   583,    15,    16,   583,   583,   583,    15,    16,
     583,   583,   203,   351,  2151,   583,   354,   583,   583,   583,
     583,  3326,  3327,  3328,  3329,   583,   583,   351,   583,   583,
     354,   471,   351,  3303,   583,   354,   563,   351,   583,   583,
     354,   583,   351,   526,   583,   354,  3317,    15,    16,   563,
     583,   563,    15,    16,    15,    16,   563,   540,   585,   351,
    2197,   583,   354,   583,   563,    15,    16,    15,    16,   382,
     583,   585,   584,   556,   583,   558,   267,   583,   585,   563,
     192,   351,   583,   583,   354,   584,   563,   583,   583,    15,
      16,   583,   351,   583,   583,   354,   583,   563,   583,  3517,
     584,   584,   585,    15,    16,   583,   589,   584,   583,   563,
     583,    15,    16,   583,   583,   583,   351,   591,   584,   354,
      15,    16,    15,    16,   583,  2689,   591,   563,   583,   351,
     584,   583,   354,   583,   421,    15,    16,   583,   583,   583,
     583,  2705,  2279,   558,   431,    15,    16,   338,   435,   583,
     583,   563,   583,   440,   583,   583,   563,   583,   445,   583,
     563,    15,    16,   583,   585,   493,   563,  2304,   563,   287,
     583,  2308,   584,  2310,  2311,  2312,  2313,   584,   290,   291,
     467,   584,   294,   295,  2321,    15,    16,   584,  2325,   584,
     563,  2328,   563,   258,  2826,    15,    16,   287,   485,   351,
     585,   585,   354,   508,   585,  2342,  2343,  2344,   495,    15,
      16,   584,  2321,   584,   501,   420,  2831,   422,  2355,   424,
     507,   426,   509,   510,  2361,   563,  2363,   514,   515,   351,
     508,   585,   354,   585,  2371,   585,   229,   499,   525,   563,
     351,   577,   529,   354,   563,   172,   584,   534,   535,   563,
     537,   538,   539,   540,   563,   230,   351,   491,   160,   354,
     584,   172,   585,   351,  3682,   584,   354,    15,    16,   533,
     584,   563,    15,    16,   585,   584,   351,   457,   363,   354,
     583,   585,  3682,   584,    12,  3703,   573,   585,   145,   145,
      15,    16,   584,   563,   145,  2432,    15,    16,  3211,  3212,
    3213,  3719,   589,   145,   563,   351,  2443,   145,   354,  2446,
     597,   598,  3128,  3618,   584,   602,    15,    16,  2950,  3719,
     351,   145,   609,   354,   145,   584,   145,   145,   563,   520,
     145,  1429,   351,  1431,   145,   354,   541,   145,   145,   351,
     145,   563,   354,  2480,   351,   145,   585,   354,   535,   584,
    2487,   584,   639,  2490,  3251,    45,   179,  2494,  2495,    15,
      16,  2498,   584,   344,  1462,  1463,  1464,    64,    12,  2506,
     107,   175,   584,   499,   584,   125,     9,  2514,   584,   555,
    2995,  2490,   584,   351,    15,    16,   354,   584,   351,   583,
     351,   354,   591,   354,   252,    15,    16,   125,   576,   585,
     390,   351,   556,   351,   354,  2514,   354,   192,    15,    16,
    3715,   563,   699,   175,   591,  2979,   218,  3233,    88,   584,
     707,  3726,   455,   710,   381,   351,   713,   714,   354,   166,
    3246,   446,   584,    15,    16,    15,    16,    15,    16,   351,
     585,   563,   354,   585,    45,  3750,   172,   351,  3063,   471,
     354,  3039,   563,    15,    16,   471,   351,   471,   351,   354,
     471,   354,   584,    15,    16,   471,   203,   429,   563,    67,
     757,   351,   759,   584,   354,   563,   204,  3092,  3042,    54,
     508,   351,   122,   237,   354,  3382,    15,    16,   563,   584,
      15,    16,    15,    16,    15,    16,   584,   351,  3062,   494,
     354,   237,   494,   122,    45,   585,   583,   585,   540,   584,
      15,    16,    15,    16,    15,    16,   584,   563,    15,    16,
     591,   351,    15,    16,   354,   577,   585,   584,    28,   584,
     267,   351,   563,   584,   354,    16,   584,   584,   584,  3154,
    2677,  2678,   584,  2680,   563,   351,    16,  3286,   354,   219,
     584,   563,  2689,   584,   591,     4,   563,   584,  2695,   175,
       9,    10,   585,   584,   584,   584,   236,   584,  2705,   447,
      70,   584,   584,   583,   262,   584,  2713,   584,    27,   249,
     585,   156,   584,    32,   159,   584,   584,    36,   584,   508,
     584,   580,    94,  2730,   585,   563,   584,   172,   584,   584,
     563,   338,   563,   351,   584,  2742,   354,   585,   351,   591,
     584,   354,  2749,   563,   584,   563,   584,   583,  3182,  2756,
     584,   584,   909,   584,   911,  2762,   351,   583,   583,   354,
     499,   591,   351,  3449,   584,   354,   584,   563,  2537,  3271,
    3272,   141,  2541,  3583,   508,   126,   383,   934,   141,   386,
     585,   563,   351,   940,   324,   354,   126,   560,   584,   563,
     508,   258,   508,  3479,  3480,   583,  3482,   116,   563,   349,
     563,   175,   584,   226,   344,  3239,    58,   179,   175,   501,
     584,   175,   591,   563,  3624,    67,   175,   509,   510,   584,
     977,   584,   979,   563,   981,   351,   175,    79,   354,   233,
    3748,    12,  2839,   591,   584,   558,   993,   994,  3524,   563,
    3526,  3527,   338,   585,   584,   217,  1003,  1004,   540,   236,
     351,   236,   303,   354,   299,  3665,   355,  1014,    96,    40,
     584,   351,  3672,   563,   354,  1022,    96,   465,   466,   467,
     468,   469,   470,   563,   351,   413,   416,   354,  3688,  1036,
    1037,  1038,  1039,   481,   584,   238,   238,   563,   583,  1046,
    3392,  1048,   591,   352,   584,   499,   583,  1054,   577,   351,
      81,   351,   354,   351,   354,    86,   354,   225,   584,   338,
     583,  3388,  3722,   520,  3724,   584,   584,   609,   170,   351,
    1077,   338,   354,   584,   584,   584,   178,   141,   338,   351,
     584,   584,   354,   591,  2941,   126,   584,   382,    13,   591,
     591,   481,   584,   145,   146,   563,   577,   583,  3457,   214,
     563,   585,   351,   591,   344,   354,   351,  2964,   351,   354,
     351,   354,   313,   354,   175,   217,   584,  1124,   563,   584,
    1127,   584,  2979,   313,   563,   534,   351,   250,   351,   354,
     351,   354,   184,   354,   351,   229,   238,   354,   351,   584,
      64,   354,   275,   236,   563,   584,   198,   236,   370,  2768,
     370,   344,   374,   585,   238,   238,   585,    18,   344,    18,
     519,   584,    87,  3020,    18,   584,   253,   583,   710,  1176,
     583,  1178,   392,  1180,  1181,  1182,  1183,  1184,   583,   227,
     232,   227,   584,  2802,  2803,  3042,  1193,   563,  1195,   584,
     115,  2810,   244,   126,   591,   584,    88,   417,  2817,   584,
     231,   584,   584,   584,   129,  3062,   584,   584,   584,   584,
     584,  3519,   563,   585,   584,   584,   584,   132,   585,   271,
     591,   107,  1229,   563,   585,   111,   151,   584,   584,   584,
    3087,  3590,  3089,   584,   247,   585,   563,   195,   163,   430,
     448,  3593,   583,  3100,   584,  3102,   583,   145,   449,   450,
     584,   355,   236,   236,   585,   475,   111,   584,   427,   449,
     450,   563,  1269,   563,   583,   563,   111,   192,   584,   300,
     372,  3100,   313,   442,   496,   583,   328,   369,  3562,   448,
     166,   563,   584,   519,   584,   591,   584,  3639,   584,   511,
     585,   563,   217,   585,   584,   584,   229,  3154,   223,   468,
     584,   584,   584,   442,   338,    41,   381,    44,   584,   338,
     584,   558,   584,   584,   563,   537,   226,   203,   563,   584,
     563,  1328,   563,   585,    45,  3182,   201,   219,   359,   585,
     552,   310,   591,   390,   499,   584,  1343,   262,   563,   584,
     563,   584,   563,   584,   236,  3202,   563,   499,   236,   583,
     563,  3208,  3209,   540,   172,   540,   583,   249,   460,   584,
      32,   584,   551,   584,   583,  3222,    23,  3726,   583,   126,
     107,   551,   573,   574,   575,   576,   577,   578,   579,   580,
     313,   267,  3239,   573,   574,   575,   576,   577,   578,   579,
     580,  3750,   534,   111,   238,  1402,   238,   337,   940,   583,
    1407,  1408,   338,  1410,   558,   584,   583,    64,  1415,   585,
     584,    68,   584,    88,  1421,  3699,  1423,    34,   584,   310,
    3277,  1428,  1429,   584,  1431,   527,   584,   584,   459,   166,
     585,  3288,   324,   584,   154,   585,  1443,   584,   238,  1446,
     499,   499,    66,   499,   584,  1452,  1453,  1454,  1455,   584,
     375,   993,   338,    16,   111,  1462,  1463,  1464,   540,   490,
     236,  1003,   540,   200,   334,   546,   203,   585,   172,   394,
     413,   584,   338,  1480,   338,   400,   126,   349,   495,   534,
     255,   406,  1489,   100,   276,   583,   583,   583,    58,   349,
     107,    58,     3,   584,   584,     6,   374,    45,   584,  1506,
      45,   138,    13,    45,   145,   430,     5,   584,   349,   394,
     349,  1518,    23,    24,   584,   134,   449,   450,   585,    45,
      45,    45,   584,  1530,   416,   585,   451,   452,   121,  1536,
     267,   424,    16,   555,   575,   576,   577,   578,   579,   580,
      28,   158,    53,   592,   219,   583,    57,   280,   175,   166,
     555,    28,   584,  3410,  3411,   145,   313,    68,   226,   141,
     584,   236,   589,   488,   585,   213,    77,   555,   141,   105,
     269,   589,    83,  3430,   249,  3432,   592,  3434,  3435,   229,
     109,   238,  3411,   214,   571,    96,   203,   589,  1595,   481,
    3447,   338,   126,   583,   585,   141,  1603,   570,   335,   199,
     111,   338,   255,   114,   585,    34,   446,   589,   571,   534,
     404,   536,   123,   124,   172,   172,   172,   570,   129,   557,
    3477,    68,   111,  1630,   546,   558,   137,  1872,  1621,   173,
    3558,   705,   143,    80,   520,  3099,    23,    24,   174,  3102,
     573,   574,   575,   576,   577,   578,   579,   580,  3750,   324,
     267,  3276,  3715,   126,  1661,  3512,  3721,  1664,   169,  3645,
    3517,  3602,  3645,   313,  3610,  3634,  3609,  3108,    55,    56,
      57,   100,   415,   209,   121,   332,   333,    64,   107,  3536,
     337,    68,  3539,  3540,  3541,  2835,  1173,   344,   425,  1591,
      77,  3206,   449,   450,   431,  2103,   433,   434,   435,   436,
     437,   438,   439,   440,   215,  3562,   217,  2500,   325,    96,
    2762,  1595,  1557,   224,  2063,   372,  3573,   334,  2749,  2818,
     337,   338,  2016,  1547,   111,  3582,  3583,   114,  2785,   158,
      88,  2785,  3589,  3231,  3025,  1559,  1560,   166,  1562,  1563,
    1564,   416,  3071,  1567,  3062,  2750,  2705,  3604,  1572,  3606,
    3436,  1188,  1576,  1577,  1578,  3612,   143,  1581,  1582,  1583,
    1584,  1585,  3446,  1587,  1588,  1589,   302,  3624,  3225,  3371,
     306,  3288,  2110,  3246,   203,  1525,  3633,  3634,   314,   313,
    2059,   292,  1920,   520,  3641,  1169,  1091,   444,  1454,  1903,
    2321,  3648,   698,   714,   241,   479,   307,  3654,  3655,   449,
     450,   312,   627,  1934,  3336,  1469,   481,  3154,  3665,  2949,
    2720,  2139,  3435,  2950,  1266,  3672,  1313,  1824,   575,   576,
     577,   578,   579,   580,  1216,  3682,  2756,  3684,  3685,  2296,
     217,  3688,  3203,  3690,  3639,  3692,   145,   224,   267,  3182,
     313,   352,  3699,  1939,   380,   981,  3703,   358,  1004,  1899,
     361,  1924,  3709,  2964,  2730,   164,   120,  2672,  2671,  3703,
     469,   219,  3719,  3517,   311,  3722,   530,  3724,  1193,  3726,
     527,  1514,   759,   384,   385,   184,   387,   460,   236,  3736,
    3737,  2480,   499,  3740,   501,   332,   333,   504,   335,   198,
     401,   249,   428,  3750,  2662,  1009,   325,   514,  3592,    23,
      24,  3423,  3613,   520,  1420,   292,   523,  3486,   337,   338,
    3719,  2677,   423,  3064,  1022,   449,   450,  2373,  1925,    88,
     307,  1475,  2990,   573,   574,   575,   576,   577,   578,   579,
     580,    55,    56,    57,   243,   244,  1943,  1944,  2713,  3190,
      64,   205,   389,  1950,    68,  1952,  1953,  1446,   452,  1012,
     610,   974,  3324,    77,  2308,  3330,   453,   412,   575,   576,
    1178,   520,   271,   614,  2273,  1338,   324,  2628,   412,   497,
    2832,   358,    96,  2101,   361,    -1,   449,   450,  3105,   519,
     519,  2540,   519,  1990,    -1,    -1,   344,   111,    -1,    -1,
     114,    -1,    -1,    -1,    -1,  2002,  2003,   384,   385,   263,
     387,    -1,    -1,    -1,    -1,  2012,   517,    -1,    -1,    12,
      13,  2018,    -1,    -1,  2021,   526,    -1,  2024,   554,   143,
      -1,   330,    -1,   287,   471,    -1,    -1,    -1,  2035,  2036,
     566,  2038,    -1,    -1,    -1,    -1,   423,  2044,  2045,   573,
     574,   575,   576,   577,   578,   579,   580,  2054,    -1,  2056,
     219,    -1,    -1,  2060,  2061,    -1,    -1,    -1,   416,    -1,
      -1,    -1,   371,    -1,    -1,    -1,    -1,   236,    -1,    -1,
     499,    -1,   501,    -1,   585,   504,    -1,    -1,   589,    -1,
     249,    -1,    12,    13,    87,   514,    -1,    -1,    -1,    -1,
      -1,   520,    -1,   217,   523,  2102,  2103,    -1,    -1,    -1,
     224,   574,   575,   576,   577,   578,   579,   580,    -1,   373,
      -1,    -1,   115,    -1,    -1,    -1,    -1,   381,    -1,    -1,
      -1,    -1,    -1,   481,  2131,    -1,   129,     3,   252,    -1,
     517,  2138,    -1,    -1,    -1,    -1,    -1,    13,    14,   526,
      -1,    -1,    -1,   532,  2151,   409,   575,   576,   151,    -1,
      26,    -1,    28,    -1,    -1,   324,    -1,    87,    -1,    -1,
     163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   292,    -1,
      -1,    47,    48,    -1,    -1,   344,    -1,    53,    -1,    -1,
      -1,    57,    58,   307,    -1,   115,    -1,    -1,  3512,   192,
    2197,   455,    -1,    -1,    70,    -1,   585,    -1,   585,   129,
      -1,    -1,    -1,    -1,    -1,  2029,    -1,  2766,  2767,    -1,
      -1,    87,   476,    -1,   217,  2774,  2040,    -1,  2777,  2778,
     223,   151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   493,
     106,   495,    -1,   163,   358,  2794,    -1,   361,    -1,   115,
     116,   117,    -1,    -1,    -1,    -1,    -1,   416,    -1,  2808,
      -1,    -1,   128,   129,  2813,  2814,  2815,  2816,    -1,   262,
     384,   385,   192,   387,    -1,  3589,    -1,    -1,    -1,    -1,
      -1,    -1,  2279,    -1,    -1,   151,    -1,    -1,    -1,    -1,
    3604,   107,  3606,    -1,    -1,    -1,    -1,   217,  3612,    -1,
      -1,    -1,   168,   223,    -1,    -1,    -1,  2304,    -1,   423,
      -1,  2308,    -1,  2310,  2311,  2312,  2313,    -1,    -1,    -1,
      -1,    -1,   481,    -1,  2321,    -1,   192,    -1,  2325,    -1,
      -1,  2328,    -1,   199,  3648,    -1,   202,    -1,   717,   126,
      -1,  3655,   262,    -1,    -1,  2342,  2343,  2344,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,    -1,   223,  2355,    -1,
      -1,    -1,    -1,    -1,  2361,    -1,  2363,    -1,    -1,    -1,
      -1,  3685,    -1,   239,  2371,    -1,  3690,    -1,    -1,    -1,
      -1,    -1,   375,    -1,    -1,    -1,    -1,   203,    -1,    -1,
      -1,   257,    -1,    -1,    -1,  3709,   262,    -1,    -1,    -1,
      -1,   394,    -1,   517,    -1,    -1,    -1,   400,    -1,    -1,
      -1,    -1,   526,   406,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3736,  3737,    -1,    -1,  3740,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2432,    -1,   430,    -1,    -1,
      -1,    -1,   229,    -1,    -1,    -1,  2443,   826,    -1,  2446,
      -1,   267,    -1,    -1,    -1,   375,    -1,    -1,   451,   452,
      -1,    -1,    -1,    -1,    -1,   252,    -1,    -1,    -1,   583,
      -1,    -1,    -1,   852,   394,    -1,    -1,    -1,    -1,    -1,
     400,    -1,   348,  2480,    -1,    -1,   406,    -1,    -1,    -1,
    2487,    -1,    -1,  2490,    -1,   488,    -1,  2494,  2495,    -1,
      -1,  2498,    -1,    -1,   370,    -1,    -1,    -1,    -1,  2506,
     430,    -1,    -1,   379,    -1,    -1,    -1,  2514,    -1,   335,
      -1,    -1,   338,    -1,   903,    -1,   313,    -1,   907,    -1,
      -1,   451,   452,   399,    -1,   401,   402,    -1,    -1,   405,
      -1,   534,   408,   536,   410,   332,   333,    -1,    -1,   415,
      -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     426,    -1,    -1,    -1,   430,    -1,    -1,    -1,   488,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     446,    -1,    -1,    -1,    -1,   451,    -1,    -1,    -1,   455,
     273,   274,   275,   276,   277,   278,    -1,    -1,   281,   282,
     283,   284,   285,   286,    -1,   288,    -1,    -1,   395,   475,
      -1,    -1,    -1,   479,   534,   431,   536,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1022,    -1,    -1,    -1,    -1,    -1,   515,
      -1,    -1,  1031,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   449,   450,    -1,   531,    -1,    -1,   534,    -1,
      -1,   458,    -1,   539,    -1,    -1,    -1,    -1,    -1,    -1,
    2677,  2678,    -1,  2680,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2689,    23,    24,    -1,   562,    -1,  2695,    -1,
      -1,    -1,    -1,    -1,   520,    -1,    -1,    -1,  2705,    -1,
      -1,    -1,    -1,   396,   397,    -1,  2713,   583,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    55,    56,    57,    -1,    -1,
      -1,    -1,    -1,  2730,    64,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    -1,  2742,    -1,    77,    -1,    -1,
      -1,    -1,  2749,    -1,    -1,    -1,    -1,    -1,    -1,  2756,
      -1,    -1,    -1,    -1,    -1,  2762,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   111,    -1,    -1,   114,   572,   573,   574,   575,   576,
     577,   578,   579,   580,    -1,   101,   102,   103,   104,   105,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,  1197,  1198,
    1199,    -1,    -1,    -1,    -1,    -1,    -1,  1206,  1207,    -1,
      -1,  1210,    -1,  1212,  1213,  1214,  1215,    -1,    -1,    -1,
    1219,    -1,  2839,  1222,  1223,    -1,  1225,    -1,  1227,  1228,
      -1,  1230,  1231,  1232,  1233,  1234,    -1,  1236,    -1,  1238,
    1239,  1240,    -1,  1242,  1243,  1244,  1245,    -1,  1247,  1248,
      -1,  1250,    -1,    -1,  1253,  1254,  1255,    -1,  1257,  1258,
    1259,  1260,    -1,  1262,  1263,  1264,  1265,   217,    -1,    -1,
      -1,    -1,  1271,  1272,   224,  1274,  1275,  1276,  1277,  1278,
     206,   207,   208,   209,  1283,    -1,  1285,  1286,  1287,  1288,
    1289,    -1,    -1,  1292,  1293,  1294,  1295,  1296,  1297,    -1,
    1299,  1300,    -1,    -1,    -1,  1304,  1305,  1306,    -1,  1308,
      -1,  1310,    -1,    -1,    -1,  1314,    -1,  1316,  1317,    -1,
      -1,    -1,    -1,  1322,  2941,    -1,    13,    14,    -1,    -1,
      -1,  1330,  1331,  1332,    -1,    -1,    -1,    -1,    -1,    26,
    1339,    -1,   292,  1342,    -1,    -1,    -1,  2964,    -1,    -1,
    1349,  1350,  1351,    -1,    -1,    -1,    -1,   307,    -1,    -1,
      47,    48,  2979,    -1,    -1,    -1,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,   302,    -1,   304,   305,
     306,    -1,    -1,    70,    -1,    -1,    -1,    -1,   314,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    -1,    -1,  3020,    -1,  1404,    -1,    -1,   358,    -1,
      -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,
      -1,    -1,    -1,    -1,    -1,  3042,    -1,    -1,   115,   116,
     117,    -1,    -1,    -1,   384,   385,    -1,   387,    -1,    -1,
      -1,   128,   129,    -1,    -1,  3062,    -1,    -1,    -1,    -1,
    1449,    -1,    -1,    -1,   380,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,
    3087,    -1,  3089,   423,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   168,    -1,  3100,    -1,  3102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   427,   428,    -1,    -1,   192,    -1,    -1,    -1,    -1,
      -1,    -1,   199,    -1,    -1,   202,    -1,    31,    32,    -1,
      -1,    -1,    -1,    37,    -1,    39,    -1,    41,    42,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   223,  3154,    -1,    -1,
      -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   239,    -1,    23,    24,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3182,    -1,   517,    -1,    -1,
     257,    -1,    -1,    -1,    -1,   262,   526,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    -1,  3202,   100,    -1,    57,    -1,
      -1,  3208,  3209,    -1,   108,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,  3222,  1605,    -1,    77,    -1,
      -1,    -1,    -1,   127,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3239,    -1,    -1,    -1,    -1,    96,   554,    -1,
     144,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,
     566,    -1,   111,    -1,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   165,    -1,   167,    -1,    -1,    -1,    -1,    -1,    -1,
    3277,   348,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3288,   186,   187,   143,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,   227,   401,   402,    -1,    -1,   405,    -1,
      -1,   408,    -1,   410,    -1,    -1,    -1,    -1,   415,    -1,
     417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,
      -1,    -1,   256,   430,    -1,    -1,    -1,    -1,   217,    -1,
      -1,   265,   266,    -1,   268,   224,    -1,    -1,    -1,   446,
      -1,    -1,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,    -1,    -1,    -1,   475,    -1,
      -1,    -1,   479,  3410,  3411,    -1,    -1,  1796,  1797,  1798,
      -1,    -1,    -1,   317,   318,   319,    -1,    -1,    -1,   323,
      -1,    -1,   326,  3430,  1813,  3432,    -1,  3434,  3435,    -1,
      -1,    -1,    -1,   292,    -1,   339,   340,    -1,   515,    -1,
    3447,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,    -1,
    1839,    -1,    -1,    -1,   531,    -1,    -1,   534,    -1,    -1,
      -1,   365,   539,   367,    -1,    -1,    -1,    -1,    -1,    -1,
    3477,    -1,  1861,    -1,    -1,    -1,    -1,  3512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   562,    -1,   391,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
      -1,    -1,   361,    -1,  3539,  3540,   583,    -1,    -1,    -1,
    3517,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   384,   385,    -1,   387,  3536,
      -1,    -1,    -1,    -1,  3541,    -1,    -1,    -1,    -1,    -1,
     444,    -1,   446,    -1,    -1,    -1,    -1,  3582,  3583,    -1,
      -1,    -1,   456,    -1,  3589,  3562,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   423,    -1,  3573,    -1,    -1,  3604,
      -1,  3606,    -1,    -1,    -1,    -1,    -1,  3612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3624,
      -1,    -1,    -1,    -1,    -1,    -1,   500,   501,  3633,  3634,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3648,    -1,    -1,    -1,    -1,    -1,    -1,
    3655,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3665,    -1,    -1,    -1,  3641,    -1,    -1,  3672,    -1,    -1,
      -1,    -1,    -1,   547,   548,    -1,    -1,  3654,    -1,    -1,
    3685,    -1,    -1,  3688,    -1,  3690,    -1,    -1,   517,    -1,
      -1,    -1,   566,    -1,    -1,    -1,    -1,   526,    -1,    -1,
      -1,    -1,    -1,    -1,  3709,  3682,    -1,  3684,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3692,    -1,  3722,    -1,  3724,
      -1,    -1,  3699,    -1,    -1,    -1,  3703,    -1,    -1,    -1,
      -1,  3736,  3737,    -1,    -1,  3740,    -1,    -1,    -1,    -1,
      -1,    -1,  3719,    -1,    -1,    -1,    -1,    -1,    -1,  3726,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2118,
      -1,    -1,  2121,    -1,    -1,  2124,  2125,    -1,    -1,    -1,
      -1,    -1,    -1,  3750,    -1,    -1,    -1,    -1,  2137,    -1,
      -1,  2140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2153,    -1,  2155,    -1,    -1,    -1,
    2159,    -1,  2161,  2162,    -1,    -1,    -1,  2166,    -1,  2168,
    2169,    -1,  2171,    -1,    -1,  2174,    -1,  2176,  2177,    -1,
      -1,    -1,    -1,  2182,  2183,    -1,    -1,  2186,    -1,  2188,
      -1,  2190,    -1,  2192,    -1,  2194,    -1,    -1,     6,    -1,
      -1,    -1,    -1,    -1,    -1,    13,  2205,  2206,    -1,    -1,
    2209,    -1,  2211,    -1,    -1,    23,    24,    -1,    -1,    -1,
    2219,  2220,    -1,  2222,    -1,  2224,    -1,    -1,  2227,  2228,
    2229,    -1,  2231,    -1,    -1,    -1,    -1,    -1,  2237,  2238,
    2239,  2240,    -1,    -1,    -1,    53,  2245,  2246,  2247,    57,
    2249,    -1,  2251,    -1,  2253,    -1,  2255,    -1,  2257,    -1,
      68,    -1,    -1,    -1,    -1,  2264,    -1,  2266,    -1,    77,
    2269,  2270,    -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,
      -1,  2280,    30,    -1,    32,    33,    -1,    -1,    96,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2295,    -1,    -1,    -1,
      -1,    -1,    -1,   111,    -1,    -1,   114,    55,    56,    -1,
      -1,    -1,    -1,    -1,    -1,   123,  2315,    65,    -1,    67,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
      -1,    -1,    -1,    -1,    -1,   143,    -1,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,    -1,    -1,    -1,  2364,    -1,    -1,    -1,    -1,
    2369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   142,   143,    -1,    -1,    -1,   147,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,
      -1,    -1,    -1,    -1,  2413,    -1,   224,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2427,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,   217,
      -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   292,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,
      -1,    -1,    -1,    -1,   312,    -1,    -1,    -1,    -1,    -1,
     258,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2530,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
      -1,    -1,    -1,    -1,   352,    -1,    -1,    -1,    -1,    -1,
     358,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   320,    -1,    -1,    -1,   384,   385,    -1,   387,
      -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   401,    -1,    -1,    -1,    -1,    -1,   347,
      -1,    -1,    -1,    -1,  2603,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2613,   423,  2615,    -1,  2617,    -1,
      -1,    -1,    -1,    -1,  2623,   373,   374,    -1,    -1,   377,
     378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2646,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   440,    -1,    -1,    -1,    -1,   445,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   455,    -1,   517,
      -1,    -1,    -1,    -1,    -1,  2714,    -1,    -1,   526,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   476,    -1,
      -1,    -1,   480,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   495,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   549,    -1,    -1,    -1,   553,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2864,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2874,    -1,    -1,    -1,    -1,
      -1,  2880,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2889,  2890,    -1,    -1,    -1,    -1,  2895,    -1,    -1,    -1,
    2899,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2912,    -1,    -1,    -1,    -1,    -1,  2918,
      -1,    -1,  2921,  2922,    -1,  2924,  2925,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2938,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3005,  3006,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3016,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3177,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3299,    -1,    -1,    -1,    -1,    -1,  3305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3350,    -1,  3352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3414,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3466,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3489,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3578,
    3579,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3598,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3607,    -1,
      -1,    -1,    -1,    -1,    -1,  3614,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3623,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,  3652,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,  3666,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    43,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,  3727,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,   245,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,   479,
     480,    -1,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,   509,
     510,    -1,   512,   513,   514,   515,   516,   517,   518,    -1,
     520,   521,   522,   523,    -1,   525,    -1,    -1,   528,   529,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,   541,   542,   543,   544,   545,   546,    -1,    -1,   549,
     550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,
      -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,
      -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,    -1,
     590,   591,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,   344,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,    -1,   586,   587,    -1,    -1,   590,   591,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,   430,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,   477,   478,   479,   480,    -1,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,
     516,   517,   518,    -1,   520,   521,   522,   523,    -1,   525,
      -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,
     566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,
     576,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,
     586,   587,    -1,    -1,   590,   591,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,   584,    -1,   586,   587,    -1,
      -1,   590,   591,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,    -1,
      -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,
     452,   453,   454,   455,    -1,   457,   458,   459,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,
     472,    -1,    -1,   475,   476,   477,   478,   479,   480,    -1,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,
     512,   513,   514,   515,   516,   517,   518,    -1,   520,   521,
     522,   523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,
      -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,
     542,   543,   544,   545,   546,    -1,    -1,   549,   550,    -1,
     552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,
     562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,
      -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,
      -1,   583,   584,    -1,   586,   587,    -1,    -1,   590,   591,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,   584,
      -1,   586,   587,    -1,    -1,   590,   591,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,
     478,   479,   480,    -1,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,   513,   514,   515,   516,   517,
     518,    -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,
     528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,   541,   542,   543,   544,   545,   546,    -1,
      -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,
      -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,
      -1,    -1,    -1,   581,    -1,   583,   584,    -1,   586,   587,
      -1,    -1,   590,   591,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    83,    84,    85,    86,    -1,    -1,    89,    90,
      91,    -1,    93,    94,    -1,    96,    97,    98,    99,   100,
      -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
     111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,    -1,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,    -1,   168,    -1,    -1,
     171,    -1,   173,   174,   175,   176,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,   186,   187,   188,   189,   190,
     191,    -1,   193,   194,    -1,   196,   197,    -1,   199,   200,
      -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,   242,   243,    -1,    -1,   246,   247,    -1,   249,   250,
      -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,    -1,   337,   338,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,   388,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,   513,   514,   515,   516,   517,   518,    -1,   520,
     521,   522,   523,    -1,   525,    -1,    -1,   528,   529,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,
     571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,
     581,    -1,   583,    -1,    -1,   586,   587,    -1,    -1,   590,
     591,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,   477,   478,   479,   480,    -1,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,
     514,   515,   516,   517,   518,    -1,   520,   521,   522,   523,
      -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,   543,
     544,   545,   546,    -1,    -1,   549,   550,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
     564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,
      -1,    -1,   586,   587,    -1,    -1,   590,   591,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    83,    84,    85,    86,
      -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,    96,
      97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,
      -1,   118,   119,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,   154,   155,   156,
     157,   158,   159,   160,    -1,   162,   163,   164,   165,   166,
      -1,   168,    -1,    -1,   171,    -1,   173,   174,   175,   176,
     177,    -1,   179,   180,   181,   182,   183,    -1,   185,   186,
     187,   188,   189,   190,   191,    -1,   193,   194,    -1,   196,
     197,    -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,   213,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,
      -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,    -1,
     337,   338,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   493,   494,    -1,   496,
     497,    -1,   499,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,   516,
     517,   518,    -1,   520,   521,   522,   523,    -1,   525,    -1,
      -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,   576,
      -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,   586,
     587,    -1,    -1,   590,   591,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,   479,
     480,    -1,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,   513,   514,   515,   516,   517,   518,    -1,
     520,   521,   522,   523,    -1,   525,    -1,    -1,   528,   529,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,   541,   542,   543,   544,   545,   546,    -1,    -1,   549,
     550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,    -1,
      -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,    -1,
      -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,    -1,
     590,   591,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      -1,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      83,    84,    85,    86,    -1,    -1,    89,    90,    91,    -1,
      93,    94,    -1,    96,    97,    98,    99,   100,    -1,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,   112,
      -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
      -1,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,   164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,
     173,   174,    -1,   176,   177,    -1,   179,   180,   181,   182,
     183,    -1,   185,   186,   187,   188,   189,   190,   191,    -1,
     193,   194,    -1,   196,   197,    -1,   199,   200,    -1,   202,
     203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
     213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
     223,   224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
     243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,
      -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,   325,   326,   327,    -1,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,   388,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     493,   494,    -1,   496,   497,    -1,   499,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
     513,   514,   515,   516,   517,   518,    -1,   520,   521,   522,
     523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,   542,
     543,   544,   545,   546,    -1,    -1,   549,   550,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,    -1,   586,   587,    -1,    -1,   590,   591,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,   477,   478,   479,   480,    -1,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,    -1,   499,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,   515,
     516,   517,   518,    -1,   520,   521,   522,   523,    -1,   525,
      -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,    -1,
     566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   575,
     576,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,    -1,
     586,   587,    -1,    -1,   590,   591,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    -1,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    83,    84,    85,    86,    -1,    -1,
      89,    90,    91,    -1,    93,    94,    -1,    96,    97,    98,
      99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,
     119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,
     139,   140,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,   164,   165,   166,    -1,   168,
      -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,
     179,   180,   181,   182,   183,    -1,   185,   186,   187,   188,
     189,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
     199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,   213,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,    -1,   337,   338,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,   388,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,    -1,   428,
     429,    -1,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,
      -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,
     469,    -1,    -1,   472,    -1,    -1,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,   496,   497,    -1,
     499,   500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,
      -1,   510,    -1,   512,   513,   514,   515,   516,   517,   518,
      -1,   520,   521,   522,   523,    -1,   525,    -1,    -1,   528,
     529,   530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,
      -1,    -1,   541,   542,   543,   544,   545,   546,    -1,    -1,
     549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,
     559,    -1,   561,   562,    -1,   564,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,    -1,   583,    -1,    -1,   586,   587,    -1,
      -1,   590,   591,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,    -1,
      -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,
     452,   453,   454,   455,    -1,   457,   458,   459,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,
     472,    -1,    -1,   475,   476,   477,   478,   479,   480,    -1,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,    -1,   499,   500,   501,
     502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,
     512,   513,   514,   515,   516,   517,   518,    -1,   520,   521,
     522,   523,    -1,   525,    -1,    -1,   528,   529,   530,    -1,
      -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,   541,
     542,   543,   544,   545,   546,    -1,    -1,   549,   550,    -1,
     552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,
     562,    -1,   564,    -1,   566,    -1,    -1,    -1,    -1,   571,
      -1,    -1,    -1,   575,   576,    -1,    -1,    -1,    -1,   581,
      -1,   583,    -1,    -1,   586,   587,    -1,    -1,   590,   591,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    83,    84,
      85,    86,    -1,    -1,    89,    90,    91,    -1,    93,    94,
      -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,   111,   112,    -1,   114,
      -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,   164,
     165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,
      -1,   176,   177,    -1,   179,   180,   181,   182,   183,    -1,
     185,   186,   187,   188,   189,   190,   191,    -1,   193,   194,
      -1,   196,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,
     225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,
      -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,
      -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
     325,   326,   327,    -1,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
      -1,   496,   497,    -1,   499,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,   513,   514,
     515,   516,   517,   518,    -1,   520,   521,   522,   523,    -1,
     525,    -1,    -1,   528,   529,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,   564,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
     575,   576,    -1,    -1,    -1,    -1,   581,    -1,   583,    -1,
      -1,   586,   587,    -1,    -1,   590,   591,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    79,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
     178,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,   217,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
     238,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,   252,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,   460,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,     5,   566,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,   591,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    79,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
     178,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,   217,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
     238,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,   460,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,     5,   566,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,   591,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,   584,    23,    24,    25,
      26,    -1,    28,   591,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,
     566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,   584,    -1,
      17,    -1,    -1,    20,   590,   591,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,   226,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
      -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,   496,
     497,    -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,
     517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
      -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,    -1,     5,   566,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,   591,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,    -1,    -1,   443,   444,   445,    -1,
      -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,
     457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,
      -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,   496,
     497,    -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,
      -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,
     517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,
     537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,
      -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,
      -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     577,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,   591,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,
     455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
     475,   476,    -1,    -1,   479,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
     515,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
     525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
     535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,
      -1,   566,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   583,    -1,
      23,    24,    25,    26,    -1,    28,   591,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,    -1,    -1,
     443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,
     453,   454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,
      -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
     493,   494,    -1,   496,   497,    -1,    -1,   500,   501,   502,
     503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,
      -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,   522,
      -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,
     533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,
     553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,
      -1,    -1,    -1,   566,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   590,   591,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,     5,   566,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,   591,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,     5,   566,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,   591,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,     5,   566,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,   591,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,     5,   566,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,   591,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,   251,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,   499,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,    -1,   566,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   590,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
      -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,
      -1,   452,   453,   454,   455,    -1,   457,   458,   459,    -1,
      -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,
      -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,
      -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,   496,   497,    -1,   499,   500,
     501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,
      -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,
     521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,
      -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,
      -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,
     561,   562,    -1,    -1,    -1,   566,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,   590,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,   499,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,   590,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,
      -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
      -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
      -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,
      -1,   566,    -1,    -1,    -1,    -1,   571,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
     585,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,   443,   444,   445,    -1,    -1,
     448,    -1,    -1,    -1,   452,   453,   454,   455,    -1,   457,
     458,   459,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
      -1,   469,    -1,    -1,   472,    -1,    -1,   475,   476,    -1,
      -1,   479,   480,    -1,   482,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,   496,   497,
      -1,    -1,   500,   501,   502,   503,   504,    -1,    -1,    -1,
      -1,    -1,   510,    -1,   512,    -1,    -1,   515,   516,   517,
     518,    -1,    -1,   521,   522,    -1,    -1,   525,    -1,    -1,
      -1,    -1,   530,    -1,    -1,   533,    -1,   535,    -1,   537,
     538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,    -1,   561,   562,    -1,    -1,    -1,   566,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,   577,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,   431,   432,   433,   434,   435,
     436,   437,   438,   439,   440,    -1,    -1,   443,   444,   445,
      -1,    -1,   448,    -1,    -1,    -1,   452,   453,   454,   455,
      -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,    -1,
     466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,   475,
     476,    -1,    -1,   479,   480,    -1,   482,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
     496,   497,    -1,    -1,   500,   501,   502,   503,   504,    -1,
      -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,   515,
     516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,   525,
      -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,   535,
      -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,    -1,
      -1,    -1,    -1,   559,    -1,   561,   562,    -1,    -1,    -1,
     566,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   577,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,   431,   432,   433,
     434,   435,   436,   437,   438,   439,   440,    -1,    -1,   443,
     444,   445,    -1,    -1,   448,    -1,    -1,    -1,   452,   453,
     454,   455,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,
      -1,    -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,
      -1,   475,   476,    -1,    -1,   479,   480,    -1,   482,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,   496,   497,    -1,    -1,   500,   501,   502,   503,
     504,    -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,
      -1,   515,   516,   517,   518,    -1,    -1,   521,   522,    -1,
      -1,   525,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,
      -1,   535,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,
     554,    -1,    -1,    -1,    -1,   559,    -1,   561,   562,    -1,
      -1,    -1,   566,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   577,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,    -1,
      -1,   443,   444,   445,    -1,    -1,   448,    -1,    -1,    -1,
     452,   453,   454,   455,    -1,   457,   458,   459,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,    -1,   469,    -1,    -1,
     472,    -1,    -1,   475,   476,    -1,    -1,   479,   480,    -1,
     482,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,   496,   497,    -1,    -1,   500,   501,
     502,   503,   504,    -1,    -1,    -1,    -1,    -1,   510,    -1,
     512,    -1,    -1,   515,   516,   517,   518,    -1,    -1,   521,
     522,    -1,    -1,   525,    -1,    -1,    -1,    -1,   530,    -1,
      -1,   533,    -1,   535,    -1,   537,   538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   546,    -1,    -1,   549,    -1,    -1,
     552,   553,   554,    -1,    -1,    -1,    -1,   559,    -1,   561,
     562,    -1,    -1,    -1,   566,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   577,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,   135,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,
       5,   571,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,
      -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
      -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
      -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
     555,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,     5,   571,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,   555,    -1,   557,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,
       5,   571,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,
      -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
      -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
      -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,
      -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
       5,   571,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,
      -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
      -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
      -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,
      -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
       5,   571,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,
      -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
      -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
      -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,
      -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,   557,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
       5,   571,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,
      -1,    -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,   163,   164,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,
     235,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,    -1,   403,   404,
      -1,   406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,
      -1,    -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,   443,   444,
     445,    -1,    -1,   448,    -1,    -1,    -1,   452,    -1,   454,
      -1,    -1,   457,   458,   459,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,    -1,   469,    -1,    -1,   472,    -1,    -1,
      -1,   476,    -1,    -1,    -1,   480,    -1,   482,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,   496,   497,    -1,    -1,   500,   501,   502,   503,   504,
      -1,    -1,    -1,    -1,    -1,   510,    -1,   512,    -1,    -1,
      -1,   516,   517,   518,    -1,    -1,   521,   522,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,   533,    -1,
      -1,    -1,   537,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,   549,    -1,    -1,   552,   553,   554,
      -1,    -1,   557,    -1,   559,    -1,   561,    -1,    -1,    -1,
      -1,   566,    -1,    -1,    -1,     5,   571,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,   166,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,   267,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,   332,   333,    -1,   335,    -1,    -1,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,   462,   463,   464,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
     520,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,   145,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,   447,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    91,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    34,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,   251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    18,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    82,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,   153,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,   175,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,   372,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,   499,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,   453,   454,   455,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,   475,   476,    -1,    -1,   479,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,   515,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,   525,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,   535,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,   562,    -1,    -1,     5,   566,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,
      60,    -1,    -1,    63,    -1,    65,    66,    -1,    -1,    69,
      -1,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,    -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,
     200,    -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
      -1,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,    -1,   403,    -1,    -1,   406,    -1,    -1,   409,
      -1,    -1,   412,   413,    -1,    -1,    -1,    -1,   418,    -1,
     420,   421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,    -1,    -1,   443,   444,   445,    -1,    -1,   448,    -1,
      -1,    -1,   452,    -1,   454,    -1,    -1,   457,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,    -1,   469,
      -1,    -1,   472,    -1,    -1,    -1,   476,    -1,    -1,    -1,
     480,    -1,   482,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,   496,   497,    -1,    -1,
     500,   501,   502,   503,   504,    -1,    -1,    -1,    -1,    -1,
     510,    -1,   512,    -1,    -1,    -1,   516,   517,   518,    -1,
      -1,   521,   522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     530,    -1,    -1,   533,    -1,    -1,    -1,   537,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,   549,
      -1,    -1,   552,   553,   554,    -1,    -1,    -1,    -1,   559,
      -1,   561,    -1,    -1,    -1,    -1,   566
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   446,   451,   455,   475,   479,   515,   531,   534,   539,
     562,   583,   594,   597,   598,   599,   600,   601,   603,   608,
     610,   615,   627,   797,   815,   818,   826,   828,   830,   833,
     838,   840,   845,   848,   853,   857,   865,   866,  1004,  1006,
    1012,  1015,  1040,  1048,  1059,  1065,  1079,  1082,  1085,  1091,
    1095,  1099,  1102,  1103,  1149,  1166,  1172,  1174,  1181,  1183,
    1208,  1214,  1215,  1216,  1217,  1263,    11,    94,   179,   214,
     374,   811,  1238,  1239,   258,   336,   847,   493,   495,  1168,
    1209,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   431,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   443,   444,
     445,   448,   452,   453,   454,   455,   457,   458,   459,   466,
     467,   469,   472,   475,   476,   479,   480,   482,   483,   484,
     488,   489,   490,   491,   493,   494,   496,   497,   500,   501,
     502,   503,   504,   510,   512,   515,   516,   517,   518,   521,
     522,   525,   530,   533,   535,   537,   538,   546,   549,   552,
     553,   554,   559,   561,   562,   566,   621,  1139,  1143,  1147,
    1148,   287,  1168,  1168,   559,  1210,    94,   178,   460,   496,
     527,   537,   619,   712,   713,   714,   787,  1049,  1005,    94,
     179,   217,   374,   496,   511,   537,   552,  1011,  1143,   847,
     620,   591,  1137,  1138,  1143,   609,  1013,  1100,    96,   217,
     495,  1168,   847,  1143,  1096,   426,   537,  1168,   847,  1016,
    1092,  1168,   620,  1210,  1143,   868,   870,   871,   349,  1151,
    1066,   475,   479,   455,   510,   455,   495,  1060,  1173,  1041,
    1143,    28,    70,   141,   370,   392,   417,   475,  1265,   430,
     583,   867,     0,     3,   595,   370,   156,  1083,  1137,  1143,
     145,   803,  1143,   621,   621,   495,   112,  1233,  1234,  1235,
    1168,   829,  1210,   854,   855,  1137,   628,   591,   508,   831,
     841,    16,  1211,   213,   715,   620,   354,  1230,  1234,  1235,
    1236,  1237,  1238,   495,   713,   217,   214,   270,   382,  1057,
    1058,   920,   921,   213,  1010,  1010,  1143,  1010,  1010,   620,
    1010,  1168,   604,  1086,    12,    13,    87,   115,   129,   151,
     163,   192,   217,   223,   262,   375,   394,   400,   406,   430,
     451,   452,   488,   534,   536,  1184,  1186,  1188,  1189,  1143,
     347,    61,   390,   591,   251,   499,  1140,  1143,  1145,   113,
     204,   270,  1018,    77,   381,  1101,  1104,   226,  1137,  1167,
    1168,   175,    32,   287,  1071,  1097,  1143,   620,   849,  1168,
     113,   270,  1019,  1047,   287,   381,   455,  1093,  1094,   827,
      12,  1182,  1186,   508,  1211,   869,    12,   125,   204,   465,
     466,   467,   468,   469,   470,   481,   875,   876,   877,  1150,
      30,    33,    55,    56,    65,    67,    85,    87,    95,   143,
     147,   177,   179,   191,   193,   216,   217,   220,   237,   258,
     263,   287,   320,   329,   347,   373,   374,   377,   378,   440,
     445,   455,   480,   495,   553,   760,   786,  1067,  1071,  1072,
    1074,  1157,   820,   821,   820,   820,   558,   819,   820,  1009,
    1137,  1168,  1047,    34,   203,   499,  1125,  1141,  1264,  1264,
    1264,  1264,  1264,   870,   867,   584,   589,  1143,  1081,  1080,
     301,   497,   522,   799,   801,   800,  1137,   145,   471,  1240,
     839,  1008,  1009,   229,   585,   861,   862,   583,   629,  1143,
     611,  1008,  1008,    52,   335,   335,   399,  1212,   332,   333,
     892,  1143,    91,  1145,  1146,  1199,  1200,   405,    10,   374,
     511,   881,  1232,  1240,  1241,  1249,  1251,  1252,  1258,   881,
    1231,  1241,  1249,  1252,  1258,  1233,  1238,   715,  1143,   175,
    1050,  1054,  1055,  1143,  1057,     7,    20,    22,    25,    29,
      32,    34,    35,    36,    38,    51,    55,    56,    62,    65,
      73,    74,    80,    83,    84,    85,    90,    91,    93,    94,
      98,    99,   100,   105,   107,   110,   111,   118,   119,   136,
     139,   140,   152,   155,   157,   158,   162,   166,   171,   176,
     180,   181,   182,   183,   185,   186,   188,   189,   190,   194,
     196,   197,   203,   209,   213,   223,   225,   242,   246,   249,
     254,   256,   259,   264,   267,   272,   279,   289,   293,   302,
     306,   308,   309,   313,   314,   315,   316,   317,   318,   319,
     325,   332,   333,   334,   337,   338,   343,   361,   362,   364,
     365,   366,   367,   368,   380,   388,   404,   405,   416,   419,
     422,   424,   428,   432,   477,   478,   483,   485,   486,   487,
     492,   499,   501,   502,   503,   504,   513,   514,   515,   520,
     523,   528,   529,   537,   541,   542,   543,   544,   545,   550,
     554,   564,   566,   571,   575,   576,   581,   583,   586,   587,
     590,   591,   886,   887,   888,   889,   893,   896,   897,   899,
     906,   910,   922,  1124,  1126,  1128,  1129,  1133,  1135,  1139,
    1143,   152,  1143,  1143,   344,   621,   621,  1146,  1198,  1008,
    1010,   540,   605,   120,   205,   263,   287,   373,   381,   409,
     455,   476,   493,  1087,  1088,  1168,   373,  1187,   420,   420,
     496,   537,   552,   349,  1191,   493,  1193,    60,   455,  1190,
      95,   552,  1192,   344,   585,    18,   145,   964,   965,  1175,
    1143,   811,   886,    75,   175,   270,  1105,  1111,    47,   175,
    1137,  1169,  1170,   846,   590,   602,  1140,   263,   850,  1146,
     851,   852,  1137,   834,   226,  1009,  1020,  1021,    47,   585,
    1008,  1187,   344,   426,  1213,  1212,   526,  1218,  1219,   577,
     879,   880,   881,   877,  1152,  1153,  1154,   263,   150,   446,
     252,   556,  1078,   516,   583,    94,   179,   374,   495,   552,
    1078,   722,  1145,   253,   983,   985,    63,   476,   172,   476,
     476,   476,   287,   493,    63,   476,    12,    40,    81,    86,
     231,   300,   359,   459,   490,  1061,  1062,  1063,   476,   205,
     476,   476,   516,   983,  1078,   175,   229,  1075,   263,   142,
      66,   376,   493,   512,   476,   549,   817,   398,   472,   822,
     823,   816,    78,   811,   585,   346,  1267,   489,  1268,   236,
     412,  1266,   584,  1219,  1221,  1222,  1223,     3,   596,   865,
    1084,  1125,  1143,   111,   710,   711,   720,   721,   769,   622,
     622,   798,  1146,   429,   552,  1008,   508,   585,   111,   856,
    1143,   855,   217,   238,   784,   785,   863,   630,   631,   886,
     273,   274,   275,   276,   277,   278,   281,   282,   283,   284,
     285,   286,   288,   396,   397,   612,   613,   614,   156,   382,
     832,    54,   156,   159,   172,   299,   382,   842,   843,   844,
      52,   399,   152,   618,   583,   885,   590,   211,   585,   881,
     881,   881,   179,   552,   179,  1241,  1137,   517,   540,   788,
    1054,  1137,  1143,   585,  1052,   591,  1056,   583,   583,   583,
     583,   583,   897,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   885,   885,   583,
     885,   583,   583,   583,   523,   583,  1124,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   886,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   923,   924,   925,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   886,   583,   885,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   583,   583,   583,   885,
     583,  1124,   583,   583,   583,  1124,   583,   583,    34,   203,
     499,   583,   583,   583,   885,   885,   885,   583,   583,   583,
     583,   583,   583,   886,   927,   897,   897,   897,   430,   583,
     886,  1227,  1143,   911,  1143,    15,    16,   351,   354,   563,
     890,   891,   145,   146,   184,   198,   232,   244,   271,   328,
     894,   126,   229,   252,   313,   395,   449,   450,   458,   572,
     573,   574,   575,   576,   577,   578,   579,   580,   892,   897,
     101,   102,   103,   104,   105,   206,   207,   208,   209,   302,
     304,   305,   306,   314,   380,   427,   428,   554,   565,   566,
     960,   962,    64,   353,   585,  1141,   583,   591,   591,  1137,
     585,    49,   411,   812,  1008,   590,   606,   607,    47,   558,
     585,  1089,   493,   583,  1201,  1201,  1201,  1201,   179,   374,
     495,  1185,  1189,  1143,   164,   330,  1143,  1176,  1177,  1020,
     287,   258,  1110,   858,   287,   965,   585,  1008,  1145,    27,
     508,  1098,   585,   508,   585,   508,  1008,  1021,  1017,  1094,
     175,   585,   179,   374,  1185,  1143,    12,   125,  1225,   585,
     872,   883,   886,  1131,  1143,   585,   191,   258,   345,   445,
    1155,  1156,  1159,  1160,   229,  1076,  1140,   886,   577,   715,
     621,   621,  1137,  1137,  1068,   267,   338,   520,   986,   987,
    1126,   621,  1078,  1146,   172,  1073,  1075,   621,  1078,   230,
     491,   160,   172,  1064,   585,  1073,  1073,  1137,  1075,  1073,
    1073,  1078,  1078,   533,   824,   585,   824,   457,   430,   583,
     587,   930,   931,   932,   933,   942,   943,   951,  1125,   363,
    1269,   352,   979,   985,  1224,   711,    64,   760,    68,    80,
     241,   311,   335,   389,   471,   624,   626,     6,    13,    23,
      24,    53,    57,    68,    77,    83,    96,   114,   123,   124,
     129,   137,   143,   169,   215,   217,   224,   292,   307,   312,
     352,   358,   361,   384,   385,   387,   401,   423,   517,   526,
     717,   719,   720,   721,   804,   805,   806,   975,   112,   228,
    1137,  1140,  1009,   583,   584,   585,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   585,   535,   843,   709,   710,   584,  1145,    45,  1200,
     179,   621,   621,   621,  1143,  1137,   616,    44,   107,   166,
     200,   203,   267,   335,   338,   425,   431,   433,   434,   435,
     436,   437,   438,   439,   440,   520,   789,   790,   791,   989,
     789,   344,  1053,  1051,   591,  1055,   175,   577,  1143,   965,
     886,   886,   886,    12,   125,   916,   966,   989,   916,   916,
     916,   886,   886,   920,   920,   886,   920,   886,   886,   886,
     886,   125,   916,   966,   886,   584,   886,   886,   886,   886,
     886,  1133,  1143,   886,   886,   886,   886,   886,   583,  1227,
     886,   960,   886,   886,   886,   584,   886,   886,   886,   886,
     920,   886,   886,    97,   100,   501,   504,   963,   886,   125,
     913,  1124,   886,   886,   886,   584,   886,   886,   886,   886,
     920,   886,   886,   886,   886,   924,     9,   926,  1133,   125,
     916,   886,   886,   125,   916,   886,   886,   886,   886,   886,
     920,   920,   920,   886,   886,   886,   886,   886,   886,   920,
     889,   886,   584,   886,   886,   886,   886,   886,   584,   886,
     886,   920,   916,   916,   886,   886,   886,   125,   916,   886,
     886,   174,   961,   962,   961,   886,    43,   245,   509,   886,
     886,  1124,   584,   886,   584,   916,  1134,  1135,  1143,   916,
     886,   886,   886,   555,   929,  1228,  1228,   584,   585,   584,
     886,   590,   912,  1145,   591,   886,   886,   886,   888,   158,
     337,   514,   530,   892,    12,    17,   888,   895,   889,   583,
     897,   889,   889,   889,   889,   252,   889,   889,   889,   889,
     896,   889,   896,   889,   889,   889,   889,   229,   252,   395,
     572,   576,  1145,   897,   886,   898,  1143,  1143,  1007,  1146,
     812,  1145,   585,   390,  1088,  1008,  1090,  1143,  1202,  1203,
     577,  1137,  1143,  1197,  1197,  1197,   145,   164,   184,   198,
     243,   244,   271,   330,   371,  1178,  1180,   556,   967,  1014,
     218,   859,   860,  1137,   270,   390,   560,  1171,  1170,   886,
    1140,  1146,  1146,   852,  1137,   156,   382,   538,   835,   836,
     837,   430,   446,   545,   546,   583,   705,  1022,  1025,  1140,
     192,  1197,  1197,  1197,  1220,   880,   175,   226,   873,   874,
     978,   979,  1000,   882,   591,  1153,   111,   510,  1143,  1162,
     321,   361,   590,   760,  1161,  1140,   175,  1077,   584,  1143,
     263,   476,  1070,   341,   585,   455,  1078,  1143,   381,   983,
    1063,  1078,  1078,  1073,  1137,  1078,  1078,   614,   825,   823,
     950,  1143,    88,   219,   236,   249,   324,   416,   481,   941,
     446,   585,  1137,   950,   585,   172,  1270,    45,   983,   145,
     447,  1031,  1032,  1032,  1140,   471,   471,   471,   471,   471,
     429,    67,    79,   178,   460,   731,   734,   735,   782,   784,
     810,   810,  1032,  1032,   810,  1032,  1032,  1032,   508,   122,
    1032,   237,   494,   170,   372,   784,   810,   237,  1032,   494,
     122,  1032,  1032,  1032,   810,    45,  1032,  1032,  1032,  1032,
    1032,    18,   145,   508,   814,  1032,  1032,  1032,   717,   585,
     583,   591,   730,   736,  1136,  1143,   802,   372,   958,  1143,
     886,   989,  1140,  1140,   107,   166,   267,   338,   520,   990,
    1140,   989,  1140,  1140,  1140,  1140,  1140,   989,  1140,  1140,
     989,   613,   361,   499,  1143,  1259,     8,    27,   697,   583,
     413,  1242,   252,   583,   699,   716,   718,   719,   435,   440,
     585,  1137,   540,   967,  1143,   931,   591,  1056,   585,   584,
     584,   585,   916,   584,   917,   585,   584,   584,   584,    18,
     584,   540,   584,   584,   584,   584,   585,   585,   540,   585,
     585,   907,   584,   577,   584,   585,   585,   584,   584,   585,
     584,   591,   584,   585,   584,   585,   585,   585,   584,   585,
     584,   585,   175,   585,   585,   584,   585,   584,   585,   585,
     584,   585,   584,   584,   585,   584,   585,   585,   585,   909,
     585,   584,   585,   585,   584,   585,   585,   584,   585,   584,
     585,   584,   585,   585,   585,   584,   583,   585,   916,   584,
     584,   584,   916,   584,   584,   585,   585,   584,   584,   585,
     584,   585,   584,   584,   584,   584,   584,   584,   584,   585,
     585,   584,   585,   584,   229,   584,   584,   585,   585,   585,
     584,   585,   585,   584,   584,   584,   584,   585,   175,   585,
     585,   916,   584,   584,   584,   585,   585,   585,   584,   175,
     886,   175,   886,   175,   886,   175,   584,   585,   585,   584,
     584,   584,   584,   584,   585,   584,   585,   584,   886,   555,
     569,   928,   868,   867,   920,   588,   191,   258,   445,  1158,
     447,  1143,   158,   337,   514,   530,   583,   886,  1227,   149,
     971,   889,    16,   960,   960,   583,   897,   889,   889,   886,
     901,   902,   903,   583,   591,   607,   262,   584,   585,   591,
     591,   508,   508,   508,  1179,   968,   984,   985,  1022,   499,
    1142,   585,   861,   560,   258,   508,   836,   706,  1023,   583,
    1028,  1033,  1028,   584,   705,  1024,  1130,  1131,  1134,  1143,
    1026,   349,   175,   175,   175,   866,   130,   931,  1001,   172,
     262,   878,  1000,   984,   874,    18,   884,  1140,  1143,   577,
    1143,   591,   233,   591,  1031,    32,   111,   761,   762,  1031,
    1145,   172,  1031,   590,  1145,    32,   111,   764,   765,  1145,
     990,  1069,   147,   553,   987,   987,   558,   338,   967,  1073,
     585,   945,   950,   930,   236,   236,   355,   952,   236,   249,
     416,   952,   942,   930,  1043,  1044,  1134,   930,   965,   947,
     948,   989,   303,   980,   111,   766,   768,  1145,   762,    96,
      96,   112,   228,   794,  1136,   785,   785,    58,   170,   372,
     527,   733,   783,   732,   733,   794,  1136,   990,   989,  1136,
     989,  1140,  1140,   760,  1032,   989,   238,   238,  1136,  1136,
     722,  1032,   164,   243,   335,   725,   990,   990,  1136,   976,
     977,  1134,   111,   989,  1140,   989,   989,   383,   386,   724,
     989,  1137,    71,    72,   111,   133,   165,   393,   723,   722,
     583,   806,   728,   729,   730,   731,  1143,     8,   164,   813,
     394,   732,   774,   737,   591,   583,  1243,   584,   585,   499,
     413,   583,   115,   223,   534,   698,  1253,   108,   227,   391,
     482,   727,  1243,  1137,   252,   700,   705,   728,   214,   405,
     702,  1112,   585,   718,   790,   617,   931,   978,   967,   965,
     225,   886,   886,   584,   886,   886,    32,    56,    97,   100,
     108,   326,   453,   504,   532,   918,   761,   920,   886,   761,
     918,   886,   920,   584,   896,   896,  1141,  1143,   886,   886,
     920,  1141,   886,   886,   886,   920,   338,   886,   886,   886,
     886,   886,   886,   886,   920,   920,   338,   886,   886,   920,
     886,   886,   886,   886,   920,   886,   889,  1133,   584,   584,
     886,   886,   886,   886,   886,   886,   886,   886,   886,   886,
     886,   886,   920,   225,   886,   886,   886,   886,   584,   886,
     886,   886,   886,   175,   886,   175,   886,   175,   886,   886,
     338,   886,   886,   570,   886,   886,   141,  1226,  1226,   584,
     591,   591,   591,  1145,   886,  1227,   584,   585,   584,   897,
     888,   886,  1227,   971,    16,   584,   881,   904,   905,   919,
     920,  1143,  1203,   577,   577,  1199,  1199,  1199,   583,   886,
     344,  1038,  1106,   860,   214,   864,  1146,   875,  1029,  1030,
    1134,  1034,   585,   583,  1025,   584,   584,   585,   591,  1218,
     175,  1199,  1199,  1199,   967,   967,   131,   356,   996,   997,
    1002,   534,   229,  1140,  1143,   591,  1143,   250,  1143,    12,
      32,   111,   344,   886,  1165,    64,   767,   886,  1146,   343,
     361,   499,  1164,  1158,  1031,   983,   275,  1078,   614,  1221,
     946,   249,   236,   942,   952,   952,   236,   344,   344,   540,
     585,  1042,  1031,   169,   214,   539,   954,   875,   886,   981,
    1132,   886,   238,   238,   785,   794,   788,   129,   446,   807,
     762,  1140,   794,   812,  1140,   808,   585,    19,   116,   982,
    1090,   584,   585,  1143,  1137,    31,    32,    37,    39,    41,
      42,    56,    97,   100,   108,   127,   144,   165,   167,   186,
     187,   227,   256,   265,   266,   268,   296,   297,   298,   317,
     318,   319,   323,   326,   339,   340,   365,   367,   391,   444,
     446,   456,   500,   501,   504,   505,   506,   507,   547,   548,
     566,   738,   741,   742,   743,   744,   745,   746,   747,  1143,
    1143,  1244,    18,  1143,   727,  1260,   344,   632,   633,   635,
    1143,   519,    18,  1137,   584,   584,    18,   708,   718,   583,
     967,   253,   988,   886,   584,   584,   584,   583,   753,   754,
     753,   583,   748,   749,   754,   753,   227,   227,   584,   584,
     584,   584,   584,   584,   585,   908,   960,   960,   584,   584,
     584,   584,   584,   584,   585,   584,   584,   584,   584,   584,
     585,   584,   584,   584,   584,   584,   915,   979,   585,   585,
     585,   584,   584,   584,   584,   585,   584,   584,   584,   585,
     229,   558,   900,   584,   584,   584,   584,   584,   584,   584,
     584,   584,   585,   584,   584,   584,   886,   584,   172,   584,
     584,   585,   585,   584,   585,   585,   584,   886,   584,   886,
     584,   886,   584,   584,   585,   584,   584,   886,   570,  1229,
    1229,   591,   795,   584,   920,   584,   585,   584,   888,   886,
     585,   584,   407,  1204,  1204,  1204,   111,   886,  1036,  1037,
     132,  1112,   247,   879,   585,  1031,  1035,  1036,  1033,  1027,
    1025,  1130,  1143,  1199,   984,   195,   972,  1142,  1142,   590,
     998,   999,  1145,   448,   577,   390,   403,   443,  1163,   768,
    1031,   583,   583,  1162,   886,   145,   584,   932,   355,   930,
     942,   236,   236,   930,   942,   935,   934,   936,  1044,   967,
    1037,   784,   955,   955,   955,   879,   585,   982,   794,   788,
     583,   111,   111,   736,   767,   738,   977,   584,   729,   775,
     754,   754,   753,   748,   369,   739,   748,   748,    20,    32,
      46,   525,   760,   770,    56,   547,   742,   744,   770,   770,
      56,   548,   548,   551,   748,   740,   753,   753,   770,   754,
     753,    23,    64,    68,   111,   337,   344,   372,   444,   527,
     756,   757,   758,   773,   892,   551,   754,   770,    32,   754,
     771,   754,   754,   753,   583,   749,   755,   591,   584,   585,
    1245,  1246,   519,   221,   229,   357,   636,   637,   638,   639,
     881,   584,   585,   634,  1140,  1245,   584,   701,   716,   583,
     705,   792,   793,  1143,   987,   960,   107,   267,   338,   520,
     770,   338,   886,   584,   584,   584,   886,   886,   442,   914,
     338,   886,   886,   886,   886,    41,   381,   584,   886,   960,
     886,   886,   886,   886,   886,   584,   584,   584,   338,   886,
     584,  1143,   584,   920,   882,   905,    59,   234,   331,   473,
     484,   561,  1195,  1196,   558,  1205,  1205,  1205,   584,   585,
    1039,   226,   707,  1030,  1037,   584,  1221,    45,   201,   969,
    1003,  1145,   585,   310,    69,   521,   390,  1164,   499,   499,
    1031,  1140,   965,   236,   344,   938,   942,   942,   344,   940,
     886,   886,   583,   978,   172,   953,   949,  1132,   583,   583,
     792,   100,   501,   504,   575,   576,  1127,  1128,   813,   756,
     289,   344,   583,   776,   778,   779,   780,   453,   532,   567,
     750,   751,   752,   583,   750,   750,   771,    20,   525,   760,
     772,   771,   761,   770,   551,   750,   583,   770,   750,   766,
    1140,   334,   759,  1127,   534,   111,   238,   758,   238,   337,
     770,   771,   770,   771,   750,   338,   750,  1143,  1143,   558,
    1248,   430,   583,  1247,  1140,   584,   585,   634,  1137,  1254,
     635,   738,  1248,  1221,   702,   705,   703,   584,   585,   982,
     583,   584,   584,   584,   584,   584,   585,   584,   584,   585,
     584,  1125,   584,   585,   584,   585,   584,   584,   310,   154,
     584,   584,   584,   584,   584,   584,   584,   585,   584,   884,
     499,   499,   499,    16,  1194,   192,   290,   291,   294,   295,
    1206,  1207,  1037,   238,  1107,   726,   874,   984,   973,  1132,
     970,   978,    66,  1113,   999,   584,   584,  1165,    16,   930,
     937,   540,   939,   540,   959,  1143,   988,   236,   956,   726,
     982,   792,   792,   584,  1129,  1129,   809,   177,   360,   454,
     115,   534,   777,  1143,   780,   752,   796,  1125,   761,   771,
     796,   885,   334,   546,    50,    58,   258,   881,   881,  1261,
     638,  1143,   172,   413,   584,  1218,   793,   338,   338,   886,
     916,   886,   920,  1195,   349,   989,   989,   989,   989,  1207,
     534,   495,   878,   558,   585,   974,   982,   886,   984,   138,
     148,   350,   498,  1114,  1115,   255,  1116,   276,   344,   886,
     583,   886,   583,   584,   585,   583,   584,   584,   788,   813,
      49,   335,   411,   446,   781,   781,   584,   585,   584,   585,
     584,   885,    58,   349,    58,   868,   867,   623,   738,   881,
    1255,   704,   982,   584,   584,   584,   585,   584,   584,   584,
    1045,  1046,  1134,  1137,    89,   418,  1132,   374,   991,    45,
      45,   138,    45,  1115,   474,   498,  1117,  1118,   145,   944,
     959,   959,  1143,   957,   958,   774,   788,     5,   111,   337,
     778,  1143,   770,  1125,   770,   349,   349,   584,   121,   624,
     625,   892,  1262,   134,   738,  1221,   886,   585,  1031,  1108,
     982,  1143,  1125,  1125,    45,  1125,    45,    45,  1118,   990,
     886,   584,   584,   584,  1221,   121,    61,   161,   213,   235,
     248,   347,   414,   571,   656,   657,   660,   669,   670,   673,
     684,   687,   689,   690,  1139,  1144,  1148,   424,  1256,   584,
    1046,  1037,   760,   763,   992,  1125,  1125,  1125,    16,   588,
    1143,   175,   330,   662,   659,  1144,  1144,  1143,   658,   671,
     674,   598,   269,   404,   557,   693,    28,   691,   592,  1250,
     623,   762,  1109,   583,   280,   175,  1143,   664,   665,   886,
     886,   555,   676,   680,   641,   656,   641,   694,   692,   685,
     688,   656,  1257,  1113,   881,   993,   994,   995,   145,   226,
     141,   886,   672,   681,   569,   680,   683,   141,   656,   589,
     533,   886,   642,   693,   691,   656,  1116,   886,   584,   585,
     989,   661,   213,   570,   555,   675,   677,   886,   641,   141,
     269,   589,   696,   128,   109,   640,   643,   686,  1144,   686,
     214,  1119,   995,   663,  1143,   666,   678,   677,   683,   682,
     571,   886,   695,    82,   153,   648,   654,  1143,   141,   656,
     589,   338,   583,  1120,   585,   641,   886,   141,   570,   141,
     641,   199,   585,   644,    76,    92,   589,   255,   584,   590,
    1121,  1122,  1134,   446,  1123,  1143,   667,   679,   571,   641,
     404,   141,   172,  1143,   738,   172,   172,  1145,   584,   585,
    1045,   135,   569,   668,   570,   557,   645,   111,   655,   463,
     651,   989,   646,   647,  1122,   664,   641,   641,   462,   464,
     649,   650,   651,   653,   892,  1143,   886,   546,   652,   598,
     585,   656,   173,  1141,   650
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1230 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            if (!thd->bootstrap &&
              (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
            {
              my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
              MYSQL_YYABORT;
            }
            thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
            thd->m_lip->found_semicolon= NULL;
          }
    break;

  case 3:
#line 1242 "sql_yacc.yy"
    {
            Lex_input_stream *lip = YYTHD->m_lip;

            if ((YYTHD->client_capabilities & CLIENT_MULTI_QUERIES) &&
                ! lip->stmt_prepare_mode &&
                ! (lip->ptr >= lip->end_of_query))
            {
              /*
                We found a well formed query, and multi queries are allowed:
                - force the parser to stop after the ';'
                - mark the start of the next query for the next invocation
                  of the parser.
              */
              lip->next_state= MY_LEX_END;
              lip->found_semicolon= lip->ptr;
            }
            else
            {
              /* Single query, terminated. */
              lip->found_semicolon= NULL;
            }
          }
    break;

  case 5:
#line 1267 "sql_yacc.yy"
    {
            /* Single query, not terminated. */
            YYTHD->m_lip->found_semicolon= NULL;
          }
    break;

  case 57:
#line 1336 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 60:
#line 1351 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= yyvsp[-2].lex_str;
        }
    break;

  case 61:
#line 1360 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 62:
#line 1367 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= yyvsp[0].lex_str;
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 63:
#line 1376 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= yyvsp[0].lex_str;
        }
    break;

  case 64:
#line 1383 "sql_yacc.yy"
    {}
    break;

  case 69:
#line 1397 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&yyvsp[0].lex_str, sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 70:
#line 1409 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 71:
#line 1417 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= yyvsp[0].lex_str.str;
       }
    break;

  case 72:
#line 1427 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 73:
#line 1433 "sql_yacc.yy"
    {}
    break;

  case 76:
#line 1442 "sql_yacc.yy"
    {
	 Lex->mi.host = yyvsp[0].lex_str.str;
       }
    break;

  case 77:
#line 1447 "sql_yacc.yy"
    {
	 Lex->mi.user = yyvsp[0].lex_str.str;
       }
    break;

  case 78:
#line 1452 "sql_yacc.yy"
    {
	 Lex->mi.password = yyvsp[0].lex_str.str;
       }
    break;

  case 79:
#line 1457 "sql_yacc.yy"
    {
	 Lex->mi.port = yyvsp[0].ulong_num;
       }
    break;

  case 80:
#line 1462 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = yyvsp[0].ulong_num;
       }
    break;

  case 81:
#line 1466 "sql_yacc.yy"
    {
           Lex->mi.ssl= yyvsp[0].ulong_num ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 82:
#line 1471 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= yyvsp[0].lex_str.str;
         }
    break;

  case 83:
#line 1475 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= yyvsp[0].lex_str.str;
         }
    break;

  case 84:
#line 1479 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= yyvsp[0].lex_str.str;
         }
    break;

  case 85:
#line 1483 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= yyvsp[0].lex_str.str;
         }
    break;

  case 86:
#line 1487 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= yyvsp[0].lex_str.str;
	 }
    break;

  case 88:
#line 1496 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = yyvsp[0].lex_str.str;
       }
    break;

  case 89:
#line 1500 "sql_yacc.yy"
    {
           Lex->mi.pos = yyvsp[0].ulonglong_number;
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 90:
#line 1516 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = yyvsp[0].lex_str.str;
         }
    break;

  case 91:
#line 1520 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = yyvsp[0].ulong_num;
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 92:
#line 1531 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, yyvsp[0].table, NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
#ifdef ENABLE_SENNA
	  lex->senna_clear();
#endif
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=yyvsp[-3].num | yyvsp[-1].num;
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 93:
#line 1551 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 94:
#line 1553 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, yyvsp[0].table, NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 95:
#line 1565 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-9].key_type,yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-9].key_type, yyvsp[-7].lex_str.str, yyvsp[-6].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();
	  }
    break;

  case 96:
#line 1579 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 97:
#line 1584 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=yyvsp[-2].lex_str.str;
            lex->create_info.options=yyvsp[-3].num;
	  }
    break;

  case 98:
#line 1591 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 99:
#line 1597 "sql_yacc.yy"
    {}
    break;

  case 100:
#line 1599 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 101:
#line 1606 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 102:
#line 1621 "sql_yacc.yy"
    {
            if (!yyvsp[-2].lex_str.str || check_db_name(yyvsp[-2].lex_str.str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spname= new sp_name(yyvsp[-2].lex_str, yyvsp[0].lex_str, true);
	    yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 103:
#line 1636 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;

	    if (check_routine_name(yyvsp[0].lex_str))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    yyval.spname= new sp_name(db, yyvsp[0].lex_str, false);
            if (yyval.spname)
	      yyval.spname->init_qname(YYTHD);
	  }
    break;

  case 104:
#line 1654 "sql_yacc.yy"
    {}
    break;

  case 105:
#line 1655 "sql_yacc.yy"
    {}
    break;

  case 106:
#line 1659 "sql_yacc.yy"
    {}
    break;

  case 107:
#line 1660 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1666 "sql_yacc.yy"
    { Lex->sp_chistics.comment= yyvsp[0].lex_str; }
    break;

  case 109:
#line 1668 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 110:
#line 1670 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 111:
#line 1672 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 112:
#line 1674 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 113:
#line 1676 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 114:
#line 1678 "sql_yacc.yy"
    { }
    break;

  case 115:
#line 1683 "sql_yacc.yy"
    { }
    break;

  case 116:
#line 1684 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 117:
#line 1685 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 118:
#line 1690 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 119:
#line 1694 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 120:
#line 1701 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= yyvsp[0].spname;
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, yyvsp[0].spname, TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 121:
#line 1709 "sql_yacc.yy"
    {}
    break;

  case 126:
#line 1725 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 127:
#line 1729 "sql_yacc.yy"
    {
	    Lex->value_list.push_back(yyvsp[0].item);
	  }
    break;

  case 132:
#line 1747 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 133:
#line 1767 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-2].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-2].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-2].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 138:
#line 1804 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[-1].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&yyvsp[-1].lex_str,
                                                     (enum enum_field_types)yyvsp[0].num,
                                                     (sp_param_mode_t)yyvsp[-3].num);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) yyvsp[0].num,
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 139:
#line 1829 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 140:
#line 1830 "sql_yacc.yy"
    { yyval.num= sp_param_in; }
    break;

  case 141:
#line 1831 "sql_yacc.yy"
    { yyval.num= sp_param_out; }
    break;

  case 142:
#line 1832 "sql_yacc.yy"
    { yyval.num= sp_param_inout; }
    break;

  case 143:
#line 1836 "sql_yacc.yy"
    {}
    break;

  case 145:
#line 1841 "sql_yacc.yy"
    {}
    break;

  case 147:
#line 1847 "sql_yacc.yy"
    {
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	  }
    break;

  case 148:
#line 1851 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if ((yyvsp[-1].spblock.vars || yyvsp[-1].spblock.conds) && (yyvsp[-2].spblock.curs || yyvsp[-2].spblock.hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (yyvsp[-1].spblock.curs && yyvsp[-2].spblock.hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    yyval.spblock.vars= yyvsp[-2].spblock.vars + yyvsp[-1].spblock.vars;
	    yyval.spblock.conds= yyvsp[-2].spblock.conds + yyvsp[-1].spblock.conds;
	    yyval.spblock.hndlrs= yyvsp[-2].spblock.hndlrs + yyvsp[-1].spblock.hndlrs;
	    yyval.spblock.curs= yyvsp[-2].spblock.curs + yyvsp[-1].spblock.curs;
	  }
    break;

  case 149:
#line 1877 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
            lex->spcont->declare_var_boundary(yyvsp[0].num);
          }
    break;

  case 150:
#line 1886 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            if (pctx == 0)
            {
              MYSQL_YYABORT;
            }
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) yyvsp[-1].num;
            Item *dflt_value_item= yyvsp[0].item;
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-yyvsp[-3].num ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            yyval.spblock.vars= yyvsp[-3].num;
            yyval.spblock.conds= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
          }
    break;

  case 151:
#line 1938 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&yyvsp[-3].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), yyvsp[-3].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&yyvsp[-3].lex_str, yyvsp[0].spcondtype);
	    yyval.spblock.vars= yyval.spblock.hndlrs= yyval.spblock.curs= 0;
	    yyval.spblock.conds= 1;
	  }
    break;

  case 152:
#line 1952 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, yyvsp[-2].num,
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 153:
#line 1967 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if (yyvsp[-5].num == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
              if (i == NULL )
                MYSQL_YYABORT;
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.curs= 0;
	    yyval.spblock.hndlrs= yyvsp[-1].num;
	    lex->spcont->add_handlers(yyvsp[-1].num);
	  }
    break;

  case 154:
#line 1999 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&yyvsp[-3].lex_str, &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), yyvsp[-3].lex_str.str);
	      delete yyvsp[0].lex;
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, yyvsp[0].lex,
                                  ctx->current_cursor_count());
	    if ( i==NULL )
              MYSQL_YYABORT;
            sp->add_instr(i);
	    ctx->push_cursor(&yyvsp[-3].lex_str);
	    yyval.spblock.vars= yyval.spblock.conds= yyval.spblock.hndlrs= 0;
	    yyval.spblock.curs= 1;
	  }
    break;

  case 155:
#line 2024 "sql_yacc.yy"
    {
	    if(Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 156:
#line 2034 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    yyval.lex= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 157:
#line 2056 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_EXIT; }
    break;

  case 158:
#line 2057 "sql_yacc.yy"
    { yyval.num= SP_HANDLER_CONTINUE; }
    break;

  case 159:
#line 2063 "sql_yacc.yy"
    { yyval.num= 1; }
    break;

  case 160:
#line 2065 "sql_yacc.yy"
    { yyval.num+= 1; }
    break;

  case 161:
#line 2070 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler(yyvsp[0].spcondtype))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition(yyvsp[0].spcondtype);
	      ctx->push_handler(yyvsp[0].spcondtype);
	    }
	  }
    break;

  case 162:
#line 2093 "sql_yacc.yy"
    {			/* mysql errno */
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::number;
	    yyval.spcondtype->mysqlerr= yyvsp[0].ulong_num;
	  }
    break;

  case 163:
#line 2099 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&yyvsp[0].lex_str))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::state;
	    memcpy(yyval.spcondtype->sqlstate, yyvsp[0].lex_str.str, 5);
	    yyval.spcondtype->sqlstate[5]= '\0';
	  }
    break;

  case 164:
#line 2113 "sql_yacc.yy"
    {}
    break;

  case 165:
#line 2114 "sql_yacc.yy"
    {}
    break;

  case 166:
#line 2119 "sql_yacc.yy"
    {
	    yyval.spcondtype= yyvsp[0].spcondtype;
	  }
    break;

  case 167:
#line 2123 "sql_yacc.yy"
    {
	    yyval.spcondtype= Lex->spcont->find_cond(&yyvsp[0].lex_str);
	    if (yyval.spcondtype == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 168:
#line 2132 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::warning;
	  }
    break;

  case 169:
#line 2137 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::notfound;
	  }
    break;

  case 170:
#line 2142 "sql_yacc.yy"
    {
	    yyval.spcondtype= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    yyval.spcondtype->type= sp_cond_type_t::exception;
	  }
    break;

  case 171:
#line 2150 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= 1;
	  }
    break;

  case 172:
#line 2165 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&yyvsp[0].lex_str, TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&yyvsp[0].lex_str, (enum_field_types)0, sp_param_in);
	    yyval.num= yyvsp[-2].num + 1;
	  }
    break;

  case 173:
#line 2182 "sql_yacc.yy"
    { yyval.item = NULL; }
    break;

  case 174:
#line 2183 "sql_yacc.yy"
    { yyval.item = yyvsp[0].item; }
    break;

  case 175:
#line 2187 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    if (lex->sphead->reset_lex(thd))
              MYSQL_YYABORT;
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 176:
#line 2197 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i= new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);
              if (i == NULL)
                MYSQL_YYABORT;
              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 177:
#line 2239 "sql_yacc.yy"
    {
            if(Lex->sphead->reset_lex(YYTHD))
               MYSQL_YYABORT;
          }
    break;

  case 178:
#line 2244 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, yyvsp[0].item,
                                      sp->m_return_field_def.sql_type, lex);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 179:
#line 2267 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 180:
#line 2269 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 182:
#line 2272 "sql_yacc.yy"
    {}
    break;

  case 183:
#line 2273 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 184:
#line 2279 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 185:
#line 2285 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2287 "sql_yacc.yy"
    {}
    break;

  case 187:
#line 2289 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;
              /*
                When jumping to a BEGIN-END block end, the target jump
                points to the block hpop/cpop cleanup instructions,
                so we should exclude the block context here.
                When jumping to something else (i.e., SP_LAB_ITER),
                there are no hpop/cpop at the jump destination,
                so we should include the block context here for cleanup.
              */
              bool exclusive= (lab->type == SP_LAB_BEGIN);

	      n= ctx->diff_handlers(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 188:
#line 2339 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[0].lex_str.str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              if (i == NULL)
                MYSQL_YYABORT;
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2379 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 190:
#line 2396 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&yyvsp[-1].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2413 "sql_yacc.yy"
    { }
    break;

  case 192:
#line 2415 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&yyvsp[0].lex_str, &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 196:
#line 2441 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 197:
#line 2462 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), yyvsp[0].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2484 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 199:
#line 2489 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               yyvsp[-1].item, lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 200:
#line 2504 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 201:
#line 2516 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 207:
#line 2536 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 208:
#line 2543 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, yyvsp[0].item))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2554 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 210:
#line 2562 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 211:
#line 2570 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 216:
#line 2588 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 217:
#line 2593 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2602 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 219:
#line 2610 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 220:
#line 2615 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, yyvsp[0].item, false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2622 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 222:
#line 2630 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            if (i == NULL)
              MYSQL_YYABORT;
            sp->add_instr(i);
          }
    break;

  case 224:
#line 2645 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label(yyvsp[-1].lex_str.str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), yyvsp[-1].lex_str.str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label(yyvsp[-1].lex_str.str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 225:
#line 2663 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

	    if (yyvsp[0].lex_str.str)
	    {
	      if (my_strcasecmp(system_charset_info, yyvsp[0].lex_str.str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lab);
	  }
    break;

  case 226:
#line 2680 "sql_yacc.yy"
    { yyval.lex_str= null_lex_str; }
    break;

  case 227:
#line 2681 "sql_yacc.yy"
    { yyval.lex_str= yyvsp[0].lex_str; }
    break;

  case 228:
#line 2686 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *ctx= lex->spcont;
            sp_label_t *lab= ctx->find_label(yyvsp[-1].lex_str.str);

            if (lab)
            {
              my_error(ER_SP_LABEL_REDEFINE, MYF(0), yyvsp[-1].lex_str.str);
              MYSQL_YYABORT;
            }

            lab= lex->spcont->push_label(yyvsp[-1].lex_str.str,
                                         lex->sphead->instructions());
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 229:
#line 2702 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

            if (yyvsp[0].lex_str.str)
            {
              if (my_strcasecmp(system_charset_info, yyvsp[0].lex_str.str, lab->name) != 0)
              {
                my_error(ER_SP_LABEL_MISMATCH, MYF(0), yyvsp[0].lex_str.str);
                MYSQL_YYABORT;
              }
            }
          }
    break;

  case 230:
#line 2718 "sql_yacc.yy"
    { /* Unlabeled blocks get a secret label. */
            LEX *lex= Lex;
            uint ip= lex->sphead->instructions();
            sp_label_t *lab= lex->spcont->push_label((char *)"", ip);
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 231:
#line 2725 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->spcont->pop_label();
          }
    break;

  case 232:
#line 2733 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 233:
#line 2742 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if (yyvsp[-2].spblock.hndlrs)
            {
              sp_instr_hpop *hpop= new sp_instr_hpop(sp->instructions(), ctx,
                                                     yyvsp[-2].spblock.hndlrs);
              if (hpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(hpop);
            }
	    if (yyvsp[-2].spblock.curs)
            {
              sp_instr_cpop *cpop= new sp_instr_cpop(sp->instructions(), ctx,
                                                     yyvsp[-2].spblock.curs);
              if (cpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(cpop);
            }
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 234:
#line 2771 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
	  }
    break;

  case 235:
#line 2781 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 236:
#line 2786 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       yyvsp[-1].item, lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 237:
#line 2801 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 238:
#line 2812 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 239:
#line 2817 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               yyvsp[-2].item, lab->ip,
                                                               lex);
            if (i == NULL)
              MYSQL_YYABORT;
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 240:
#line 2835 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 241:
#line 2837 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 242:
#line 2842 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 243:
#line 2844 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 244:
#line 2846 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 245:
#line 2850 "sql_yacc.yy"
    {}
    break;

  case 246:
#line 2851 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2853 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[0].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 248:
#line 2859 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, yyvsp[-1].table, NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 249:
#line 2867 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2868 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 251:
#line 2868 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2872 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2874 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 254:
#line 2874 "sql_yacc.yy"
    {}
    break;

  case 255:
#line 2876 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 256:
#line 2876 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2881 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 258:
#line 2897 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 259:
#line 2901 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 260:
#line 2911 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2912 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2915 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2916 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2919 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2920 "sql_yacc.yy"
    {}
    break;

  case 266:
#line 2923 "sql_yacc.yy"
    {}
    break;

  case 267:
#line 2924 "sql_yacc.yy"
    {}
    break;

  case 268:
#line 2927 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 269:
#line 2928 "sql_yacc.yy"
    { yyval.num= yyvsp[0].num;}
    break;

  case 270:
#line 2931 "sql_yacc.yy"
    { yyval.num=yyvsp[0].num; }
    break;

  case 271:
#line 2932 "sql_yacc.yy"
    { yyval.num= yyvsp[-1].num | yyvsp[0].num; }
    break;

  case 272:
#line 2935 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 273:
#line 2938 "sql_yacc.yy"
    { yyval.num= 0; }
    break;

  case 274:
#line 2939 "sql_yacc.yy"
    { yyval.num=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 282:
#line 2955 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 283:
#line 2956 "sql_yacc.yy"
    { Lex->create_info.db_type= yyvsp[0].db_type; WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 284:
#line 2957 "sql_yacc.yy"
    { Lex->create_info.max_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 285:
#line 2958 "sql_yacc.yy"
    { Lex->create_info.min_rows= yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 286:
#line 2959 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 287:
#line 2960 "sql_yacc.yy"
    { Lex->create_info.password=yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 288:
#line 2961 "sql_yacc.yy"
    { Lex->create_info.comment=yyvsp[0].lex_str; Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 289:
#line 2962 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=yyvsp[0].ulonglong_number; Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 290:
#line 2964 "sql_yacc.yy"
    {
            switch(yyvsp[0].ulong_num) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 291:
#line 2979 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 292:
#line 2984 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 293:
#line 2985 "sql_yacc.yy"
    { Lex->create_info.table_options|= yyvsp[0].ulong_num ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 294:
#line 2986 "sql_yacc.yy"
    { Lex->create_info.row_type= yyvsp[0].row_type;  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 295:
#line 2988 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 296:
#line 2993 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 297:
#line 2998 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 298:
#line 3003 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 301:
#line 3019 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= yyvsp[0].ulong_num; Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 302:
#line 3020 "sql_yacc.yy"
    { Lex->create_info.data_file_name= yyvsp[0].lex_str.str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 303:
#line 3021 "sql_yacc.yy"
    { Lex->create_info.index_file_name= yyvsp[0].lex_str.str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 304:
#line 3022 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= yyvsp[0].lex_str.str; Lex->create_info.connect_string.length= yyvsp[0].lex_str.length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 305:
#line 3027 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", yyvsp[0].charset->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= yyvsp[0].charset;
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 306:
#line 3044 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && yyvsp[0].charset &&
               !my_charset_same(cinfo->default_table_charset,yyvsp[0].charset))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       yyvsp[0].charset->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= yyvsp[0].charset;
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 307:
#line 3060 "sql_yacc.yy"
    {
	  yyval.db_type = ha_resolve_by_name(yyvsp[0].lex_str.str,yyvsp[0].lex_str.length);
	  if (yyval.db_type == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), yyvsp[0].lex_str.str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 308:
#line 3069 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DEFAULT; }
    break;

  case 309:
#line 3070 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_FIXED; }
    break;

  case 310:
#line 3071 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_DYNAMIC; }
    break;

  case 311:
#line 3072 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPRESSED; }
    break;

  case 312:
#line 3073 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_REDUNDANT; }
    break;

  case 313:
#line 3074 "sql_yacc.yy"
    { yyval.row_type= ROW_TYPE_COMPACT; }
    break;

  case 314:
#line 3077 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 315:
#line 3078 "sql_yacc.yy"
    { yyval.ulong_num= RAID_TYPE_0; }
    break;

  case 316:
#line 3079 "sql_yacc.yy"
    { yyval.ulong_num=yyvsp[0].ulong_num;}
    break;

  case 317:
#line 3082 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_DISABLED; }
    break;

  case 318:
#line 3083 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_FIRST; }
    break;

  case 319:
#line 3084 "sql_yacc.yy"
    { yyval.ulong_num= MERGE_INSERT_TO_LAST; }
    break;

  case 320:
#line 3087 "sql_yacc.yy"
    {}
    break;

  case 322:
#line 3091 "sql_yacc.yy"
    {yyval.num = (int) STRING_RESULT; }
    break;

  case 323:
#line 3092 "sql_yacc.yy"
    {yyval.num = (int) REAL_RESULT; }
    break;

  case 324:
#line 3093 "sql_yacc.yy"
    {yyval.num = (int) DECIMAL_RESULT; }
    break;

  case 325:
#line 3094 "sql_yacc.yy"
    {yyval.num = (int) INT_RESULT; }
    break;

  case 331:
#line 3109 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3119 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
#ifdef ENABLE_SENNA
            Key *key= new Key(yyvsp[-6].key_type, yyvsp[-5].simple_string, yyvsp[0].key_alg ? yyvsp[0].key_alg : yyvsp[-4].key_alg, 0, lex->col_list,
                              lex->senna_flags, lex->senna_initial_n_segments);
            lex->alter_info.key_list.push_back(key);
            lex->senna_clear();
#else /* ENABLE_SENNA */
            Key *key= new Key(yyvsp[-6].key_type, yyvsp[-5].simple_string, yyvsp[0].key_alg ? yyvsp[0].key_alg : yyvsp[-4].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 3133 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= yyvsp[-5].simple_string ? yyvsp[-5].simple_string:yyvsp[-7].simple_string;
            Key *key= new Key(yyvsp[-6].key_type, key_name, yyvsp[-4].key_alg, 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 3141 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= yyvsp[-4].simple_string ? yyvsp[-4].simple_string : yyvsp[-7].simple_string;
            Key *key= new foreign_key(key_name, lex->col_list,
                                      yyvsp[0].table,
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
#ifdef ENABLE_SENNA
            lex->senna_clear();
#endif /* ENABLE_SENNA */
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 335:
#line 3161 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 336:
#line 3168 "sql_yacc.yy"
    {
#ifdef ENABLE_SENNA
            Lex->senna_clear();
#endif /* ENABLE_SENNA */
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 340:
#line 3186 "sql_yacc.yy"
    { yyval.simple_string=(char*) 0; }
    break;

  case 341:
#line 3187 "sql_yacc.yy"
    { yyval.simple_string= yyvsp[0].simple_string; }
    break;

  case 342:
#line 3191 "sql_yacc.yy"
    { yyval.simple_string=yyvsp[0].simple_string; }
    break;

  case 343:
#line 3196 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 344:
#line 3204 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, yyvsp[-3].lex_str.str,
				(enum enum_field_types) yyvsp[-1].num,
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 345:
#line 3217 "sql_yacc.yy"
    { yyval.num=yyvsp[-2].num; }
    break;

  case 346:
#line 3218 "sql_yacc.yy"
    { yyval.num=yyvsp[-2].num; }
    break;

  case 347:
#line 3219 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_FLOAT; }
    break;

  case 348:
#line 3220 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  yyval.num=FIELD_TYPE_BIT; }
    break;

  case 349:
#line 3222 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_BIT; }
    break;

  case 350:
#line 3223 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_TINY; }
    break;

  case 351:
#line 3225 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_TINY; }
    break;

  case 352:
#line 3227 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_STRING; }
    break;

  case 353:
#line 3228 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_STRING; }
    break;

  case 354:
#line 3230 "sql_yacc.yy"
    { yyval.num=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 355:
#line 3232 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  yyval.num=FIELD_TYPE_STRING;
					  Lex->charset=nation